/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ColumnDefine;
import com.els.modules.system.mapper.ColumnDefineMapper;
import com.els.modules.system.service.ColumnDefineService;
import com.els.modules.system.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ColumnDefineServiceImpl
extends ServiceImpl<ColumnDefineMapper, ColumnDefine>
implements ColumnDefineService {
    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addToEnterpriseLevel(HashMap<String, String> map) {
        String ids = map.get("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        Assert.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)I18nUtil.translate("", "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u5217\u8fdb\u884c\u751f\u6210\uff01"));
        List columnDefineList = this.listByIds(idList);
        ArrayList<String> tableCodes = new ArrayList<String>();
        for (ColumnDefine define : columnDefineList) {
            if (tableCodes.contains(define.getTableCode())) continue;
            tableCodes.add(define.getTableCode());
        }
        String elsAccount = TenantContext.getTenant();
        String subAccount = SysUtil.getLoginUser() != null ? SysUtil.getLoginUser().getSubAccount() : "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.in((Object)"table_code", tableCodes);
        List oldList = this.list((Wrapper)queryWrapper);
        ArrayList<String> oldIds = new ArrayList<String>();
        ArrayList<ColumnDefine> newColumnDefineList = new ArrayList<ColumnDefine>();
        for (ColumnDefine define : columnDefineList) {
            define.setId(null);
            define.setElsAccount(elsAccount);
            define.setCreateBy(subAccount);
            define.setUpdateBy(subAccount);
            define.setCreateTime(new Date());
            define.setUpdateTime(new Date());
            newColumnDefineList.add(define);
            for (ColumnDefine oldDefine : oldList) {
                if (!oldDefine.getTableCode().equals(define.getTableCode()) || !oldDefine.getColumnCode().equals(define.getColumnCode()) || oldIds.contains(oldDefine.getId())) continue;
                oldIds.add(oldDefine.getId());
            }
        }
        this.removeByIds(oldIds);
        this.saveBatch(newColumnDefineList);
    }
}

