/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyInterfaceConfig;
import com.els.modules.system.entity.CompanyInterfaceConfigItem;
import com.els.modules.system.mapper.CompanyInterfaceConfigItemMapper;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.CompanyInterfaceConfigService;
import com.els.modules.system.vo.CompanyInterfaceConfigVO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CompanyInterfaceConfigItemServiceImpl
extends BaseServiceImpl<CompanyInterfaceConfigItemMapper, CompanyInterfaceConfigItem>
implements CompanyInterfaceConfigItemService {
    private static final String REDIS_KEY = "sys:company:interface:item:";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private CompanyInterfaceConfigService companyInterfaceConfigService;

    private String getRedisKey(String elsAccount, String interfaceCode) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(interfaceCode);
        return redisKey.toString();
    }

    @Override
    public boolean deleteByMainId(String mainId) {
        return ((CompanyInterfaceConfigItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public List<CompanyInterfaceConfigItem> selectByMainId(String mainId) {
        return ((CompanyInterfaceConfigItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    @Transactional
    public void edit(CompanyInterfaceConfigVO configVO) {
        if (StrUtil.isBlank((CharSequence)configVO.getId())) {
            CompanyInterfaceConfig config = new CompanyInterfaceConfig();
            BeanUtils.copyProperties((Object)configVO, (Object)config);
            config.setId(config.getInterfaceId());
            config.setInterfaceId(null);
            this.companyInterfaceConfigService.updateCompanyInterfaceConfig(config);
            configVO.setId(config.getId());
        } else {
            ((CompanyInterfaceConfigItemMapper)this.baseMapper).deleteByMainId(configVO.getId());
        }
        List<CompanyInterfaceConfigItem> itemList = configVO.getCompanyInterfaceConfigItemList();
        if (itemList != null && !itemList.isEmpty()) {
            for (CompanyInterfaceConfigItem item : itemList) {
                item.setHeadId(configVO.getId());
                item.setSrmInterfaceCode(configVO.getSrmInterfaceCode());
                if (StrUtil.isBlank((CharSequence)item.getCustomBean())) {
                    item.setCustomBean(configVO.getCustomBean());
                }
                if (StrUtil.isBlank((CharSequence)item.getCustomParam())) {
                    item.setCustomParam(configVO.getCustomParam());
                }
                item.setElsAccount(configVO.getElsAccount());
                SysUtil.setSysParam(item, configVO);
            }
            this.saveBatch(itemList);
        }
        this.redisUtil.del(this.getRedisKey(TenantContext.getTenant(), configVO.getSrmInterfaceCode()));
    }

    @Override
    public CompanyInterfaceConfigItem getOneConfig(String elsAccount, String srmInterfaceCode, String companyCode) {
        List<CompanyInterfaceConfigItem> configList = this.getConfigList(elsAccount, srmInterfaceCode);
        if (configList != null) {
            for (CompanyInterfaceConfigItem configItem : configList) {
                if (!configItem.getCompanyCode().equals(companyCode)) continue;
                return configItem;
            }
        }
        return null;
    }

    private List<CompanyInterfaceConfigItem> getConfigList(String elsAccount, String srmInterfaceCode) {
        List configList = (List)this.redisUtil.get(this.getRedisKey(elsAccount, srmInterfaceCode));
        if (configList == null) {
            configList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"srm_interface_code", (Object)srmInterfaceCode));
            this.redisUtil.set(this.getRedisKey(elsAccount, srmInterfaceCode), configList, 14400L);
        }
        return configList;
    }

    @Override
    public List<CompanyInterfaceConfigItem> getConfig(String elsAccount, String srmInterfaceCode) {
        List<CompanyInterfaceConfigItem> configList = this.getConfigList(elsAccount, srmInterfaceCode);
        if (!configList.isEmpty()) {
            return configList;
        }
        CompanyInterfaceConfig interfaceConfig = this.companyInterfaceConfigService.getOneConfig(elsAccount, srmInterfaceCode);
        if (interfaceConfig != null && null != interfaceConfig.getInterfaceCode()) {
            CompanyInterfaceConfigItem configItem = new CompanyInterfaceConfigItem();
            BeanUtils.copyProperties((Object)interfaceConfig, (Object)configItem);
            configList.add(configItem);
        }
        return configList;
    }
}

