/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util.jsonschema;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.jsonschema.AbstractCommonProperty;
import com.els.common.util.jsonschema.JsonSchemaDescrip;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonschemaUtil {
    public static JSONObject getJsonSchema(JsonSchemaDescrip descrip, List<AbstractCommonProperty> propertyList) {
        JSONObject obj = new JSONObject();
        obj.put("$schema", (Object)descrip.getSchema());
        obj.put("type", (Object)descrip.getType());
        obj.put("title", (Object)descrip.getTitle());
        List<String> requiredArr = descrip.getRequired();
        obj.put("required", requiredArr);
        JSONObject properties = new JSONObject();
        for (AbstractCommonProperty commonProperty : propertyList) {
            Map<String, Object> map = commonProperty.getPropertyJson();
            properties.put(map.get("key").toString(), map.get("prop"));
        }
        obj.put("properties", (Object)properties);
        return obj;
    }

    public static JSONObject getSubJsonSchema(String title, List<String> requiredArr, List<AbstractCommonProperty> propertyList) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)"object");
        obj.put("view", (Object)"tab");
        obj.put("title", (Object)title);
        if (requiredArr == null) {
            requiredArr = new ArrayList<String>();
        }
        obj.put("required", requiredArr);
        JSONObject properties = new JSONObject();
        for (AbstractCommonProperty commonProperty : propertyList) {
            Map<String, Object> map = commonProperty.getPropertyJson();
            properties.put(map.get("key").toString(), map.get("prop"));
        }
        obj.put("properties", (Object)properties);
        return obj;
    }
}

