/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.CompanyInterfaceConfig;
import com.els.modules.system.entity.CompanyInterfaceConfigItem;
import com.els.modules.system.entity.ThirdAuth;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.CompanyInterfaceConfigService;
import com.els.modules.system.service.InterfaceExtendExecuteService;
import com.els.modules.system.service.ThirdAuthService;
import com.els.modules.system.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InterfaceUtil {
    private static final Logger log = LoggerFactory.getLogger(InterfaceUtil.class);
    private static final String REDIS_KEY = "sys:thirdAuth:interfaceToken:";
    private static final String GET_TOKEN_URL = "/els/openApi/getToken";
    private static final String INVOKE_URL = "/els/openApi/invoke";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private ThirdAuthService thirdAuthService;
    @Resource
    private CompanyInterfaceConfigService companyInterfaceConfigService;
    @Resource
    private CompanyInterfaceConfigItemService companyInterfaceConfigItemService;
    @Resource
    private InterfaceExtendExecuteService extendExecuteService;

    private JSONObject getAuthObj(String elsAccount) {
        JSONObject authObj = (JSONObject)this.redisUtil.get(REDIS_KEY + elsAccount);
        if (authObj != null) {
            return authObj;
        }
        try {
            ThirdAuth authDTO = this.thirdAuthService.getThirdAuthByType(elsAccount, "0");
            if (authDTO == null) {
                throw new ELSBootException("\u8d26\u53f7" + elsAccount + "\u672a\u914d\u7f6e\u63a5\u53e3\u5e73\u53f0\u51ed\u8bc1\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
            StringBuilder url = new StringBuilder(authDTO.getAppUrl());
            url.append(GET_TOKEN_URL).append("?key=").append(authDTO.getAppKey()).append("&secret=").append(authDTO.getAppSecret());
            String result = HttpUtil.get((String)url.toString());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            int code = resultObj.getIntValue("code");
            if (code == 200) {
                authObj = new JSONObject();
                String token = resultObj.getJSONObject("result").getString("token");
                long expiresIn = resultObj.getJSONObject("result").getLongValue("expiresIn");
                authObj.put("token", (Object)token);
                authObj.put("appUrl", (Object)authDTO.getAppUrl());
                this.redisUtil.set(REDIS_KEY + elsAccount, authObj, expiresIn - 200L);
                return authObj;
            }
            throw new ELSBootException("\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0token\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        catch (Exception e) {
            log.error("InterfaceUtil_getToken_failed:", (Throwable)e);
            throw e;
        }
    }

    private String transitionInterfaceCode(String elsAccount, String companyCode, JSONObject param) {
        String srmInterfaceCode = param.getString("srm_interface_code");
        if (StrUtil.isBlank((CharSequence)srmInterfaceCode)) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_WWWCxyVAoxOLVW_92454e57", "SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        CompanyInterfaceConfig configDTO = null;
        if (StrUtil.isBlank((CharSequence)companyCode)) {
            configDTO = this.companyInterfaceConfigService.getOneConfig(elsAccount, srmInterfaceCode);
        } else {
            CompanyInterfaceConfigItem config = this.companyInterfaceConfigItemService.getOneConfig(elsAccount, srmInterfaceCode, companyCode);
            if (config == null) {
                configDTO = this.companyInterfaceConfigService.getOneConfig(elsAccount, srmInterfaceCode);
            } else {
                configDTO = new CompanyInterfaceConfig();
                BeanUtils.copyProperties((Object)config, (Object)configDTO);
            }
        }
        if (configDTO == null) {
            throw new ELSBootException("SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801:" + srmInterfaceCode + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01");
        }
        param.put("interface_code", (Object)configDTO.getInterfaceCode());
        return configDTO.getCustomBean();
    }

    public JSONObject callInterface(String elsAccount, String companyCode, JSONObject param, Object custom) {
        String beanName = this.transitionInterfaceCode(elsAccount, companyCode, param);
        JSONObject authObj = this.getAuthObj(elsAccount);
        StringBuilder url = new StringBuilder(authObj.getString("appUrl"));
        url.append(INVOKE_URL);
        if (StrUtil.isNotBlank((CharSequence)beanName) && !this.extendExecuteService.getService(beanName).inspectParam(param, custom).booleanValue()) {
            return new JSONObject();
        }
        if (StrUtil.isNotBlank((CharSequence)beanName)) {
            param = this.extendExecuteService.getService(beanName).before(param, custom);
        }
        String result = ((HttpRequest)HttpRequest.post((String)url.toString()).header("token", authObj.getString("token"))).body(param.toJSONString()).execute().body();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (StrUtil.isNotBlank((CharSequence)beanName)) {
            resultObj = this.extendExecuteService.getService(beanName).after(resultObj, custom);
        }
        return resultObj;
    }

    public JSONObject callInterface(String elsAccount, String companyCode, String srmInterfaceCode, JSONObject headParam, JSONObject urlParam, JSONObject bodyParam, Object custom) {
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)srmInterfaceCode);
        param.put("url_param", (Object)urlParam);
        param.put("header_param", (Object)headParam);
        param.put("body", (Object)bodyParam);
        return this.callInterface(elsAccount, companyCode, param, custom);
    }

    public JSONObject callInterface(String elsAccount, String companyCode, String srmInterfaceCode, Object custom) {
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)srmInterfaceCode);
        return this.callInterface(elsAccount, companyCode, param, custom);
    }

    public void callInterface(String elsAccount, String srmInterfaceCode, Object custom) {
        List<CompanyInterfaceConfigItem> configItemList = this.companyInterfaceConfigItemService.getConfig(elsAccount, srmInterfaceCode);
        if (CollectionUtils.isEmpty(configItemList)) {
            return;
        }
        for (CompanyInterfaceConfigItem item : configItemList) {
            JSONObject param = new JSONObject();
            param.put("bus_account", (Object)elsAccount);
            param.put("srm_interface_code", (Object)item.getSrmInterfaceCode());
            this.callInterface(elsAccount, item.getCompanyCode(), param, custom);
        }
    }

    public void callInterface(String elsAccount, List<String> srmInterfaceCode, Object custom) {
        ArrayList<CompanyInterfaceConfigItem> configItemList = new ArrayList<CompanyInterfaceConfigItem>();
        for (String code : srmInterfaceCode) {
            configItemList.addAll(this.companyInterfaceConfigItemService.getConfig(elsAccount, code));
        }
        if (CollectionUtils.isEmpty(configItemList)) {
            return;
        }
        for (CompanyInterfaceConfigItem item : configItemList) {
            JSONObject param = new JSONObject();
            param.put("bus_account", (Object)elsAccount);
            param.put("srm_interface_code", (Object)item.getSrmInterfaceCode());
            this.callInterface(elsAccount, item.getCompanyCode(), param, custom);
        }
    }

    public void callInterface(String elsAccount, Map<String, String> codeAndCustomParamMap) {
        for (Map.Entry<String, String> entry : codeAndCustomParamMap.entrySet()) {
            String srmInterfaceCode = entry.getKey();
            String customParam = entry.getValue();
            List<CompanyInterfaceConfigItem> configItemList = this.companyInterfaceConfigItemService.getConfig(elsAccount, srmInterfaceCode);
            if (CollectionUtils.isEmpty(configItemList)) {
                return;
            }
            for (CompanyInterfaceConfigItem item : configItemList) {
                JSONObject param = new JSONObject();
                param.put("bus_account", (Object)elsAccount);
                param.put("srm_interface_code", (Object)item.getSrmInterfaceCode());
                this.callInterface(elsAccount, item.getCompanyCode(), param, (Object)customParam);
            }
        }
    }
}

