/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.oss.service.IAttachmnetService;
import com.els.modules.attachment.oss.utils.OSSManageUtil;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.template.util.FreeMarkerTemplateUtils;
import com.els.modules.template.vo.TemplateHeadVO;
import freemarker.template.Template;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="aliCloudOssFileServiceImpl")
public class AliCloudOssFileServiceImpl
implements IAttachmnetService {
    private static final Logger log = LoggerFactory.getLogger(AliCloudOssFileServiceImpl.class);
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Value(value="${els.path.upload}")
    private String uploadpath;

    @Override
    public String uploadFile(MultipartFile uploadFile, String remothPath) throws IOException {
        String documentName = uploadFile.getOriginalFilename();
        return OSSManageUtil.uploadFile(uploadFile.getBytes(), documentName, remothPath);
    }

    @Override
    public void downloadFile(OutputStream outputStream, String filePath) throws FileNotFoundException, Exception {
        OSSManageUtil.downloadFile(filePath, outputStream);
    }

    @Override
    public void delete(String filePath) {
        String remotePath = this.uploadpath + filePath;
        OSSManageUtil.deleteFile(remotePath);
    }

    @Override
    public void deleteBatch(List<String> filePaths) {
        if (CollectionUtil.isNotEmpty(filePaths)) {
            ArrayList<String> remotePaths = new ArrayList<String>();
            for (String filePath : filePaths) {
                remotePaths.add(this.uploadpath + filePath);
            }
            if (CollectionUtil.isNotEmpty(remotePaths)) {
                OSSManageUtil.deleteFileBatch(remotePaths);
            }
        }
    }

    @Override
    public void generatorJs(String savePathDir, TemplateHeadVO headVO) {
        log.info("generatorJs in aliOss------------");
        StringWriter purOut = new StringWriter();
        StringWriter saleOut = new StringWriter();
        try {
            savePathDir = "/opt/upFiles/js" + File.separator + TenantContext.getTenant();
            String filePurName = "purchase_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            Template purTemp = FreeMarkerTemplateUtils.getTemplate("js-code-pur.ftl");
            HashMap<String, TemplateHeadVO> map = new HashMap<String, TemplateHeadVO>(128);
            map.put("data", headVO);
            purTemp.process(map, (Writer)purOut);
            OSSManageUtil.uploadFile(purOut.toString().getBytes("UTF-8"), filePurName, savePathDir + File.separator + filePurName);
            String fileSupName = "sale_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            Template supTemp = FreeMarkerTemplateUtils.getTemplate("js-code-sup.ftl");
            supTemp.process(map, (Writer)saleOut);
            OSSManageUtil.uploadFile(saleOut.toString().getBytes("UTF-8"), fileSupName, savePathDir + File.separator + fileSupName);
        }
        catch (Exception e) {
            throw new ELSBootException("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u81f3OSS\u5f02\u5e38!", (Throwable)e, new String[0]);
        }
        finally {
            if (purOut != null) {
                try {
                    purOut.close();
                }
                catch (IOException iOException) {}
            }
            if (saleOut != null) {
                try {
                    saleOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String uploadFile(byte[] bytes, String remothPath, String documentName) {
        return OSSManageUtil.uploadFile(bytes, documentName, remothPath);
    }
}

