/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.BigDecimalFormat;
import com.els.common.aspect.annotation.Dict;
import com.els.common.aspect.annotation.ReadConfig;
import com.els.common.aspect.annotation.ReadConfigType;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DateUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.SensitiveField;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.SensitiveFieldService;
import com.els.modules.system.util.AdminFlagUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private SensitiveFieldService sensitiveFieldService;
    private final String OBJECT_CLASS = "java.lang.Object";
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
    private List<SensitiveField> sensitiveFieldList;

    @Pointcut(value="execution(public * com.els.modules..*.*Controller.*(..))")
    public void executeService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="executeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        try {
            long start = System.currentTimeMillis();
            if (this.sensitiveFieldList != null) {
                this.sensitiveFieldList.clear();
            }
            String sensitiveFieldGroups = null;
            if (SysUtil.getLoginUser() != null) {
                sensitiveFieldGroups = SysUtil.getLoginUser().getSensitiveFieldGroups();
            }
            this.sensitiveFieldList = this.sensitiveFieldService.findSensitiveFieldByGroup(TenantContext.getTenant(), sensitiveFieldGroups);
            this.parseDictText(result);
            long end = System.currentTimeMillis();
            log.debug("\u89e3\u6790\u6ce8\u5165JSON\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
            Object object = result;
            return object;
        }
        catch (Exception e) {
            log.error("DictAspect_parseDictText_failed:", (Throwable)e);
            Object object = result;
            return object;
        }
        finally {
            I18nUtil.clear();
            TenantContext.clear();
        }
    }

    public void parseDictText(Object result) {
        if (result instanceof Result) {
            if (((Result)result).getResult() instanceof IPage) {
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                for (Object record : ((IPage)((Result)result).getResult()).getRecords()) {
                    if (record == null) continue;
                    JSONObject item = this.parseJson(record);
                    items.add(item);
                }
                ((IPage)((Result)result).getResult()).setRecords(items);
            } else if (((Result)result).getResult() instanceof BaseEntity) {
                Object record = ((Result)result).getResult();
                ((Result)result).setResult(this.parseJson(record));
            } else if (((Result)result).getResult() instanceof List) {
                ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                boolean flag = false;
                for (Object record : (List)((Result)result).getResult()) {
                    if (!(record instanceof BaseEntity)) continue;
                    items.add(this.parseJson(record));
                    flag = true;
                }
                if (flag) {
                    ((List)((Result)result).getResult()).clear();
                    ((List)((Result)result).getResult()).addAll(items);
                }
            }
        }
    }

    private JSONObject parseJson(Object record) {
        return this.parseJson(record, null, null, null, null);
    }

    private JSONObject parseJson(Object record, String templateAccount, String busAccount, String templateNumber, String templateVersion) {
        ReadConfig readConfig;
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(record);
        }
        catch (JsonProcessingException e) {
            log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        JSONObject item = JSONObject.parseObject((String)json);
        if (StrUtil.isBlank((CharSequence)templateAccount)) {
            templateAccount = item.getString("templateAccount");
        }
        if (StrUtil.isBlank((CharSequence)busAccount) && StrUtil.isBlank((CharSequence)(busAccount = item.getString("busAccount")))) {
            busAccount = TenantContext.getTenant();
        }
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{templateNumber, templateVersion})) {
            templateNumber = item.getString("templateNumber");
            templateVersion = item.getString("templateVersion");
        }
        if ((readConfig = record.getClass().getAnnotation(ReadConfig.class)) != null && !StrUtil.isAllBlank((CharSequence[])new CharSequence[]{templateNumber, templateVersion})) {
            String queryAccount;
            ReadConfigType type = readConfig.value();
            String string = queryAccount = StrUtil.isBlank((CharSequence)templateAccount) ? busAccount : templateAccount;
            if (StringUtils.isBlank((CharSequence)queryAccount)) {
                queryAccount = TenantContext.getTenant();
            }
            TemplateHeadVO headVO = this.templateHeadService.getAllConfig(queryAccount, templateNumber, templateVersion);
            Map<String, String> dictMap = ReadConfigType.HEAD.equals((Object)type) ? headVO.getTemplateConfigHeadList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).collect(Collectors.toMap(TemplateConfigHead::getFieldName, TemplateConfigHead::getDictCode, (newVal, oldVal) -> oldVal)) : headVO.getTemplateConfigItemList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).collect(Collectors.toMap(TemplateConfigItem::getFieldName, TemplateConfigItem::getDictCode, (newVal, oldVal) -> oldVal));
            this.translate(record, templateAccount, busAccount, templateNumber, templateVersion, item, dictMap, true);
        } else {
            this.translate(record, templateAccount, busAccount, templateNumber, templateVersion, item, new HashMap<String, String>(), false);
        }
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            this.optSensitiveField(item);
        }
        return item;
    }

    private void translate(Object record, String templateAccount, String busAccount, String templateNumber, String templateVersion, JSONObject item, Map<String, String> dictMap, boolean isConfig) {
        for (Field field : ConvertUtils.getAllFields(record)) {
            BigDecimalFormat annotation;
            String textValue;
            String key;
            String dictCode = dictMap.get(field.getName());
            if (isConfig && StrUtil.isNotBlank((CharSequence)dictCode)) {
                String code;
                String text = null;
                String table = null;
                String valueText = null;
                if (dictCode.contains(",") || dictCode.contains("#")) {
                    String[] dictCodeArray = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                    table = dictCodeArray[0];
                    text = dictCodeArray[1];
                    valueText = dictCodeArray[2];
                    code = "";
                    if (dictCodeArray.length > 3) {
                        code = dictCodeArray[3];
                    }
                } else {
                    code = dictCode;
                }
                key = String.valueOf(item.get((Object)field.getName()));
                textValue = this.translateDictValue(code, text, table, key, false, busAccount, valueText);
                item.put(field.getName() + "_dictText", (Object)textValue);
            } else if (field.getAnnotation(Dict.class) != null) {
                boolean isFilterSql = false;
                String code = field.getAnnotation(Dict.class).dicCode();
                String text = field.getAnnotation(Dict.class).dicText();
                String table = field.getAnnotation(Dict.class).dictTable();
                if (code.contains("${")) {
                    isFilterSql = true;
                    StringBuffer filterSql = new StringBuffer();
                    Matcher matcher = this.pattern.matcher(code);
                    while (matcher.find()) {
                        matcher.appendReplacement(filterSql, item.get((Object)matcher.group(1)) + "");
                    }
                    matcher.appendTail(filterSql);
                    code = filterSql.toString();
                }
                key = String.valueOf(item.get((Object)field.getName()));
                textValue = this.translateDictValue(code, text, table, key, isFilterSql, busAccount, null);
                item.put(field.getName() + "_dictText", (Object)textValue);
            } else if (field.getType().isAssignableFrom(List.class) && !field.getType().getName().equals("java.lang.Object")) {
                List list = null;
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), record.getClass());
                    Method getMethod = pd.getReadMethod();
                    list = (List)getMethod.invoke(record, new Object[0]);
                }
                catch (Exception e) {
                    log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
                }
                if (list != null && list.size() > 0 && list.get(0) instanceof BaseEntity) {
                    ArrayList<JSONObject> items = new ArrayList<JSONObject>();
                    for (Object obj : list) {
                        JSONObject itemObj = this.parseJson(obj, templateAccount, busAccount, templateNumber, templateVersion);
                        items.add(itemObj);
                    }
                    item.put(field.getName(), items);
                }
            }
            if (Date.class.equals(field.getType()) && field.getAnnotation(JsonFormat.class) == null && item.get((Object)field.getName()) != null) {
                SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                item.put(field.getName(), (Object)aDate.format(DateUtils.parseDate(item.get((Object)field.getName()))));
            }
            if (Date.class.equals(field.getType()) && item.get((Object)field.getName()) != null) {
                item.put(field.getName() + "_DateMaps", (Object)DateUtils.getMillis(DateUtils.parseDate(item.get((Object)field.getName()))));
            }
            if (!field.getType().getName().equals(BigDecimal.class.getName()) || null == (annotation = field.getAnnotation(BigDecimalFormat.class))) continue;
            try {
                int scale = annotation.scale();
                field.setAccessible(true);
                Object o = field.get(record);
                if (null == o && annotation.nullToZero()) {
                    o = BigDecimal.ZERO;
                }
                BigDecimal v = (BigDecimal)o;
                String formatVal = String.format("%." + scale + "f", v.doubleValue());
                item.put(field.getName(), (Object)formatVal);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private String translateDictValue(String code, String text, String table, String key, boolean isFilterSql, String busAccount, String valueText) {
        String[] keys;
        if (ConvertUtils.isEmpty(key)) {
            return null;
        }
        StringBuffer textValue = new StringBuffer();
        for (String k : keys = key.split(",")) {
            String tmpValue;
            if (k.trim().length() == 0 || (tmpValue = isFilterSql ? this.dictService.queryTableDictTextByFilterSql(table, text, code, busAccount) : (StrUtil.isNotBlank((CharSequence)valueText) ? this.translateSelect(table, text, valueText, code, busAccount, k.trim()) : this.dictService.queryDictTextByKey(code, k.trim(), busAccount))) == null) continue;
            if (!"".equals(textValue.toString())) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }

    private String translateSelect(String table, String descText, String valueText, String where, String elsAccount, String value) {
        String tmpValue = "";
        List<DictModel> list = this.dictService.queryTableDictItemsByCodeAndFilter(table, descText, valueText, where, elsAccount);
        for (DictModel model : list) {
            if (!model.getValue().equals(value)) continue;
            tmpValue = model.getText();
            break;
        }
        if (StrUtil.isBlank((CharSequence)tmpValue)) {
            return value;
        }
        return value + "_" + tmpValue;
    }

    private void optSensitiveField(JSONObject obj) {
        if (this.sensitiveFieldList != null) {
            try {
                for (SensitiveField field : this.sensitiveFieldList) {
                    String fieldCode = field.getFieldCode();
                    if ("id".equals(fieldCode)) continue;
                    String repalceType = field.getReplaceType();
                    String fieldValue = obj.getString(fieldCode);
                    if ("2".equals(repalceType)) {
                        obj.put(fieldCode, (Object)this.encrypt2(fieldValue));
                        continue;
                    }
                    if ("3".equals(repalceType)) {
                        obj.put(fieldCode, (Object)this.encrypt(fieldValue));
                        continue;
                    }
                    obj.put(fieldCode, (Object)"*");
                }
            }
            catch (Exception e) {
                log.error("optSensitiveField_failed:", (Throwable)e);
            }
        }
    }

    private String encrypt(String terget) {
        if (StrUtil.isBlank((CharSequence)terget)) {
            return "";
        }
        return terget.replaceAll("(?<=\\S{3})\\S(?=\\S{4})", "*");
    }

    private String encrypt2(String terget) {
        if (StrUtil.isBlank((CharSequence)terget)) {
            return "";
        }
        return terget.replaceAll("(?<=\\S{3})\\S", "*");
    }
}

