/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.quartz.entity.QuartzJob;
import com.els.modules.quartz.job.BaseJob;
import com.els.modules.quartz.service.IQuartzJobService;
import com.els.modules.system.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/quartzJob"})
@Api(tags={"\u5b9a\u65f6\u4efb\u52a1\u63a5\u53e3"})
public class QuartzJobController {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobController.class);
    @Autowired
    private IQuartzJobService quartzJobService;
    @Autowired
    private Scheduler scheduler;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<?> queryPageList(QuartzJob quartzJob, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)quartzJob), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.quartzJobService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6dfb\u52a0", logType=2, operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<?> add(@RequestBody QuartzJob quartzJob) {
        List<QuartzJob> list = this.quartzJobService.findByJobNameKey(quartzJob.getJobNameKey());
        if (list != null && list.size() > 0) {
            return Result.error((String)"\u8be5\u5b9a\u65f6\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.quartzJobService.saveAndScheduleJob(quartzJob);
        return Result.ok((String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u7f16\u8f91", logType=2, operateType=3)
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public Result<?> eidt(@RequestBody QuartzJob quartzJob) {
        try {
            this.quartzJobService.editAndScheduleJob(quartzJob);
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!");
        }
        return Result.ok((String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u6210\u529f!");
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6839\u636eID\u5220\u9664", logType=2, operateType=4)
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)((Object)this.quartzJobService.getById((Serializable)((Object)id)));
        if (quartzJob == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        this.quartzJobService.deleteAndStopJob(quartzJob);
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6839\u636eID\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return Result.error((String)"\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        }
        for (String id : Arrays.asList(ids.split(","))) {
            QuartzJob job = (QuartzJob)((Object)this.quartzJobService.getById((Serializable)((Object)id)));
            this.quartzJobService.deleteAndStopJob(job);
        }
        return Result.ok((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f!");
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6682\u505c", logType=2, operateType=3)
    @GetMapping(value={"/pause"})
    @ApiOperation(value="\u6682\u505c\u5b9a\u65f6\u4efb\u52a1")
    public Result<Object> pauseJob(@RequestParam(name="jobNameKey", required=true) String jobNameKey) {
        QuartzJob job = null;
        try {
            job = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)new LambdaQueryWrapper().eq(QuartzJob::getJobNameKey, (Object)jobNameKey)));
            if (job == null) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_IKLSxMKW_aa9815a6", (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01"));
            }
            this.scheduler.pauseJob(JobKey.jobKey((String)jobNameKey.trim()));
        }
        catch (SchedulerException e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_PYIKLSKm_7f3f21d0", (String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25"));
        }
        job.setStatus(CommonConstant.STATUS_DISABLE);
        this.quartzJobService.updateById((Object)job);
        return Result.ok((String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u6062\u590d", logType=2, operateType=3)
    @GetMapping(value={"/resume"})
    @ApiOperation(value="\u6062\u590d\u5b9a\u65f6\u4efb\u52a1")
    public Result<Object> resumeJob(@RequestParam(name="jobNameKey", required=true) String jobNameKey) {
        QuartzJob job = (QuartzJob)((Object)this.quartzJobService.getOne((Wrapper)new LambdaQueryWrapper().eq(QuartzJob::getJobNameKey, (Object)jobNameKey)));
        if (job == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_IKLSxMKW_aa9815a6", (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01"));
        }
        this.quartzJobService.resumeJob(job);
        return Result.ok((String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)((Object)this.quartzJobService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)quartzJob));
    }

    @RequestMapping(value={"/manualExecute"}, method={RequestMethod.GET})
    public Result<?> manualExecute(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)((Object)this.quartzJobService.getById((Serializable)((Object)id)));
        if (quartzJob == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IKLSxMKW_aa9815a6", (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01"));
        }
        try {
            BaseJob baseJob = (BaseJob)Class.forName(quartzJob.getJobClassName()).newInstance();
            baseJob.executeBusiness(quartzJob.getParameter());
        }
        catch (Exception e) {
            throw new ELSBootException(String.valueOf(I18nUtil.translate((String)"i18n_alert_RcKmWWWWW_5f5e6fec", (String)"\u6267\u884c\u5931\u8d25\uff01")) + e.getMessage());
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f");
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u5bfc\u51faExcel", logType=2, operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, QuartzJob quartzJob) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)quartzJob), (Map)request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        List pageList = this.quartzJobService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u5b9a\u65f6\u4efb\u52a1\u5217\u8868");
        mv.addObject("entity", QuartzJob.class);
        mv.addObject("params", (Object)new ExportParams("\u5b9a\u65f6\u4efb\u52a1\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:els", "\u5bfc\u51fa\u4fe1\u606f", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    @AutoLog(value="\u5b9a\u65f6\u4efb\u52a1-\u5bfc\u5165\u5b9a\u65f6", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listQuartzJobs = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), QuartzJob.class, (ImportParams)params);
                for (QuartzJob quartzJobExcel : listQuartzJobs) {
                    this.quartzJobService.save((Object)quartzJobExcel);
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + listQuartzJobs.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

