/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.system.entity.ElsAlertConfig;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.ElsAlertConfigService;
import com.els.modules.system.vo.ElsAlertConfigVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u9884\u8b66"})
@RestController
@RequestMapping(value={"/system/elsAlertConfig"})
public class ElsAlertConfigController
extends BaseController<ElsAlertConfig, ElsAlertConfigService> {
    @Autowired
    private ElsAlertConfigService elsAlertConfigService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    private static final String ALERT_NUMBER = "alertNumber";

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsAlertConfig elsAlertConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsAlertConfig), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsAlertConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    public Result<?> querySysPageList(ElsAlertConfig elsAlertConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsAlertConfig), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsAlertConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsAlertConfigVO configVO) {
        ElsAlertConfig elsAlertConfig = new ElsAlertConfig();
        BeanUtil.copyProperties((Object)((Object)configVO), (Object)((Object)elsAlertConfig), (String[])new String[0]);
        elsAlertConfig.setAlertCode(this.codeGeneratorService.getNextCode(ALERT_NUMBER, (Object)elsAlertConfig));
        this.elsAlertConfigService.saveElsAlertConfig(elsAlertConfig, configVO.getElsMsgConfigItemList());
        return Result.ok((Object)((Object)elsAlertConfig));
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", logType=2, operateType=2)
    @ApiOperation(value="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7", notes="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u81f3\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/addBy100000"})
    public Result<?> addBy100000(@RequestParam(name="id", required=true) String id) {
        this.elsAlertConfigService.addBy100000(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsAlertConfigVO configVO) {
        ElsAlertConfig elsAlertConfig = new ElsAlertConfig();
        BeanUtil.copyProperties((Object)((Object)configVO), (Object)((Object)elsAlertConfig), (String[])new String[0]);
        this.elsAlertConfigService.updateElsAlertConfig(elsAlertConfig, configVO.getElsMsgConfigItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsAlertConfigService.delElsAlertConfig(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsAlertConfigService.delBatchElsAlertConfig(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsAlertConfig elsAlertConfig = (ElsAlertConfig)((Object)this.elsAlertConfigService.getById((Serializable)((Object)id)));
        List itemList = this.elsMsgConfigItemService.selectByMainId(id);
        ElsAlertConfigVO configVO = new ElsAlertConfigVO();
        BeanUtil.copyProperties((Object)((Object)elsAlertConfig), (Object)((Object)configVO), (String[])new String[0]);
        configVO.setElsMsgConfigItemList(itemList);
        return Result.ok((Object)((Object)configVO));
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u5bfc\u51faExcel", logType=2, operateType=6)
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsAlertConfig elsAlertConfig) {
        return super.exportXls(request, (Object)elsAlertConfig, ElsAlertConfig.class, "\u9884\u8b66");
    }

    @AutoLog(value="\u9884\u8b66\u7ba1\u7406-\u5bfc\u5165Excel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ElsAlertConfig.class);
    }
}

