/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.job;

import com.els.common.util.SpringContextUtils;
import com.els.modules.system.entity.Log;
import com.els.modules.system.service.LogService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(BaseJob.class);
    private String parameter;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String strjobClass = jobExecutionContext.getJobDetail().getKey().getName();
        String name = strjobClass.substring(strjobClass.lastIndexOf(".") + 1);
        LogService logService = (LogService)SpringContextUtils.getBean(LogService.class);
        Log objLog = new Log();
        objLog.setUsername("\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1");
        objLog.setLogType(Integer.valueOf(3));
        objLog.setOperateType(Integer.valueOf(7));
        try {
            long startTime = System.currentTimeMillis();
            this.executeBusiness(this.parameter);
            long endTime = System.currentTimeMillis();
            objLog.setCostTime(Long.valueOf(endTime - startTime));
            objLog.setLogContent(name + "\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
            logService.save((Object)objLog);
        }
        catch (Exception e) {
            log.error("BaseJob run failed:", (Throwable)e);
            objLog.setResponseParam(e.getMessage());
            objLog.setLogContent(name + "\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            logService.save((Object)objLog);
            throw new JobExecutionException(e.getMessage());
        }
    }

    public abstract void executeBusiness(String var1);

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }
}

