/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.service.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.env.impl.ContextImpl;
import com.bstek.uflo.expr.ExpressionContext;
import com.bstek.uflo.model.HistoryProcessInstance;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.service.IdentityService;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.StartProcessInfo;
import com.bstek.uflo.service.TaskOpinion;
import com.bstek.uflo.service.TaskService;
import com.bstek.uflo.utils.IDGenerator;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.uflo.enumerate.AuditStatusEnum;
import com.els.modules.uflo.mapper.UfloHisActivityMapper;
import com.els.modules.uflo.mapper.UfloHisTaskMapper;
import com.els.modules.uflo.mapper.UfloProcessInstanceMapper;
import com.els.modules.uflo.mapper.UfloTaskMapper;
import com.els.modules.uflo.service.UfloOptService;
import com.els.modules.uflo.vo.AuditInputParamVO;
import com.els.modules.uflo.vo.AuditOutputParamVO;
import com.els.modules.uflo.vo.UfloHisActivityVO;
import com.els.modules.uflo.vo.UfloHisTask;
import com.els.modules.uflo.vo.UfloProcessInstanceVO;
import com.els.modules.uflo.vo.UfloTask;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class UfloOptServiceImpl
implements UfloOptService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UfloOptServiceImpl.class);
    private static final String UFLO_PREV_TASK_REDIS_KEY = "key_prev_task#";
    @Autowired
    @Lazy
    private RedisUtil redisUtil;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private UfloTaskMapper ufloTaskMapper;
    @Autowired
    private UfloProcessInstanceMapper ufloProcessInstanceMapper;
    @Autowired
    private UfloHisTaskMapper ufloHisTaskMapper;
    @Autowired
    UfloHisActivityMapper ufloHisActivityMapper;
    private ContextImpl context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = new ContextImpl();
        this.context.setApplicationContext(applicationContext);
        this.context.setSessionFactory((SessionFactory)((EntityManagerFactory)applicationContext.getBean("entityManagerFactory")).unwrap(SessionFactory.class));
        this.context.setProcessService((ProcessService)applicationContext.getBean("uflo.processService"));
        this.context.setExpressionContext((ExpressionContext)applicationContext.getBean("uflo.expressionContext"));
        this.context.setIdentityService((IdentityService)applicationContext.getBean("uflo.identityService"));
        this.context.setTaskService((TaskService)applicationContext.getBean("uflo.taskService"));
        this.context.setCommandService((CommandService)applicationContext.getBean("uflo.commandService"));
    }

    private List<Task> getTaskListByRootProcessInstanceId(Long rootProcessInstanceId) {
        Session session = this.context.getSession();
        CriteriaBuilder build = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = build.createQuery(Task.class);
        Root root = criteriaQuery.from(Task.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where(new Predicate[]{build.equal((Expression)root.get("rootProcessInstanceId"), (Object)rootProcessInstanceId), build.equal((Expression)root.get("state"), (Object)TaskState.Created)});
        List taskList = session.createQuery(criteriaQuery).getResultList();
        return taskList;
    }

    private ProcessInstance getProcessInstanceByRootProcessInstanceId(Long rootProcessInstanceId) {
        Session session = this.context.getSession();
        CriteriaBuilder build = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = build.createQuery(ProcessInstance.class);
        Root root = criteriaQuery.from(ProcessInstance.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)build.equal((Expression)root.get("rootId"), (Object)rootProcessInstanceId));
        criteriaQuery.orderBy(new Order[]{build.desc((Expression)root.get("rootId"))});
        ProcessInstance processInstance = (ProcessInstance)session.createQuery(criteriaQuery).setMaxResults(1).uniqueResult();
        return processInstance;
    }

    private List<ProcessInstance> getProcessInstanceListByRootProcessInstanceId(Long rootProcessInstanceId) {
        Session session = this.context.getSession();
        CriteriaBuilder build = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = build.createQuery(ProcessInstance.class);
        Root root = criteriaQuery.from(ProcessInstance.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)build.equal((Expression)root.get("rootId"), (Object)rootProcessInstanceId));
        List processInstances = session.createQuery(criteriaQuery).getResultList();
        return processInstances;
    }

    private HistoryProcessInstance getHistoryProcessInstanceByRootProcessInstanceId(Long rootProcessInstanceId) {
        Session session = this.context.getSession();
        CriteriaBuilder build = session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = build.createQuery(HistoryProcessInstance.class);
        Root root = criteriaQuery.from(HistoryProcessInstance.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where((Expression)build.equal((Expression)root.get("processInstanceId"), (Object)rootProcessInstanceId));
        criteriaQuery.orderBy(new Order[]{build.desc((Expression)root.get("processInstanceId"))});
        HistoryProcessInstance processInstance = (HistoryProcessInstance)session.createQuery(criteriaQuery).setMaxResults(1).uniqueResult();
        return processInstance;
    }

    @Override
    public AuditOutputParamVO submit(AuditInputParamVO auditVO) {
        if (StringUtils.isEmpty((CharSequence)auditVO.getProcessName())) {
            throw new ELSBootException("processName" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        AuditOutputParamVO result = new AuditOutputParamVO();
        StartProcessInfo info = new StartProcessInfo(user.getElsAccount() + "_" + user.getSubAccount() + "_" + user.getRealname());
        info.setTag(auditVO.getBusinessType());
        info.setBusinessId(auditVO.getBusinessId());
        info.setVariables(auditVO.getVariables());
        info.setSubject(auditVO.getAuditSubject());
        info.setCompleteStartTaskOpinion(auditVO.getAuditOpinion());
        ProcessInstance processInstance = this.processService.startProcessByName(auditVO.getProcessName() + "_" + user.getElsAccount(), info);
        UfloHisTask hisTask = new UfloHisTask();
        hisTask.setBusinessId(processInstance.getBusinessId());
        hisTask.setEndDate(new Date());
        this.ufloHisTaskMapper.updateByBusinessId(hisTask);
        result.setProcessRootId(processInstance.getId() + "");
        result.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        result.setSubmitUser(info.getPromoter());
        List<Task> taskList = this.getTaskListByRootProcessInstanceId(processInstance.getId());
        if (taskList != null) {
            List<String> auditUserList = taskList.parallelStream().map(Task::getAssignee).collect(Collectors.toList());
            result.setNextAuditUserList(auditUserList);
            List prevTaskList = taskList.parallelStream().map(Task::getPrevTask).collect(Collectors.toList());
            StringBuilder redisKey = new StringBuilder(UFLO_PREV_TASK_REDIS_KEY);
            redisKey.append(user.getElsAccount()).append("_").append(user.getSubAccount()).append("_").append(processInstance.getId());
            this.redisUtil.lSet(redisKey.toString(), prevTaskList);
        }
        return result;
    }

    @Override
    public AuditOutputParamVO complete(AuditInputParamVO auditVO) {
        AuditOutputParamVO result = new AuditOutputParamVO();
        if (auditVO.getRootProcessInstanceId() == null) {
            throw new ELSBootException("rootProcessInstanceId" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        long rootProcessInstanceId = auditVO.getRootProcessInstanceId();
        result.setProcessRootId(rootProcessInstanceId + "");
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String currentUser = user.getElsAccount() + "_" + user.getSubAccount() + "_" + user.getRealname();
        List<Task> currentTaskList = this.getTaskListByRootProcessInstanceId(rootProcessInstanceId);
        if (currentTaskList == null || currentTaskList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APxiTtkW_d01e66a8", (String)"\u5f53\u524d\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        }
        List currentUserTaskList = currentTaskList.parallelStream().filter(vo -> TaskState.Created.equals((Object)vo.getState()) && currentUser.equals(vo.getAssignee())).collect(Collectors.toList());
        if (currentUserTaskList == null || currentUserTaskList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RjAPUzLnOtkUzW_dfbf83e1", (String)"\u53ea\u6709\u5f53\u524d\u5ba1\u6279\u4eba\u624d\u80fd\u64cd\u4f5c\u5ba1\u6279\uff01"));
        }
        long taskId = ((Task)currentUserTaskList.get(0)).getId();
        this.taskService.start(taskId);
        this.taskService.complete(taskId, auditVO.getVariables(), new TaskOpinion(auditVO.getAuditOpinion()));
        UfloHisTask hisTask = new UfloHisTask();
        hisTask.setBusinessId(auditVO.getBusinessId());
        hisTask.setOpinion(auditVO.getAuditOpinion());
        hisTask.setEndDate(new Date());
        this.ufloHisTaskMapper.updateByBusinessId(hisTask);
        List<Task> taskList = this.getTaskListByRootProcessInstanceId(rootProcessInstanceId);
        ProcessInstance processInstance = this.getProcessInstanceByRootProcessInstanceId(rootProcessInstanceId);
        if (processInstance != null) {
            result.setSubmitUser(processInstance.getPromoter());
        } else {
            HistoryProcessInstance historyProcessInstance = this.getHistoryProcessInstanceByRootProcessInstanceId(rootProcessInstanceId);
            result.setSubmitUser(historyProcessInstance.getPromoter());
        }
        StringBuilder redisKey = new StringBuilder(UFLO_PREV_TASK_REDIS_KEY);
        redisKey.append(user.getElsAccount()).append("_").append(user.getSubAccount()).append("_").append(auditVO.getRootProcessInstanceId());
        if (taskList == null || taskList.size() == 0) {
            result.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            this.redisUtil.del(new String[]{redisKey.toString()});
        } else {
            result.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
            List redisPrevTaskList = this.redisUtil.lGet(redisKey.toString(), 0L, Integer.MAX_VALUE);
            List<String> auditUserList = null;
            auditUserList = redisPrevTaskList != null ? taskList.parallelStream().filter(vo -> !redisPrevTaskList.contains(vo.getPrevTask())).map(Task::getAssignee).collect(Collectors.toList()) : taskList.parallelStream().map(Task::getAssignee).collect(Collectors.toList());
            if (auditUserList != null && auditUserList.size() > 0) {
                List prevTaskList = taskList.parallelStream().map(Task::getPrevTask).collect(Collectors.toList());
                prevTaskList.addAll(redisPrevTaskList);
                this.redisUtil.lSet(redisKey.toString(), prevTaskList);
            }
            result.setNextAuditUserList(auditUserList);
        }
        return result;
    }

    private String cancelCheckAndResult(Session session, List<Task> taskList, long rootProcessInstanceId, String currentUser) {
        if (taskList == null || taskList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExiTqXW_8e60fce6", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64a4\u9500\uff01"));
        }
        List createTaskList = taskList.parallelStream().filter(vo -> TaskState.Created.equals((Object)vo.getState())).collect(Collectors.toList());
        if (createTaskList == null || createTaskList.isEmpty()) {
            log.error("createTaskList is null");
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExiTqXW_8e60fce6", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64a4\u9500\uff01"));
        }
        List parentTaskList = taskList.parallelStream().filter(vo -> ((Task)createTaskList.get(0)).getPrevTask().equals(vo.getNodeName())).collect(Collectors.toList());
        if (parentTaskList == null || parentTaskList.isEmpty()) {
            ProcessInstance processInstance = this.getProcessInstanceByRootProcessInstanceId(rootProcessInstanceId);
            if (!processInstance.getPromoter().equals(currentUser)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RjAPQLzEjXtUzLnOqXUzW_587d0a4e", (String)"\u53ea\u6709\u5f53\u524d\u6d41\u7a0b\u72b6\u6001\u7684\u4e0a\u7ea7\u5ba1\u6279\u4eba\u624d\u80fd\u64a4\u9500\u5ba1\u6279\uff01"));
            }
            return AuditStatusEnum.AUDIT_NEW.getValue();
        }
        if (parentTaskList.size() > 1) {
            log.error("\u5b58\u5728\u591a\u4e2a\u7236\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500");
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExiTqXW_8e60fce6", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64a4\u9500\uff01"));
        }
        if (!((Task)parentTaskList.get(0)).getAssignee().equals(currentUser)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RjAPQLzEjXtUzLnOqXUzW_587d0a4e", (String)"\u53ea\u6709\u5f53\u524d\u6d41\u7a0b\u72b6\u6001\u7684\u4e0a\u7ea7\u5ba1\u6279\u4eba\u624d\u80fd\u64a4\u9500\u5ba1\u6279\uff01"));
        }
        List commonParentTaskList = taskList.parallelStream().filter(vo -> ((Task)createTaskList.get(0)).getPrevTask().equals(vo.getPrevTask())).collect(Collectors.toList());
        List commonParentTaskCompletedList = commonParentTaskList.parallelStream().filter(vo -> TaskState.Completed.equals((Object)vo.getState())).collect(Collectors.toList());
        if (commonParentTaskCompletedList.size() > 0) {
            log.error("\u5b58\u5728\u5176\u4ed6\u8005\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\uff01");
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APxiTqXW_d0263b9b", (String)"\u5f53\u524d\u4e0d\u5141\u8bb8\u64a4\u9500\uff01"));
        }
        return AuditStatusEnum.AUDIT_DOING.getValue();
    }

    @Override
    public AuditOutputParamVO cancel(AuditInputParamVO auditVO) {
        AuditOutputParamVO result = new AuditOutputParamVO();
        if (auditVO.getRootProcessInstanceId() == null) {
            throw new ELSBootException("rootProcessInstanceId" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        long rootProcessInstanceId = auditVO.getRootProcessInstanceId();
        result.setProcessRootId(rootProcessInstanceId + "");
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String currentUser = user.getElsAccount() + "_" + user.getSubAccount() + "_" + user.getRealname();
        String option = StringUtils.isEmpty((CharSequence)auditVO.getAuditOpinion()) ? "\u64a4\u9500\u5ba1\u6279" : auditVO.getAuditOpinion();
        List<Task> taskList = this.getTaskListByRootProcessInstanceId(rootProcessInstanceId);
        Session session = this.context.getSession();
        String auditStatus = this.cancelCheckAndResult(session, taskList, rootProcessInstanceId, currentUser);
        List createTaskList = taskList.parallelStream().filter(vo -> TaskState.Created.equals((Object)vo.getState())).collect(Collectors.toList());
        ProcessInstance processInstance = this.getProcessInstanceByRootProcessInstanceId(rootProcessInstanceId);
        if (auditStatus == AuditStatusEnum.AUDIT_NEW.getValue()) {
            this.ufloTaskMapper.deleteByPrevTask(((Task)createTaskList.get(0)).getPrevTask(), rootProcessInstanceId);
            this.ufloProcessInstanceMapper.deleteById(rootProcessInstanceId);
            UfloHisTask hisTask = new UfloHisTask();
            BeanUtils.copyProperties(createTaskList.get(0), (Object)hisTask);
            hisTask.setId(IDGenerator.getInstance().nextId());
            hisTask.setTaskId(((Task)createTaskList.get(0)).getId());
            hisTask.setHisProcessInstanceId(processInstance.getHistoryProcessInstanceId());
            hisTask.setEndDate(new Date());
            hisTask.setState(TaskState.Canceled.toString());
            hisTask.setType(((Task)createTaskList.get(0)).getType().name());
            hisTask.setOpinion(option);
            this.ufloHisTaskMapper.insert(hisTask);
        } else {
            List<ProcessInstance> processInstanceList = this.getProcessInstanceListByRootProcessInstanceId(rootProcessInstanceId);
            for (ProcessInstance instance : processInstanceList) {
                this.ufloHisActivityMapper.deleteByNodeNameAndProcessId(instance.getCurrentNode(), instance.getId());
            }
            UfloProcessInstanceVO instanceVO = new UfloProcessInstanceVO();
            instanceVO.setId(rootProcessInstanceId);
            instanceVO.setCurrentNode(((Task)createTaskList.get(0)).getPrevTask());
            instanceVO.setCurrentTask(instanceVO.getCurrentNode());
            this.ufloProcessInstanceMapper.updateById(instanceVO);
            List<Long> processInstanceIdList = createTaskList.parallelStream().filter(vo -> vo.getProcessInstanceId() != rootProcessInstanceId).map(Task::getProcessInstanceId).distinct().collect(Collectors.toList());
            if (processInstanceIdList.size() > 0) {
                this.ufloProcessInstanceMapper.batchDeleteById(processInstanceIdList);
            }
            this.ufloTaskMapper.deleteByPrevTask(((Task)createTaskList.get(0)).getPrevTask(), rootProcessInstanceId);
            List parentTaskList = taskList.parallelStream().filter(vo -> ((Task)createTaskList.get(0)).getPrevTask().equals(vo.getNodeName())).collect(Collectors.toList());
            UfloTask ufloTask = new UfloTask();
            ufloTask.setTaskId(((Task)parentTaskList.get(0)).getId());
            ufloTask.setProgress(0);
            ufloTask.setState(TaskState.Created.toString());
            this.ufloTaskMapper.updateById(ufloTask);
            UfloHisActivityVO activityVO = new UfloHisActivityVO();
            activityVO.setProcessInstanceId(((Task)parentTaskList.get(0)).getProcessInstanceId());
            activityVO.setNodeName(((Task)parentTaskList.get(0)).getNodeName());
            this.ufloHisActivityMapper.updateByNodeNameAndProcessId(activityVO);
            UfloHisTask hisTask = new UfloHisTask();
            BeanUtils.copyProperties(parentTaskList.get(0), (Object)hisTask);
            hisTask.setId(IDGenerator.getInstance().nextId());
            hisTask.setTaskId(((Task)parentTaskList.get(0)).getId());
            hisTask.setHisProcessInstanceId(processInstance.getHistoryProcessInstanceId());
            hisTask.setEndDate(new Date());
            hisTask.setState(TaskState.Canceled.toString());
            hisTask.setType(((Task)parentTaskList.get(0)).getType().name());
            hisTask.setOpinion(option);
            this.ufloHisTaskMapper.insert(hisTask);
        }
        StringBuilder redisKey = new StringBuilder(UFLO_PREV_TASK_REDIS_KEY);
        redisKey.append(currentUser).append("_").append(auditVO.getRootProcessInstanceId());
        List redisPrevTaskList = this.redisUtil.lGet(redisKey.toString(), 0L, Integer.MAX_VALUE);
        if (redisPrevTaskList != null && redisPrevTaskList.size() > 0) {
            List resultPrevTaskList = redisPrevTaskList.parallelStream().filter(o -> !o.equals(((Task)createTaskList.get(0)).getPrevTask())).collect(Collectors.toList());
            this.redisUtil.lSet(redisKey.toString(), resultPrevTaskList);
        }
        List<String> nextAuditUserList = createTaskList.parallelStream().map(Task::getAssignee).collect(Collectors.toList());
        result.setNextAuditUserList(nextAuditUserList);
        result.setSubmitUser(processInstance.getPromoter());
        result.setAuditStatus(auditStatus);
        result.setProcessRootId(rootProcessInstanceId + "");
        return result;
    }

    @Override
    public AuditOutputParamVO reject(AuditInputParamVO auditVO) {
        AuditOutputParamVO result = new AuditOutputParamVO();
        if (auditVO.getRootProcessInstanceId() == null) {
            throw new ELSBootException("rootProcessInstanceId" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        long rootProcessInstanceId = auditVO.getRootProcessInstanceId();
        result.setProcessRootId(rootProcessInstanceId + "");
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String currentUser = user.getElsAccount() + "_" + user.getSubAccount() + "_" + user.getRealname();
        String option = StringUtils.isEmpty((CharSequence)auditVO.getAuditOpinion()) ? "\u5ba1\u6279\u62d2\u7edd" : auditVO.getAuditOpinion();
        List<Task> taskList = this.getTaskListByRootProcessInstanceId(rootProcessInstanceId);
        ProcessInstance processInstance = this.getProcessInstanceByRootProcessInstanceId(rootProcessInstanceId);
        if (taskList == null || taskList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APxiTtkW_d01e66a8", (String)"\u5f53\u524d\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        }
        List createUserList = taskList.parallelStream().filter(vo -> TaskState.Created.equals((Object)vo.getState())).map(Task::getAssignee).collect(Collectors.toList());
        if (!createUserList.contains(currentUser)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RjAPUzLnOFKUzW_d96f0c45", (String)"\u53ea\u6709\u5f53\u524d\u5ba1\u6279\u4eba\u624d\u80fd\u62d2\u7edd\u5ba1\u6279\uff01"));
        }
        List createTaskList = taskList.parallelStream().filter(vo -> TaskState.Created.equals((Object)vo.getState())).filter(vo -> vo.getAssignee().equals(currentUser)).collect(Collectors.toList());
        this.ufloProcessInstanceMapper.deleteByRootId(rootProcessInstanceId);
        this.ufloTaskMapper.deleteByRootId(rootProcessInstanceId);
        UfloHisTask hisTask = new UfloHisTask();
        BeanUtils.copyProperties(createTaskList.get(0), (Object)hisTask);
        hisTask.setId(IDGenerator.getInstance().nextId());
        hisTask.setTaskId(((Task)createTaskList.get(0)).getId());
        hisTask.setHisProcessInstanceId(processInstance.getHistoryProcessInstanceId());
        hisTask.setEndDate(new Date());
        hisTask.setState(TaskState.Withdraw.name());
        hisTask.setType(((Task)createTaskList.get(0)).getType().name());
        hisTask.setOpinion(option);
        this.ufloHisTaskMapper.insert(hisTask);
        StringBuilder redisKey = new StringBuilder(UFLO_PREV_TASK_REDIS_KEY);
        redisKey.append(currentUser).append("_").append(auditVO.getRootProcessInstanceId());
        this.redisUtil.del(new String[]{redisKey.toString()});
        result.setNextAuditUserList(createUserList.parallelStream().filter(o -> !o.equals(currentUser)).collect(Collectors.toList()));
        result.setSubmitUser(processInstance.getPromoter());
        result.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
        result.setProcessRootId(rootProcessInstanceId + "");
        return result;
    }
}

