/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.config;

import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

@Configuration
public class UfloDataSourceConfig {
    @Bean
    public LocalSessionFactoryBean entityManagerFactory(DataSource dataSource) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setPackagesToScan(new String[]{"com.bstek.uflo.model*"});
        Properties prop = new Properties();
        prop.put("hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
        prop.put("hibernate.show_sql", (Object)false);
        prop.put("hibernate.hbm2ddl.auto", "update");
        prop.put("hibernate.jdbc.batch_size", (Object)100);
        sessionFactoryBean.setHibernateProperties(prop);
        return sessionFactoryBean;
    }

    @Bean(value={"hibernateTransactionManager"})
    public HibernateTransactionManager hibernateTransactionManager(SessionFactory entityManagerFactory, DataSource dataSource) {
        HibernateTransactionManager hi = new HibernateTransactionManager();
        hi.setSessionFactory(entityManagerFactory);
        hi.setDataSource(dataSource);
        return hi;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }
}

