/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.uflo.entity.AuditConfig;
import com.els.modules.uflo.service.AuditConfigService;
import com.els.modules.uflo.service.UfloAuditService;
import com.els.modules.uflo.vo.AuditInputParamVO;
import com.els.modules.uflo.vo.UfloHisTask;
import com.els.modules.uflo.vo.UfloTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba1\u6279"})
@RestController
@RequestMapping(value={"/elsUflo/audit"})
public class AuditController
extends BaseController<AuditConfig, AuditConfigService> {
    @Autowired
    private UfloAuditService ufloAuditService;

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u63d0\u4ea4\u5ba1\u6279")
    @ApiOperation(value="\u5ba1\u6279-\u63d0\u4ea4\u5ba1\u6279", notes="\u5ba1\u6279-\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody AuditInputParamVO inputParamVO) {
        this.ufloAuditService.submit(inputParamVO);
        return this.commonSuccessResult(2);
    }

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u5ba1\u6279\u901a\u8fc7")
    @ApiOperation(value="\u5ba1\u6279-\u5ba1\u6279\u901a\u8fc7", notes="\u5ba1\u6279-\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"/complete"})
    public Result<?> complete(@RequestBody AuditInputParamVO inputParamVO) {
        this.ufloAuditService.complete(inputParamVO);
        return this.commonSuccessResult(2);
    }

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u5ba1\u6279\u901a\u8fc7")
    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7", notes="\u5ba1\u6279\u901a\u8fc7")
    @GetMapping(value={"/completeByOut"})
    public Result<?> completeByOut(@RequestParam(name="rootProcessInstanceId") Long rootProcessInstanceId, @RequestParam(name="businessId") String businessId, @RequestParam(name="businessType") String businessType) {
        AuditInputParamVO inputParamVO = new AuditInputParamVO();
        inputParamVO.setRootProcessInstanceId(rootProcessInstanceId);
        inputParamVO.setBusinessId(businessId);
        inputParamVO.setBusinessType(businessType);
        return this.complete(inputParamVO);
    }

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u5ba1\u6279\u62d2\u7edd")
    @ApiOperation(value="\u5ba1\u6279\u62d2\u7edd", notes="\u5ba1\u6279\u62d2\u7edd")
    @GetMapping(value={"/rejectByOut"})
    public Result<?> rejectByOut(@RequestParam(name="rootProcessInstanceId") Long rootProcessInstanceId, @RequestParam(name="businessId") String businessId, @RequestParam(name="businessType") String businessType) {
        AuditInputParamVO inputParamVO = new AuditInputParamVO();
        inputParamVO.setRootProcessInstanceId(rootProcessInstanceId);
        inputParamVO.setBusinessId(businessId);
        inputParamVO.setBusinessType(businessType);
        return this.reject(inputParamVO);
    }

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u64a4\u9500\u5ba1\u6279")
    @ApiOperation(value="\u5ba1\u6279-\u64a4\u9500\u5ba1\u6279", notes="\u5ba1\u6279-\u64a4\u9500\u5ba1\u6279")
    @PostMapping(value={"/cancel"})
    @RequiresPermissions(value={"audit#audit:operate"})
    public Result<?> cancel(@RequestBody AuditInputParamVO inputParamVO) {
        this.ufloAuditService.cancel(inputParamVO);
        return this.commonSuccessResult(2);
    }

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u5ba1\u6279\u62d2\u7edd")
    @ApiOperation(value="\u5ba1\u6279-\u5ba1\u6279\u62d2\u7edd", notes="\u5ba1\u6279-\u5ba1\u6279\u62d2\u7edd")
    @PostMapping(value={"/reject"})
    @RequiresPermissions(value={"audit#audit:operate"})
    public Result<?> reject(@RequestBody AuditInputParamVO inputParamVO) {
        this.ufloAuditService.reject(inputParamVO);
        return this.commonSuccessResult(2);
    }

    @ApiOperation(value="\u5ba1\u6279-\u5f85\u5ba1\u6279\u5217\u8868", notes="\u5ba1\u6279-\u5f85\u5ba1\u6279\u5217\u8868")
    @GetMapping(value={"/todoPagelist"})
    public Result<?> todoPagelist(AuditConfig auditConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        UfloTask task = new UfloTask();
        task.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        task.setPageSize(pageSize);
        task.setSubject(req.getParameter("subject"));
        IPage<UfloTask> pageList = this.ufloAuditService.todoPagelist(task);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5ba1\u6279-\u5df2\u5ba1\u6279\u5217\u8868", notes="\u5ba1\u6279-\u5df2\u5ba1\u6279\u5217\u8868")
    @GetMapping(value={"/donePagelist"})
    public Result<?> donePagelist(AuditConfig auditConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        UfloHisTask task = new UfloHisTask();
        task.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        task.setPageSize(pageSize);
        task.setSubject(req.getParameter("subject"));
        IPage<UfloHisTask> pageList = this.ufloAuditService.donePagelist(task);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5ba1\u6279-\u5ba1\u6279\u8bb0\u5f55", notes="\u5ba1\u6279-\u5ba1\u6279\u8bb0\u5f55")
    @GetMapping(value={"/auditHislist"})
    @RequiresPermissions(value={"audit#audit:operate"})
    public Result<?> auditHislist(AuditConfig auditConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        UfloHisTask task = new UfloHisTask();
        task.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        task.setPageSize(pageSize);
        if (StrUtil.isBlank((CharSequence)req.getParameter("businessId"))) {
            throw new ELSBootException("businessId" + I18nUtil.translate((String)"i18n_alert_WWWWWWWWWxOLVW_c2c7a97", (String)"\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        task.setBusinessId(req.getParameter("businessId"));
        IPage<UfloHisTask> pageList = this.ufloAuditService.auditHislist(task);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u5ba1\u6279\u7ba1\u7406", value="\u8f6c\u529e")
    @ApiOperation(value="\u5ba1\u6279-\u8f6c\u529e", notes="\u5ba1\u6279-\u8f6c\u529e")
    @PostMapping(value={"/deliverTo"})
    public Result<?> deliverTo(@RequestBody UfloTask task) {
        this.ufloAuditService.deliverTo(task);
        return this.commonSuccessResult(2);
    }
}

