/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.provider.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bstek.uflo.console.provider.ProcessFile;
import com.bstek.uflo.console.provider.ProcessProvider;
import com.els.common.system.vo.LoginUser;
import com.els.modules.uflo.entity.UfloFile;
import com.els.modules.uflo.mapper.UfloFileMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ureport.database.provider")
public class UfloDatabaseProviderImpl
implements ProcessProvider {
    private static final String NAME = "mysql-provider";
    private String prefix = "mysql:";
    private boolean disabled;
    @Resource
    private UfloFileMapper ufloFileMapper;

    public InputStream loadProcess(String file) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        queryWrapper.eq(UfloFile::getName, (Object)this.getCorrectName(file));
        queryWrapper.eq(UfloFile::getElsAccount, (Object)user.getElsAccount());
        UfloFile ureportFileEntity = (UfloFile)this.ufloFileMapper.selectOne((Wrapper)queryWrapper);
        byte[] content = ureportFileEntity.getContent();
        return new ByteArrayInputStream(content);
    }

    public void deleteProcess(String file) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        queryWrapper.eq(UfloFile::getName, (Object)this.getCorrectName(file));
        queryWrapper.eq(UfloFile::getElsAccount, (Object)user.getElsAccount());
        this.ufloFileMapper.delete((Wrapper)queryWrapper);
    }

    public List<ProcessFile> loadAllProcesses() {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List list = this.ufloFileMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(UfloFile::getElsAccount, (Object)user.getElsAccount()));
        ArrayList<ProcessFile> reportList = new ArrayList<ProcessFile>();
        for (UfloFile ureportFileEntity : list) {
            reportList.add(new ProcessFile(ureportFileEntity.getName(), ureportFileEntity.getUpdateTime()));
        }
        return reportList;
    }

    public void saveProcess(String file, String content) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        file = this.getCorrectName(file);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UfloFile::getName, (Object)file);
        queryWrapper.eq(UfloFile::getElsAccount, (Object)user.getElsAccount());
        UfloFile ureportFileEntity = (UfloFile)this.ufloFileMapper.selectOne((Wrapper)queryWrapper);
        if (ureportFileEntity == null) {
            ureportFileEntity = new UfloFile();
            ureportFileEntity.setName(file);
            ureportFileEntity.setElsAccount(user.getElsAccount());
            ureportFileEntity.setContent(content.getBytes(StandardCharsets.UTF_8));
            this.ufloFileMapper.insert(ureportFileEntity);
        } else {
            ureportFileEntity.setContent(content.getBytes(StandardCharsets.UTF_8));
            this.ufloFileMapper.update(ureportFileEntity, (Wrapper)queryWrapper);
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    private String getCorrectName(String name) {
        if (name.startsWith(this.prefix)) {
            name = name.substring(this.prefix.length());
        }
        return name;
    }

    public boolean support(String fileName) {
        return fileName.startsWith(this.prefix);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setUfloFileMapper(UfloFileMapper ufloFileMapper) {
        this.ufloFileMapper = ufloFileMapper;
    }
}

