/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.uflo.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SelectionsDto;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.uflo.entity.AuditConfig;
import com.els.modules.uflo.service.AuditConfigService;
import com.els.modules.uflo.service.AuditOptCallBackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Api(tags={"\u5ba1\u6279\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/elsUflo/auditConfig"})
public class AuditConfigController
extends BaseController<AuditConfig, AuditConfigService> {
    @Autowired
    private AuditConfigService auditConfigService;

    @AutoLog(value="\u5ba1\u6279\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5ba1\u6279\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(AuditConfig auditConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)auditConfig), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.auditConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u67e5\u8be2\u4e1a\u52a1\u5b9e\u73b0bean\u5217\u8868", notes="\u5ba1\u6279\u914d\u7f6e-\u67e5\u8be2\u4e1a\u52a1\u5b9e\u73b0bean\u5217\u8868")
    @GetMapping(value={"/queryImplBeanList"})
    public Result<?> queryImplBeanList(HttpServletRequest req) {
        String[] beans = SpringContextUtils.getApplicationContext().getBeanNamesForType(AuditOptCallBackService.class);
        return Result.ok((Object)beans);
    }

    @AutoLog(value="\u5ba1\u6279\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u6dfb\u52a0", notes="\u5ba1\u6279\u914d\u7f6e-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody AuditConfig auditConfig) {
        this.auditConfigService.saveAuditConfig(auditConfig);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u5ba1\u6279\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u7f16\u8f91", notes="\u5ba1\u6279\u914d\u7f6e-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody AuditConfig auditConfig) {
        this.auditConfigService.updateAuditConfig(auditConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5ba1\u6279\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", notes="\u5ba1\u6279\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.auditConfigService.delAuditConfig(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5ba1\u6279\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u6279\u91cf\u5220\u9664", notes="\u5ba1\u6279\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.auditConfigService.delBatchAuditConfig(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u5ba1\u6279\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2", notes="\u5ba1\u6279\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        AuditConfig auditConfig = (AuditConfig)((Object)this.auditConfigService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)auditConfig));
    }

    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, AuditConfig auditConfig, @RequestBody SelectionsDto selectionsDto) {
        List<String> selectionList;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)auditConfig), (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String[] ids = selectionsDto.getSelections();
        if (ConvertUtils.isNotEmpty((Object)ids) && CollectionUtil.isNotEmpty(selectionList = Arrays.asList(ids))) {
            queryWrapper.clear();
            Map parameterMap = request.getParameterMap();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)parameterMap, (Object)((Object)auditConfig));
            queryWrapper.in((Object)"id", selectionList);
        }
        List auditConfigList = this.auditConfigService.list((Wrapper)queryWrapper);
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u5ba1\u6279\u914d\u7f6e");
        mv.addObject("entity", AuditConfig.class);
        mv.addObject("params", (Object)new ExportParams("\u5ba1\u6279\u914d\u7f6e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u5ba1\u6279\u914d\u7f6e", request.getParameter("defineColumnCode")));
        mv.addObject("data", (Object)auditConfigList);
        return mv;
    }

    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, AuditConfig.class);
    }
}

