/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email;

import com.els.common.constant.CommonConstant;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.employ.api.dto.ElsEmployeInfoDTO;
import com.els.modules.employ.api.service.EmployeeInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EmailSendService {
    @Autowired
    private AccountRpcService accountRpcService;
    @Autowired
    private EmployeeInfoRpcService employeeInfoRpcService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PersonalSettingService personalSettingService;

    public void bindEmail(String elsAccount, String subAccount, ElsSubAccount elsSubAccount) {
        String email = this.getEmail(elsAccount, subAccount);
        if (StringUtils.isEmpty((Object)email)) {
            return;
        }
        elsSubAccount.setEmail(email);
        this.elsSubAccountService.updateById((Object)elsSubAccount);
    }

    public String getEmail(String elsAccount, String subAccount) {
        String email = "";
        ElsSubAccountDTO accountDTO = this.accountRpcService.getAccount(elsAccount, subAccount);
        if (accountDTO == null) {
            return email;
        }
        ElsEmployeInfoDTO employeeInfo = this.employeeInfoRpcService.getEmployeeInfoBySubAccountId(accountDTO.getId());
        if (employeeInfo != null && !StringUtils.isEmpty((Object)employeeInfo.getEmail()) && StringUtils.isEmpty((Object)(email = employeeInfo.getFbk7()))) {
            email = employeeInfo.getEmail();
        }
        return email;
    }

    public void enableEmailInfo(String elsAccount, String subAccount) {
        List personalSettings = this.personalSettingService.querySettingBySubAccount(elsAccount, subAccount);
        if (CollectionUtils.isEmpty((Collection)personalSettings)) {
            this.enableEmailMessage(elsAccount, subAccount);
            return;
        }
        List settings = personalSettings.stream().filter(setting -> !StringUtils.isEmpty((Object)setting.getReceiveType()) && "EMAIL".equals(setting.getReceiveType()) && setting.getIsReceive() != null && setting.getIsReceive() == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(settings)) {
            this.enableEmailMessage(elsAccount, subAccount);
        }
    }

    public void enableEmailMessage(String elsAccount, String subAccount) {
        PersonalSetting personalSetting = new PersonalSetting();
        personalSetting.setReceiveType("EMAIL");
        personalSetting.setIsReceive(CommonConstant.STATUS_NO);
        this.personalSettingService.saveNewSetting(elsAccount, subAccount, personalSetting);
    }

    public void checkBindEmail(String elsAccount, String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getUserByAccount(elsAccount + "_" + subAccount);
        if (elsSubAccount == null) {
            return;
        }
        if (StringUtils.isEmpty((Object)elsSubAccount.getEmail())) {
            this.bindEmail(elsAccount, subAccount, elsSubAccount);
            this.enableEmailInfo(elsAccount, subAccount);
        } else {
            this.enableEmailInfo(elsAccount, subAccount);
        }
    }
}

