/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.changeApply.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.changeApply.entity.PurchaseChangeApply;
import com.els.modules.changeApply.mapper.PurchaseChangeApplyMapper;
import com.els.modules.changeApply.service.PurchaseChangeApplyService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseChangeApplyServiceImpl
extends BaseServiceImpl<PurchaseChangeApplyMapper, PurchaseChangeApply>
implements PurchaseChangeApplyService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseChangeApply purchaseChangeApply, List<PurchaseAttachment> purchaseAttachmentList) {
        purchaseChangeApply.setChangeNumber(this.invokeBaseRpcService.getNextCode("changeApply", (Object)purchaseChangeApply));
        ((PurchaseChangeApplyMapper)this.baseMapper).insert((Object)purchaseChangeApply);
        super.setHeadDefaultValue((BaseEntity)purchaseChangeApply);
        this.insertData(purchaseChangeApply, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseChangeApply purchaseChangeApply, List<PurchaseAttachment> purchaseAttachmentList) {
        int count = ((PurchaseChangeApplyMapper)this.baseMapper).updateById((Object)purchaseChangeApply);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseAttachmentService.deleteByMainId(purchaseChangeApply.getId());
        this.insertData(purchaseChangeApply, purchaseAttachmentList);
    }

    private void insertData(PurchaseChangeApply purchaseChangeApply, List<PurchaseAttachment> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachment entity : purchaseAttachmentList) {
                entity.setHeadId(purchaseChangeApply.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseChangeApply);
            }
            this.purchaseAttachmentService.saveBatch(purchaseAttachmentList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseAttachmentService.deleteByMainId(id);
        ((PurchaseChangeApplyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseAttachmentService.deleteByMainId(serializable.toString());
            ((PurchaseChangeApplyMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

