/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.employ.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.mapper.ElsEmployeInfoMapper;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.system.controller.ElsSubAccountController;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ElsEmployeInfoServiceImpl
extends BaseServiceImpl<ElsEmployeInfoMapper, ElsEmployeInfo>
implements ElsEmployeInfoService {
    @Autowired
    private ElsSubAccountController elsSubAccountController;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    @Override
    @Transactional
    public void add(ElsEmployeInfo elsEmployeInfo) {
        String employNumber = this.invokeBaseRpcService.getNextCode("employeInfo", (Object)elsEmployeInfo);
        employNumber = employNumber.replace("MM", elsEmployeInfo.getPersonnelType());
        List pinyins = HanLP.convertToPinyinList((String)elsEmployeInfo.getLoginName());
        StringBuilder namePinYin = new StringBuilder();
        for (Pinyin s : pinyins) {
            namePinYin.append(s.getPinyinWithoutTone());
        }
        elsEmployeInfo.setWorkNum(employNumber);
        if (EmployInfoStatusEnum.ON_TRIAL.getValue().equals(elsEmployeInfo.getEmployeeStatus()) || EmployInfoStatusEnum.ON_WORKER.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("selectedroles", (Object)"1599663987668365314");
            jsonObject.put("realname", (Object)elsEmployeInfo.getLoginName());
            jsonObject.put("subAccount", (Object)namePinYin.toString());
            jsonObject.put("password", (Object)"123456");
            jsonObject.put("workNo", (Object)employNumber);
            Result result = this.elsSubAccountController.add(jsonObject);
            JSONObject subAccount = (JSONObject)result.getResult();
            elsEmployeInfo.setSubAccountId(subAccount.getString("id"));
        }
        ((ElsEmployeInfoMapper)this.baseMapper).insert((Object)elsEmployeInfo);
    }

    @Override
    @Transactional
    public void edit(ElsEmployeInfo elsEmployeInfo) {
        LambdaUpdateWrapper subAccountWrapper;
        if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus()) && StringUtils.isNotEmpty((String)elsEmployeInfo.getSubAccountId())) {
            subAccountWrapper = new UpdateWrapper().lambda();
            subAccountWrapper.eq(BaseEntity::getId, (Object)elsEmployeInfo.getSubAccountId());
            subAccountWrapper.set(ElsSubAccount::getStatus, (Object)AccountStatusEnum.FROZEN.getCode());
            this.elsSubAccountService.update((Wrapper)subAccountWrapper);
        } else if ((EmployInfoStatusEnum.ON_TRIAL.getValue().equals(elsEmployeInfo.getEmployeeStatus()) || EmployInfoStatusEnum.ON_WORKER.getValue().equals(elsEmployeInfo.getEmployeeStatus())) && StringUtils.isEmpty((String)elsEmployeInfo.getSubAccountId())) {
            List pinyins = HanLP.convertToPinyinList((String)elsEmployeInfo.getLoginName());
            StringBuilder namePinYin = new StringBuilder();
            for (Pinyin s : pinyins) {
                namePinYin.append(s.getPinyinWithoutTone());
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("selectedroles", (Object)"1599663987668365314");
            jsonObject.put("realname", (Object)elsEmployeInfo.getLoginName());
            jsonObject.put("subAccount", (Object)namePinYin.toString());
            jsonObject.put("password", (Object)"123456");
            jsonObject.put("workNo", (Object)elsEmployeInfo.getWorkNum());
            Result result = this.elsSubAccountController.add(jsonObject);
            JSONObject subAccount = (JSONObject)result.getResult();
            elsEmployeInfo.setSubAccountId(subAccount.getString("id"));
        } else if ((EmployInfoStatusEnum.ON_TRIAL.getValue().equals(elsEmployeInfo.getEmployeeStatus()) || EmployInfoStatusEnum.ON_WORKER.getValue().equals(elsEmployeInfo.getEmployeeStatus())) && StringUtils.isNotEmpty((String)elsEmployeInfo.getSubAccountId())) {
            subAccountWrapper = new UpdateWrapper().lambda();
            subAccountWrapper.eq(BaseEntity::getId, (Object)elsEmployeInfo.getSubAccountId());
            subAccountWrapper.set(ElsSubAccount::getStatus, (Object)AccountStatusEnum.NORMAL.getCode());
            this.elsSubAccountService.update((Wrapper)subAccountWrapper);
        }
        int count = ((ElsEmployeInfoMapper)this.baseMapper).updateById((Object)elsEmployeInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    @Transactional
    public void delete(String id) {
        ((ElsEmployeInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> idList) {
        ((ElsEmployeInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

