/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.manLeaveApply.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.manLeaveApply.entity.PurchaseManLeave;
import com.els.modules.manLeaveApply.mapper.PurchaseManLeaveMapper;
import com.els.modules.manLeaveApply.service.PurchaseManLeaveService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseManLeaveServiceImpl
extends BaseServiceImpl<PurchaseManLeaveMapper, PurchaseManLeave>
implements PurchaseManLeaveService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (purchaseManLeave.getLeaveStartDate() != null && purchaseManLeave.getLeaveEndDate() != null) {
            long leaveDays = DateUtil.betweenDay((Date)purchaseManLeave.getLeaveStartDate(), (Date)purchaseManLeave.getLeaveEndDate(), (boolean)true);
            purchaseManLeave.setLeaveDays(new BigDecimal(leaveDays));
        }
        purchaseManLeave.setUserName(loginUser.getRealname());
        purchaseManLeave.setUserId(loginUser.getId());
        purchaseManLeave.setManLeaveNum(this.invokeBaseRpcService.getNextCode("manLeaveApply", (Object)purchaseManLeave));
        LambdaQueryWrapper lambdaQueryWrapper = new QueryWrapper().lambda();
        lambdaQueryWrapper.eq(ElsEmployeInfo::getSubAccountId, (Object)loginUser.getId());
        ElsEmployeInfo elsEmployeInfo = (ElsEmployeInfo)((Object)this.elsEmployeInfoService.getOne((Wrapper)lambdaQueryWrapper));
        if (elsEmployeInfo != null) {
            if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
                throw new ELSBootException("\u5f53\u524d\u8d26\u6237\u5458\u5de5\u72b6\u6001\u4e3a\u5df2\u79bb\u804c,\u4e0d\u80fd\u521b\u5efa\u8bf7\u5047\u5355!");
            }
            purchaseManLeave.setPost(elsEmployeInfo.getRole());
        }
        ((PurchaseManLeaveMapper)this.baseMapper).insert((Object)purchaseManLeave);
        super.setHeadDefaultValue((BaseEntity)purchaseManLeave);
        this.insertData(purchaseManLeave, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        int count;
        if (purchaseManLeave.getLeaveStartDate() != null && purchaseManLeave.getLeaveEndDate() != null) {
            long leaveDays = DateUtil.betweenDay((Date)purchaseManLeave.getLeaveStartDate(), (Date)purchaseManLeave.getLeaveEndDate(), (boolean)true);
            purchaseManLeave.setLeaveDays(new BigDecimal(leaveDays));
        }
        Assert.isTrue(((count = ((PurchaseManLeaveMapper)this.baseMapper).updateById((Object)purchaseManLeave)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseAttachmentService.deleteByMainId(purchaseManLeave.getId());
        this.insertData(purchaseManLeave, purchaseAttachmentList);
    }

    private void insertData(PurchaseManLeave purchaseManLeave, List<PurchaseAttachment> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachment entity : purchaseAttachmentList) {
                entity.setHeadId(purchaseManLeave.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseManLeave);
            }
            this.purchaseAttachmentService.saveBatch(purchaseAttachmentList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseAttachmentService.deleteByMainId(id);
        ((PurchaseManLeaveMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseAttachmentService.deleteByMainId(serializable.toString());
            ((PurchaseManLeaveMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

