/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.resignationApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.employ.entity.ElsEmployeInfo;
import com.els.modules.employ.enumerate.EmployInfoStatusEnum;
import com.els.modules.employ.service.ElsEmployeInfoService;
import com.els.modules.resignationApply.entity.PurchaseResignationApply;
import com.els.modules.resignationApply.mapper.PurchaseResignationApplyMapper;
import com.els.modules.resignationApply.service.PurchaseResignationApplyService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseResignationApplyServiceImpl
extends BaseServiceImpl<PurchaseResignationApplyMapper, PurchaseResignationApply>
implements PurchaseResignationApplyService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsEmployeInfoService elsEmployeInfoService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseResignationApply purchaseResignationApply, List<PurchaseAttachment> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper resignationApplyLambdaQueryWrapper = new QueryWrapper().lambda();
        resignationApplyLambdaQueryWrapper.eq(PurchaseResignationApply::getApplyUserId, (Object)loginUser.getId());
        PurchaseResignationApply dbResignationApply = (PurchaseResignationApply)((Object)this.getOne((Wrapper)resignationApplyLambdaQueryWrapper));
        if (dbResignationApply != null) {
            throw new ELSBootException("\u5f53\u524d\u8d26\u53f7\u5df2\u7ecf\u586b\u5199\u8fc7\u8f9e\u804c\u7533\u8bf7\u4e0d\u80fd\u91cd\u590d\u521b\u5efa!");
        }
        purchaseResignationApply.setApplyUser(loginUser.getRealname());
        purchaseResignationApply.setApplyUserId(loginUser.getId());
        purchaseResignationApply.setResignationNumber(this.invokeBaseRpcService.getNextCode("convertApply", (Object)purchaseResignationApply));
        LambdaQueryWrapper lambdaQueryWrapper = new QueryWrapper().lambda();
        lambdaQueryWrapper.eq(ElsEmployeInfo::getSubAccountId, (Object)loginUser.getId());
        ElsEmployeInfo elsEmployeInfo = (ElsEmployeInfo)((Object)this.elsEmployeInfoService.getOne((Wrapper)lambdaQueryWrapper));
        if (elsEmployeInfo != null) {
            if (EmployInfoStatusEnum.ON_LEAVE.getValue().equals(elsEmployeInfo.getEmployeeStatus())) {
                throw new ELSBootException("\u5f53\u524d\u8d26\u6237\u5458\u5de5\u72b6\u6001\u4e3a\u5df2\u79bb\u804c,\u4e0d\u80fd\u521b\u5efa\u7533\u8bf7\u5355!");
            }
            purchaseResignationApply.setHireDate(elsEmployeInfo.getHireDate());
            purchaseResignationApply.setPost(elsEmployeInfo.getRole());
            purchaseResignationApply.setDepartmentId(elsEmployeInfo.getDepartname());
            purchaseResignationApply.setPersonnelType(elsEmployeInfo.getPersonnelType());
        }
        ((PurchaseResignationApplyMapper)this.baseMapper).insert((Object)purchaseResignationApply);
        super.setHeadDefaultValue((BaseEntity)purchaseResignationApply);
        this.insertData(purchaseResignationApply, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseResignationApply purchaseResignationApply, List<PurchaseAttachment> purchaseAttachmentList) {
        int count = ((PurchaseResignationApplyMapper)this.baseMapper).updateById((Object)purchaseResignationApply);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseAttachmentService.deleteByMainId(purchaseResignationApply.getId());
        this.insertData(purchaseResignationApply, purchaseAttachmentList);
    }

    private void insertData(PurchaseResignationApply purchaseResignationApply, List<PurchaseAttachment> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachment entity : purchaseAttachmentList) {
                entity.setHeadId(purchaseResignationApply.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseResignationApply);
            }
            this.purchaseAttachmentService.saveBatch(purchaseAttachmentList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseAttachmentService.deleteByMainId(id);
        ((PurchaseResignationApplyMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseAttachmentService.deleteByMainId(serializable.toString());
            ((PurchaseResignationApplyMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

