/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.organization.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.organization.dao.OrganizationUserRefMapper;
import com.els.liby.organization.entity.OrganizationUserRef;
import com.els.liby.organization.entity.OrganizationUserRefExample;
import com.els.liby.organization.service.OrganizationUserRefService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOrganizationUserRefService")
public class OrganizationUserRefServiceImpl
implements OrganizationUserRefService {
    @Resource
    protected OrganizationUserRefMapper organizationUserRefMapper;

    @CacheEvict(value={"organizationUserRef"}, allEntries=true)
    public void addObj(OrganizationUserRef t) {
        this.organizationUserRefMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"organizationUserRef"}, allEntries=true)
    public void addAll(List<OrganizationUserRef> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.organizationUserRefMapper.insertBatch(list);
    }

    @CacheEvict(value={"organizationUserRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.organizationUserRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"organizationUserRef"}, allEntries=true)
    public void modifyObj(OrganizationUserRef t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.organizationUserRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"organizationUserRef"}, keyGenerator="redisKeyGenerator")
    public OrganizationUserRef queryObjById(String id) {
        return this.organizationUserRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"organizationUserRef"}, keyGenerator="redisKeyGenerator")
    public List<OrganizationUserRef> queryAllObjByExample(OrganizationUserRefExample example) {
        return this.organizationUserRefMapper.selectByExample(example);
    }

    @Cacheable(value={"organizationUserRef"}, keyGenerator="redisKeyGenerator")
    public PageView<OrganizationUserRef> queryObjByPage(OrganizationUserRefExample example) {
        PageView<OrganizationUserRef> pageView = example.getPageView();
        pageView.setQueryResult(this.organizationUserRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"organizationUserRef"}, allEntries=true)
    public void deleteByExample(OrganizationUserRefExample example) {
        if (CollectionUtils.isEmpty(example.getOredCriteria())) {
            throw new CommonException("\u5220\u9664\u7b5b\u9009\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.organizationUserRefMapper.deleteByExample(example);
    }
}

