/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.organization.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.liby.organization.dao.OrganizationMapper;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.entity.OrganizationUserRef;
import com.els.liby.organization.entity.OrganizationUserRefExample;
import com.els.liby.organization.service.OrganizationService;
import com.els.liby.organization.service.OrganizationUserRefService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOrganizationService")
public class OrganizationServiceImpl
implements OrganizationService {
    @Resource
    protected OrganizationMapper organizationMapper;
    @Resource
    protected OrganizationUserRefService organizationUserRefService;

    @CacheEvict(value={"organization"}, allEntries=true)
    public void addObj(Organization t) {
        this.organizationMapper.insertSelective(t);
    }

    @CacheEvict(value={"organization"}, allEntries=true)
    public void deleteObjById(String id) {
        this.organizationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"organization"}, allEntries=true)
    public void modifyObj(Organization t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.organizationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"organization"}, keyGenerator="redisKeyGenerator")
    public Organization queryObjById(String id) {
        return this.organizationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"organization"}, keyGenerator="redisKeyGenerator")
    public List<Organization> queryAllObjByExample(OrganizationExample example) {
        return this.organizationMapper.selectByExample(example);
    }

    @Cacheable(value={"organization"}, keyGenerator="redisKeyGenerator")
    public PageView<Organization> queryObjByPage(OrganizationExample example) {
        PageView<Organization> pageView = example.getPageView();
        pageView.setQueryResult(this.organizationMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"organization"}, allEntries=true)
    public void addBatch(List<Organization> orgList) {
        this.organizationMapper.insertBatch(orgList);
    }

    @Override
    @CacheEvict(value={"organization"}, allEntries=true)
    public void deleteAll() {
        this.organizationMapper.deleteByExample(null);
    }

    @Override
    @CacheEvict(value={"organization"}, allEntries=true)
    public void modifyByExample(Organization organization, OrganizationExample example) {
        this.organizationMapper.updateByExampleSelective(organization, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"organization"}, allEntries=true)
    public void authDataRight(String userId, String organizationType, List<Organization> organizations) {
        Assert.isNotBlank((String)userId, (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)organizationType, (String)"\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        for (Organization organization2 : organizations) {
            Assert.isNotBlank((String)organization2.getId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (organizationType.equals(organization2.getOrganizationType())) continue;
            throw new CommonException("\u7ec4\u7ec7\u7684\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        OrganizationUserRefExample example = new OrganizationUserRefExample();
        example.createCriteria().andOrganizationTypeEqualTo(organizationType).andUserIdEqualTo(userId);
        this.organizationUserRefService.deleteByExample(example);
        Date now = new Date();
        List refList = organizations.stream().map(organization -> {
            OrganizationUserRef ref = new OrganizationUserRef();
            ref.setOrganizationId(organization.getId());
            ref.setOrganizationType(organizationType);
            ref.setOrganizationName(organization.getOrganizationName());
            ref.setUserId(userId);
            ref.setCreateTime(now);
            return ref;
        }).collect(Collectors.toList());
        this.organizationUserRefService.addAll(refList);
    }

    @Override
    @Cacheable(value={"organization"}, keyGenerator="redisKeyGenerator")
    public List<Organization> queryByUser(String userId, OrganizationExample organizationExample) {
        return this.organizationMapper.selectJoinUserRefByExample(userId, organizationExample);
    }

    @Override
    @Cacheable(value={"organization"}, keyGenerator="redisKeyGenerator")
    public List<String> queryCodeByUser(String userId, OrganizationExample example) {
        List<Organization> organizationList = this.queryByUser(userId, example);
        if (CollectionUtils.isEmpty(organizationList)) {
            return null;
        }
        return organizationList.stream().map(Organization::getCode).collect(Collectors.toList());
    }

    @Override
    @Cacheable(value={"organization"}, keyGenerator="redisKeyGenerator")
    public String getAbbreviationByCode(String factoryCode) {
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andCodeEqualTo(factoryCode).andOrganizationTypeEqualTo("T001W");
        List<Organization> lists = this.organizationMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(lists)) {
            return lists.get(0).getExtend2();
        }
        return null;
    }

    @CacheEvict(value={"organization"}, allEntries=true)
    public void deleteByExample(OrganizationExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.organizationMapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"organization"}, allEntries=true)
    public void addAll(List<Organization> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.organizationMapper.insertSelective((Organization)record));
    }
}

