/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.organization.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.service.OrganizationService;
import com.els.liby.organization.service.OrganizationUserRefService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
@Controller
@RequestMapping(value={"organization"})
public class OrganizationController {
    @Resource
    protected OrganizationService organizationService;
    @Resource
    protected OrganizationUserRefService organizationUserRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Organization organization) {
        this.organizationService.addObj(organization);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Organization organization) {
        Assert.isNotBlank((String)organization.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.organizationService.modifyObj(organization);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.organizationService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Organization", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Organization>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OrganizationExample example = new OrganizationExample();
        example.setOrderByClause("CODE ASC");
        example.setPageView((PageView<Organization>)new PageView(pageNo, pageSize));
        OrganizationExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(1);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.organizationService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7528\u4e8e\u7684\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Organization", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findForCurrentUser/{organizationType}"})
    @ResponseBody
    public ResponseResult<List<Organization>> findForCurrentUserByPage(@PathVariable(value="organizationType", required=true) String organizationType, @RequestBody(required=false) QueryParamWapper wapper) {
        OrganizationExample example = new OrganizationExample();
        example.setOrderByClause("CODE ASC");
        OrganizationExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(1);
        criteria.andOrganizationTypeEqualTo(organizationType);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        return ResponseResult.success(this.organizationService.queryByUser(SpringSecurityUtils.getLoginUserId(), example));
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7528\u4e8e\u7684\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Organization", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findForUser/{organizationType}/{userId}"})
    @ResponseBody
    public ResponseResult<List<Organization>> findForUser(@PathVariable(value="organizationType", required=true) String organizationType, @PathVariable(value="userId", required=true) String userId, @RequestBody(required=false) QueryParamWapper wapper) {
        OrganizationExample example = new OrganizationExample();
        example.setOrderByClause("CODE ASC");
        OrganizationExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(1);
        criteria.andOrganizationTypeEqualTo(organizationType);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        return ResponseResult.success(this.organizationService.queryByUser(userId, example));
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7ec4\u7ec7\u67b6\u6784\u6570\u636e")
    @RequestMapping(value={"service/authDataRight/{organizationType}/{userId}"})
    @ResponseBody
    public ResponseResult<String> authDataRight(@RequestBody List<Organization> organizations, @PathVariable(value="organizationType", required=true) String organizationType, @PathVariable(value="userId", required=true) String userId) {
        this.organizationService.authDataRight(userId, organizationType, organizations);
        return ResponseResult.success();
    }
}

