/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.qualitytesting.command;

import com.els.base.common.ContextUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.PurVoucher;
import com.els.base.delivery.entity.PurVoucherExample;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.liby.qualitytesting.command.AbstractQualityTestingCommand;
import com.els.liby.qualitytesting.command.QualityTestingCommandInvoker;
import com.els.liby.qualitytesting.entity.QmsQualityReportPo;
import com.els.liby.qualitytesting.entity.QualityTesting;
import com.els.liby.qualitytesting.entity.QualityTestingExample;
import com.els.liby.qualitytesting.service.QualityTestingService;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SynchronizeQmsQualityReportCmd
extends AbstractQualityTestingCommand<Void> {
    private static final String TESTING_FAILURE = "QUALITY_TESTING_FAILURE";
    private QualityTestingService qualityTestingService = (QualityTestingService)SpringContextHolder.getOneBean(QualityTestingService.class);
    private List<QmsQualityReportPo> qmsQualityReportList;

    public SynchronizeQmsQualityReportCmd(List<QmsQualityReportPo> qmsQualityReportList) {
        this.qmsQualityReportList = qmsQualityReportList;
    }

    @Override
    public Void execute(QualityTestingCommandInvoker context) {
        if (CollectionUtils.isEmpty(this.qmsQualityReportList)) {
            return null;
        }
        List qualityTestingList = this.qmsQualityReportList.stream().filter(qmsQualityReport -> StringUtils.isNotBlank((String)qmsQualityReport.getMblnr())).map(qmsQualityReport -> {
            String reportDate;
            QualityTesting qt = new QualityTesting();
            qt.setPublishStatus(Constant.YES_INT);
            String reportInspectDate = qmsQualityReport.getInspectDate();
            if (StringUtils.isNotBlank((String)reportInspectDate)) {
                qt.setInspectionDate(this.strToDate(reportInspectDate, "yyyy-MM-dd"));
            }
            qt.setReceiptVoucherNumber(qmsQualityReport.getMblnr());
            qt.setReceiptDate(qmsQualityReport.getBudat());
            qt.setMaterialNumber(qmsQualityReport.getMatnr());
            qt.setBatchNumber(qmsQualityReport.getCharg());
            String conclustion = qmsQualityReport.getConclustion();
            if (StringUtils.isNotBlank((String)conclustion)) {
                if ("\u5408\u683c".equals(conclustion)) {
                    qt.setIsQualified(Constant.YES_INT);
                } else {
                    qt.setIsQualified(Constant.NO_INT);
                }
            }
            if (StringUtils.isNotBlank((String)(reportDate = qmsQualityReport.getReportDate()))) {
                qt.setUnqualifiedDate(this.strToDate(reportDate, "yyyy-MM-dd"));
            }
            qt.setUnqualifiedDescription(qmsQualityReport.getInferiorDesc());
            qt.setSupSapCode(qmsQualityReport.getLifnr());
            qt.setSupName(qmsQualityReport.getName1());
            qt.setCreateTime(new Date());
            qt.setUpdateTime(new Date());
            qt.setIsEnable(Constant.YES_INT);
            this.getPurVoucher(qt);
            this.getMaterial(qt);
            return qt;
        }).collect(Collectors.toList());
        for (QualityTesting qualityTesting : qualityTestingList) {
            String receiptVoucherNumber = qualityTesting.getReceiptVoucherNumber();
            QualityTesting record = new QualityTesting();
            record.setIsEnable(Constant.NO_INT);
            QualityTestingExample example = new QualityTestingExample();
            example.createCriteria().andReceiptVoucherNumberEqualTo(receiptVoucherNumber);
            this.qualityTestingService.updateByExample(record, example);
        }
        Lists.partition(qualityTestingList, (int)100).forEach(partitionList -> this.qualityTestingService.addAll((List)partitionList));
        qualityTestingList.stream().forEach(q -> {
            if (Constant.NO_INT.equals(q.getIsQualified())) {
                this.sendMsg((QualityTesting)q, TESTING_FAILURE);
            }
        });
        return null;
    }

    private void sendMsg(QualityTesting q, String testingType) {
        List<String> userIds = this.getSupCompanyRef(q.getSupSapCode());
        Message msg = Message.init((Object)q).setCompanyCode("51034215").setBusinessTypeCode(testingType).setSenderId("20180705030515-30df16cdc1154995b").setMsgLevel(MessageLevelEnum.HIGH).addReceiverIdList(this.getSupCompanyRef(q.getSupSapCode()));
        MessageSendUtils.sendMessage((Message)msg);
    }

    private List<String> getSupCompanyRef(String supSapCode) {
        return ContextUtils.getCompanyUserRefService().queryUserOfcompanySapCode(supSapCode);
    }

    private void getPurVoucher(QualityTesting qt) {
        PurVoucherExample example = new PurVoucherExample();
        example.createCriteria().andMaterialVoucherNoEqualTo(qt.getReceiptVoucherNumber());
        List lists = ContextUtils.getPurVoucherService().queryAllObjByExample((IExample)example);
        if (lists.size() > 0) {
            PurVoucher voucher = (PurVoucher)lists.get(0);
            qt.setOrderNo(voucher.getPurchaseOrderNo());
            qt.setOrderItemNo(voucher.getPurchaseOrderItemNo());
            qt.setDeliveryOrderNo(voucher.getDeliveryOrderNo());
            qt.setFactoryCode(voucher.getFactory());
        }
    }

    private void getMaterial(QualityTesting qt) {
        MaterialExample example = new MaterialExample();
        example.createCriteria().andMaterialCodeEqualTo(qt.getMaterialNumber());
        List lists = ContextUtils.getMaterialService().queryAllObjByExample((IExample)example);
        if (lists.size() > 0) {
            Material material = (Material)lists.get(0);
            qt.setMaterialDescription(material.getDescription());
        }
    }

    private Date strToDate(String dateTimeStr, String formatStr) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)formatStr);
        DateTime dateTime = dateTimeFormatter.parseDateTime(dateTimeStr);
        return dateTime.toDate();
    }
}

