/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.qualitytesting.service.impl;

import com.els.base.common.ContextUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.liby.qualitytesting.dao.QualityTestingMapper;
import com.els.liby.qualitytesting.entity.QmsQualityReportPo;
import com.els.liby.qualitytesting.entity.QualityTesting;
import com.els.liby.qualitytesting.entity.QualityTestingExample;
import com.els.liby.qualitytesting.service.QualityTestingService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualityTestingService")
public class QualityTestingServiceImpl
implements QualityTestingService {
    @Resource
    protected QualityTestingMapper qualityTestingMapper;

    @CacheEvict(value={"qualityTesting"}, allEntries=true)
    public void addObj(QualityTesting t) {
        this.qualityTestingMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"qualityTesting"}, allEntries=true)
    public void addAll(List<QualityTesting> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.qualityTestingMapper.insertBatch(list);
    }

    @CacheEvict(value={"qualityTesting"}, allEntries=true)
    public void deleteObjById(String id) {
        this.qualityTestingMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualityTesting"}, allEntries=true)
    public void modifyObj(QualityTesting t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.qualityTestingMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"qualityTesting"}, keyGenerator="redisKeyGenerator")
    public QualityTesting queryObjById(String id) {
        return this.qualityTestingMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"qualityTesting"}, keyGenerator="redisKeyGenerator")
    public List<QualityTesting> queryAllObjByExample(QualityTestingExample example) {
        return this.qualityTestingMapper.selectByExample(example);
    }

    @Cacheable(value={"qualityTesting"}, keyGenerator="redisKeyGenerator")
    public PageView<QualityTesting> queryObjByPage(QualityTestingExample example) {
        PageView<QualityTesting> pageView = example.getPageView();
        pageView.setQueryResult(this.qualityTestingMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"qualityTesting"}, allEntries=true)
    public void updateByExample(QualityTesting record, QualityTestingExample example) {
        this.qualityTestingMapper.updateByExampleSelective(record, example);
    }

    @Override
    public List<QmsQualityReportPo> queryQmsQualityReport(Date inspectDate) {
        String inspectDateString = new DateTime((Object)inspectDate).toString("yyyy-MM-dd");
        List<QmsQualityReportPo> qmsQualityReportList = this.qualityTestingMapper.selectQmsQualityReportList(inspectDateString);
        return qmsQualityReportList;
    }

    @Override
    public List<QmsQualityReportPo> scheduleGetQmsQualityReport() {
        String inspectDateString = new DateTime().minusDays(1).toString("yyyy-MM-dd");
        List<QmsQualityReportPo> qmsQualityReportList = this.qualityTestingMapper.selectQmsQualityReportList(inspectDateString);
        return qmsQualityReportList;
    }

    @Override
    public void testIm(QualityTesting q, String type) {
        List<String> userIds = this.getSupCompanyRef(q.getSupSapCode());
        Message msg = Message.init((Object)q).setCompanyCode("51034215").setBusinessTypeCode(type).setSenderId("20180705030515-30df16cdc1154995b").setMsgLevel(MessageLevelEnum.HIGH).addReceiverIdList(this.getSupCompanyRef(q.getSupSapCode()));
        MessageSendUtils.sendMessage((Message)msg);
    }

    private List<String> getSupCompanyRef(String supSapCode) {
        return ContextUtils.getCompanyUserRefService().queryUserOfcompanySapCode(supSapCode);
    }

    @CacheEvict(value={"qualityTesting"}, allEntries=true)
    public void deleteByExample(QualityTestingExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.qualityTestingMapper.deleteByExample(example);
    }
}

