/*
 * Decompiled with CFR 0.152.
 */
package com.els.liby.qualitytesting.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.liby.forecast.util.ExcelFileData;
import com.els.liby.qualitytesting.command.QualityTestingCommandInvoker;
import com.els.liby.qualitytesting.command.SynchronizeQmsQualityReportCmd;
import com.els.liby.qualitytesting.entity.QmsQualityReportPo;
import com.els.liby.qualitytesting.entity.QualityTesting;
import com.els.liby.qualitytesting.entity.QualityTestingExample;
import com.els.liby.qualitytesting.entity.SynchronizeQmsQualityReportRequest;
import com.els.liby.qualitytesting.service.QualityTestingService;
import com.els.liby.qualitytesting.utils.QualifiedConverter;
import com.els.liby.qualitytesting.utils.SendConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import jxl.write.WriteException;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8d28\u68c0")
@Controller
@RequestMapping(value={"qualityTesting"})
public class QualityTestingController {
    private static Logger logger = LoggerFactory.getLogger(QualityTestingController.class);
    @Resource
    protected QualityTestingService qualityTestingService;
    @Resource
    protected QualityTestingCommandInvoker qualityTestingCommandInvoker;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d28\u68c0\u5217\u8868-\u4f9b\u5e94\u5546\u65b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualityTesting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualityTesting>> findSupByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Company company = CompanyUtils.currentCompany();
        QualityTestingExample example = new QualityTestingExample();
        example.setPageView((PageView<QualityTesting>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC");
        QualityTestingExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andSupSapCodeIn(company.getCompanySapCodeList());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.qualityTestingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d28\u68c0\u5217\u8868-\u91c7\u8d2d\u65b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualityTesting", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualityTesting>> findPurByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualityTestingExample example = new QualityTestingExample();
        example.setPageView((PageView<QualityTesting>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC");
        QualityTestingExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.qualityTestingService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u8d28\u68c0")
    @RequestMapping(value={"service/publish"})
    @ResponseBody
    public ResponseResult<String> publish(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, (String)"\u53d1\u5e03\u5931\u8d25,idList\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        QualityTesting record = new QualityTesting();
        record.setPublishStatus(Constant.YES_INT);
        record.setUpdateTime(new Date());
        record.setUpdateUserId(loginUser.getId());
        record.setUpdateUserName(loginUser.getLoginName());
        QualityTestingExample example = new QualityTestingExample();
        example.createCriteria().andIdIn((List)idList);
        this.qualityTestingService.updateByExample(record, example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u540c\u6b65qms\u8d28\u91cf\u62a5\u8868")
    @RequestMapping(value={"service/synchronizeQmsQualityReport"})
    @ResponseBody
    public ResponseResult<String> synchronizeQmsQualityReport(@RequestBody SynchronizeQmsQualityReportRequest reportRequest) {
        Date inspectDate = reportRequest.getInspectDate();
        Assert.isNotNull((Object)inspectDate, (String)"\u8d28\u68c0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        List<QmsQualityReportPo> qmsQualityReportList = this.qualityTestingService.queryQmsQualityReport(inspectDate);
        SynchronizeQmsQualityReportCmd synchronizeQmsQualityReportCmd = new SynchronizeQmsQualityReportCmd(qmsQualityReportList);
        User loginUser = SpringSecurityUtils.getLoginUser();
        synchronizeQmsQualityReportCmd.setPurUser(loginUser);
        this.qualityTestingCommandInvoker.invoke(synchronizeQmsQualityReportCmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="testIm")
    @RequestMapping(value={"front/testIm"})
    @ResponseBody
    public ResponseResult<String> testIm() {
        QualityTestingExample example = new QualityTestingExample();
        example.createCriteria().andIsQualifiedEqualTo(Constant.NO_INT);
        List lists = this.qualityTestingService.queryAllObjByExample((IExample)example);
        this.qualityTestingService.testIm((QualityTesting)lists.get(0), "QUALITY_TESTING_FAILURE");
        return ResponseResult.success();
    }

    @ApiOperation(value="\u8d28\u68c0\u7ed3\u679c\u9009\u4e2d\u5bfc\u51fa\u9009\u4e2d-\u91c7\u8d2d\u65b9", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=false) List<String> ids) throws IOException, ParseException, WriteException {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e");
        QualityTestingExample example = new QualityTestingExample();
        example.setOrderByClause(" CREATE_TIME DESC");
        example.createCriteria().andIsEnableEqualTo(1).andIdIn((List)ids);
        List qualityTestingList = this.qualityTestingService.queryAllObjByExample((IExample)example);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcel();
        FileData fileDataReturn = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, (List)qualityTestingList, (String)"\u8d28\u68c0\u7ed3\u679c", (String)"\u8d28\u68c0\u7ed3\u679c", (int)0);
        return ResponseResult.success((Object)fileDataReturn);
    }

    @ApiOperation(value="\u8d28\u68c0\u7ed3\u679c\u67e5\u8be2\u5bfc\u51fa\u9009\u4e2d-\u4f9b\u5e94\u5546", httpMethod="POST")
    @RequestMapping(value={"service/downloadSupExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadSupExcel(@RequestBody(required=false) List<String> ids) throws IOException, ParseException, WriteException {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e");
        QualityTestingExample example = new QualityTestingExample();
        example.setOrderByClause(" CREATE_TIME DESC");
        example.createCriteria().andIsEnableEqualTo(1).andIdIn((List)ids);
        List qualityTestingList = this.qualityTestingService.queryAllObjByExample((IExample)example);
        List<TitleAndModelKey> titleAndModelKeys = this.createSupExcel();
        FileData fileDataReturn = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, (List)qualityTestingList, (String)"\u8d28\u68c0\u7ed3\u679c", (String)"\u8d28\u68c0\u7ed3\u679c", (int)0);
        return ResponseResult.success((Object)fileDataReturn);
    }

    @ApiOperation(value="\u8d28\u68c0\u7ed3\u679c\u67e5\u8be2\u5bfc\u51fa\u5168\u90e8-\u91c7\u8d2d\u65b9", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelByAll"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelByAll(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CategoryQuotaItem") @RequestBody(required=false) QueryParamWapper wapper) throws IOException, ParseException, WriteException {
        QualityTestingExample example = new QualityTestingExample();
        example.setOrderByClause(" CREATE_TIME DESC");
        QualityTestingExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcel();
        List qualityTestingList = this.qualityTestingService.queryAllObjByExample((IExample)example);
        FileData fileDataReturn = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, (List)qualityTestingList, (String)"\u8d28\u68c0\u7ed3\u679c", (String)"\u8d28\u68c0\u7ed3\u679c", (int)0);
        return ResponseResult.success((Object)fileDataReturn);
    }

    @ApiOperation(value="\u8d28\u68c0\u7ed3\u679c\u5bfc\u51fa\u5168\u90e8-\u4f9b\u5e94\u5546", httpMethod="GET")
    @RequestMapping(value={"service/downloadExcelBySupAll"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelBySupAll(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CategoryQuotaItem") @RequestBody(required=false) QueryParamWapper wapper) throws IOException, ParseException, WriteException {
        Company company = CompanyUtils.currentCompany();
        QualityTestingExample example = new QualityTestingExample();
        example.setOrderByClause(" CREATE_TIME DESC");
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupSapCodeIn(company.getCompanySapCodeList());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List qualityTestingList = this.qualityTestingService.queryAllObjByExample((IExample)example);
        List<TitleAndModelKey> titleAndModelKeys = this.createSupExcel();
        FileData fileDataReturn = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, (List)qualityTestingList, (String)"\u8d28\u68c0\u7ed3\u679c", (String)"\u8d28\u68c0\u7ed3\u679c", (int)0);
        return ResponseResult.success((Object)fileDataReturn);
    }

    private FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename);
        pdfFile.setFileSuffix("xls");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    private List<TitleAndModelKey> createExcel() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        QualifiedConverter qualifiedConverter = new QualifiedConverter();
        SendConverter sendConverter = new SendConverter();
        TitleAndModelKey publishStatus = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u5e03\u72b6\u6001", (String)"publishStatus");
        publishStatus.setToObjConverter((StrToObjConverter)sendConverter);
        publishStatus.setToStrConverter((ObjToStrConverter)sendConverter);
        titleAndModelKeys.add(publishStatus);
        TitleAndModelKey inspectionDate = ExcelUtils.createTitleAndModelKey((String)"\u68c0\u9a8c\u65e5\u671f", (String)"inspectionDate");
        inspectionDate.setToObjConverter((StrToObjConverter)dateConverter);
        inspectionDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(inspectionDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6536\u8d27\u51ed\u8bc1\u53f7", (String)"receiptVoucherNumber"));
        TitleAndModelKey receiptDate = ExcelUtils.createTitleAndModelKey((String)"\u6536\u8d27\u65e5\u671f", (String)"receiptDate");
        receiptDate.setToObjConverter((StrToObjConverter)dateConverter);
        receiptDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(receiptDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u53f7", (String)"materialNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDescription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5355\u53f7", (String)"deliveryOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7", (String)"orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6279\u6b21\u53f7", (String)"batchNumber"));
        TitleAndModelKey isQualified = ExcelUtils.createTitleAndModelKey((String)"\u5408\u683c\u60c5\u51b5", (String)"isQualified");
        isQualified.setToObjConverter((StrToObjConverter)qualifiedConverter);
        isQualified.setToStrConverter((ObjToStrConverter)qualifiedConverter);
        titleAndModelKeys.add(isQualified);
        TitleAndModelKey unqualifiedDate = ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u65e5\u671f", (String)"unqualifiedDate");
        unqualifiedDate.setToObjConverter((StrToObjConverter)dateConverter);
        unqualifiedDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(unqualifiedDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u63cf\u8ff0", (String)"unqualifiedDescription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP", (String)"supSapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supName"));
        return titleAndModelKeys;
    }

    private List<TitleAndModelKey> createSupExcel() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        QualifiedConverter qualifiedConverter = new QualifiedConverter();
        SendConverter sendConverter = new SendConverter();
        TitleAndModelKey inspectionDate = ExcelUtils.createTitleAndModelKey((String)"\u68c0\u9a8c\u65e5\u671f", (String)"inspectionDate");
        inspectionDate.setToObjConverter((StrToObjConverter)dateConverter);
        inspectionDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(inspectionDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6536\u8d27\u51ed\u8bc1\u53f7", (String)"receiptVoucherNumber"));
        TitleAndModelKey receiptDate = ExcelUtils.createTitleAndModelKey((String)"\u6536\u8d27\u65e5\u671f", (String)"receiptDate");
        receiptDate.setToObjConverter((StrToObjConverter)dateConverter);
        receiptDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(receiptDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5355\u53f7", (String)"deliveryOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7", (String)"orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u53f7", (String)"materialNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDescription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6279\u6b21\u53f7", (String)"batchNumber"));
        TitleAndModelKey isQualified = ExcelUtils.createTitleAndModelKey((String)"\u5408\u683c\u60c5\u51b5", (String)"isQualified");
        isQualified.setToObjConverter((StrToObjConverter)qualifiedConverter);
        isQualified.setToStrConverter((ObjToStrConverter)qualifiedConverter);
        titleAndModelKeys.add(isQualified);
        TitleAndModelKey unqualifiedDate = ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u65e5\u671f", (String)"unqualifiedDate");
        unqualifiedDate.setToObjConverter((StrToObjConverter)dateConverter);
        unqualifiedDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(unqualifiedDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u5408\u683c\u63cf\u8ff0", (String)"unqualifiedDescription"));
        return titleAndModelKeys;
    }
}

