/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.ThirdAccountService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/personalSetting"})
public class PersonalSettingController
extends BaseController<PersonalSetting, PersonalSettingService> {
    private static final Logger log = LoggerFactory.getLogger(PersonalSettingController.class);
    @Autowired
    private PersonalSettingService personalSettingService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u4fdd\u5b58\u63a5\u53d7\u8bbe\u7f6e", logType=2, operateType=3)
    @PostMapping(value={"/saveSetting"})
    public Result<?> saveSetting(@RequestBody PersonalSetting personalSetting) {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->saveSetting: personalSetting: " + personalSetting + ", elsAccount: " + elsAccount + ", subAccount: " + subAccount);
        this.personalSettingService.saveNewSetting(elsAccount, subAccount, personalSetting);
        return Result.ok();
    }

    @GetMapping(value={"/querySetting"})
    public Result<?> querySetting() {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->querySetting: elsAccount: " + elsAccount + ",subAccount: " + subAccount);
        List<PersonalSetting> personalSetting = this.personalSettingService.querySettingBySubAccount(elsAccount, subAccount);
        return Result.ok(personalSetting);
    }

    @GetMapping(value={"/queryBindList"})
    public Result<?> queryBindList() {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->queryBindList: elsAccount: " + elsAccount + ",subAccount: " + subAccount);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        query.eq(ThirdAccount::getUserId, (Object)this.getCurrentUser().getId());
        List list = this.thirdAccountService.list((Wrapper)query);
        return Result.ok((Object)list);
    }

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u751f\u6210\u5fae\u4fe1\u4e8c\u7ef4\u7801", logType=2, operateType=3)
    @GetMapping(value={"/generateWechatQRCode"})
    public Result<?> generateWechatQRCode() {
        return Result.ok();
    }

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u89e3\u9664\u5fae\u4fe1\u7ed1\u5b9a", logType=2, operateType=4)
    @GetMapping(value={"/wechatUnBind"})
    public Result<?> wechatUnBind() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BaseEntity::getElsAccount, (Object)this.getTenantId());
        query.eq(ThirdAccount::getUserId, (Object)this.getCurrentUser().getId());
        this.thirdAccountService.remove((Wrapper)query);
        return Result.ok();
    }

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u751f\u6210\u5fae\u4fe1\u4e8c\u7ef4\u7801", logType=2, operateType=1)
    @GetMapping(value={"/generateWechatMPQRCode"})
    public Result<Object> generateWechatMPQRCode() {
        return Result.ok();
    }
}

