/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.mail.MailUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.util.Assert;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.mapper.ElsTenantMapper;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsTenantServiceImpl
extends ServiceImpl<ElsTenantMapper, ElsTenant>
implements ElsTenantService {
    private static final Logger log = LoggerFactory.getLogger(ElsTenantServiceImpl.class);
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private RoleService roleService;
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private PersonalSettingService personalSettingService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private InvokeBaseRpcService baseDubboService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveElsTenant(ElsTenant elsTenant) {
        this.checkParam(elsTenant);
        elsTenant.setElsAccount(elsTenant.getElsAccount().trim());
        this.saveElsTenantInfo(elsTenant);
        String tenantAccount = elsTenant.getElsAccount();
        Role role = this.creatElsAccountRole(tenantAccount);
        String password = ConvertUtils.randomGen((int)10);
        ElsSubAccount account = this.creatElsSubAccount(elsTenant, tenantAccount, password);
        this.elsSubAccountService.addUserWithRole(account, role.getId());
        this.savePersonalSetting(tenantAccount, account.getSubAccount());
        this.setPermission(tenantAccount, role);
        if (StringUtils.isNotBlank((CharSequence)elsTenant.getEmail())) {
            try {
                MailUtil.send((String)elsTenant.getEmail(), (String)"QQT \u63a5\u53e3\u5e73\u53f0\u8d26\u53f7", (String)("QQT \u63a5\u53e3\u5e73\u53f0\u8d26\u53f7\u5df2\u4e3a\u60a8\u7533\u8bf7\u6210\u529f,\u8bbf\u95ee\u94fe\u63a5\u4e3a\uff1a" + (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address") + "\u3002\u79df\u6237\u540d\uff1a" + elsTenant.getCompanyName() + " \u8d26\u53f7\uff1a" + elsTenant.getElsAccount() + "  \u5b50\u8d26\u53f7\uff1a" + account.getSubAccount() + " \u521d\u59cb\u5bc6\u7801\uff1a" + password), (boolean)false, (File[])new File[0]);
                MailUtil.send((String)"tso@51qqt.com", (String)(elsTenant.getCompanyName() + "  \u63a5\u53e3\u5e73\u53f0\u8d26\u53f7\u4fe1\u606f"), (String)("\u63a5\u53e3\u5e73\u53f0\u8bbf\u95ee\u94fe\u63a5\u4e3a\uff1a" + (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address") + "\u3002\u79df\u6237\u540d\uff1a" + elsTenant.getCompanyName() + " \u8d26\u53f7\uff1a" + elsTenant.getElsAccount() + "  \u5b50\u8d26\u53f7\uff1a" + account.getSubAccount() + " \u521d\u59cb\u5bc6\u7801\uff1a" + password), (boolean)false, (File[])new File[0]);
            }
            catch (Exception e) {
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    private void checkParam(ElsTenant elsTenant) {
        Assert.isNotBlank((String)elsTenant.getElsAccount(), (String)"\u79df\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsTenant.getElsAccount());
        ElsTenant tenant = (ElsTenant)((Object)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        Assert.isNull((Object)((Object)tenant), (String)"\u79df\u6237\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728!");
    }

    private void saveElsTenantInfo(ElsTenant elsTenant) {
        elsTenant.setAccountStatus(AccountStatusEnum.NORMAL.getCode());
        try {
            elsTenant.setExpiryDate(new SimpleDateFormat("yyyy-MM-dd").parse("2029-12-31"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.save((Object)elsTenant);
    }

    private Role creatElsAccountRole(String tenantAccount) {
        Role role = new Role();
        role.setElsAccount(tenantAccount);
        role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
        role.setRoleCode("companyAdmin");
        this.roleService.save(role);
        return role;
    }

    private ElsSubAccount creatElsSubAccount(ElsTenant elsTenant, String tenantAccount, String password) {
        ElsSubAccount account = new ElsSubAccount();
        account.setElsAccount(tenantAccount);
        account.setSubAccount("API" + tenantAccount);
        account.setRealname(elsTenant.getLinkman());
        account.setPhone(elsTenant.getPhone());
        account.setStatus(1);
        account.setEmail(elsTenant.getEmail());
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)(tenantAccount + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        account.setDeleted(0);
        return account;
    }

    public void savePersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(0);
            personalSettings.add(personalSetting);
        }
        this.personalSettingService.saveBatch(personalSettings);
    }

    public void setPermission(String elsAccount, Role role) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_default_menu", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List list = this.permissionService.list((Wrapper)queryWrapper);
        if (list != null) {
            ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
            for (Permission permission : list) {
                CompanyPermission companyPermission = new CompanyPermission();
                companyPermission.setId(IdWorker.getIdStr());
                companyPermission.setElsAccount(elsAccount);
                companyPermission.setPermissionId(permission.getId());
                companyPermission.setName(permission.getName());
                companyPermission.setSortNo(permission.getSortNo());
                companyPermission.setIcon(permission.getIcon());
                companyPermission.setIconColor(permission.getIconColor());
                companyPermission.setRuleFlag(permission.getRuleFlag());
                companyPermission.setStatus(permission.getStatus());
                companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
                companyPermission.setUpdateTime(new Date());
                companyPermissions.add(companyPermission);
            }
            if (!companyPermissions.isEmpty()) {
                this.permissionService.insertCompanyMeunBatch(companyPermissions);
                ArrayList companyPermissionList = Lists.newArrayList();
                for (CompanyPermission companyPermission : companyPermissions) {
                    RolePermission rolePermission = new RolePermission();
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(role.getId());
                    rolePermission.setPermissionId(companyPermission.getPermissionId());
                    companyPermissionList.add(rolePermission);
                }
                if (CollUtil.isNotEmpty((Collection)companyPermissionList)) {
                    this.rolePermissionService.saveBatch(companyPermissionList);
                }
            }
        }
    }

    @Override
    public void updateElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).updateById((Object)elsTenant);
    }

    @Override
    public void delElsTenant(String id) {
        ((ElsTenantMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTenant(List<String> idList) {
        ((ElsTenantMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<JSONObject> checkTenantIsEffective(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        ElsTenant tenant = (ElsTenant)((Object)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        Result result = new Result();
        if (tenant == null) {
            result.error500("\u8be5ELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (AccountStatusEnum.FROZEN.getCode().equals(tenant.getAccountStatus())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5ELS\u8d26\u53f7\u5df2\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        if (new Date().after(tenant.getExpiryDate())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u5931\u6548\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5ELS\u8d26\u53f7\u5df2\u8fc7\u6709\u6548\u65e5\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        return result;
    }

    @Override
    public ElsTenant selectElsTenantInfo(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        ElsTenant tenant = (ElsTenant)((Object)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        return tenant;
    }

    @Override
    public List<ElsTenant> selectElsTenantInfoList() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0);
        List tenantList = ((ElsTenantMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return tenantList;
    }
}

