/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.els.common.util.RedisUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaGenerator {
    private static final Logger log = LoggerFactory.getLogger(CaptchaGenerator.class);
    private static String bizPath = "files";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static final int WIDTH = 132;
    private static final int HEIGHT = 32;
    private static final int CODE_LENGTH = 6;
    private static final char[] CHARS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final Random RANDOM = new Random();

    public static String getCaptchaGenerator(RedisUtil redisUtil, String uploadpath, String randomKey) {
        BufferedImage bufferedImage = new BufferedImage(132, 32, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 132, 32);
        g.setFont(new Font("Arial", 1, 20));
        g.setColor(Color.BLACK);
        String code = CaptchaGenerator.generateCode();
        g.drawString(code, 20, 25);
        CaptchaGenerator.addNoise(g);
        g.dispose();
        String filePath = uploadpath + File.separator + bizPath + File.separator + "tpyzm";
        File outputFile = new File(filePath);
        if (!outputFile.exists()) {
            outputFile.mkdirs();
        }
        filePath = filePath + File.separator + sdf.format(new Date()) + "_captcha.png";
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputFile);
            FileInputStream in = new FileInputStream(outputFile);
            redisUtil.set(randomKey, (Object)code, 60L);
            return "data:image/png;base64," + CaptchaGenerator.streamToBase64(in);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToBase64(InputStream in) {
        byte[] data = null;
        try {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = in.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            data = swapStream.toByteArray();
        }
        catch (IOException e) {
            log.error("streamToBase64--\u6587\u4ef6\u4e0b\u8f7d\u5904\u7406\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("streamToBase64--base64\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                }
            }
        }
        return new String(Base64.encodeBase64(data));
    }

    public static void main(String[] args) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(132, 32, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 132, 32);
        g.setFont(new Font("Arial", 1, 20));
        g.setColor(Color.BLACK);
        String code = CaptchaGenerator.generateCode();
        System.out.println(code);
        g.drawString(code, 20, 25);
        CaptchaGenerator.addNoise(g);
        g.dispose();
        File outputFile = new File("E:\\captcha.png");
        ImageIO.write((RenderedImage)bufferedImage, "png", outputFile);
        FileInputStream in = new FileInputStream(outputFile);
        System.out.println("data:image/png;base64," + CaptchaGenerator.streamToBase64(in));
    }

    private static String generateCode() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            sb.append(CHARS[RANDOM.nextInt(CHARS.length)]);
        }
        return sb.toString();
    }

    private static void addNoise(Graphics2D g) {
        g.setColor(Color.GRAY);
        for (int i = 0; i < 100; ++i) {
            int x = RANDOM.nextInt(132);
            int y = RANDOM.nextInt(32);
            g.drawRect(x, y, 1, 1);
        }
    }
}

