/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.entity.SaleAttachment;
import com.els.modules.attachment.service.SaleAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SaleAttachmentBeanServiceImpl
implements SaleAttachmentRpcService {
    @Resource
    private SaleAttachmentService saleAttachmentService;

    public List<SaleAttachmentDTO> selectByMainId(String id) {
        List<SaleAttachment> attachmentList = this.saleAttachmentService.selectByMainId(id);
        return SysUtil.copyProperties(attachmentList, SaleAttachmentDTO.class);
    }

    public void insertBatchSomeColumn(List<SaleAttachmentDTO> attachmentDTOList) {
        ArrayList attachmentList = SysUtil.copyProperties(attachmentDTOList, SaleAttachment.class);
        this.saleAttachmentService.saveBatch(attachmentList, 200);
    }

    public void deleteByMainId(String id) {
        this.saleAttachmentService.deleteByMainId(id);
    }

    public void sendFile(AttachmentSendDTO sendDTO) {
        AttachmentSendVO sendVO = new AttachmentSendVO();
        BeanUtils.copyProperties((Object)sendDTO, (Object)sendVO);
        this.saleAttachmentService.sendFile(sendVO);
    }

    public List<PurchaseAttachmentDTO> toPurchaseAttachment(String mainId) {
        List<PurchaseAttachment> attachmentList = this.saleAttachmentService.toPurchaseAttachment(mainId);
        return SysUtil.copyProperties(attachmentList, PurchaseAttachmentDTO.class);
    }

    public void updateById(SaleAttachmentDTO attachmentDTO) {
        SaleAttachment attachment = (SaleAttachment)((Object)SysUtil.copyProperties((Object)attachmentDTO, SaleAttachment.class));
        this.saleAttachmentService.updateById((Object)attachment);
    }

    public void insert(SaleAttachmentDTO attachmentDTO) {
        SaleAttachment attachment = (SaleAttachment)((Object)SysUtil.copyProperties((Object)attachmentDTO, SaleAttachment.class));
        this.saleAttachmentService.save((Object)attachment);
    }

    public void updateAttachmentBatchById(List<SaleAttachmentDTO> saleAttachmentList) {
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            this.saleAttachmentService.updateBatchById(SysUtil.copyProperties(saleAttachmentList, SaleAttachment.class));
        }
    }

    public SaleAttachmentDTO selectById(String id) {
        SaleAttachment attachment = (SaleAttachment)((Object)this.saleAttachmentService.getById((Serializable)((Object)id)));
        return (SaleAttachmentDTO)SysUtil.copyProperties((Object)((Object)attachment), SaleAttachmentDTO.class);
    }
}

