/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.extend.entity.BusinessFieldExtend;
import com.els.modules.extend.mapper.BusinessFieldExtendMapper;
import com.els.modules.extend.service.BusinessFieldExtendService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BusinessFieldExtendServiceImpl
extends ServiceImpl<BusinessFieldExtendMapper, BusinessFieldExtend>
implements BusinessFieldExtendService {
    @Override
    public boolean deleteByMainId(String mainId) {
        return ((BusinessFieldExtendMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public List<BusinessFieldExtend> selectByMainId(String mainId) {
        return ((BusinessFieldExtendMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void addData(String extendObj, String mainId) {
        if (StrUtil.isBlank((CharSequence)extendObj) || StrUtil.isBlank((CharSequence)mainId)) {
            return;
        }
        JSONObject object = JSONObject.parseObject((String)extendObj, (Feature[])new Feature[]{Feature.OrderedField});
        List<BusinessFieldExtend> extendsList = this.getListByJson(object, mainId);
        if (!extendsList.isEmpty()) {
            this.saveBatch(extendsList, 2000);
        }
    }

    private List<BusinessFieldExtend> getListByJson(JSONObject object, String mainId) {
        ArrayList<BusinessFieldExtend> extendsList = new ArrayList<BusinessFieldExtend>();
        for (String key : object.keySet()) {
            String value = object.getString(key);
            BusinessFieldExtend extend = new BusinessFieldExtend();
            extend.setFieldName(key);
            extend.setFieldValue(value);
            extend.setVoucherId(mainId);
            extendsList.add(extend);
        }
        return extendsList;
    }

    private List<BusinessFieldExtend> getListByJson(JSONObject object, String mainId, String itemId) {
        ArrayList<BusinessFieldExtend> extendsList = new ArrayList<BusinessFieldExtend>();
        for (String key : object.keySet()) {
            String value = object.getString(key);
            BusinessFieldExtend extend = new BusinessFieldExtend();
            extend.setFieldName(key);
            extend.setFieldValue(value);
            extend.setVoucherId(mainId);
            extend.setItemId(itemId);
            extendsList.add(extend);
        }
        return extendsList;
    }

    @Override
    public void updateData(String extendObj, String mainId) {
        if (StrUtil.isBlank((CharSequence)extendObj) || StrUtil.isBlank((CharSequence)mainId)) {
            return;
        }
        ((BusinessFieldExtendMapper)this.baseMapper).deleteByMainId(mainId);
        JSONObject object = JSONObject.parseObject((String)extendObj, (Feature[])new Feature[]{Feature.OrderedField});
        List<BusinessFieldExtend> extendsList = this.getListByJson(object, mainId);
        if (!extendsList.isEmpty()) {
            this.saveBatch(extendsList, 2000);
        }
    }

    @Override
    public void deleteData(String mainId) {
        if (StrUtil.isBlank((CharSequence)mainId)) {
            return;
        }
        ((BusinessFieldExtendMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public String selectDataByMainId(String mainId) {
        if (StrUtil.isBlank((CharSequence)mainId)) {
            return null;
        }
        List<BusinessFieldExtend> extendsList = ((BusinessFieldExtendMapper)this.baseMapper).selectByMainId(mainId);
        JSONObject object = new JSONObject();
        for (BusinessFieldExtend extend : extendsList) {
            if (!StrUtil.isBlank((CharSequence)extend.getItemId())) continue;
            object.put(extend.getFieldName(), (Object)extend.getFieldValue());
        }
        return object.toJSONString();
    }

    @Override
    public void addItemData(Map<String, String> extendMap, String mainId) {
        if (extendMap == null || StrUtil.isBlank((CharSequence)mainId)) {
            return;
        }
        ArrayList<BusinessFieldExtend> extendsList = new ArrayList<BusinessFieldExtend>();
        for (String itemId : extendMap.keySet()) {
            JSONObject object = JSONObject.parseObject((String)extendMap.get(itemId), (Feature[])new Feature[]{Feature.OrderedField});
            extendsList.addAll(this.getListByJson(object, mainId, itemId));
        }
        if (!extendsList.isEmpty()) {
            this.saveBatch(extendsList, 2000);
        }
    }

    @Override
    public Map<String, String> selectItemDataByMainId(String mainId) {
        if (StrUtil.isBlank((CharSequence)mainId)) {
            return null;
        }
        List<BusinessFieldExtend> extendsList = ((BusinessFieldExtendMapper)this.baseMapper).selectByMainId(mainId);
        Map<String, List<BusinessFieldExtend>> itemMap = extendsList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getItemId())).collect(Collectors.groupingBy(BusinessFieldExtend::getItemId));
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String itemId : itemMap.keySet()) {
            List<BusinessFieldExtend> itemList = itemMap.get(itemId);
            JSONObject object = new JSONObject();
            for (BusinessFieldExtend extend : itemList) {
                object.put(extend.getFieldName(), (Object)extend.getFieldValue());
            }
            resultMap.put(itemId, object.toJSONString());
        }
        return resultMap;
    }
}

