/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ParamConfig;
import com.els.modules.system.mapper.ParamConfigMapper;
import com.els.modules.system.service.ParamConfigService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ParamConfigServiceImpl
extends BaseServiceImpl<ParamConfigMapper, ParamConfig>
implements ParamConfigService {
    private static final String REDIS_KEY = "sys:paramConfig:";
    @Resource
    private RedisUtil redisUtil;

    @Override
    public void saveParamConfig(ParamConfig paramConfig) {
        if (StrUtil.isBlank((CharSequence)paramConfig.getParamName())) {
            throw new ELSBootException("paramName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isBlank((CharSequence)paramConfig.getParamValue())) {
            throw new ELSBootException("paramValue \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int count = ((ParamConfigMapper)this.baseMapper).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"param_name", (Object)paramConfig.getParamName()));
        if (count > 0) {
            throw new ELSBootException("paramName \u5df2\u7ecf\u5b58\u5728\uff01");
        }
        ((ParamConfigMapper)this.baseMapper).insert((Object)paramConfig);
        String redisKey = REDIS_KEY + TenantContext.getTenant();
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public void updateParamConfig(ParamConfig paramConfig) {
        paramConfig.setParamName(null);
        ((ParamConfigMapper)this.baseMapper).updateById((Object)paramConfig);
        String redisKey = REDIS_KEY + TenantContext.getTenant();
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public void delParamConfig(String id) {
        ((ParamConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        String redisKey = REDIS_KEY + TenantContext.getTenant();
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public void delBatchParamConfig(List<String> idList) {
        ((ParamConfigMapper)this.baseMapper).deleteBatchIds(idList);
        String redisKey = REDIS_KEY + TenantContext.getTenant();
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public JSONObject getParamConfigObj(String elsAccount) {
        String redisKey = REDIS_KEY + elsAccount;
        JSONObject object = (JSONObject)this.redisUtil.get(redisKey);
        if (object != null) {
            return object;
        }
        List configList = ((ParamConfigMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount));
        object = new JSONObject();
        for (ParamConfig config : configList) {
            object.put(config.getParamName(), (Object)config.getParamValue());
        }
        this.redisUtil.set(redisKey, (Object)object, 7200L);
        return object;
    }
}

