/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integration.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RedisRateLimiter;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AppContext;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.api.dto.InterfaceAppDTO;
import com.els.modules.integration.api.dto.MultipartFileDTO;
import com.els.modules.integration.api.service.InterfaceAppPermissionRpcService;
import com.els.modules.integration.api.service.InterfaceAppRpcService;
import com.els.modules.integration.api.service.OpenApiRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5f00\u653e\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/openApi"})
public class OpenApiController {
    private static final Logger log = LoggerFactory.getLogger(OpenApiController.class);
    @Autowired
    private InterfaceAppRpcService interfaceAppRpcService;
    @Autowired
    private OpenApiRpcService openApiRpcService;
    @Autowired
    private InterfaceAppPermissionRpcService interfaceAppPermissionRpcService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u83b7\u53d6token", notes="\u83b7\u53d6token")
    @GetMapping(value={"/getToken"})
    public Result<?> getToken(@RequestParam(name="key") String appKey, @RequestParam(name="secret") String appSecret) {
        InterfaceAppDTO appDTO = this.interfaceAppRpcService.getApp(appKey, appSecret);
        if (appDTO == null) {
            throw new ELSBootException("\u5e94\u7528key\u6216\u8005\u5bc6\u94a5\u4e0d\u6b63\u786e\uff01");
        }
        if ("1".equals(appDTO.getAppStatus())) {
            throw new ELSBootException("\u5e94\u7528\u5df2\u505c\u7528\uff01");
        }
        String token = JwtUtil.sign((String)appDTO.getId(), (String)appSecret, (int)4);
        Long expiresIn = 7200L;
        JSONObject object = new JSONObject();
        object.put("token", (Object)token);
        object.put("expiresIn", (Object)expiresIn);
        String redisKey = "sys:app:token:" + token;
        this.redisUtil.set(redisKey, (Object)token, expiresIn.longValue());
        return Result.ok((Object)object);
    }

    @ApiOperation(value="\u7edf\u4e00\u63a5\u53e3\u8c03\u7528", notes="\u7edf\u4e00\u63a5\u53e3\u8c03\u7528")
    @RedisRateLimiter(count=100, time=1)
    @PostMapping(value={"/invoke"})
    public Result<?> invoke(@RequestBody String paramStr) {
        log.debug("invoke_\u63a5\u53e3\u8c03\u7528\u8bf7\u6c42\u5165\u53c2\uff1a" + paramStr);
        JSONObject param = this.checkParameterInfo(paramStr);
        String resultStr = this.openApiRpcService.invoke(param, null);
        try {
            return Result.ok((Object)JSONObject.parse((String)resultStr));
        }
        catch (Exception e) {
            Result r = new Result();
            r.setSuccess(true);
            r.setCode(CommonConstant.SC_OK_200);
            r.setResult((Object)resultStr);
            return r;
        }
    }

    @ApiOperation(value="\u7edf\u4e00\u63a5\u53e3\u8c03\u7528", notes="\u7edf\u4e00\u63a5\u53e3\u8c03\u7528")
    @RedisRateLimiter(count=100, time=1)
    @PostMapping(value={"/customInvoke"})
    public Object customInvoke(@RequestBody String paramStr) {
        log.debug("customInvoke_\u63a5\u53e3\u8c03\u7528\u8bf7\u6c42\u5165\u53c2\uff1a" + paramStr);
        JSONObject param = this.checkParameterInfo(paramStr);
        String resultStr = this.openApiRpcService.invoke(param, null);
        try {
            JSONObject object = JSONObject.parseObject((String)resultStr);
            return object;
        }
        catch (Exception e) {
            try {
                JSONArray array = JSONArray.parseArray((String)resultStr);
                return array;
            }
            catch (Exception e2) {
                return resultStr;
            }
        }
    }

    private JSONObject checkParameterInfo(@RequestBody String paramStr) {
        String interfaceCode;
        String busAccount;
        if (paramStr == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVNsxOLVW_51d52976", (String)"\u63a5\u53e3\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        JSONObject param = JSONObject.parseObject((String)paramStr, (Feature[])new Feature[]{Feature.OrderedField});
        String string = busAccount = StringUtils.isNotBlank((CharSequence)param.getString("bus_account")) ? param.getString("bus_account") : param.getString("busAccount");
        if (StrUtil.isBlank((CharSequence)busAccount)) {
            throw new ELSBootException("\u4e1a\u52a1\u65b9\u8d26\u53f7 bus_account\uff08\u6216busAccount\uff09 \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String elsAccount = TenantContext.getTenant();
        if (!"100000".equals(elsAccount) && !busAccount.equals(elsAccount)) {
            throw new ELSBootException("\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u65b9\u8d26\u53f7\uff01");
        }
        this.setLoginUser(busAccount);
        String string2 = interfaceCode = StringUtils.isNotBlank((CharSequence)param.getString("interface_code")) ? param.getString("interface_code") : param.getString("interfaceCode");
        if (StrUtil.isBlank((CharSequence)interfaceCode)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWWWWWWWWWxOLVW_61a79d80", (String)"\u63a5\u53e3\u7f16\u7801 interfaceCode \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (!this.interfaceAppPermissionRpcService.checkAppPermission(busAccount, AppContext.getAppId(), interfaceCode).booleanValue()) {
            throw new ELSBootException("\u63a5\u53e3\u4e0d\u5b58\u5728\u6216\u8005\u6ca1\u6709\u5f00\u901a\u8c03\u7528\u6743\u9650\uff01");
        }
        param.put("logInfoId", null);
        return param;
    }

    private void setLoginUser(String elsAccount) {
        LoginUser loginUser = new LoginUser();
        loginUser.setElsAccount(elsAccount);
        loginUser.setSubAccount("interface");
        loginUser.setRealname("interface");
        LoginUserContext.setUser((LoginUser)loginUser);
        TenantContext.setTenant((String)elsAccount);
    }

    @PostMapping(value={"/file"})
    public String invoke(String firstName, String lastName, MultipartFile[] file) {
        String result = firstName + lastName;
        if (file != null) {
            for (MultipartFile multipartFile : file) {
                result = result + (multipartFile.getOriginalFilename() != null ? multipartFile.getOriginalFilename() : "");
            }
        }
        return result;
    }

    private void savePic(InputStream inputStream, String fileName) {
        FileOutputStream os = null;
        String path = "D:\\testTempFile\\";
        byte[] bs = new byte[1024];
        File tempFile = new File(path);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        try {
            int len;
            os = new FileOutputStream(tempFile.getPath() + File.separator + fileName);
            while ((len = inputStream.read(bs)) != -1) {
                ((OutputStream)os).write(bs, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/invokeFile"})
    public Result<?> invokeFile(String bus_account, String interface_code, String body, String header_param, String url_param, String business_message, MultipartFile[] files) {
        JSONObject data = new JSONObject();
        data.put("bus_account", (Object)bus_account);
        data.put("interface_code", (Object)interface_code);
        data.put("body", (Object)body);
        data.put("header_param", (Object)header_param);
        data.put("url_param", (Object)url_param);
        data.put("business_message", (Object)business_message);
        log.debug("invoke_\u63a5\u53e3\u8c03\u7528\u8bf7\u6c42\u5165\u53c2\uff1a" + data);
        JSONObject param = this.checkParameterInfo(data.toJSONString());
        ArrayList<MultipartFileDTO> fileVOs = null;
        if (files != null) {
            fileVOs = new ArrayList<MultipartFileDTO>();
            for (MultipartFile multipartFile : files) {
                MultipartFileDTO fileVO = new MultipartFileDTO();
                fileVO.setFileName(multipartFile.getOriginalFilename());
                fileVO.setStream(this.multipartToInputStream(multipartFile));
                fileVOs.add(fileVO);
            }
        }
        String resultStr = this.openApiRpcService.invoke(param, fileVOs);
        try {
            return Result.ok((Object)JSONObject.parse((String)resultStr));
        }
        catch (Exception e) {
            Result r = new Result();
            r.setSuccess(true);
            r.setCode(CommonConstant.SC_OK_200);
            r.setResult((Object)resultStr);
            return r;
        }
    }

    public InputStream multipartToInputStream(MultipartFile multipartFile) {
        FileInputStream inputStream = null;
        File file = null;
        try {
            file = File.createTempFile("temp", null);
            if (file == null) {
                throw new ELSBootException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            multipartFile.transferTo(file);
            inputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new ELSBootException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", (Throwable)e, new String[0]);
        }
        finally {
            file.deleteOnExit();
        }
        return inputStream;
    }
}

