/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.api.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.system.base.entity.ElsStatusLog;
import com.els.common.system.vo.DictModel;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsCompanyLanguageDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.ElsStatusLogDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.language.entity.ElsCompanyLanguage;
import com.els.modules.language.service.ElsCompanyLanguageService;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.ElsStatusLogService;
import com.els.modules.system.vo.ElsCompanySetVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseBeanServiceImpl
implements BaseRpcService {
    @Resource
    private ElsCompanySetService elsCompanySetService;
    @Resource
    private PurchaseAttachmentService purchaseAttachmentService;
    @Resource
    private I18nService i18nService;
    @Resource
    private CodeGeneratorService codeGeneratorService;
    @Resource
    private DictService dictService;
    @Resource
    private ElsStatusLogService elsStatusLogService;
    @Resource
    private ElsCompanyLanguageService elsCompanyLanguageService;

    public String getI18nValue(String i18nKey, String defaultValue) {
        return this.i18nService.getI18nValue(i18nKey, defaultValue);
    }

    public JSONObject findAllListCache(String tenant, String language) {
        return this.i18nService.findAllListCache(tenant, language);
    }

    public List<ElsCompanySetDTO> getCompanySetList(String elsAccount) {
        List<ElsCompanySetVO> companySetList = this.elsCompanySetService.findList(elsAccount);
        ArrayList<ElsCompanySetDTO> resultList = new ArrayList<ElsCompanySetDTO>();
        for (ElsCompanySetVO setVO : companySetList) {
            ElsCompanySetDTO setDTO = new ElsCompanySetDTO();
            BeanUtils.copyProperties((Object)((Object)setVO), (Object)setDTO);
            resultList.add(setDTO);
        }
        return resultList;
    }

    public List<PurchaseAttachmentDTO> getPurchaseAttachmentListByMainId(String mainId) {
        List<PurchaseAttachment> purchaseAttachmentList = this.purchaseAttachmentService.selectByMainId(mainId);
        ArrayList<PurchaseAttachmentDTO> resultList = new ArrayList<PurchaseAttachmentDTO>();
        for (PurchaseAttachment attachment : purchaseAttachmentList) {
            PurchaseAttachmentDTO attachmentDTO = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)((Object)attachment), (Object)attachmentDTO);
            resultList.add(attachmentDTO);
        }
        return resultList;
    }

    public String getNextCode(String codeType, Object businessObj) {
        return this.codeGeneratorService.getNextCode(codeType, businessObj);
    }

    public String getNextCode(String codeType, Object businessObj, String elsAccount) {
        return this.codeGeneratorService.getNextCode(codeType, businessObj, elsAccount);
    }

    public List<DictDTO> queryDictItemsByCode(String dictCode, String elsAccount) {
        List<DictModel> dictModelsList = this.dictService.queryDictItemsByCode(dictCode, elsAccount);
        return SysUtil.copyProperties(dictModelsList, DictDTO.class);
    }

    public String checkAndAdd(String value) {
        return this.i18nService.checkAndAdd(value);
    }

    public Map<String, String> checkAndAdd(List<String> value) {
        return this.i18nService.checkAndAdd(value);
    }

    public List<ElsCompanyLanguageDTO> getAuthLanguage(List<String> elsAccounts) {
        List<ElsCompanyLanguage> authLanguage = this.elsCompanyLanguageService.getAuthLanguage(elsAccounts);
        return SysUtil.copyProperties(authLanguage, ElsCompanyLanguageDTO.class);
    }

    public void addStatusLog(String businessId, String status, String businessType, String operateType) {
        this.elsStatusLogService.addStatusLog(businessId, status, businessType, operateType);
    }

    public List<ElsStatusLogDTO> listStatusLog(String businessId) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsStatusLogService.lambdaQuery().eq(ElsStatusLog::getBusinessId, (Object)businessId)).orderByAsc(ElsStatusLog::getStatusDate)).list();
        return SysUtil.copyProperties((List)list, ElsStatusLogDTO.class);
    }

    public List<String> getNextCodes(String codeType, Object businessObj, int size) {
        return this.codeGeneratorService.getNextCodes(codeType, businessObj, size);
    }
}

