/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.api.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.job.api.service.QuartzRpcService;
import com.els.modules.quartz.entity.QuartzJob;
import com.els.modules.quartz.service.IQuartzJobService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.SchedulerException;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class QuartzBeanServiceImpl
implements QuartzRpcService {
    @Resource
    private IQuartzJobService quartzJobService;

    public void createJob(QuartzJobDTO jobDTO) {
        QuartzJob quartzJob = new QuartzJob();
        BeanUtils.copyProperties((Object)jobDTO, (Object)((Object)quartzJob));
        this.quartzJobService.saveAndScheduleJob(quartzJob);
    }

    public void updateJob(QuartzJobDTO jobDTO) {
        QuartzJob quartzJob = new QuartzJob();
        BeanUtils.copyProperties((Object)jobDTO, (Object)((Object)quartzJob));
        try {
            this.quartzJobService.editAndScheduleJob(quartzJob);
        }
        catch (SchedulerException e) {
            throw new ELSBootException("edit job failed:" + e.getMessage());
        }
    }

    public void deleteJob(QuartzJobDTO jobDTO) {
        QuartzJob quartzJob = new QuartzJob();
        BeanUtils.copyProperties((Object)jobDTO, (Object)((Object)quartzJob));
        this.quartzJobService.deleteAndStopJob(quartzJob);
    }

    public List<QuartzJobDTO> findJobList(String jobKey) {
        List<QuartzJob> jobList = this.quartzJobService.findByJobNameKey(jobKey);
        ArrayList<QuartzJobDTO> dtoList = new ArrayList<QuartzJobDTO>();
        BeanUtils.copyProperties(jobList, dtoList);
        return dtoList;
    }
}

