/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.api.service.AlertRpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.MqUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.system.entity.ElsAlertConfig;
import com.els.modules.system.entity.ElsAlertRecord;
import com.els.modules.system.enums.AlertFrequencyEnum;
import com.els.modules.system.rpc.service.JobExecuteService;
import com.els.modules.system.rpc.service.JobInvokeAccountRpcService;
import com.els.modules.system.service.AlertService;
import com.els.modules.system.service.ElsAlertRecordService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertServiceImpl
implements AlertService {
    @Autowired
    private ElsAlertRecordService elsAlertRecordService;
    @Resource
    private JobInvokeAccountRpcService jobInvokeAccountRpcService;
    @Resource
    private JobExecuteService jobExecuteService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void runAlert(ElsAlertConfig alertConfig) {
        List<?> alertList = this.getAlertList(alertConfig);
        for (Object obj : alertList) {
            boolean exeFlag = this.getExeFlag(alertConfig, obj);
            if (!exeFlag) continue;
            this.addAlertRecord(alertConfig, obj);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)alertConfig.getElsAccount());
            msgObj.put("businessType", (Object)"alert");
            msgObj.put("operateType", (Object)"notice");
            msgObj.put("msgConfigHeadId", (Object)alertConfig.getId());
            msgObj.put("businessObj", obj);
            JSONObject sendObj = new JSONObject();
            sendObj.put("elsAccount", (Object)alertConfig.getElsAccount());
            sendObj.put("subAccount", (Object)"system");
            sendObj.put("realname", (Object)"system");
            msgObj.put("sendObj", (Object)sendObj);
            List<ElsSubAccountDTO> accountList = this.getReceiverAccountList(alertConfig, obj);
            Map<String, List<ElsSubAccountDTO>> accountMap = accountList.stream().collect(Collectors.groupingBy(BaseDTO::getElsAccount));
            JSONArray array = new JSONArray();
            for (String elsAccount : accountMap.keySet()) {
                List<ElsSubAccountDTO> list = accountMap.get(elsAccount);
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("elsAccount", (Object)elsAccount);
                receiveObj.put("urlParam", obj);
                receiveObj.put("toSubAccountList", list);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
        }
    }

    private void addAlertRecord(ElsAlertConfig alertConfig, Object obj) {
        ElsAlertRecord record = new ElsAlertRecord();
        record.setElsAccount(alertConfig.getElsAccount());
        record.setAlertCofigId(alertConfig.getId());
        record.setBusinessId((String)BeanUtil.getProperty((Object)obj, (String)"id"));
        record.setAlertTime(new Date());
        this.elsAlertRecordService.save((Object)record);
    }

    private boolean getExeFlag(ElsAlertConfig alertConfig, Object obj) {
        String id = (String)BeanUtil.getProperty((Object)obj, (String)"id");
        List recordList = this.elsAlertRecordService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)alertConfig.getElsAccount())).eq((Object)"alert_cofig_id", (Object)alertConfig.getId())).eq((Object)"business_id", (Object)id)).orderByDesc((Object)"alert_time"));
        if (recordList.isEmpty()) {
            return true;
        }
        String alertFrequency = alertConfig.getAlertFrequency();
        if (AlertFrequencyEnum.ONCE.getCode().equals(alertFrequency)) {
            return false;
        }
        if (AlertFrequencyEnum.DAY.getCode().equals(alertFrequency)) {
            return true;
        }
        if (AlertFrequencyEnum.WEEK.getCode().equals(alertFrequency)) {
            return this.compare((ElsAlertRecord)((Object)recordList.get(0)), 7);
        }
        if (AlertFrequencyEnum.MONTH.getCode().equals(alertFrequency)) {
            return this.compare((ElsAlertRecord)((Object)recordList.get(0)), 30);
        }
        return false;
    }

    private boolean compare(ElsAlertRecord record, int days) {
        String date2;
        Date alertTime = record.getAlertTime();
        DateTime checkDate = DateUtil.offsetDay((Date)alertTime, (int)days);
        String date1 = DateUtil.formatDate((Date)checkDate);
        return date1.compareTo(date2 = DateUtil.formatDate((Date)new Date())) <= 0;
    }

    protected List<ElsSubAccountDTO> getReceiverAccountList(ElsAlertConfig alertConfig, Object obj) {
        ArrayList<ElsSubAccountDTO> list = new ArrayList<ElsSubAccountDTO>();
        if (StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeUser())) {
            String[] userIds;
            for (String userId : userIds = alertConfig.getNoticeUser().split(",")) {
                this.addSubAccount(list, userId);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeRole())) {
            list.addAll(this.jobInvokeAccountRpcService.getAccountListByRoles(alertConfig.getNoticeRole()));
        }
        list.addAll(this.getPrincipalList(obj, alertConfig));
        List distinctList = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ElsSubAccountDTO>(Comparator.comparing(BaseDTO::getId))), ArrayList::new));
        return distinctList;
    }

    private void addSubAccount(List<ElsSubAccountDTO> list, String userId) {
        ElsSubAccountDTO account = this.jobInvokeAccountRpcService.getAccountById(userId);
        if (account != null) {
            list.add(account);
        }
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, ElsAlertConfig alertConfig) {
        AlertRpcService service = this.jobExecuteService.getAlertRpcService(alertConfig.getAlertService());
        return service.getPrincipalList(obj, this.getJsonByObejct((Object)alertConfig));
    }

    private JSONObject getJsonByObejct(Object param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "{}";
        try {
            json = mapper.writeValueAsString(param);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return JSONObject.parseObject((String)json);
    }

    public List<?> getAlertList(ElsAlertConfig alertConfig) {
        AlertRpcService service = this.jobExecuteService.getAlertRpcService(alertConfig.getAlertService());
        return service.getAlertList(this.getJsonByObejct((Object)alertConfig));
    }
}

