/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.job;

import com.els.common.util.MqUtil;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(BaseJob.class);
    private String parameter;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String strjobClass = jobExecutionContext.getJobDetail().getKey().getName();
        String name = strjobClass.substring(strjobClass.lastIndexOf(".") + 1);
        StringBuilder builder = new StringBuilder("\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1\uff1a");
        try {
            long startTime = System.currentTimeMillis();
            this.executeBusiness(this.parameter);
            long endTime = System.currentTimeMillis();
            builder.append(name).append(" \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f! \u8017\u65f6\uff1a").append(endTime - startTime);
        }
        catch (Exception e) {
            log.error("BaseJob run failed:", (Throwable)e);
            builder.append(name).append(" \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!");
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            MqUtil.sendLogMsg((String)"100000", (String)builder.toString(), (Integer)3, (Integer)7);
        }
    }

    public abstract void executeBusiness(String var1);

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }
}

