/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mongolog.api.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.modules.message.api.dto.InterfaceLogInfoDTO;
import com.els.modules.message.api.service.InterfaceLogRpcService;
import com.els.modules.mongolog.entity.db.InterfaceDbLogInfo;
import com.els.modules.mongolog.entity.mongo.InterfaceResendValue;
import com.els.modules.mongolog.service.InterfaceDbLogInfoService;
import com.els.modules.mongolog.service.InterfaceMongoLogService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterfaceLogRpcServiceImpl
implements InterfaceLogRpcService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceLogRpcServiceImpl.class);
    @Autowired
    private InterfaceDbLogInfoService interfaceDbLogInfoService;
    @Autowired
    private InterfaceMongoLogService interfaceMongoLogService;
    @Resource(name="logPoolExecutor")
    private ThreadPoolExecutor logPoolExecutor;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor srmPoolExecutor;

    public void asyncSave(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        InterfaceDbLogInfo interfaceLogInfo = new InterfaceDbLogInfo();
        BeanUtils.copyProperties((Object)interfaceLogInfoDTO, (Object)((Object)interfaceLogInfo));
        log.info("<-----\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}],\u63a5\u53e3\u7f16\u7801[{}],\u5f00\u59cb\u63d2\u5165\u65e5\u5fd7", (Object)interfaceLogInfoDTO.getLogInfoId(), (Object)interfaceLogInfoDTO.getInterfaceCode());
        long startMYTime = System.currentTimeMillis();
        try {
            this.interfaceDbLogInfoService.saveOrUpdateByLogInfoId(interfaceLogInfo);
            long endTime = System.currentTimeMillis();
            log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mysql\u65e5\u5fd7\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMYTime});
        }
        catch (Exception exception) {
            long endTime = System.currentTimeMillis();
            log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mysql\u65e5\u5fd7\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMYTime});
            log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mysql\u65e5\u5fd7\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{}]", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), exception.getMessage()});
        }
        this.logPoolExecutor.execute(() -> {
            long startMGTime = System.currentTimeMillis();
            try {
                this.interfaceMongoLogService.saveOrUpdateInPutLog(interfaceLogInfoDTO);
                this.interfaceMongoLogService.saveOrUpdateOutPutLog(interfaceLogInfoDTO);
                long endTime = System.currentTimeMillis();
                log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u51fa\u5165\u53c2]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime});
            }
            catch (Exception exception) {
                long endTime = System.currentTimeMillis();
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u51fa\u5165\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime});
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u51fa\u5165\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{}]", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), exception.getMessage()});
                interfaceLogInfoDTO.setOutputParameter("mongo\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25\uff1a" + exception.getMessage());
                this.interfaceMongoLogService.saveOrUpdateOutPutLog(interfaceLogInfoDTO);
                JSONObject msgObj = this.produceErrorNotifyInfo(interfaceLogInfoDTO.getElsAccount(), interfaceLogInfoDTO.getInterfaceCode(), interfaceLogInfoDTO.getInputParameter(), interfaceLogInfoDTO.getOutputParameter(), exception, interfaceLogInfoDTO.getLogInfoId());
                MqUtil.sendBusMsg((String)msgObj.toJSONString());
            }
            log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\u63d2\u5165[\u51fa\u5165\u53c2]\u7ed3\u675f----->", (Object)interfaceLogInfoDTO.getLogInfoId(), (Object)interfaceLogInfoDTO.getInterfaceCode());
        });
        this.srmPoolExecutor.execute(() -> {
            long startMGTime1 = System.currentTimeMillis();
            try {
                this.interfaceMongoLogService.saveOrUpdateActualInPutLog(interfaceLogInfoDTO);
                this.interfaceMongoLogService.saveOrUpdateActualOutPutLog(interfaceLogInfoDTO);
                this.interfaceMongoLogService.saveOrUpdateResendValue(interfaceLogInfoDTO);
                long endTime = System.currentTimeMillis();
                log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5b9e\u9645\u51fa\u5165\u53c2]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime1});
            }
            catch (Exception exception) {
                long endTime = System.currentTimeMillis();
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5b9e\u9645\u51fa\u5165\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime1});
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5b9e\u9645\u51fa\u5165\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{}]", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), exception.getMessage()});
            }
            log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\u63d2\u5165[\u5b9e\u9645\u51fa\u5165\u53c2]\u7ed3\u675f----->", (Object)interfaceLogInfoDTO.getLogInfoId(), (Object)interfaceLogInfoDTO.getInterfaceCode());
        });
    }

    private JSONObject produceErrorNotifyInfo(String elsAccount, String interfaceCode, String input, String output, Throwable e, String id) {
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)elsAccount);
        msgObj.put("interfaceCode", (Object)interfaceCode);
        msgObj.put("businessType", (Object)"interface_error_notify");
        LoginUser loginUser = new LoginUser();
        loginUser.setId("9999999999");
        loginUser.setElsAccount(elsAccount);
        loginUser.setSubAccount("interface");
        loginUser.setRealname("interface");
        msgObj.put("sendObj", (Object)loginUser);
        HashMap<String, String> businessObj = new HashMap<String, String>(16);
        businessObj.put("requestTime", DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss"));
        businessObj.put("errorMsg", "mongo\u65e5\u5fd7\u5b58\u50a8\u5f02\u5e38\uff1a" + e.getMessage() + "\t\n \u65e5\u5fd7ID\u4e3a\uff1a" + id + "\t\n \u63a5\u53e3\u5165\u53c2\uff1a" + input + " \uff0c\u63a5\u53e3\u51fa\u53c2\uff1a" + output);
        msgObj.put("businessObj", (Object)SysUtil.objectToJSON(businessObj));
        return msgObj;
    }

    public InterfaceLogInfoDTO queryLogInfo(String logInfoId) {
        InterfaceDbLogInfo interfaceDbLogInfo = this.interfaceDbLogInfoService.queryByLogInfoId(logInfoId);
        if (interfaceDbLogInfo != null) {
            InterfaceLogInfoDTO logInfoDTO = new InterfaceLogInfoDTO();
            BeanUtils.copyProperties((Object)((Object)interfaceDbLogInfo), (Object)logInfoDTO);
            InterfaceResendValue interfaceResendValue = this.interfaceMongoLogService.getInterfaceResendValue(logInfoId);
            if (interfaceResendValue != null) {
                logInfoDTO.setResendParameter(interfaceResendValue.getValue());
            }
            return logInfoDTO;
        }
        return null;
    }

    public void solveLogInfo(String logInfoId) {
        InterfaceDbLogInfo interfaceDbLogInfo = this.interfaceDbLogInfoService.queryByLogInfoId(logInfoId);
        if (interfaceDbLogInfo != null) {
            interfaceDbLogInfo.setLogType("1");
            this.interfaceDbLogInfoService.updateById((Object)interfaceDbLogInfo);
        }
    }

    public String getInterfaceResendParameter(String logInfoId) {
        InterfaceResendValue interfaceResendValue = this.interfaceMongoLogService.getInterfaceResendValue(logInfoId);
        String resendParameter = null;
        if (interfaceResendValue != null) {
            resendParameter = interfaceResendValue.getValue();
        }
        return resendParameter;
    }

    public void clearLog(int days) {
        Date currentDate = new Date();
        DateTime clearDate = DateUtil.offsetDay((Date)currentDate, (int)(-days));
        List logIdList = this.interfaceDbLogInfoService.list((Wrapper)new QueryWrapper().select(new String[]{"id", "log_info_id"}).lt((Object)"create_time", (Object)clearDate));
        log.info("\u67e5\u8be2\u5230 " + logIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u65e5\u5fd7\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
        for (InterfaceDbLogInfo logInfo : logIdList) {
            try {
                this.interfaceDbLogInfoService.deleteById(logInfo.getId());
                this.interfaceMongoLogService.deleteByLogInfoId(logInfo.getLogInfoId());
            }
            catch (Exception e) {
                log.error("\u65e5\u5fd7id:" + logInfo.getId() + " \u6e05\u7406\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }
}

