/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mongolog.service.impl;

import com.els.modules.message.api.dto.InterfaceLogInfoDTO;
import com.els.modules.mongolog.entity.db.InterfaceDbLogInfo;
import com.els.modules.mongolog.entity.mongo.InterfaceActualInput;
import com.els.modules.mongolog.entity.mongo.InterfaceActualOutput;
import com.els.modules.mongolog.entity.mongo.InterfaceInput;
import com.els.modules.mongolog.entity.mongo.InterfaceOutput;
import com.els.modules.mongolog.entity.mongo.InterfaceResendValue;
import com.els.modules.mongolog.repository.InterfaceActualInputRepository;
import com.els.modules.mongolog.repository.InterfaceActualOutputRepository;
import com.els.modules.mongolog.repository.InterfaceInputRepository;
import com.els.modules.mongolog.repository.InterfaceLogInfoRepository;
import com.els.modules.mongolog.repository.InterfaceOutputRepository;
import com.els.modules.mongolog.repository.InterfaceResendValueRepository;
import com.els.modules.mongolog.service.InterfaceMongoLogService;
import com.els.modules.mongolog.vo.LogInfoId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class InterfaceMongoLogServiceImpl
implements InterfaceMongoLogService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    InterfaceLogInfoRepository interfaceLogInfoRepository;
    @Autowired
    InterfaceResendValueRepository interfaceResendValueRepository;
    @Autowired
    InterfaceInputRepository interfaceInputRepository;
    @Autowired
    InterfaceOutputRepository interfaceOutputRepository;
    @Autowired
    InterfaceActualInputRepository interfaceActualInputRepository;
    @Autowired
    InterfaceActualOutputRepository interfaceActualOutputRepository;

    @Override
    public List<String> filterParameterLogInfo(InterfaceDbLogInfo interfaceLogInfo, List<String> dbLogIdList) {
        Query inputQuery;
        List result;
        List logInfoIdInputList;
        ArrayList<String> logInfoIdList = new ArrayList<String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getInputParameter()}) && (logInfoIdInputList = (result = this.mongoTemplate.find(inputQuery = this.getQueryConditionForDb(interfaceLogInfo.getInputParameter(), interfaceLogInfo.getElsAccount(), dbLogIdList), LogInfoId.class, "interface_input")).stream().map(LogInfoId::getLogInfoId).collect(Collectors.toList())).size() > 0) {
            logInfoIdList.addAll(logInfoIdInputList);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getOutputParameter()})) {
            inputQuery = this.getQueryConditionForDb(interfaceLogInfo.getOutputParameter(), interfaceLogInfo.getElsAccount(), dbLogIdList);
            result = this.mongoTemplate.find(inputQuery, LogInfoId.class, "interface_output");
            List logInfoIdOutPutList = result.stream().map(LogInfoId::getLogInfoId).collect(Collectors.toList());
            if (logInfoIdList.size() == 0) {
                logInfoIdList.addAll(logInfoIdOutPutList);
            } else {
                logInfoIdList.retainAll(logInfoIdOutPutList);
            }
        }
        return logInfoIdList;
    }

    private Query getQueryConditionForDb(String filterParameter, String elsAccount, List<String> dbLogIdList) {
        Query query = new Query();
        if (dbLogIdList != null && dbLogIdList.size() > 0) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"logInfoId").in(dbLogIdList));
        }
        Pattern pattern = Pattern.compile("^.*" + filterParameter + ".*$", 8);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"value").regex(pattern));
        query.fields().include("logInfoId").exclude("_id");
        return query;
    }

    @Override
    public InterfaceInput getInterFaceInput(String logInfoId) {
        InterfaceInput result = null;
        InterfaceInput interfaceInput = new InterfaceInput();
        interfaceInput.setLogInfoId(logInfoId);
        ExampleMatcher exampleMatcher = ExampleMatcher.matching().withMatcher("logInfoId", ExampleMatcher.GenericPropertyMatchers.exact());
        Example example = Example.of((Object)interfaceInput, (ExampleMatcher)exampleMatcher);
        Optional optional = this.interfaceInputRepository.findOne(example);
        if (optional.isPresent()) {
            result = (InterfaceInput)optional.get();
        }
        return result;
    }

    @Override
    public InterfaceActualInput getInterfaceActualInput(String logInfoId) {
        InterfaceActualInput result = null;
        InterfaceActualInput interfaceActualInput = new InterfaceActualInput();
        interfaceActualInput.setLogInfoId(logInfoId);
        ExampleMatcher exampleMatcher = ExampleMatcher.matching().withMatcher("logInfoId", ExampleMatcher.GenericPropertyMatchers.exact());
        Example example = Example.of((Object)interfaceActualInput, (ExampleMatcher)exampleMatcher);
        Optional optional = this.interfaceActualInputRepository.findOne(example);
        if (optional.isPresent()) {
            result = (InterfaceActualInput)optional.get();
        }
        return result;
    }

    @Override
    public InterfaceOutput getInterFaceOutput(String logInfoId) {
        InterfaceOutput result = null;
        InterfaceOutput interfaceOutput = new InterfaceOutput();
        interfaceOutput.setLogInfoId(logInfoId);
        ExampleMatcher exampleMatcher = ExampleMatcher.matching().withMatcher("logInfoId", ExampleMatcher.GenericPropertyMatchers.exact());
        Example example = Example.of((Object)interfaceOutput, (ExampleMatcher)exampleMatcher);
        Optional optional = this.interfaceOutputRepository.findOne(example);
        if (optional.isPresent()) {
            result = (InterfaceOutput)optional.get();
        }
        return result;
    }

    @Override
    public InterfaceActualOutput getInterfaceActualOutput(String logInfoId) {
        InterfaceActualOutput result = null;
        InterfaceActualOutput interfaceActualOutput = new InterfaceActualOutput();
        interfaceActualOutput.setLogInfoId(logInfoId);
        ExampleMatcher exampleMatcher = ExampleMatcher.matching().withMatcher("logInfoId", ExampleMatcher.GenericPropertyMatchers.exact());
        Example example = Example.of((Object)interfaceActualOutput, (ExampleMatcher)exampleMatcher);
        Optional optional = this.interfaceActualOutputRepository.findOne(example);
        if (optional.isPresent()) {
            result = (InterfaceActualOutput)optional.get();
        }
        return result;
    }

    @Override
    public InterfaceResendValue getInterfaceResendValue(String logInfoId) {
        InterfaceResendValue result = null;
        InterfaceResendValue interfaceResendValue = new InterfaceResendValue();
        interfaceResendValue.setLogInfoId(logInfoId);
        ExampleMatcher exampleMatcher = ExampleMatcher.matching().withMatcher("logInfoId", ExampleMatcher.GenericPropertyMatchers.exact());
        Example example = Example.of((Object)interfaceResendValue, (ExampleMatcher)exampleMatcher);
        Optional optional = this.interfaceResendValueRepository.findOne(example);
        if (optional.isPresent()) {
            result = (InterfaceResendValue)optional.get();
        }
        return result;
    }

    @Override
    public void saveOrUpdateInPutLog(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        if (StringUtils.isBlank((CharSequence)interfaceLogInfoDTO.getInputParameter())) {
            return;
        }
        InterfaceInput interFaceInput = this.getInterFaceInput(interfaceLogInfoDTO.getLogInfoId());
        String parameter = interfaceLogInfoDTO.getInputParameter();
        if (interFaceInput != null) {
            interFaceInput.setValue(parameter);
            this.interfaceInputRepository.save(interFaceInput);
        } else {
            InterfaceInput interfaceInput = new InterfaceInput().setLogInfoId(interfaceLogInfoDTO.getLogInfoId()).setValue(parameter);
            this.interfaceInputRepository.insert(interfaceInput);
        }
    }

    @Override
    public void saveOrUpdateActualInPutLog(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        if (StringUtils.isBlank((CharSequence)interfaceLogInfoDTO.getActInputParameter())) {
            return;
        }
        InterfaceActualInput interFaceActualInput = this.getInterfaceActualInput(interfaceLogInfoDTO.getLogInfoId());
        if (interFaceActualInput != null) {
            interFaceActualInput.setValue(interfaceLogInfoDTO.getActInputParameter());
            this.interfaceActualInputRepository.save(interFaceActualInput);
        } else {
            InterfaceActualInput interfaceActualInput = new InterfaceActualInput().setLogInfoId(interfaceLogInfoDTO.getLogInfoId()).setValue(interfaceLogInfoDTO.getActInputParameter());
            this.interfaceActualInputRepository.insert(interfaceActualInput);
        }
    }

    @Override
    public void saveOrUpdateOutPutLog(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        if (StringUtils.isBlank((CharSequence)interfaceLogInfoDTO.getOutputParameter())) {
            return;
        }
        InterfaceOutput interFaceOutput = this.getInterFaceOutput(interfaceLogInfoDTO.getLogInfoId());
        String parameter = interfaceLogInfoDTO.getOutputParameter();
        if (interFaceOutput != null) {
            interFaceOutput.setValue(parameter);
            this.interfaceOutputRepository.save(interFaceOutput);
        } else {
            InterfaceOutput interfaceOutput = new InterfaceOutput().setLogInfoId(interfaceLogInfoDTO.getLogInfoId()).setValue(parameter);
            this.interfaceOutputRepository.insert(interfaceOutput);
        }
    }

    @Override
    public void saveOrUpdateActualOutPutLog(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        if (StringUtils.isBlank((CharSequence)interfaceLogInfoDTO.getActOutputParameter())) {
            return;
        }
        InterfaceActualOutput actualOutput = this.getInterfaceActualOutput(interfaceLogInfoDTO.getLogInfoId());
        if (actualOutput != null) {
            actualOutput.setValue(interfaceLogInfoDTO.getActOutputParameter());
            this.interfaceActualOutputRepository.save(actualOutput);
        } else {
            InterfaceActualOutput interfaceActualOutput = new InterfaceActualOutput().setLogInfoId(interfaceLogInfoDTO.getLogInfoId()).setValue(interfaceLogInfoDTO.getActOutputParameter());
            this.interfaceActualOutputRepository.insert(interfaceActualOutput);
        }
    }

    @Override
    public void saveOrUpdateResendValue(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        if (StringUtils.isBlank((CharSequence)interfaceLogInfoDTO.getResendParameter())) {
            return;
        }
        InterfaceResendValue interfaceResendValue = this.getInterfaceResendValue(interfaceLogInfoDTO.getLogInfoId());
        if (interfaceResendValue != null) {
            interfaceResendValue.setValue(interfaceLogInfoDTO.getResendParameter());
            this.interfaceResendValueRepository.save(interfaceResendValue);
        } else {
            InterfaceResendValue insertData = new InterfaceResendValue().setLogInfoId(interfaceLogInfoDTO.getLogInfoId()).setValue(interfaceLogInfoDTO.getResendParameter());
            this.interfaceResendValueRepository.insert(insertData);
        }
    }

    @Override
    public void deleteByLogInfoId(String logInfoId) {
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"logInfoId").is((Object)logInfoId)), InterfaceActualInput.class);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"logInfoId").is((Object)logInfoId)), InterfaceActualOutput.class);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"logInfoId").is((Object)logInfoId)), InterfaceInput.class);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"logInfoId").is((Object)logInfoId)), InterfaceOutput.class);
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"logInfoId").is((Object)logInfoId)), InterfaceResendValue.class);
    }
}

