/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.message.service.MsgService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Service;

@Service
public class BusinessMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(BusinessMessageConsumer.class);
    @Resource
    private MsgService msgService;

    @StreamListener(value="input")
    public void receive(String msgBody) {
        log.info("msgBody: " + msgBody);
        if (StrUtil.isBlank((CharSequence)msgBody)) {
            return;
        }
        try {
            JSONObject msgObj = JSONObject.parseObject((String)msgBody);
            if (!msgObj.containsKey((Object)"busAccount")) {
                throw new ELSBootException("busAccount can not be blank");
            }
            if (!msgObj.containsKey((Object)"msgKey")) {
                throw new ELSBootException("msgKey can not be blank");
            }
            if (!msgObj.containsKey((Object)"businessType")) {
                throw new ELSBootException("businessType can not be blank");
            }
            if (!msgObj.containsKey((Object)"sendObj")) {
                throw new ELSBootException("sendObj can not be blank");
            }
            if (!msgObj.containsKey((Object)"businessObj")) {
                throw new ELSBootException("businessObj can not be blank");
            }
            this.msgService.sendMsg(msgObj);
        }
        catch (Exception e) {
            log.error("send_msg_failed:" + msgBody, (Throwable)e);
        }
    }
}

