/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.notice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.notice.entity.PurchaseNotice;
import com.els.modules.notice.entity.PurchaseNoticeSupplier;
import com.els.modules.notice.entity.SaleNotice;
import com.els.modules.notice.service.PurchaseNoticeService;
import com.els.modules.notice.service.PurchaseNoticeSupplierService;
import com.els.modules.notice.service.SaleNoticeService;
import com.els.modules.notice.vo.PurchaseNoticeVO;
import com.els.modules.notice.vo.SaleNoticeVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notice/purchaseNotice"})
@Api(tags={"\u91c7\u8d2d\u516c\u544a"})
public class PurchaseNoticeController
extends BaseController<PurchaseNotice, PurchaseNoticeService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseNoticeController.class);
    @Autowired
    private PurchaseNoticeService purchaseNoticeService;
    @Autowired
    private SaleNoticeService saleNoticeService;
    @Autowired
    private PurchaseNoticeSupplierService purchaseNoticeSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseNotice purchaseNotice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseNotice), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseNoticeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u767b\u5f55\u9875\u516c\u544a\u5217\u8868\u67e5\u8be2", notes="\u767b\u5f55\u9875\u516c\u544a\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/noToken/publicList"})
    public Result<?> queryPublicPageList(PurchaseNotice purchaseNotice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseNotice), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(PurchaseNotice::getNoticeScope, (Object)NoticeScopeEnum.OPEN.getValue());
        queryWrapper.lambda().ge(PurchaseNotice::getExpiryTime, (Object)new Date());
        queryWrapper.lambda().le(PurchaseNotice::getEffectiveTime, (Object)new Date());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().notIn(PurchaseNotice::getBusinessType, new Object[]{""})).or()).isNull(PurchaseNotice::getBusinessType);
        queryWrapper.lambda().orderByDesc(PurchaseNotice::getTop);
        queryWrapper.lambda().orderByDesc(PurchaseNotice::getPublishTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseNoticeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u767b\u5f55\u9875\u516c\u5f00\u5bfb\u6e90\u516c\u544a\u5217\u8868\u67e5\u8be2", notes="\u767b\u5f55\u9875\u516c\u5f00\u5bfb\u6e90\u516c\u544a\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/noToken/publicInquiryList"})
    public Result<?> queryPublicInquiryPageList(PurchaseNotice purchaseNotice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseNotice), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(PurchaseNotice::getNoticeScope, (Object)NoticeScopeEnum.OPEN.getValue());
        queryWrapper.lambda().ge(PurchaseNotice::getExpiryTime, (Object)new Date());
        queryWrapper.lambda().le(PurchaseNotice::getEffectiveTime, (Object)new Date());
        queryWrapper.lambda().in(PurchaseNotice::getBusinessType, new Object[]{""});
        queryWrapper.lambda().orderByDesc(PurchaseNotice::getTop);
        queryWrapper.lambda().orderByDesc(PurchaseNotice::getPublishTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseNoticeService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseNoticeVO purchaseNoticePage) {
        PurchaseNotice purchaseNotice = new PurchaseNotice();
        BeanUtils.copyProperties((Object)((Object)purchaseNoticePage), (Object)((Object)purchaseNotice));
        this.purchaseNoticeService.saveMain(purchaseNotice, purchaseNoticePage.getPurchaseNoticeSupplierList(), purchaseNoticePage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseNotice));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseNoticeVO purchaseNoticePage) {
        PurchaseNotice purchaseNotice = new PurchaseNotice();
        BeanUtils.copyProperties((Object)((Object)purchaseNoticePage), (Object)((Object)purchaseNotice));
        this.purchaseNoticeService.updateMain(purchaseNotice, purchaseNoticePage.getPurchaseNoticeSupplierList(), purchaseNoticePage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseNoticeVO purchaseNoticePage) {
        PurchaseNotice purchaseNotice = new PurchaseNotice();
        BeanUtils.copyProperties((Object)((Object)purchaseNoticePage), (Object)((Object)purchaseNotice));
        this.purchaseNoticeService.publish(purchaseNotice, purchaseNoticePage.getPurchaseNoticeSupplierList(), purchaseNoticePage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchaseNoticeService.cancel(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876", notes="\u7f6e\u9876/\u53d6\u6d88\u7f6e\u9876")
    @GetMapping(value={"/topOpt"})
    public Result<?> topOpt(@RequestParam(name="id") String id) {
        this.purchaseNoticeService.setTopOpt(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u9875\u516c\u544a", notes="\u83b7\u53d6\u767b\u5f55\u9875\u516c\u544a")
    @GetMapping(value={"/noToken/getPublicNotice"})
    public Result<?> getPublicNotice() {
        List<PurchaseNotice> noticeList = this.purchaseNoticeService.getPublicNoticeList();
        return Result.ok(noticeList);
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u9875\u516c\u5f00\u5bfb\u6e90\u516c\u544a", notes="\u83b7\u53d6\u767b\u5f55\u9875\u516c\u5f00\u5bfb\u6e90\u516c\u544a")
    @GetMapping(value={"/noToken/getPublicInquiryNotice"})
    public Result<?> getPublicInquiryNotice() {
        List<PurchaseNotice> noticeList = this.purchaseNoticeService.getPublicInquiryNoticeList();
        return Result.ok(noticeList);
    }

    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u516c\u544a", notes="\u83b7\u53d6\u9996\u9875\u516c\u544a")
    @GetMapping(value={"/getHomePageNotice"})
    public Result<?> getHomePageNotice(PurchaseNotice purchaseNotice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        int fromIndex = pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0;
        IPage<PurchaseNotice> noticeList = this.purchaseNoticeService.getHomePageNoticeList(fromIndex, pageSize);
        return Result.ok(noticeList);
    }

    @AutoLog(value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseNoticeService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseNoticeService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/noToken/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseNotice purchaseNotice = (PurchaseNotice)((Object)this.purchaseNoticeService.getById((Serializable)((Object)id)));
        if (purchaseNotice != null) {
            PurchaseNoticeVO purchaseNoticeVO = new PurchaseNoticeVO();
            BeanUtils.copyProperties((Object)((Object)purchaseNotice), (Object)((Object)purchaseNoticeVO));
            List<PurchaseNoticeSupplier> purchaseNoticeSupplierList = this.purchaseNoticeSupplierService.selectByMainId(id);
            purchaseNoticeVO.setPurchaseNoticeSupplierList(purchaseNoticeSupplierList);
            List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
            purchaseNoticeVO.setPurchaseAttachmentList(purchaseAttachmentList);
            return Result.ok((Object)((Object)purchaseNoticeVO));
        }
        SaleNotice saleNotice = (SaleNotice)((Object)this.saleNoticeService.getById((Serializable)((Object)id)));
        SaleNoticeVO saleNoticeVO = new SaleNoticeVO();
        BeanUtils.copyProperties((Object)((Object)saleNotice), (Object)((Object)saleNoticeVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleNoticeVO.setSaleAttachmentList(saleAttachmentList);
        return Result.ok((Object)((Object)saleNoticeVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u516c\u544aid\u67e5\u8be2\u516c\u544a\u4f9b\u5e94\u5546\u5217\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u516c\u544aid\u67e5\u8be2\u516c\u544a\u4f9b\u5e94\u5546\u5217\u8868")
    @GetMapping(value={"/queryPurchaseNoticeSupplierByMainId"})
    public Result<?> queryPurchaseNoticeSupplierListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseNoticeSupplier> purchaseNoticeSupplierList = this.purchaseNoticeSupplierService.selectByMainId(id);
        return Result.ok(purchaseNoticeSupplierList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u516c\u544aid\u67e5\u8be2\u9644\u4ef6\u5217\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u516c\u544aid\u67e5\u8be2\u9644\u4ef6\u5217\u8868")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id") String id) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        return Result.ok((Object)purchaseAttachmentList);
    }
}

