/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mongolog.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TimeUtils {
    public static boolean isBeforeTime(String startTime, String endTime, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        try {
            startCalendar.setTime(df.parse(startTime));
            endCalendar.setTime(df.parse(endTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return startCalendar.before(endCalendar);
    }

    public static String timeAdd(String dateTime, int addMinute, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Calendar timeCalendar = Calendar.getInstance();
        try {
            timeCalendar.setTime(df.parse(dateTime));
            timeCalendar.add(12, addMinute);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String time = df.format(timeCalendar.getTime());
        return time;
    }

    public static String getNowTime(String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(new Date());
    }

    public static String timeFormat(String dataTime, String beforFormat, String resultFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(beforFormat);
        try {
            Date time = formatter.parse(dataTime);
            SimpleDateFormat dateFormat = new SimpleDateFormat(resultFormat);
            String formatTime = dateFormat.format(time);
            return formatTime;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getDays(String startTime, String endTime, String pattern) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date start = null;
        Date end = null;
        try {
            start = dateFormat.parse(startTime);
            end = dateFormat.parse(endTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        tempEnd.add(5, 1);
        while (tempStart.before(tempEnd)) {
            days.add(dateFormat.format(tempStart.getTime()));
            tempStart.add(6, 1);
        }
        return days;
    }

    public static List<String> getHours(String startTime, String endTime, String pattern) {
        ArrayList<String> hours = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date start = null;
        Date end = null;
        try {
            start = dateFormat.parse(startTime);
            end = dateFormat.parse(endTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            String format = dateFormat.format(tempStart.getTime());
            System.out.println(format);
            tempStart.add(11, 1);
            String format1 = dateFormat.format(tempStart.getTime());
            System.out.println(format1);
            System.out.println("------------");
        }
        return hours;
    }

    public static void main(String[] args) {
        List<String> hours = TimeUtils.getHours("2022-10-07 00:00:00", "2022-10-07 23:59:59", "yyyy-MM-dd HH:mm:ss");
        for (String hour : hours) {
            System.out.println(hour);
        }
    }
}

