/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.integration.api.dto.InterfaceConfigDTO;
import com.els.modules.integration.api.dto.InterfaceMsgNotifyDTO;
import com.els.modules.integration.api.service.InterfaceMsgNotifyRpcService;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.handle.enums.ReceiveTypeEnum;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.vo.MsgVO;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MsgServiceImpl
implements MsgService {
    private static final Logger log = LoggerFactory.getLogger(MsgServiceImpl.class);
    @Resource
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Resource
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Resource
    private MessageInvokeAccountService accountDubboService;
    @Resource
    private InterfaceMsgNotifyRpcService interfaceMsgNotifyRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    private List<String> processData(List<PersonalSettingDTO> personalSettings) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SendMsgTypeEnum.IN_MSG.getType());
        for (PersonalSettingDTO personalSetting : personalSettings) {
            if (ReceiveTypeEnum.EMAIL.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.EMAIL.getType());
                continue;
            }
            if (ReceiveTypeEnum.MSG.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.SMS.getType());
                continue;
            }
            if (ReceiveTypeEnum.NEWS.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.IN_MSG.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT_EP.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX_EP.getType());
                continue;
            }
            if (!ReceiveTypeEnum.DINGTALK.getValue().equals(personalSetting.getReceiveType())) continue;
            list.add(SendMsgTypeEnum.DINGTALK.getType());
        }
        return list;
    }

    private List<ElsMsgConfigItem> getMsgConfigItemList(String headId) {
        List<ElsMsgConfigItem> resultList = new ArrayList<ElsMsgConfigItem>();
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        return resultList;
    }

    @Override
    public void sendMsg(JSONObject msg) {
        String interfaceCode;
        String busAccount = msg.getString("busAccount");
        InterfaceConfigDTO interfaceInfo = this.interfaceMsgNotifyRpcService.getInterfaceInfo(busAccount, interfaceCode = msg.getString("interfaceCode"));
        if (interfaceInfo == null) {
            return;
        }
        String interfaceInfoId = interfaceInfo.getId();
        List msgNotifyDTOList = this.interfaceMsgNotifyRpcService.getInterfaceMsgNotify(interfaceInfoId);
        if (msgNotifyDTOList == null || msgNotifyDTOList.size() == 0) {
            return;
        }
        for (InterfaceMsgNotifyDTO msgNotifyDTO : msgNotifyDTOList) {
            String[] receiveArray;
            List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(msgNotifyDTO.getMsgHeadId());
            if (configItemList.isEmpty()) {
                return;
            }
            JSONObject businessObj = msg.getJSONObject("businessObj");
            businessObj.put("appName", (Object)interfaceInfo.getAppName());
            businessObj.put("srmModule", (Object)interfaceInfo.getSrmModule());
            businessObj.put("interfaceName", (Object)interfaceInfo.getInterfaceName());
            businessObj.put("interfaceCode", (Object)interfaceInfo.getInterfaceCode());
            businessObj.put("interfaceDesc", (Object)interfaceInfo.getInterfaceDesc());
            businessObj.put("interfaceVersion", (Object)interfaceInfo.getInterfaceVersion());
            ElsSubAccountDTO sendAccount = (ElsSubAccountDTO)msg.getObject("sendObj", ElsSubAccountDTO.class);
            for (String subAccount : receiveArray = msgNotifyDTO.getSubAccounts().split(",")) {
                String toElsAccount = busAccount;
                ElsSubAccountDTO receive = this.invokeAccountRpcService.getAccount(busAccount, subAccount);
                List<PersonalSettingDTO> personalSettings = this.accountDubboService.getPersonalSetting(toElsAccount, receive.getSubAccount());
                List<String> list = this.processData(personalSettings);
                for (ElsMsgConfigItem item : configItemList) {
                    if (!list.contains(item.getMsgType())) continue;
                    try {
                        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(item.getMsgType());
                        MsgVO msgVO = new MsgVO();
                        msgVO.setElsMsgConfigItem(item);
                        msgVO.setReceiveAccount(receive);
                        msgVO.setSendAccount(sendAccount);
                        msgVO.setParams(businessObj);
                        sendMsgHandle.sendMsg(msgVO);
                    }
                    catch (Exception e) {
                        log.error(msg.toJSONString() + ",send_msg_fialed:" + item.getMsgType(), (Throwable)e);
                    }
                }
            }
        }
    }
}

