/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mongolog.api.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.modules.message.api.dto.InterfaceLogInfoDTO;
import com.els.modules.message.api.service.InterfaceLogRpcService;
import com.els.modules.mongolog.entity.db.InterfaceDbLogInfo;
import com.els.modules.mongolog.entity.mongo.InterfaceResendValue;
import com.els.modules.mongolog.service.InterfaceDbLogInfoService;
import com.els.modules.mongolog.service.InterfaceMongoLogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InterfaceLogRpcServiceImpl
implements InterfaceLogRpcService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceLogRpcServiceImpl.class);
    @Value(value="${logging.ip.recordFlag}")
    private String recordFlag;
    @Autowired
    private InterfaceDbLogInfoService interfaceDbLogInfoService;
    @Autowired
    private InterfaceMongoLogService interfaceMongoLogService;
    @Resource(name="logPoolExecutor")
    private ThreadPoolExecutor logPoolExecutor;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor srmPoolExecutor;
    @Resource(name="mysqlLogPoolExecutor")
    private ThreadPoolExecutor mysqlLogPoolExecutor;

    public void asyncSave(InterfaceLogInfoDTO interfaceLogInfoDTO) {
        InterfaceDbLogInfo interfaceLogInfo = new InterfaceDbLogInfo();
        BeanUtils.copyProperties((Object)interfaceLogInfoDTO, (Object)((Object)interfaceLogInfo));
        if (!"N".equals(this.recordFlag)) {
            try {
                Process process = Runtime.getRuntime().exec("curl ip.sb");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String ip = reader.readLine().trim();
                if (StringUtils.isBlank((CharSequence)interfaceLogInfo.getBusinessMessage())) {
                    interfaceLogInfo.setBusinessMessage("(" + ip + ")");
                } else {
                    interfaceLogInfo.setBusinessMessage(interfaceLogInfoDTO.getBusinessMessage() + "(" + ip + ")");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("<-----\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}],\u63a5\u53e3\u7f16\u7801[{}],\u5f00\u59cb\u63d2\u5165\u65e5\u5fd7", (Object)interfaceLogInfoDTO.getLogInfoId(), (Object)interfaceLogInfoDTO.getInterfaceCode());
        this.mysqlLogPoolExecutor.execute(() -> {
            long startMYTime = System.currentTimeMillis();
            try {
                this.interfaceDbLogInfoService.saveOrUpdateByLogInfoId(interfaceLogInfo);
                long endTime = System.currentTimeMillis();
                log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mysql\u65e5\u5fd7\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMYTime});
            }
            catch (Exception exception) {
                long endTime = System.currentTimeMillis();
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mysql\u65e5\u5fd7\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMYTime});
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mysql\u65e5\u5fd7\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{}]", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), exception.getMessage()});
            }
        });
        this.logPoolExecutor.execute(() -> {
            long startMGTime = System.currentTimeMillis();
            try {
                this.interfaceMongoLogService.saveOrUpdateInPutLog(interfaceLogInfoDTO);
                this.interfaceMongoLogService.saveOrUpdateActualInPutLog(interfaceLogInfoDTO);
                long endTime = System.currentTimeMillis();
                log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5165\u53c2/\u5b9e\u9645\u5165\u53c2]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime});
            }
            catch (Exception exception) {
                long endTime = System.currentTimeMillis();
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5165\u53c2/\u5b9e\u9645\u5165\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime});
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5165\u53c2/\u5b9e\u9645\u5165\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{}]", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), exception.getMessage()});
                String inputParameter = interfaceLogInfoDTO.getInputParameter();
                int lenght = inputParameter.length() > 10000 ? 10000 : inputParameter.length();
                interfaceLogInfoDTO.setInputParameter("mongo\u65e5\u5fd7[\u5165\u53c2/\u5b9e\u9645\u5165\u53c2]\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u4fdd\u5b58\u503c\uff1a" + interfaceLogInfoDTO.getInputParameter().substring(0, lenght) + "\u3002\u4fdd\u5b58\u5f02\u5e38\u4fe1\u606f\uff1a" + exception.getMessage());
                this.interfaceMongoLogService.saveOrUpdateInPutLog(interfaceLogInfoDTO);
                JSONObject msgObj = this.produceErrorNotifyInfo(interfaceLogInfoDTO.getElsAccount(), interfaceLogInfoDTO.getInterfaceCode(), interfaceLogInfoDTO.getInputParameter(), interfaceLogInfoDTO.getOutputParameter(), exception, interfaceLogInfoDTO.getLogInfoId());
                MqUtil.sendBusMsg((String)msgObj.toJSONString());
            }
            log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\u63d2\u5165[\u5165\u53c2/\u5b9e\u9645\u5165\u53c2]\u7ed3\u675f----->", (Object)interfaceLogInfoDTO.getLogInfoId(), (Object)interfaceLogInfoDTO.getInterfaceCode());
        });
        this.srmPoolExecutor.execute(() -> {
            long startMGTime1 = System.currentTimeMillis();
            try {
                this.interfaceMongoLogService.saveOrUpdateActualOutPutLog(interfaceLogInfoDTO);
                this.interfaceMongoLogService.saveOrUpdateOutPutLog(interfaceLogInfoDTO);
                this.interfaceMongoLogService.saveOrUpdateResendValue(interfaceLogInfoDTO);
                long endTime = System.currentTimeMillis();
                log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5b9e\u9645\u51fa\u53c2/\u51fa\u53c2]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime1});
            }
            catch (Exception exception) {
                long endTime = System.currentTimeMillis();
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5b9e\u9645\u51fa\u53c2/\u51fa\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u6267\u884c\u65f6\u95f4\u4e3a[{}]ms", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), endTime - startMGTime1});
                log.error("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\u63d2\u5165mongodb[\u5b9e\u9645\u51fa\u53c2/\u51fa\u53c2]\u5931\u8d25\uff0c\u63a5\u53e3\u7f16\u7801[{}]\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{}]", new Object[]{interfaceLogInfoDTO.getLogInfoId(), interfaceLogInfoDTO.getInterfaceCode(), exception.getMessage()});
                String outputParameter = interfaceLogInfoDTO.getOutputParameter();
                int lenght = outputParameter.length() > 10000 ? 10000 : outputParameter.length();
                interfaceLogInfoDTO.setOutputParameter("mongo\u65e5\u5fd7[\u5b9e\u9645\u51fa\u53c2/\u51fa\u53c2]\u4fdd\u5b58\u5931\u8d25\uff1a\u539f\u4fdd\u5b58\u503c\uff1a" + interfaceLogInfoDTO.getOutputParameter().substring(0, lenght) + "\u3002\u4fdd\u5b58\u5f02\u5e38\u4fe1\u606f\uff1a" + exception.getMessage());
                this.interfaceMongoLogService.saveOrUpdateOutPutLog(interfaceLogInfoDTO);
                JSONObject msgObj = this.produceErrorNotifyInfo(interfaceLogInfoDTO.getElsAccount(), interfaceLogInfoDTO.getInterfaceCode(), interfaceLogInfoDTO.getInputParameter(), interfaceLogInfoDTO.getOutputParameter(), exception, interfaceLogInfoDTO.getLogInfoId());
                MqUtil.sendBusMsg((String)msgObj.toJSONString());
            }
            log.info("\u65e5\u5fd7\u6807\u8bc6logInfoId\u4e3a[{}]\uff0c\u63a5\u53e3\u7f16\u7801[{}]\u63d2\u5165[\u5b9e\u9645\u51fa\u53c2/\u51fa\u53c2]\u7ed3\u675f----->", (Object)interfaceLogInfoDTO.getLogInfoId(), (Object)interfaceLogInfoDTO.getInterfaceCode());
        });
    }

    private JSONObject produceErrorNotifyInfo(String elsAccount, String interfaceCode, String input, String output, Throwable e, String id) {
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)elsAccount);
        msgObj.put("interfaceCode", (Object)interfaceCode);
        msgObj.put("businessType", (Object)"interface_error_notify");
        LoginUser loginUser = new LoginUser();
        loginUser.setId("9999999999");
        loginUser.setElsAccount(elsAccount);
        loginUser.setSubAccount("interface");
        loginUser.setRealname("interface");
        msgObj.put("sendObj", (Object)loginUser);
        HashMap<String, String> businessObj = new HashMap<String, String>(16);
        businessObj.put("requestTime", DateUtils.getDate((String)"yyyy-MM-dd HH:mm:ss"));
        businessObj.put("errorMsg", "mongo\u65e5\u5fd7\u5b58\u50a8\u5f02\u5e38\uff1a" + e.getMessage() + "\t\n \u65e5\u5fd7ID\u4e3a\uff1a" + id + "\t\n \u63a5\u53e3\u5165\u53c2\uff1a" + input + " \uff0c\u63a5\u53e3\u51fa\u53c2\uff1a" + output);
        msgObj.put("businessObj", (Object)SysUtil.objectToJSON(businessObj));
        return msgObj;
    }

    public InterfaceLogInfoDTO queryLogInfo(String logInfoId) {
        InterfaceDbLogInfo interfaceDbLogInfo = this.interfaceDbLogInfoService.queryByLogInfoId(logInfoId);
        if (interfaceDbLogInfo != null) {
            InterfaceLogInfoDTO logInfoDTO = new InterfaceLogInfoDTO();
            BeanUtils.copyProperties((Object)((Object)interfaceDbLogInfo), (Object)logInfoDTO);
            InterfaceResendValue interfaceResendValue = this.interfaceMongoLogService.getInterfaceResendValue(logInfoId);
            if (interfaceResendValue != null) {
                logInfoDTO.setResendParameter(interfaceResendValue.getValue());
            }
            return logInfoDTO;
        }
        return null;
    }

    public void solveLogInfo(String logInfoId) {
        InterfaceDbLogInfo interfaceDbLogInfo = this.interfaceDbLogInfoService.queryByLogInfoId(logInfoId);
        if (interfaceDbLogInfo != null) {
            interfaceDbLogInfo.setLogType("1");
            this.interfaceDbLogInfoService.updateById((Object)interfaceDbLogInfo);
        }
    }

    public String getInterfaceResendParameter(String logInfoId) {
        InterfaceResendValue interfaceResendValue = this.interfaceMongoLogService.getInterfaceResendValue(logInfoId);
        String resendParameter = null;
        if (interfaceResendValue != null) {
            resendParameter = interfaceResendValue.getValue();
        }
        return resendParameter;
    }

    public void clearLog(int days, String interfaceCode, String tenantAccount, String excludeAccount) {
        List logIdList;
        Date currentDate = new Date();
        DateTime clearDate = DateUtil.offsetDay((Date)currentDate, (int)(-days));
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)interfaceCode)) {
            wrapper.eq((Object)"interface_code", (Object)interfaceCode);
        }
        if (StringUtils.isNotBlank((CharSequence)tenantAccount)) {
            wrapper.eq((Object)"els_account", (Object)tenantAccount);
        }
        if (StringUtils.isNotBlank((CharSequence)excludeAccount)) {
            String[] excludeAccounts = excludeAccount.split(",");
            wrapper.notIn((Object)"els_account", Arrays.asList(excludeAccounts));
        }
        wrapper.select(new String[]{"id", "log_info_id"}).lt((Object)"create_time", (Object)clearDate);
        wrapper.last(" limit 1000");
        while (!(logIdList = this.interfaceDbLogInfoService.list((Wrapper)wrapper)).isEmpty()) {
            log.info("\u67e5\u8be2\u5230 " + logIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u65e5\u5fd7\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
            List<String> dbLogInfoIds = logIdList.stream().map(x -> x.getId()).collect(Collectors.toList());
            List<String> mongoLogInfoIds = logIdList.stream().map(x -> x.getLogInfoId()).collect(Collectors.toList());
            try {
                this.interfaceDbLogInfoService.deleteBatch(dbLogInfoIds);
                this.interfaceMongoLogService.deleteByLogInfoIdBatch(mongoLogInfoIds);
            }
            catch (Exception e) {
                log.error("\u65e5\u5fd7\u6279\u91cf\u6e05\u7406\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    public void LogClearByDateTimeJob(String startTime, String endTime, String interfaceCode, String tenantAccount) {
        List logIdList;
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)interfaceCode)) {
            wrapper.eq((Object)"interface_code", (Object)interfaceCode);
        }
        if (StringUtils.isNotBlank((CharSequence)tenantAccount)) {
            wrapper.eq((Object)"els_account", (Object)tenantAccount);
        }
        wrapper.gt((Object)"create_time", (Object)startTime);
        wrapper.lt((Object)"create_time", (Object)endTime);
        wrapper.last(" limit 1000");
        while (!(logIdList = this.interfaceDbLogInfoService.list((Wrapper)wrapper)).isEmpty()) {
            log.info("\u67e5\u8be2\u5230 " + logIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u65e5\u5fd7\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
            List<String> dbLogInfoIds = logIdList.stream().map(x -> x.getId()).collect(Collectors.toList());
            List<String> mongoLogInfoIds = logIdList.stream().map(x -> x.getLogInfoId()).collect(Collectors.toList());
            try {
                this.interfaceDbLogInfoService.deleteBatch(dbLogInfoIds);
                this.interfaceMongoLogService.deleteByLogInfoIdBatch(mongoLogInfoIds);
            }
            catch (Exception e) {
                log.error("\u65e5\u5fd7\u6279\u91cf\u6e05\u7406\u5931\u8d25:", (Throwable)e);
            }
        }
    }
}

