/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mongolog.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mongolog.entity.db.InterfaceDbLogInfo;
import com.els.modules.mongolog.service.InterfaceDbLogInfoService;
import com.els.modules.mongolog.service.InterfaceMongoLogService;
import com.els.modules.mongolog.utils.SplitUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u63a5\u53e3\u65e5\u5fd7"})
@RestController
@RequestMapping(value={"/interface/log/"})
public class InterfaceLogInfoController
extends BaseController<InterfaceDbLogInfo, InterfaceDbLogInfoService> {
    @Autowired
    private InterfaceDbLogInfoService interfaceLogDbInfoService;
    @Autowired
    private InterfaceMongoLogService interfaceMongoLogService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="loginfo")
    public Result<?> queryPageList(InterfaceDbLogInfo interfaceLogInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        boolean hasParam;
        if (!"100000".equals(TenantContext.getTenant())) {
            interfaceLogInfo.setElsAccount(TenantContext.getTenant());
        }
        if (interfaceLogInfo.getSelectHour() != null) {
            Date endDate = DateUtils.addDays((Date)interfaceLogInfo.getSelectHour(), (int)1);
            interfaceLogInfo.setStaTime(interfaceLogInfo.getSelectHour());
            interfaceLogInfo.setEndTime(endDate);
        }
        List dbLogIdList = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getInputParameter()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getOutputParameter()})) {
            QueryWrapper queryWrapper;
            if (StringUtils.isBlank((CharSequence)interfaceLogInfo.getInterfaceCode())) {
                throw new ELSBootException("\u63a5\u53e3\u51fa\u5165\u53c2\u67e5\u8be2\uff0c\u63a5\u53e3\u7f16\u7801\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isNotBlank((CharSequence)interfaceLogInfo.getInterfaceCode())) {
                queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
                queryWrapper.eq((Object)"interface_code", (Object)interfaceLogInfo.getInterfaceCode());
                queryWrapper.last("limit 0,10");
                List logInfoList = this.interfaceLogDbInfoService.list((Wrapper)queryWrapper);
                if (logInfoList == null || logInfoList.size() == 0) {
                    throw new ELSBootException("\u63a5\u53e3\u7f16\u7801[" + interfaceLogInfo.getInterfaceCode() + "]\u67e5\u8be2\u65e5\u5fd7\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01");
                }
            }
            if (interfaceLogInfo.getStaTime() == null && interfaceLogInfo.getEndTime() == null) {
                throw new ELSBootException("\u63a5\u53e3\u51fa\u5165\u53c2\u67e5\u8be2\uff0c\u65f6\u95f4\u8303\u56f4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
            queryWrapper.eq((Object)"interface_code", (Object)interfaceLogInfo.getInterfaceCode());
            queryWrapper.gt((Object)"create_time", (Object)interfaceLogInfo.getStaTime());
            queryWrapper.lt((Object)"create_time", (Object)interfaceLogInfo.getEndTime());
            List contractHeads = this.interfaceLogDbInfoService.list((Wrapper)queryWrapper);
            dbLogIdList = contractHeads.stream().map(InterfaceDbLogInfo::getLogInfoId).collect(Collectors.toList());
        }
        ArrayList<String> logInfoList = new ArrayList<String>();
        if (dbLogIdList != null && dbLogIdList.size() > 0) {
            List splitList = SplitUtils.splitList(dbLogIdList, 10);
            for (List<String> list : splitList) {
                List<String> subLogInfoList = this.interfaceMongoLogService.filterParameterLogInfo(interfaceLogInfo, list);
                if (subLogInfoList.isEmpty()) continue;
                logInfoList.addAll(subLogInfoList);
            }
        }
        boolean bl = hasParam = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getInputParameter()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getOutputParameter()});
        if (hasParam && logInfoList.isEmpty()) {
            return Result.ok((Object)new Page());
        }
        Date staTime = interfaceLogInfo.getStaTime();
        Date date = interfaceLogInfo.getEndTime();
        interfaceLogInfo.setInputParameter(null);
        interfaceLogInfo.setOutputParameter(null);
        interfaceLogInfo.setStaTime(null);
        interfaceLogInfo.setEndTime(null);
        interfaceLogInfo.setSelectHour(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)interfaceLogInfo), (Map)req.getParameterMap());
        if (logInfoList != null && logInfoList.size() > 0) {
            queryWrapper.in((Object)"log_info_id", logInfoList);
        }
        if (staTime != null && date != null) {
            queryWrapper.gt((Object)"create_time", (Object)staTime);
            queryWrapper.lt((Object)"create_time", (Object)date);
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isNotBlank((CharSequence)interfaceLogInfo.getSelectField())) {
            String[] fields = interfaceLogInfo.getSelectField().split(",");
            queryWrapper.select(fields);
        }
        IPage pageList = this.interfaceLogDbInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u65e5\u5fd7\u8bb0\u5f55\u8be6\u60c5", notes="\u901a\u8fc7id\u83b7\u53d6\u65e5\u5fd7\u8bb0\u5f55\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String logInfoId) {
        InterfaceDbLogInfo interfaceLogInfo = this.interfaceLogDbInfoService.queryByLogInfoId(logInfoId);
        return Result.ok((Object)((Object)interfaceLogInfo));
    }
}

