/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mongolog.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.mongolog.entity.db.InterfaceDbLogInfo;
import com.els.modules.mongolog.entity.mongo.InterfaceActualInput;
import com.els.modules.mongolog.entity.mongo.InterfaceActualOutput;
import com.els.modules.mongolog.entity.mongo.InterfaceInput;
import com.els.modules.mongolog.entity.mongo.InterfaceOutput;
import com.els.modules.mongolog.mapper.InterfaceLogInfoMapper;
import com.els.modules.mongolog.service.InterfaceDbLogInfoService;
import com.els.modules.mongolog.service.InterfaceMongoLogService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InterfaceDbLogInfoServiceImpl
extends BaseServiceImpl<InterfaceLogInfoMapper, InterfaceDbLogInfo>
implements InterfaceDbLogInfoService {
    @Autowired
    private InterfaceMongoLogService interfaceMongoLogService;
    @Autowired
    private InterfaceLogInfoMapper interfaceLogInfoMapper;

    @Override
    public void add(InterfaceDbLogInfo interfaceLogInfo) {
        ((InterfaceLogInfoMapper)this.baseMapper).insert((Object)interfaceLogInfo);
    }

    @Override
    public void saveOrUpdateByLogInfoId(InterfaceDbLogInfo interfaceLogInfo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"log_info_id", (Object)interfaceLogInfo.getLogInfoId());
        InterfaceDbLogInfo dbData = (InterfaceDbLogInfo)((Object)((InterfaceLogInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (dbData != null) {
            interfaceLogInfo.setUpdateTime(new Date());
            interfaceLogInfo.setUpdateBy(interfaceLogInfo.getElsAccount());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"log_info_id", (Object)interfaceLogInfo.getLogInfoId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getOutputParameter()})) {
                if (dbData.getResendNumber() == null) {
                    interfaceLogInfo.setResendNumber(0);
                } else {
                    interfaceLogInfo.setLastResendTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    interfaceLogInfo.setResendNumber(dbData.getResendNumber() + 1);
                }
            }
            ((InterfaceLogInfoMapper)this.baseMapper).update((Object)interfaceLogInfo, (Wrapper)updateWrapper);
        } else {
            interfaceLogInfo.setCreateBy(interfaceLogInfo.getElsAccount());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{interfaceLogInfo.getOutputParameter()})) {
                interfaceLogInfo.setResendNumber(0);
            }
            ((InterfaceLogInfoMapper)this.baseMapper).insert((Object)interfaceLogInfo);
        }
    }

    @Override
    public InterfaceDbLogInfo queryByLogInfoId(String logInfoId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"log_info_id", (Object)logInfoId);
        InterfaceDbLogInfo dbData = (InterfaceDbLogInfo)((Object)((InterfaceLogInfoMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (dbData != null) {
            InterfaceInput interFaceInput = this.interfaceMongoLogService.getInterFaceInput(logInfoId);
            InterfaceOutput interFaceOutput = this.interfaceMongoLogService.getInterFaceOutput(logInfoId);
            InterfaceActualInput interfaceActualInput = this.interfaceMongoLogService.getInterfaceActualInput(logInfoId);
            InterfaceActualOutput interfaceActualOutput = this.interfaceMongoLogService.getInterfaceActualOutput(logInfoId);
            dbData.setInputParameter(interFaceInput == null ? null : interFaceInput.getValue());
            dbData.setActInputParameter(interfaceActualInput == null ? null : interfaceActualInput.getValue());
            dbData.setOutputParameter(interFaceOutput == null ? null : interFaceOutput.getValue());
            dbData.setActOutputParameter(interfaceActualOutput == null ? null : interfaceActualOutput.getValue());
        }
        return dbData;
    }

    @Override
    public void edit(InterfaceDbLogInfo interfaceLogInfo) {
        int count = ((InterfaceLogInfoMapper)this.baseMapper).updateById((Object)interfaceLogInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((InterfaceLogInfoMapper)this.baseMapper).deleteById(id);
    }

    @Override
    public void deleteBatch(List<String> idList) {
        this.interfaceLogInfoMapper.deleteBatchByIds(idList);
    }

    @Override
    public void deleteById(String id) {
        ((InterfaceLogInfoMapper)this.baseMapper).deleteById(id);
    }
}

