/*
 * Decompiled with CFR 0.152.
 */
package com.els.aspect;

import com.els.annotation.InterfaceEnhance;
import com.els.common.BaseVO;
import com.els.dao.ChangeLogMapper;
import com.els.dao.InterfaceEnhanceMapper;
import com.els.enhance.ChangeLogService;
import com.els.enhance.InterfaceEnhanceService;
import com.els.enhance.impl.ChangeLogServiceImpl;
import com.els.enumerate.ResponseCodeEnum;
import com.els.util.SpringContextHelper;
import com.els.vo.InterfaceEnhanceVO;
import com.els.web.filter.ContextFilter;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceEnhanceAspect {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceEnhanceAspect.class);

    public Object doEnhance(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null && method.getAnnotation(InterfaceEnhance.class) != null && ContextFilter.context.get() != null && ((HttpServletRequest)ContextFilter.context.get()).getSession().getAttribute("elsAccount") != null) {
            InterfaceEnhance interfaceEnhance = method.getAnnotation(InterfaceEnhance.class);
            boolean logFlag = false;
            ChangeLogService changeLogService = null;
            Object obj1 = null;
            if (interfaceEnhance.logImpl() != ChangeLogServiceImpl.class) {
                try {
                    logFlag = true;
                    changeLogService = (ChangeLogService)interfaceEnhance.logImpl().newInstance();
                    obj1 = changeLogService.getObject(point.getArgs());
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u53d8\u66f4\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            String elsAccount = ((HttpServletRequest)ContextFilter.context.get()).getSession().getAttribute("elsAccount").toString();
            String className = point.getTarget().getClass().getInterfaces()[0].getName();
            String methodName = method.getName();
            InterfaceEnhanceMapper interfaceEnhanceMapper = (InterfaceEnhanceMapper)SpringContextHelper.getBean((String)"interfaceEnhanceMapper");
            InterfaceEnhanceVO queryVO = new InterfaceEnhanceVO();
            queryVO.setElsAccount(elsAccount);
            queryVO.setInterfaceClass(className);
            queryVO.setInterfaceMethod(methodName);
            List lstVO = interfaceEnhanceMapper.query(queryVO);
            for (InterfaceEnhanceVO enhanceVO : lstVO) {
                if (enhanceVO.getExecutePlace() != 0) continue;
                String preClass = enhanceVO.getEnhanceClass();
                Class<?> preClazz = Class.forName(preClass);
                InterfaceEnhanceService preService = (InterfaceEnhanceService)preClazz.newInstance();
                Response preRes = preService.doEnhance(point.getArgs());
                BaseVO preEntity = (BaseVO)preRes.getEntity();
                if (ResponseCodeEnum.SUCCESS.getValue().equals(preEntity.getStatusCode())) continue;
                return preRes;
            }
            Object res = point.proceed();
            for (InterfaceEnhanceVO enhanceVO : lstVO) {
                if (enhanceVO.getExecutePlace() != 1) continue;
                String afterClass = enhanceVO.getEnhanceClass();
                Class<?> afterClazz = Class.forName(afterClass);
                InterfaceEnhanceService afterService = (InterfaceEnhanceService)afterClazz.newInstance();
                Object[] args = point.getArgs();
                args = ArrayUtils.add((Object[])args, (Object)res);
                res = afterService.doEnhance(args);
            }
            if (logFlag) {
                try {
                    Object obj2 = changeLogService.getObject(point.getArgs());
                    String maker = ((HttpServletRequest)ContextFilter.context.get()).getSession().getAttribute("elsSubAccount") + "_" + ((HttpServletRequest)ContextFilter.context.get()).getSession().getAttribute("username");
                    List lstLog = changeLogService.recordChangeLog(elsAccount, obj1, obj2, interfaceEnhance.logReason(), maker);
                    if (!lstLog.isEmpty()) {
                        ChangeLogMapper changeLogMapper = (ChangeLogMapper)SpringContextHelper.getBean((String)"changeLogMapper");
                        changeLogMapper.insertBatch(lstLog);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8bb0\u5f55\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25\uff1a" + e);
                }
            }
            return res;
        }
        return point.proceed();
    }
}

