/*
 * Decompiled with CFR 0.152.
 */
package com.els.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.SSOToken;
import com.baomidou.kisso.Token;
import com.els.async.SmsAsynTask;
import com.els.common.BaseVO;
import com.els.common.SysProperties;
import com.els.cxf.exception.BusinessException;
import com.els.dao.AccountAgentMapper;
import com.els.dao.AccountAppMapper;
import com.els.dao.AccountMapper;
import com.els.dao.AccountResourceMapper;
import com.els.dao.CommonMapper;
import com.els.dao.ContactInfoMapper;
import com.els.dao.ElsEnterpriseExtendMapper;
import com.els.dao.ElsInvitationRecordMapper;
import com.els.dao.ElsPasswordSecurityMapper;
import com.els.dao.ElsRegisterCodeMapper;
import com.els.dao.ElsSubaccountParamMapper;
import com.els.dao.FriendsMapper;
import com.els.dao.PasswordPolicyMapper;
import com.els.dao.PasswordRecordMapper;
import com.els.dao.RedisClusterDao;
import com.els.dao.RoleAppMapper;
import com.els.dao.RoleResourceMapper;
import com.els.dao.SubAccountRoleMapper;
import com.els.dao.SupplierBusinessInfoMapper;
import com.els.dao.SupplierMainDataMapper;
import com.els.enumerate.PasswordStatusEnum;
import com.els.enumerate.ResponseCodeEnum;
import com.els.enumerate.RoleEnum;
import com.els.message.listener.OnlineUserListener;
import com.els.sap.ldap.LdapAuthService;
import com.els.sap.ldap.LdapAuthServicePortType;
import com.els.service.AccountService;
import com.els.service.DALClientService;
import com.els.service.ElsParamService;
import com.els.service.I18nService;
import com.els.service.InterfaceConfigService;
import com.els.service.MsgService;
import com.els.service.impl.BaseServiceImpl;
import com.els.util.DataFormatUtil;
import com.els.util.EncryptUtil;
import com.els.util.ExportExcel;
import com.els.util.IpUtil;
import com.els.util.RandomUtil;
import com.els.vo.AccountAgentVO;
import com.els.vo.AccountInfoVO;
import com.els.vo.AccountVO;
import com.els.vo.AuditEntityVO;
import com.els.vo.BusinessPartnerVO;
import com.els.vo.ContactInfoVO;
import com.els.vo.ElsEnterpriseExtendVO;
import com.els.vo.ElsInvitationRecordVO;
import com.els.vo.ElsPasswordSecurityVO;
import com.els.vo.ElsRegisterCodeVO;
import com.els.vo.EnterpriseVO;
import com.els.vo.InterfaceParamVO;
import com.els.vo.InterfaceResultVO;
import com.els.vo.PageListVO;
import com.els.vo.PasswordPolicyVO;
import com.els.vo.PasswordRecordVO;
import com.els.vo.SubAccountRoleVO;
import com.els.vo.SubAccountVO;
import com.els.vo.SupplierBusinessInfoVO;
import com.els.vo.SupplierMainDataVO;
import com.els.vo.SystemLogVO;
import com.els.web.filter.ContextFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
extends BaseServiceImpl
implements AccountService {
    private static final Logger logger = LoggerFactory.getLogger(AccountServiceImpl.class);
    private static final String SUB_ACCOUNT_KEY_PREFIX = "key_subAccount#";
    private static final String ALL_SUB_ACCOUNT_KEY = "all_subAccount_key#";
    private static final String ENTERPRISE_KEY_PREFIX = "key_enterprise#";
    private static final String MSG_MODULE = "friend";
    private static final String MSG_TYPE = "requestAddFriend";
    private static final String MSG_URL = "friendVerify.jsp";
    private static final String REG_PHONE_VERI_CODE = "telphone_verify_code#";
    private static final String REG_PHONE_VERI_CODE_PERIOD = "telphone_verify_PERIOD#";
    private static final String ELS_ADMIN_VERIFICATION = "els_admin_verification#";
    private static final String ELS_ADMIN_VERIFICATION_PERIOD = "els_admin_verification_period#";
    private static final String ELS_ADMIN_PERIOD = "ELS_ADMIN_PERIOD#";
    private static String adminPhone;
    private Map<String, EnterpriseVO> cacheMap = new ConcurrentHashMap<String, EnterpriseVO>();
    @Autowired
    private ElsPasswordSecurityMapper elsPasswordSecurityMapper;
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    private ContactInfoMapper contactInfoMapper;
    @Autowired
    private ElsSubaccountParamMapper elsSubAccountParamMapper;
    @Autowired
    private FriendsMapper friendsMapper;
    @Autowired
    @Qualifier(value="msgServiceImpl")
    private MsgService msgService;
    @Autowired
    @Qualifier(value="elsParamServiceImpl")
    private ElsParamService elsParamService;
    @Autowired
    private AccountAgentMapper accountAgentMapper;
    @Autowired
    private SubAccountRoleMapper subAccountRoleMapper;
    @Autowired
    private RoleResourceMapper roleResourceMapper;
    @Autowired
    private RoleAppMapper roleAppMapper;
    @Autowired
    private CommonMapper commonMapper;
    @Autowired
    @Qualifier(value="i18nServiceImpl")
    private I18nService i18nService;
    @Autowired
    private DALClientService DALClientService;
    @Autowired
    private PasswordRecordMapper passwordRecordMapper;
    @Autowired
    private PasswordPolicyMapper passwordPolicyMapper;
    @Autowired
    private ElsRegisterCodeMapper elsRegisterCodeMapper;
    @Autowired
    private SupplierMainDataMapper supplierMainDataMapper;
    private final RedisClusterDao redisDao = new RedisClusterDao();
    @Autowired
    private AccountResourceMapper accountResourceMapper;
    @Resource
    private InterfaceConfigService interfaceConfigService;

    static {
        Properties properties = SysProperties.INSTANCE.getSysProperties();
        adminPhone = properties.getProperty("adminPhone");
    }

    public Response findAccountByNumber(String elsAccountNumber) {
        AccountVO vo = this.accountMapper.findAccountByNumber(elsAccountNumber);
        if (vo != null) {
            return this.getOkResponse((BaseVO)vo);
        }
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_accountDoesNotExist", "No Account found", new Object[0]));
    }

    public static String getDateStr() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    @Transactional(rollbackFor={Exception.class})
    public Response register(SupplierMainDataVO mainVO) {
        try {
            List listFbk20;
            System.out.println("registerMethod");
            EnterpriseVO enterprise = mainVO.getEnterpriseVO();
            String registerCode = mainVO.getElsRegisterCodeVO().getRegisterCode();
            ElsRegisterCodeVO elsRegisterCodeVO = ((ElsRegisterCodeMapper)this.DALClientService.getMapper("540000", ElsRegisterCodeMapper.class)).checkRegisterCode(registerCode);
            if (elsRegisterCodeVO == null) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u975e\u6cd5\u9080\u8bf7\u6ce8\u518c!");
            }
            String eamilTemp = enterprise.getCustomerNotice();
            String message = this.checkRegisterCode(elsRegisterCodeVO, eamilTemp);
            if (message != null) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), message);
            }
            mainVO.setFbk1(null);
            if (StringUtils.isBlank((String)mainVO.getToElsAccount())) {
                EnterpriseVO queryVO = new EnterpriseVO();
                queryVO.setFullName(StringUtils.deleteWhitespace((String)mainVO.getEnterpriseVO().getFullName()));
                List lstEnterprise = this.accountMapper.findElsAccountList(queryVO);
                if (!lstEnterprise.isEmpty()) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u8be5\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u7ecf\u6ce8\u518c");
                }
            }
            if ((listFbk20 = ((SupplierMainDataMapper)this.DALClientService.getMapper("540000", SupplierMainDataMapper.class)).checkFbk20(mainVO.getFbk20(), mainVO.getCountryCode())).size() > 0) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u8be5\u56fd\u7684\u7a0e\u52a1\u7801\u5df2\u6ce8\u518c\u8fc7");
            }
            ElsInvitationRecordVO invitation = ((ElsInvitationRecordMapper)this.DALClientService.getMapper("540000", ElsInvitationRecordMapper.class)).selectByRegisterCode(mainVO.getElsRegisterCodeVO().getRegisterCode());
            SubAccountVO subAccountInfo = ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).selectInfoByElsSubAccount(invitation.getElsSubAccount());
            System.out.println(subAccountInfo.getName());
            mainVO.setFbk25(subAccountInfo.getElsSubAccount());
            mainVO.setFbk31(subAccountInfo.getName());
            mainVO.setFbk17(subAccountInfo.getElsSubAccount());
            mainVO.setFbk46(subAccountInfo.getOrganizationCode());
            mainVO.setFbk47(AccountServiceImpl.getDateStr());
            mainVO.setFbk29("1");
            mainVO.setPurchaseFrozen("0");
            mainVO.setElsAccount("540000");
            String toElsAccount = null;
            if (StringUtils.isBlank((String)mainVO.getToElsAccount())) {
                String maxAccount = this.accountMapper.findMaxAccount();
                if (StringUtils.isBlank((String)maxAccount)) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u65e0\u6cd5\u521b\u5efaELS\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458!");
                }
                toElsAccount = String.valueOf(Integer.parseInt(maxAccount));
                mainVO.setFbk48(AccountServiceImpl.getDateStr());
                mainVO.setFbk50(this.getCurrentSubAccount());
                mainVO.setToElsAccount(toElsAccount);
                mainVO.setFbk42("1");
                mainVO.setFbk39("1");
                mainVO.setFbk19("1");
                ((SupplierMainDataMapper)this.DALClientService.getMapper("540000", SupplierMainDataMapper.class)).insert(mainVO);
                enterprise.setElsAccount(toElsAccount);
                enterprise.setFbk38(AccountServiceImpl.getDateStr());
                enterprise.setFbk40(enterprise.getName());
                enterprise.setShortName(enterprise.getFullName());
                enterprise.setLastUpdateDate(new Date());
                enterprise.setCreateDate(new Date());
                ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).insertEnterpriseInfo(enterprise);
                SupplierBusinessInfoVO business = new SupplierBusinessInfoVO();
                business.setElsAccount(toElsAccount);
                business.setCreate_datetime(AccountServiceImpl.getDateStr());
                business.setCreater_user(this.getCurrentSubAccountPrefix());
                ((SupplierBusinessInfoMapper)this.DALClientService.getMapper("540000", SupplierBusinessInfoMapper.class)).insert((Object)business);
            } else {
                toElsAccount = mainVO.getToElsAccount();
                enterprise.setElsAccount(toElsAccount);
                enterprise.setFbk39(AccountServiceImpl.getDateStr());
                enterprise.setFbk41(enterprise.getName());
                enterprise.setShortName(enterprise.getFullName());
                enterprise.setLastUpdateDate(new Date());
                enterprise.setCreateDate(new Date());
                ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).updateByPrimaryKeySelective(enterprise);
                mainVO.setFbk28(enterprise.getName());
                mainVO.setFbk49(AccountServiceImpl.getDateStr());
                ((SupplierMainDataMapper)this.DALClientService.getMapper("540000", SupplierMainDataMapper.class)).updateMainInfo(mainVO);
            }
            String maxSubAccount = ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).findNextSubAccount(toElsAccount);
            if (maxSubAccount == null || maxSubAccount == "1") {
                maxSubAccount = "1001";
            }
            SubAccountVO subAccountVO = new SubAccountVO();
            subAccountVO.setElsAccount(toElsAccount);
            subAccountVO.setElsSubAccount(maxSubAccount);
            Properties config = SysProperties.INSTANCE.getProperties("sysconfig.properties");
            String password = config.getProperty("password");
            subAccountVO.setElsSubAccountPassword(password);
            subAccountVO.setFrozenFlag("Y");
            subAccountVO.setName(enterprise.getName());
            subAccountVO.setEmail(enterprise.getCustomerNotice());
            subAccountVO.setCreateDate(new Date());
            subAccountVO.setCreateUser(enterprise.getName());
            subAccountVO.setLastUpdateDate(new Date());
            subAccountVO.setCreateUser(enterprise.getName());
            subAccountVO.setStation("sale");
            subAccountVO.setIsAdmin("Y");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
            Date myDate1 = dateFormat1.parse("2099-12-31");
            subAccountVO.setAccountValidityDate(myDate1);
            ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).insertSubAccount(subAccountVO);
            ElsRegisterCodeVO registerCodeVO = mainVO.getElsRegisterCodeVO();
            ((ElsRegisterCodeMapper)this.DALClientService.getMapper("540000", ElsRegisterCodeMapper.class)).updateCodeStatus(registerCodeVO.getRegisterCode());
            this.createUserIDMRegister(toElsAccount, enterprise.getFullName(), enterprise.getName(), enterprise.getCustomerNotice(), subAccountInfo.getName(), subAccountInfo.getEmail());
            subAccountVO.setStatusCode("200");
            return Response.ok((Object)subAccountVO).build();
        }
        catch (Exception e) {
            logger.error("\u6ce8\u518c\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6ce8\u518c\u5931\u8d25!");
        }
    }

    public String checkRegisterCode(ElsRegisterCodeVO elsRegisterCodeVO, String eamilTemp) {
        List querySubAccountByEmail = this.accountMapper.querySubAccountByEmail(eamilTemp);
        int hours = (int)((System.currentTimeMillis() - elsRegisterCodeVO.getCreateTime().getTime()) / 3600000L);
        String message = null;
        if (hours > 72) {
            message = "\u6ce8\u518c\u94fe\u63a5\u5df2\u5931\u6548!";
        } else if (elsRegisterCodeVO.getCodeStatus() != null && elsRegisterCodeVO.getCodeStatus() == 2) {
            message = "\u8be5\u94fe\u63a5\u5df2\u6ce8\u518c\uff0c\u4e0d\u80fd\u518d\u6b21\u6ce8\u518c!";
        } else if (!querySubAccountByEmail.isEmpty()) {
            message = "\u6ce8\u518c\u90ae\u7bb1\u5df2\u5b58\u5728\uff0c\u6ce8\u518c\u5931\u8d25!";
        }
        return message;
    }

    public Response login(final SubAccountVO subAccountVO) {
        SubAccountVO acountTemp = this.accountMapper.findLoginSubAccountByEmail(subAccountVO);
        if (acountTemp == null) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", new Object[0]));
        }
        if ("540000".equals(acountTemp.getElsAccount())) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("", "\u91c7\u8d2d\u65b9\u4e0d\u5141\u8bb8\u901a\u8fc7\u8be5\u767b\u5f55\u5730\u5740\u8fdb\u884c\u767b\u5f55", new Object[0]));
        }
        try {
            String frozenFlag;
            String fbk39;
            SupplierMainDataVO recond;
            if (this.redisDao.getList("key_onlineElsAccountList#") != null) {
                this.redisDao.getList("key_onlineElsAccountList#").contains(String.valueOf(acountTemp.getElsAccount()) + "_" + acountTemp.getElsSubAccount());
            }
            final SubAccountVO acount = this.accountMapper.findLoginSubAccount(acountTemp);
            SupplierMainDataVO supplierMainDataVO = new SupplierMainDataVO();
            supplierMainDataVO.setElsAccount("540000");
            if (StringUtils.isNotBlank((String)acount.getElsAccount())) {
                supplierMainDataVO.setToElsAccount(acount.getElsAccount());
            }
            if ((recond = this.supplierMainDataMapper.selectByPrimaryKey(supplierMainDataVO)) != null && "0".equals(fbk39 = recond.getFbk39())) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("", "\u8be5\u4f9b\u5e94\u5546\u88ab\u51bb\u7ed3\uff0c\u4e0d\u53ef\u767b\u5165\uff0c\u8bf7\u8054\u7cfb\u8d1f\u8d23\u7684\u91c7\u8d2d\u4eba\u5458\u3002", new Object[0]));
            }
            if (acount == null) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef.", new Object[0]));
            }
            String loginType = subAccountVO.getLoginType();
            HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
            if (loginType == null || !loginType.equals("auto")) {
                if (request.getSession().getAttribute("rand") == null) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_VerificationCodeOverTime", "\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f.", new Object[0]));
                }
                String identifyCode = (String)request.getSession().getAttribute("rand");
                if (!identifyCode.equalsIgnoreCase(subAccountVO.getIdentifyCode())) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef.", new Object[0]));
                }
            }
            String unionId = acountTemp.getUnionId();
            System.out.println(String.valueOf(acountTemp.getEmail()) + "_unionId:" + unionId);
            if (!"1".equals(unionId)) {
                String username = acount.getEmail();
                String subPassword = subAccountVO.getElsSubAccountPassword();
                String wsUrl = SysProperties.INSTANCE.getSysProperties().getProperty("lhdz.sap.idm.URL");
                Properties config = SysProperties.INSTANCE.getProperties("sysconfig.properties");
                String LdapAuthServiceWSDL = config.getProperty("IDM.LdapAuthServiceWSDL");
                String wsdlPath1 = AccountServiceImpl.class.getResource("/").getFile();
                String wsdlPath = "file:" + wsdlPath1 + "wsdl/" + LdapAuthServiceWSDL;
                System.out.println("WSDLPath:" + wsdlPath);
                URL url = null;
                try {
                    url = new URL(wsdlPath);
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage());
                }
                LdapAuthService ldapAuthService = new LdapAuthService(url);
                String adminname = config.getProperty("adminname");
                String adminpwd = config.getProperty("adminpwd");
                System.out.println("\u4f9b\u5e94\u5546\u767b\u5165\u8d26\u53f7\uff1a" + username);
                LdapAuthServicePortType endpoint = ldapAuthService.getLdapAuthServiceHttpSoap11Endpoint();
                String validate = endpoint.validate(adminname, adminpwd, username, subPassword);
                System.out.println("IDM\u9a8c\u8bc1\u51fa\u53c2\uff1a" + validate);
                JSONObject object = JSONObject.parseObject((String)validate);
                String result = object.getString("result");
                if ("lockedAccount".equals(result)) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_js_els_locked", "\u4f60\u7684\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a(IDM\u7cfb\u7edf\u9a8c\u8bc1)", new Object[0]));
                }
                if (!"true".equals(result)) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef(IDM\u7cfb\u7edf\u9a8c\u8bc1)", new Object[0]));
                }
            } else {
                String password2;
                String password = EncryptUtil.md5((String)subAccountVO.getElsSubAccountPassword());
                if (!password.equals(password2 = acount.getElsSubAccountPassword())) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", new Object[0]));
                }
            }
            if ("Y".equals(frozenFlag = acount.getFrozenFlag())) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_alert_accountIsFrozen", "\u60a8\u7684\u8d26\u6237\u5df2\u7ecf\u88ab\u51bb\u7ed3\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", new Object[0]));
            }
            Date accountValidityDate = acount.getAccountValidityDate();
            Date timeDate = new Date();
            if (accountValidityDate == null || timeDate.getTime() > accountValidityDate.getTime()) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_alert_outValidityDate", "\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", new Object[0]));
            }
            request.getSession().invalidate();
            request.getCookies()[0].setMaxAge(0);
            request.getSession(true);
            try {
                HttpServletResponse response = (HttpServletResponse)ContextFilter.responseContext.get();
                SSOToken st = new SSOToken(request, String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount());
                SSOHelper.setSSOCookie((HttpServletRequest)request, (HttpServletResponse)response, (Token)st, (boolean)true);
                SSOToken token = (SSOToken)SSOHelper.getToken((HttpServletRequest)request);
                logger.info("token=" + token);
            }
            catch (Exception e) {
                logger.info("SSOToken exception" + e.getMessage());
            }
            request.getSession().setAttribute("elsAccount", (Object)acount.getElsAccount());
            request.getSession().setAttribute("elsSubAccount", (Object)acount.getElsSubAccount());
            request.getSession().setAttribute("username", (Object)acount.getName());
            request.getSession().setAttribute("role", (Object)acount.getStation());
            request.getSession().setAttribute("isAdmin", (Object)acount.getIsAdmin());
            request.getSession().setAttribute("logo", (Object)acount.getLogo());
            request.getSession().setAttribute("employeeNumber", (Object)acount.getEmployeeNumber());
            request.getSession().setAttribute("nickname", (Object)acount.getNickname());
            request.getSession().setAttribute("wxAccount", (Object)acount.getWxAccount());
            request.getSession().setAttribute("qqAccount", (Object)acount.getQqAccount());
            request.getSession().setAttribute("roleName", (Object)acount.getRoleName());
            request.getSession().setAttribute("email", (Object)acount.getEmail());
            request.getSession().setAttribute("userID", (Object)acount.getMaterialCate());
            String userRole = this.accountMapper.getUserRoleCode(acount.getElsAccount(), acount.getElsSubAccount());
            request.getSession().setAttribute("userRole", (Object)userRole);
            String toElsAccount = this.friendsMapper.getFriendElsAccount(acount.getElsAccount(), acount.getElsSubAccount());
            request.getSession().setAttribute("toElsAccount", (Object)toElsAccount);
            EnterpriseVO enterpriseVO = this.accountMapper.findEnterpriseByNumber(acount.getElsAccount());
            if (enterpriseVO != null) {
                request.getSession().setAttribute("fullName", (Object)enterpriseVO.getFullName());
                request.getSession().setAttribute("companyShortName", (Object)enterpriseVO.getShortName());
                logger.info(String.valueOf(enterpriseVO.getShortName()) + "login in!");
            }
            if (!"1".equals(unionId)) {
                this.removeLoginUser(String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount(), request);
            }
            final String language = subAccountVO.getLanguage();
            this.i18nService.setLanguage(language);
            this.elsParamService.setSessionParam();
            this.redisDao.del("key_dataRule#" + acount.getElsAccount() + "$" + acount.getElsSubAccount());
            logger.info("redis \u8bb0\u5f55\u767b\u5f55\u7528\u62371");
            final String ip = IpUtil.getIpAddr((HttpServletRequest)request);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!AccountServiceImpl.this.redisDao.getList("key_onlineUserList#").contains(acount.getName())) {
                        AccountServiceImpl.this.redisDao.lpush("key_onlineUserList#", acount.getName());
                    }
                    if (!AccountServiceImpl.this.redisDao.getList("key_onlineElsAccountList#").contains(String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount())) {
                        AccountServiceImpl.this.redisDao.lpush("key_onlineElsAccountList#", String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount());
                    }
                    logger.info("redis \u8bb0\u5f55\u767b\u5f55\u7528\u62372");
                    SystemLogVO logVO = new SystemLogVO();
                    logVO.setElsAccount(acount.getElsAccount());
                    logVO.setElsSubAccount(String.valueOf(acount.getElsSubAccount()) + "_" + acount.getName());
                    logVO.setOperation("login");
                    logVO.setModule("login");
                    logVO.setDescription("\u767b\u9646\u7cfb\u7edf");
                    logVO.setClientIP(ip);
                    logVO.setLogtime(new Date());
                    logVO.setClientOs(subAccountVO.getClientOs());
                    logVO.setClientType(subAccountVO.getClientType());
                    logVO.setBrowser(subAccountVO.getBrowser());
                    logVO.setLanguage(language);
                    AccountServiceImpl.this.setIpAdress(ip, logVO);
                    AccountServiceImpl.this.log(logVO);
                }
            }).start();
            logger.info(String.valueOf(acount.getName()) + "\u4e0a\u7ebf\u4e86");
            return this.getOkResponse((BaseVO)subAccountVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.info("\u767b\u5f55\u9519\u8bef:" + e.getMessage());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("elsAccount", subAccountVO.getElsAccount());
            map.put("exception", String.valueOf(this.getI18n("i18n_account_error_loginError", "\u767b\u5f55\u51fa\u9519:", new Object[0])) + e.getMessage());
            this.sendSms("ELS_LOGIN_SMS_TEMPLATE", map);
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_loginError", "\u767b\u5f55\u51fa\u9519:", new Object[0]));
        }
    }

    private void removeLoginUser(String user, HttpServletRequest request) {
        if (OnlineUserListener.getSessionmap().containsKey(user)) {
            HttpSession session = (HttpSession)OnlineUserListener.getSessionmap().get(user);
            System.out.println("--\u6dfb\u52a0removesessionid---" + session.getId());
            OnlineUserListener.getRemovesessionidmap().put(session.getId(), "true");
        }
        OnlineUserListener.getSessionmap().put(user, request.getSession());
    }

    public Response loginLD(final SubAccountVO subAccountVO) {
        String materialCate = subAccountVO.getMaterialCate();
        if (materialCate == null || "".equals(materialCate)) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("", "UserID\u4e3a\u7a7a", new Object[0]));
        }
        try {
            String frozenFlag;
            String unionId;
            final SubAccountVO acount = this.accountMapper.findSubaccountByUserId(subAccountVO);
            if (acount == null) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01", new Object[0]));
            }
            if (this.redisDao.getList("key_onlineElsAccountList#") != null) {
                this.redisDao.getList("key_onlineElsAccountList#").contains(String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount());
            }
            if (!"1".equals(unionId = acount.getUnionId())) {
                System.out.println("IDM\u63a5\u53e3\u8ba4\u8bc1\u767b\u5f55");
                String username = acount.getMaterialCate();
                String subPassword = subAccountVO.getElsSubAccountPassword();
                System.out.println("\u8d26\u53f7\uff1a" + username);
                Properties config = SysProperties.INSTANCE.getProperties("sysconfig.properties");
                String LdapAuthServiceWSDL = config.getProperty("IDM.LdapAuthServiceWSDL");
                String wsdlPath1 = AccountServiceImpl.class.getResource("/").getFile();
                String wsdlPath = "file:" + wsdlPath1 + "wsdl/" + LdapAuthServiceWSDL;
                URL url = null;
                try {
                    url = new URL(wsdlPath);
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage());
                }
                LdapAuthService ldapAuthService = new LdapAuthService(url);
                String adminname = config.getProperty("adminname");
                String adminpwd = config.getProperty("adminpwd");
                LdapAuthServicePortType endpoint = ldapAuthService.getLdapAuthServiceHttpSoap11Endpoint();
                String validate = endpoint.validate(adminname, adminpwd, username, subPassword);
                System.out.println("\u51fa\u53c2:" + validate);
                JSONObject object = JSONObject.parseObject((String)validate);
                String result = object.getString("result");
                if ("lockedAccount".equals(result)) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_js_els_locked", "\u4f60\u7684\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a(IDM\u7cfb\u7edf\u9a8c\u8bc1)", new Object[0]));
                }
                if (!"true".equals(result)) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef(IDM\u7cfb\u7edf\u9a8c\u8bc1\uff09", new Object[0]));
                }
            } else {
                System.out.println("ipur\u7cfb\u7edf\u8d26\u5bc6\u9a8c\u8bc1");
                String password = EncryptUtil.md5((String)subAccountVO.getElsSubAccountPassword());
                String password2 = acount.getElsSubAccountPassword();
                if (!password.equals(password2)) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alertMsg_usernameOrPasswordWrong", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef!", new Object[0]));
                }
            }
            String loginType = subAccountVO.getLoginType();
            HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
            String defaultLanguage = "";
            if (loginType == null || !loginType.equals("auto")) {
                defaultLanguage = this.getCurrentLanguage();
                if (defaultLanguage == null || "".equals(defaultLanguage)) {
                    defaultLanguage = "zh_cn";
                }
            } else {
                defaultLanguage = subAccountVO.getLanguage();
            }
            if ("Y".equals(frozenFlag = acount.getFrozenFlag())) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_alert_accountIsFrozen", "\u60a8\u7684\u8d26\u6237\u5df2\u7ecf\u88ab\u51bb\u7ed3\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", new Object[0]));
            }
            Date accountValidityDate = acount.getAccountValidityDate();
            Date timeDate = new Date();
            if (accountValidityDate == null || timeDate.getTime() > accountValidityDate.getTime()) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_alert_outValidityDate", "\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", new Object[0]));
            }
            request.getSession().invalidate();
            request.getSession(true);
            try {
                HttpServletResponse response = (HttpServletResponse)ContextFilter.responseContext.get();
                SSOToken st = new SSOToken(request, String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount());
                SSOHelper.setSSOCookie((HttpServletRequest)request, (HttpServletResponse)response, (Token)st, (boolean)true);
                SSOToken token = (SSOToken)SSOHelper.getToken((HttpServletRequest)request);
                logger.info("token=" + token);
            }
            catch (Exception e) {
                logger.info("SSOToken exception" + e.getMessage());
            }
            request.getSession().setAttribute("userID", (Object)acount.getMaterialCate());
            request.getSession().setAttribute("elsAccount", (Object)acount.getElsAccount());
            request.getSession().setAttribute("elsSubAccount", (Object)acount.getElsSubAccount());
            request.getSession().setAttribute("username", (Object)acount.getName());
            request.getSession().setAttribute("role", (Object)acount.getStation());
            request.getSession().setAttribute("isAdmin", (Object)acount.getIsAdmin());
            request.getSession().setAttribute("logo", (Object)acount.getLogo());
            request.getSession().setAttribute("employeeNumber", (Object)acount.getEmployeeNumber());
            request.getSession().setAttribute("nickname", (Object)acount.getNickname());
            request.getSession().setAttribute("wxAccount", (Object)acount.getWxAccount());
            request.getSession().setAttribute("qqAccount", (Object)acount.getQqAccount());
            request.getSession().setAttribute("roleName", (Object)acount.getRoleName());
            request.getSession().setAttribute("email", (Object)acount.getEmail());
            request.getSession().setAttribute("userID", (Object)acount.getMaterialCate());
            String userRole = this.accountMapper.getUserRoleCode(acount.getElsAccount(), acount.getElsSubAccount());
            request.getSession().setAttribute("userRole", (Object)userRole);
            String toElsAccount = this.friendsMapper.getFriendElsAccount(acount.getElsAccount(), acount.getElsSubAccount());
            request.getSession().setAttribute("toElsAccount", (Object)toElsAccount);
            EnterpriseVO enterpriseVO = this.accountMapper.findEnterpriseByNumber(acount.getElsAccount());
            if (enterpriseVO != null) {
                request.getSession().setAttribute("fullName", (Object)enterpriseVO.getFullName());
                request.getSession().setAttribute("companyShortName", (Object)enterpriseVO.getShortName());
                logger.info(String.valueOf(enterpriseVO.getShortName()) + "login in!");
            }
            if (!"1".equals(unionId)) {
                this.removeLoginUser(String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount(), request);
            }
            final String language = defaultLanguage;
            this.i18nService.setLanguage(language);
            this.elsParamService.setSessionParam();
            this.redisDao.del("key_dataRule#" + acount.getElsAccount() + "$" + acount.getElsSubAccount());
            logger.info("redis \u8bb0\u5f55\u767b\u5f55\u7528\u62371");
            final String ip = IpUtil.getIpAddr((HttpServletRequest)request);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!AccountServiceImpl.this.redisDao.getList("key_onlineUserList#").contains(acount.getName())) {
                        AccountServiceImpl.this.redisDao.lpush("key_onlineUserList#", acount.getName());
                    }
                    if (!AccountServiceImpl.this.redisDao.getList("key_onlineElsAccountList#").contains(String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount())) {
                        AccountServiceImpl.this.redisDao.lpush("key_onlineElsAccountList#", String.valueOf(acount.getElsAccount()) + "_" + acount.getElsSubAccount());
                    }
                    logger.info("redis \u8bb0\u5f55\u767b\u5f55\u7528\u62372");
                    if (!"1".equals(acount.getUnionId())) {
                        SystemLogVO logVO = new SystemLogVO();
                        logVO.setElsAccount(acount.getElsAccount());
                        logVO.setElsSubAccount(String.valueOf(acount.getElsSubAccount()) + "_" + acount.getName());
                        logVO.setOperation("login");
                        logVO.setModule("login");
                        logVO.setDescription("\u767b\u9646\u7cfb\u7edf");
                        logVO.setClientIP(ip);
                        logVO.setLogtime(new Date());
                        logVO.setClientOs(subAccountVO.getClientOs());
                        logVO.setClientType(subAccountVO.getClientType());
                        logVO.setBrowser(subAccountVO.getBrowser());
                        logVO.setLanguage(language);
                        AccountServiceImpl.this.setIpAdress(ip, logVO);
                        AccountServiceImpl.this.log(logVO);
                    }
                }
            }).start();
            logger.info(String.valueOf(acount.getName()) + "\u4e0a\u7ebf\u4e86");
            return this.getOkResponse((BaseVO)subAccountVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.info("\u767b\u5f55\u9519\u8bef:" + e.getMessage());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("elsAccount", subAccountVO.getElsAccount());
            map.put("exception", String.valueOf(this.getI18n("i18n_account_error_loginError", "\u767b\u5f55\u51fa\u9519:", new Object[0])) + e.getMessage());
            this.sendSms("ELS_LOGIN_SMS_TEMPLATE", map);
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_loginError", "\u767b\u5f55\u51fa\u9519:", new Object[0]));
        }
    }

    private void setIpAdress(String ip, SystemLogVO logVO) {
        Map addressMap = IpUtil.getLocationFromIp((String)ip);
        logVO.setCountry((String)addressMap.get("country"));
        logVO.setRegion((String)addressMap.get("region"));
        logVO.setCity((String)addressMap.get("city"));
    }

    public PageListVO findEnterpriseByCondition(EnterpriseVO enterpriseVO) {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        String elsAccount = request.getSession().getAttribute("elsAccount").toString();
        EnterpriseVO enterprise = this.accountMapper.findEnterpriseByNumber(elsAccount);
        if ("sale".equals(enterprise.getFbk1())) {
            enterpriseVO.setFbk1("purchase");
        }
        PageListVO pageListVO = new PageListVO();
        int total = this.accountMapper.findEnterpriseByConditionCount(enterpriseVO);
        pageListVO.setTotal(total);
        pageListVO.setRows(this.accountMapper.findEnterpriseByCondition(enterpriseVO));
        return pageListVO;
    }

    public int findEnterpriseByConditionCount(EnterpriseVO enterpriseVO) {
        return this.accountMapper.findEnterpriseByConditionCount(enterpriseVO);
    }

    public Response findSubAccountByAll(SubAccountVO subAccountVO) {
        PageListVO pageListVO = new PageListVO();
        int count = this.accountMapper.findSubAccountByAllCount(subAccountVO);
        if (count > 0) {
            List rows = this.accountMapper.findSubAccountByAll(subAccountVO);
            pageListVO.setRows(rows);
            pageListVO.setTotal(count);
        }
        return Response.ok((Object)pageListVO).build();
    }

    public Response findSubAccountList(SubAccountVO subAccountVO) {
        if (subAccountVO.getElsSubAccount() != null && subAccountVO.getElsSubAccount().equals("")) {
            subAccountVO.setElsSubAccount(null);
        }
        List rows = this.accountMapper.findSubAccountByNumber(subAccountVO);
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(rows);
        pageListVO.setTotal(this.accountMapper.findSubAccountByNumberCount(subAccountVO));
        return Response.ok((Object)pageListVO).build();
    }

    public Response getSubAccountList(SubAccountVO subAccountVO) {
        List rows = this.accountMapper.getSubAccountList(subAccountVO);
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(rows);
        pageListVO.setTotal(rows.size());
        return Response.ok((Object)pageListVO).build();
    }

    public Response findBusinessPartner(BusinessPartnerVO businessPartnerVO) {
        List rows = new ArrayList();
        try {
            rows = this.accountMapper.findBusinessPartnerByNumber(businessPartnerVO);
            PageListVO pageListVO = new PageListVO();
            pageListVO.setRows(rows);
            pageListVO.setTotal(this.accountMapper.findBusinessPartnerNumberCount(businessPartnerVO));
            return Response.ok((Object)pageListVO).build();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.info("\u67e5\u627eels\u8d26\u53f7\u4e1a\u52a1\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            throw new RuntimeException("\u67e5\u627eels\u8d26\u53f7\u4e1a\u52a1\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
    }

    public List<SubAccountVO> findSubAccountList(String elsAccount) {
        String key = SUB_ACCOUNT_KEY_PREFIX + elsAccount;
        List list = this.redisDao.getObjectList(key);
        if (list != null && list.size() > 0) {
            logger.info("\u4ece\u7f13\u5b58\u83b7\u53d6subAccountVO list");
            return list;
        }
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount(elsAccount);
        List rows = this.accountMapper.findSubAccountByNumber(subAccountVO);
        this.redisDao.setObjectList(key, rows);
        return rows;
    }

    public List<SubAccountVO> findSubAccountListByElsAccount(String elsAccount) {
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount(elsAccount);
        List rows = this.accountMapper.findSubAccountByNumber(subAccountVO);
        return rows;
    }

    public Response findMyFriendSubAccountList(String MyElsAccount, String MyElsSubAccount, String MyRole, String friendElsAccount) {
        return null;
    }

    @Transactional
    public Response createSubaccount(SubAccountVO subAccountVO) {
        String result;
        try {
            int count;
            String elsAccount = this.getLoginElsAccount();
            SubAccountVO sVo = new SubAccountVO();
            sVo.setElsAccount(elsAccount);
            if (!elsAccount.equals("540000") && (count = ((AccountMapper)this.DALClientService.getMapper(elsAccount, AccountMapper.class)).findSubaccountByCount(sVo)) >= 10) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("", "\u4f9b\u5e94\u5546\u89d2\u8272\u53ea\u80fd\u521b\u5efa10\u4f4d\uff01", new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u5224\u65ad\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
        }
        if (RoleEnum.SALE.getValue().equals(this.getCurrentRole()) && RoleEnum.PURCHASE.getValue().equals(subAccountVO.getStation())) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_cannot_build_new_purchase", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u65b0\u5efa\u91c7\u8d2d\u89d2\u8272", new Object[0]));
        }
        Response response = this.verifySubAccount(subAccountVO);
        if (response.getEntity() instanceof String && !(result = (String)response.getEntity()).equals("")) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), String.valueOf(result) + this.getI18n("i18n_account_alert_isExisting", "\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8f93\u5165", new Object[0]));
        }
        String elsSubAccount = this.accountMapper.findNextSubAccount(subAccountVO.getElsAccount());
        subAccountVO.setElsSubAccount(elsSubAccount);
        subAccountVO.setElsSubAccountPassword(EncryptUtil.md5((String)"uaes,123"));
        subAccountVO.setCreateDate(new Date());
        subAccountVO.setCreateUser(this.getCreateUser() != null ? this.getCreateUser() : "");
        subAccountVO.setLastUpdateDate(new Date());
        subAccountVO.setLastUpdateUser(this.getCreateUser() != null ? this.getCreateUser() : "");
        SubAccountVO subVo = this.accountMapper.selectSubAccountPrimaryKey(subAccountVO.getElsAccount(), "1001");
        long time = subVo.getAccountValidityDate().getTime() - 604800L;
        subAccountVO.setAccountValidityDate(new Date(time));
        SubAccountRoleVO subAccountRoleVO = new SubAccountRoleVO();
        subAccountRoleVO.setElsAccount(subAccountVO.getElsAccount());
        subAccountRoleVO.setElsSubAccount(elsSubAccount);
        subAccountRoleVO.setRoleCode(subAccountVO.getStation());
        ArrayList<SubAccountRoleVO> lstData = new ArrayList<SubAccountRoleVO>();
        lstData.add(subAccountRoleVO);
        try {
            String validatorResult = this.getValidatorResult(subAccountVO);
            if (!StringUtils.isEmpty((String)validatorResult)) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), validatorResult);
            }
            if (!"540000".equals(subAccountVO.getElsAccount())) {
                subAccountVO.setFrozenFlag("Y");
            } else {
                subAccountVO.setFrozenFlag("N");
            }
            String serviceUrl = this.findServiceURL(subAccountVO.getElsAccount());
            if (serviceUrl == null) {
                this.accountMapper.insertSubAccount(subAccountVO);
                this.subAccountRoleMapper.batchInsert(lstData);
            } else {
                try {
                    ((AccountMapper)this.DALClientService.getRemoteMapper(serviceUrl, AccountMapper.class)).insertSubAccount(subAccountVO);
                    ((SubAccountRoleMapper)this.DALClientService.getRemoteMapper(serviceUrl, SubAccountRoleMapper.class)).batchInsert(lstData);
                }
                catch (Exception e) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_common_error_systemError", "System error!", new Object[0]));
                }
                this.accountMapper.insertSubAccount(subAccountVO);
                this.subAccountRoleMapper.batchInsert(lstData);
            }
            if (!"540000".equals(subAccountVO.getElsAccount())) {
                SubAccountVO sub = this.accountMapper.selectByMainFbk17(subAccountVO.getElsAccount());
                String inviteName = sub.getName();
                String email = sub.getEmail();
                logger.info("\u65b0\u589e\u4f9b\u5e94\u5546\u8d26\u53f7inviteName:" + inviteName);
                logger.info("\u65b0\u589e\u4f9b\u5e94\u5546\u8d26\u53f7email:" + email);
                this.createUserIDMRegister(subAccountVO.getElsAccount(), this.getCreateCompanyShortName(), subAccountVO.getName(), subAccountVO.getEmail(), inviteName, email);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.info("\u521b\u5efa\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
            throw new RuntimeException("\u521b\u5efa\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
        }
        this.redisDao.del(SUB_ACCOUNT_KEY_PREFIX + subAccountVO.getElsAccount());
        this.redisDao.del(ALL_SUB_ACCOUNT_KEY + subAccountVO.getElsAccount());
        return this.getOkResponse((BaseVO)subAccountVO);
    }

    @Transactional
    public Response updateSubaccount(SubAccountVO subAccountVO) {
        String key;
        block19: {
            key = SUB_ACCOUNT_KEY_PREFIX + subAccountVO.getElsAccount() + "$" + subAccountVO.getElsSubAccount();
            try {
                String email = ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).getEmail(subAccountVO.getElsAccount(), subAccountVO.getElsSubAccount());
                if (!email.equals(subAccountVO.getEmail())) {
                    List querySubAccountByEmail = this.accountMapper.querySubAccountByEmail(subAccountVO.getEmail());
                    if (querySubAccountByEmail != null && querySubAccountByEmail.size() > 0) {
                        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u6ce8\u518c\u90ae\u7bb1\u5df2\u5b58\u5728\uff0c\u6ce8\u518c\u5931\u8d25!");
                    }
                    subAccountVO.setFrozenFlag("Y");
                    HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
                    Object obj = request.getSession().getAttribute("username");
                    String loginUser = String.valueOf(obj);
                    String string = this.createUserIDMRegister(subAccountVO.getElsAccount(), this.getCreateCompanyShortName(), subAccountVO.getName(), subAccountVO.getEmail(), loginUser, this.getEmail());
                }
                subAccountVO.setLastUpdateDate(new Date());
                subAccountVO.setLastUpdateUser(this.getCreateUser());
                SubAccountRoleVO subAccountRoleVO = new SubAccountRoleVO();
                subAccountRoleVO.setElsAccount(subAccountVO.getElsAccount());
                subAccountRoleVO.setElsSubAccount(subAccountVO.getElsSubAccount());
                subAccountRoleVO.setRoleCode(subAccountVO.getStation());
                String serviceUrl = this.findServiceURL(subAccountVO.getElsAccount());
                if (serviceUrl == null) {
                    this.accountMapper.updateSubAccount(subAccountVO);
                    if (!StringUtils.isEmpty((String)subAccountRoleVO.getRoleCode())) {
                        this.subAccountRoleMapper.updateSubAccountRole(subAccountRoleVO);
                    }
                    break block19;
                }
                try {
                    ((AccountMapper)this.DALClientService.getRemoteMapper(serviceUrl, AccountMapper.class)).updateSubAccount(subAccountVO);
                    if (!StringUtils.isEmpty((String)subAccountRoleVO.getRoleCode())) {
                        ((SubAccountRoleMapper)this.DALClientService.getRemoteMapper(serviceUrl, SubAccountRoleMapper.class)).updateSubAccountRole(subAccountRoleVO);
                    }
                }
                catch (Exception e) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_common_error_systemError", "System error!", new Object[0]));
                }
                this.accountMapper.updateSubAccount(subAccountVO);
                if (!StringUtils.isEmpty((String)subAccountRoleVO.getRoleCode())) {
                    this.subAccountRoleMapper.updateSubAccountRole(subAccountRoleVO);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.info("\u66f4\u65b0\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
                throw new RuntimeException("\u66f4\u65b0\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
            }
        }
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        String elsSubAccount = (String)request.getSession().getAttribute("elsSubAccount");
        if (subAccountVO.getElsSubAccount() != null && subAccountVO.getElsSubAccount().equals(elsSubAccount)) {
            if (subAccountVO.getName() != null) {
                request.getSession().setAttribute("username", (Object)subAccountVO.getName());
            }
            if (subAccountVO.getStation() != null) {
                request.getSession().setAttribute("role", (Object)subAccountVO.getStation());
            }
            if (subAccountVO.getIsAdmin() != null) {
                request.getSession().setAttribute("isAdmin", (Object)subAccountVO.getIsAdmin());
            }
            if (subAccountVO.getLogo() != null) {
                request.getSession().setAttribute("logo", (Object)subAccountVO.getLogo());
            }
            if (subAccountVO.getEmployeeNumber() != null) {
                request.getSession().setAttribute("employeeNumber", (Object)subAccountVO.getEmployeeNumber());
            }
            if (subAccountVO.getNickname() != null) {
                request.getSession().setAttribute("nickname", (Object)subAccountVO.getNickname());
            }
            if (subAccountVO.getWxAccount() != null) {
                request.getSession().setAttribute("wxAccount", (Object)subAccountVO.getWxAccount());
            }
            if (subAccountVO.getQqAccount() != null) {
                request.getSession().setAttribute("qqAccount", (Object)subAccountVO.getQqAccount());
            }
        }
        this.redisDao.del(key);
        this.redisDao.del(SUB_ACCOUNT_KEY_PREFIX + subAccountVO.getElsAccount());
        this.redisDao.del(ALL_SUB_ACCOUNT_KEY + subAccountVO.getElsAccount());
        logger.info("\u4ece\u7f13\u5b58\u5220\u9664subAccountVO");
        return this.getOkResponse((BaseVO)subAccountVO);
    }

    @Transactional
    public Response removeSubaccount(String elsAccount, String elsSubAccount) {
        SubAccountVO subAccountVO;
        String key;
        block6: {
            key = SUB_ACCOUNT_KEY_PREFIX + elsAccount + "$" + elsSubAccount;
            subAccountVO = new SubAccountVO();
            subAccountVO.setElsAccount(elsAccount);
            subAccountVO.setElsSubAccount(elsSubAccount);
            String serviceUrl = this.findServiceURL(subAccountVO.getElsAccount());
            SubAccountRoleVO subAccountRoleVO = new SubAccountRoleVO();
            subAccountRoleVO.setElsAccount(elsAccount);
            subAccountRoleVO.setElsSubAccount(elsSubAccount);
            try {
                Response response = this.findSubaccount(elsAccount, elsSubAccount);
                if (response != null && response.getEntity() != null && response.getEntity() instanceof SubAccountVO) {
                    SubAccountVO entity = (SubAccountVO)response.getEntity();
                    ObjectMapper mapper = new ObjectMapper();
                    AuditEntityVO auditEntityVO = new AuditEntityVO();
                    auditEntityVO.setAuditTable("account_audit");
                    auditEntityVO.setBusinessId(elsAccount);
                    auditEntityVO.setBusinessType("Account");
                    auditEntityVO.setElsAccount(elsAccount);
                    auditEntityVO.setElsSubAccount(elsSubAccount);
                    auditEntityVO.setOperationUser(this.getCreateUser());
                    auditEntityVO.setEntity(mapper.writeValueAsString((Object)entity));
                    auditEntityVO.setTableName("els_subaccount_info");
                    auditEntityVO.setVO(SubAccountVO.class.getName());
                    this.commonMapper.insertAuditEntity(auditEntityVO);
                }
                if (serviceUrl == null) {
                    this.accountMapper.setDel(subAccountVO);
                    this.subAccountRoleMapper.batchDelete(subAccountRoleVO);
                    break block6;
                }
                try {
                    ((AccountMapper)this.DALClientService.getRemoteMapper(serviceUrl, AccountMapper.class)).setDel(subAccountVO);
                    ((SubAccountRoleMapper)this.DALClientService.getRemoteMapper(serviceUrl, SubAccountRoleMapper.class)).batchDelete(subAccountRoleVO);
                }
                catch (Exception e) {
                    return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_common_error_systemError", "System error!", new Object[0]));
                }
                this.accountMapper.setDel(subAccountVO);
                this.subAccountRoleMapper.batchDelete(subAccountRoleVO);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.info("\u5220\u9664\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
                throw new RuntimeException("\u5220\u9664\u5b50\u8d26\u53f7\u9519\u8bef:" + e.getMessage());
            }
        }
        this.redisDao.del(key);
        this.redisDao.del(SUB_ACCOUNT_KEY_PREFIX + subAccountVO.getElsAccount());
        this.redisDao.del(ALL_SUB_ACCOUNT_KEY + subAccountVO.getElsAccount());
        logger.info("\u4ece\u7f13\u5b58\u5220\u9664subAccountVO");
        return this.getOkResponse((BaseVO)subAccountVO);
    }

    public Response findMySubaccount() {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        String elsAccount = (String)request.getSession().getAttribute("elsAccount");
        String elsSubAccount = (String)request.getSession().getAttribute("elsSubAccount");
        return this.findSubaccount(elsAccount, elsSubAccount);
    }

    public Response findSubaccount(String elsAccount, String elsSubAccount) {
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount(elsAccount);
        subAccountVO.setElsSubAccount(elsSubAccount);
        List list = null;
        try {
            list = this.accountMapper.findSubAccountByNumber(subAccountVO);
        }
        catch (Exception e) {
            logger.info("\u67e5\u627e\u5b50\u8d26\u53f7\u5f02\u5e38:" + e.getMessage());
            logger.error(e.getMessage());
        }
        if (list != null && list.size() > 0) {
            SubAccountVO vo = (SubAccountVO)list.get(0);
            return this.getOkResponse((BaseVO)vo);
        }
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_sub_not_exit", "\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728!", new Object[0]));
    }

    public Response checkPassword(SubAccountVO subAccountVO) {
        String pwd = subAccountVO.getNewPassword();
        Response req = this.getPasswordSecurity(subAccountVO.getElsAccount());
        ElsPasswordSecurityVO security = (ElsPasswordSecurityVO)req.getEntity();
        String msg = "";
        if (security != null) {
            Pattern p;
            Matcher m;
            if (security.getMinLength() > 0 && pwd.length() < security.getMinLength()) {
                msg = String.valueOf(msg) + this.getI18n("i18n_msg_greater", "\u957f\u5ea6\u5927\u4e8e\u7b49\u4e8e", new Object[0]) + security.getMinLength() + this.getI18n("i18n_label_A", "\u4f4d", new Object[0]);
            }
            if (security.getComplexity().indexOf("num") >= 0 && !(m = (p = Pattern.compile(".*\\d+.*")).matcher(pwd)).matches()) {
                if (StringUtils.isNotBlank((String)msg)) {
                    msg = String.valueOf(msg) + ",";
                }
                msg = String.valueOf(msg) + this.getI18n("i18n_msg_IncludeNumber", "\u5305\u542b\u6570\u5b57", new Object[0]);
            }
            if (security.getComplexity().indexOf("lower") >= 0 && !(m = (p = Pattern.compile(".*[a-z]+.*")).matcher(pwd)).matches()) {
                msg = StringUtils.isNotBlank((String)msg) ? ((msg = String.valueOf(msg) + ",").indexOf("\u5305\u542b") >= 0 ? String.valueOf(msg) + this.getI18n("i18n_label_Numericlowercase", "\u5c0f\u5199\u5b57\u6bcd", new Object[0]) : String.valueOf(msg) + this.getI18n("i18n_msg_includeLowerCase", "\u5305\u542b\u5c0f\u5199\u5b57\u6bcd", new Object[0])) : String.valueOf(msg) + this.getI18n("i18n_msg_includeLowerCase", "\u5305\u542b\u5c0f\u5199\u5b57\u6bcd", new Object[0]);
            }
            if (security.getComplexity().indexOf("upper") >= 0 && !(m = (p = Pattern.compile(".*[A-Z]+.*")).matcher(pwd)).matches()) {
                msg = StringUtils.isNotBlank((String)msg) ? ((msg = String.valueOf(msg) + ",").indexOf("\u5305\u542b") >= 0 ? String.valueOf(msg) + this.getI18n("i18n_label_Thecapitalletters", "\u5927\u5199\u5b57\u6bcd", new Object[0]) : String.valueOf(msg) + this.getI18n("i18n_label_IncludeThecapitalletters", "\u5305\u542b\u5927\u5199\u5b57\u6bcd", new Object[0])) : String.valueOf(msg) + this.getI18n("i18n_label_IncludeThecapitalletters", "\u5305\u542b\u5927\u5199\u5b57\u6bcd", new Object[0]);
            }
            if (security.getComplexity().indexOf("char") >= 0 && !(m = (p = Pattern.compile(".*[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]+.*")).matcher(pwd)).matches()) {
                msg = StringUtils.isNotBlank((String)msg) ? ((msg = String.valueOf(msg) + ",").indexOf("\u5305\u542b") >= 0 ? String.valueOf(msg) + this.getI18n("i18n_label_Specialcharacters", "\u7279\u6b8a\u5b57\u7b26", new Object[0]) : String.valueOf(msg) + this.getI18n("i18n_label_Includespecialcharacters", "\u5305\u542b\u7279\u6b8a\u5b57\u7b26", new Object[0])) : String.valueOf(msg) + this.getI18n("i18n_label_Includespecialcharacters", "\u5305\u542b\u7279\u6b8a\u5b57\u7b26", new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((String)msg)) {
            msg = String.valueOf(this.getI18n("i18n_msg_Passwordmust", "\u5bc6\u7801\u5fc5\u987b", new Object[0])) + msg;
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), msg);
        }
        return Response.ok((Object)new BaseVO()).build();
    }

    @Transactional
    public Response changePassword(SubAccountVO subAccountVO) {
        Response req = this.checkPassword(subAccountVO);
        BaseVO result = (BaseVO)req.getEntity();
        if (ResponseCodeEnum.FAIL.getValue().equals(result.getStatusCode())) {
            return req;
        }
        SubAccountVO account = this.accountMapper.findLoginSubAccount(subAccountVO);
        if (account == null) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_accountDoesNotExist", "No Account found", new Object[0]));
        }
        String pwd = account.getElsSubAccountPassword();
        if (!EncryptUtil.md5((String)subAccountVO.getOldPassword()).equals(pwd)) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_oldPasswordError", "\u65e7\u5bc6\u7801\u9519\u8bef", new Object[0]));
        }
        String newPassword = subAccountVO.getNewPassword();
        if (StringUtils.isEmpty((String)newPassword)) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_newPasswordNotNull", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        subAccountVO.setElsSubAccountPassword(EncryptUtil.md5((String)newPassword));
        String serviceUrl = this.findServiceURL(subAccountVO.getElsAccount());
        if (serviceUrl == null) {
            this.accountMapper.updateSubAccountPassword(subAccountVO);
            this.addPasswordRecord(account, false);
        } else {
            try {
                ((AccountMapper)this.DALClientService.getRemoteMapper(serviceUrl, AccountMapper.class)).updateSubAccountPassword(subAccountVO);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.error(e.getMessage());
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_common_error_systemError", "System error!", new Object[0]));
            }
            this.accountMapper.updateSubAccountPassword(subAccountVO);
            this.addPasswordRecord(account, false);
        }
        return this.getOkResponse((BaseVO)subAccountVO);
    }

    public Response queryPurchaseEnquirySupplyByCondtion(EnterpriseVO epVO) {
        EnterpriseVO enterprise = null;
        try {
            enterprise = this.accountMapper.findEnterpriseByNumber(epVO.getElsAccount());
            if (enterprise == null) {
                enterprise = new EnterpriseVO();
            }
            ContactInfoVO checkInfo = new ContactInfoVO();
            checkInfo.setElsAccount(epVO.getElsAccount());
            ContactInfoVO contactInfo = this.contactInfoMapper.selectByPrimaryKey(checkInfo);
            if (contactInfo == null) {
                contactInfo = new ContactInfoVO();
            }
            String logoURL = enterprise.getLogo();
            Properties sysProperties = SysProperties.INSTANCE.getSysProperties();
            String fileSystemPath = sysProperties.getProperty("fileSystemPath");
            String srcPath = String.valueOf(fileSystemPath) + File.separator + logoURL;
            enterprise.setFbk1(srcPath);
            enterprise.setContactInfoVO(contactInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_vendor_query_failure", "\u4f9b\u5e94\u5546\u67e5\u8be2\u5931\u8d25", new Object[0]));
        }
        return Response.ok((Object)enterprise).build();
    }

    public Response addPurchaseEnquirySupply(EnterpriseVO epVO) {
        try {
            this.accountMapper.insertEnterpriseInfo(epVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_vendor_insert_failure", "\u4f9b\u5e94\u5546\u63d2\u5165\u5931\u8d25", new Object[0]));
        }
        return this.getOkResponse((BaseVO)epVO);
    }

    public Response deletePurchaseEnquirySupply(EnterpriseVO epVO) {
        try {
            this.accountMapper.deleteEnterpriseByPrimaryKey(epVO.getElsAccount());
            ContactInfoVO contactInfo = new ContactInfoVO();
            contactInfo.setElsAccount(epVO.getElsAccount());
            this.contactInfoMapper.deleteByPrimaryKey(contactInfo);
            this.redisDao.del(ENTERPRISE_KEY_PREFIX + epVO.getElsAccount());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_vendor_delect_failure", "\u4f9b\u5e94\u5546\u5220\u9664\u5931\u8d25", new Object[0]));
        }
        return this.getOkResponse((BaseVO)epVO);
    }

    public Response updatePurchaseEnquirySupply(EnterpriseVO epVO) {
        return null;
    }

    public Response getEnterpriseLogo(String elsAccount) {
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        String logo = "";
        try {
            enterpriseVO = this.accountMapper.findEnterpriseByNumber(elsAccount);
            String dbURL = enterpriseVO.getLogo();
            Properties sysProperties = SysProperties.INSTANCE.getSysProperties();
            String fileSystemPath = sysProperties.getProperty("fileSystemPath");
            logo = String.valueOf(fileSystemPath) + File.separator + dbURL;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return Response.ok((Object)logo).build();
    }

    public Response doLogoURL(String logoURL) {
        String logo = "";
        try {
            Properties sysProperties = SysProperties.INSTANCE.getSysProperties();
            String fileSystemPath = sysProperties.getProperty("fileSystemPath");
            logo = String.valueOf(fileSystemPath) + File.separator + logoURL;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return Response.ok((Object)logo).build();
    }

    public Response checkSubAccountIsExist(SubAccountVO subAccountVO) {
        String key = ALL_SUB_ACCOUNT_KEY + subAccountVO.getElsAccount();
        List listVOs = this.redisDao.getObjectList(key);
        if (listVOs != null && listVOs.size() > 0) {
            logger.info("\u4ece\u7f13\u5b58\u83b7\u53d6subAccountVO list");
        } else {
            SubAccountVO accountVO = new SubAccountVO();
            accountVO.setElsAccount(subAccountVO.getElsAccount());
            listVOs = this.accountMapper.findSubAccountList(accountVO);
            this.redisDao.setObjectList(key, listVOs);
        }
        for (SubAccountVO vo : listVOs) {
            if (subAccountVO.getElsSubAccount() == null || subAccountVO.getElsSubAccount() == "" || !subAccountVO.getElsSubAccount().equals(vo.getElsSubAccount())) continue;
            return Response.ok((Object)"1").build();
        }
        return Response.ok((Object)"0").build();
    }

    public Response checkInfoIsExist(SubAccountVO subAccountVO) {
        List lstVOs = this.accountMapper.findSubAccountListByInfo(subAccountVO);
        if (!(lstVOs.size() <= 0 || ((SubAccountVO)lstVOs.get(0)).getElsAccount().equals(subAccountVO.getElsAccount()) && ((SubAccountVO)lstVOs.get(0)).getElsSubAccount().equals(subAccountVO.getElsSubAccount()))) {
            return Response.ok((Object)"1").build();
        }
        return Response.ok((Object)"0").build();
    }

    private Response verifySubAccount(SubAccountVO subAccountVO) {
        String result;
        Response response;
        String email = subAccountVO.getEmail();
        String telphone1 = subAccountVO.getTelphone1();
        String employeeNumber = subAccountVO.getEmployeeNumber();
        SubAccountVO verifyVO = new SubAccountVO();
        verifyVO.setElsAccount(subAccountVO.getElsAccount());
        verifyVO.setElsSubAccount(subAccountVO.getElsSubAccount());
        StringBuffer buffer = new StringBuffer("");
        if (!StringUtils.isEmpty((String)email)) {
            verifyVO.setEmail(email);
            response = this.checkInfoIsExist(verifyVO);
            if (response.getEntity() instanceof String && (result = (String)response.getEntity()) != "0") {
                buffer.append(this.getI18n("i18n_account_title_email", "\u90ae\u7bb1 ", new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((String)telphone1)) {
            verifyVO.setEmail(null);
            verifyVO.setTelphone1(telphone1);
            response = this.checkInfoIsExist(verifyVO);
            if (response.getEntity() instanceof String && (result = (String)response.getEntity()) != "0") {
                buffer.append(this.getI18n("i18n_account_title_phonenumber", "\u624b\u673a\u53f7 ", new Object[0]));
            }
        }
        if (!StringUtils.isEmpty((String)employeeNumber)) {
            verifyVO.setTelphone1(null);
            verifyVO.setEmployeeNumber(employeeNumber);
            response = this.checkInfoIsExist(verifyVO);
            if (response.getEntity() instanceof String && (result = (String)response.getEntity()) != "0") {
                buffer.append(this.getI18n("i18n_account_title_employeenumber", "\u5de5\u53f7", new Object[0]));
            }
        }
        return Response.ok((Object)buffer.toString()).build();
    }

    public Response adminChangePassword(SubAccountVO subAccountVO) {
        Response req = this.checkPassword(subAccountVO);
        BaseVO result = (BaseVO)req.getEntity();
        if (ResponseCodeEnum.FAIL.getValue().equals(result.getStatusCode())) {
            return req;
        }
        SubAccountVO subAccountInfo = new SubAccountVO();
        List list = this.accountMapper.findSubAccountByNumber(subAccountVO);
        if (list == null || list.size() == 0) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_accountDoesNotExist", "No Account found", new Object[0]));
        }
        subAccountInfo = (SubAccountVO)list.get(0);
        String newPassword = subAccountVO.getNewPassword();
        if (StringUtils.isEmpty((String)newPassword)) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_newPasswordNotNull", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        subAccountVO.setElsSubAccountPassword(EncryptUtil.md5((String)newPassword));
        try {
            this.accountMapper.updateSubAccountPassword(subAccountVO);
            HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
            String currElsAccount = request.getSession().getAttribute("elsAccount").toString();
            String currElsSubAccount = request.getSession().getAttribute("elsSubAccount").toString();
            if (subAccountInfo.getElsAccount().equals(currElsAccount) && subAccountInfo.getElsSubAccount().equals(currElsSubAccount)) {
                this.addPasswordRecord(subAccountInfo, false);
            } else {
                this.addPasswordRecord(subAccountInfo, true);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("\u4fee\u6539\u5bc6\u7801\u9519\u8bef " + e.getMessage());
        }
        return Response.ok((Object)subAccountVO).build();
    }

    public int insertPasswordRecord(PasswordRecordVO passwordRecordVO) {
        int result = 0;
        try {
            ((PasswordRecordMapper)this.DALClientService.getMapper(PasswordRecordMapper.class)).insertSelective(passwordRecordVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("\u63d2\u5165\u5bc6\u7801\u66f4\u6539\u8bb0\u5f55\u5931\u8d25 " + e.getMessage());
        }
        return result;
    }

    public EnterpriseVO findEnterpriseInfo(String elsAccount) {
        if (StringUtils.isEmpty((String)elsAccount)) {
            return null;
        }
        EnterpriseVO enterpriseVO = (EnterpriseVO)this.redisDao.get(ENTERPRISE_KEY_PREFIX + elsAccount, EnterpriseVO.class);
        if (enterpriseVO != null) {
            logger.info("\u4ece\u7f13\u5b58\u83b7\u53d6enterpriseVO");
            return enterpriseVO;
        }
        enterpriseVO = this.accountMapper.findEnterpriseByNumber(elsAccount);
        if (enterpriseVO != null) {
            this.redisDao.set(ENTERPRISE_KEY_PREFIX + elsAccount, (Object)enterpriseVO);
        }
        return enterpriseVO;
    }

    public Response getPhoneValiteCode(SubAccountVO subAccountVO) {
        return null;
    }

    public List<String> getAllChildElsAccount(String elsAccount) {
        ArrayList<EnterpriseVO> childList = new ArrayList<EnterpriseVO>();
        this.getAllChildElsAccount(elsAccount, childList, 1);
        ArrayList<String> list = new ArrayList<String>();
        for (EnterpriseVO enter : childList) {
            String childElsAccount = enter.getElsAccount();
            if (list.contains(childElsAccount)) continue;
            list.add(childElsAccount);
        }
        return list;
    }

    private void getAllChildElsAccount(String elsAccount, ArrayList<EnterpriseVO> list, int level) {
        List childList = this.accountMapper.findEnterpriseByParentElsAccount(elsAccount);
        ++level;
        if (childList != null && childList.size() > 0) {
            list.addAll(childList);
            if (level <= 20) {
                for (EnterpriseVO enterprise : childList) {
                    this.getAllChildElsAccount(enterprise.getElsAccount(), list, level);
                }
            }
        }
    }

    public List<String> getAllParentElsAccount(String elsAccount) {
        ArrayList<String> parentList = new ArrayList<String>();
        this.getAllParentElsAccount(elsAccount, parentList, 1);
        return parentList;
    }

    private void getAllParentElsAccount(String elsAccount, List<String> list, int level) {
        EnterpriseVO enterprise = this.accountMapper.findEnterpriseByNumber(elsAccount);
        ++level;
        if (!StringUtils.isEmpty((String)enterprise.getParentElsAccount())) {
            if (!list.contains(enterprise.getParentElsAccount())) {
                list.add(enterprise.getParentElsAccount());
            }
            if (level <= 20) {
                this.getAllParentElsAccount(enterprise.getParentElsAccount(), list, level);
            }
        }
    }

    public Response findAllChildEnterprise(String elsAccount) {
        ArrayList<EnterpriseVO> childList = new ArrayList<EnterpriseVO>();
        this.getAllChildElsAccount(elsAccount, childList, 1);
        PageListVO pageListVO = new PageListVO();
        ArrayList<EnterpriseVO> resultList = new ArrayList<EnterpriseVO>();
        HashMap<String, EnterpriseVO> childMap = new HashMap<String, EnterpriseVO>();
        for (EnterpriseVO enter : childList) {
            String childElsAccount = enter.getElsAccount();
            if (childMap.containsKey(childElsAccount)) continue;
            childMap.put(childElsAccount, enter);
            resultList.add(enter);
        }
        pageListVO.setRows(resultList);
        pageListVO.setTotal(resultList.size());
        return Response.ok((Object)pageListVO).build();
    }

    public Response findParentOrChildSubAccountList(String elsAccount, String type) {
        ArrayList<String> parentElsAccountList;
        List<Object> rows = new ArrayList();
        if (type.equals("parent")) {
            parentElsAccountList = new ArrayList<String>();
            this.getAllParentElsAccount(elsAccount, parentElsAccountList, 1);
            for (String parentElsAccount : parentElsAccountList) {
                List<SubAccountVO> parentElsSubAccountList = this.findSubAccountListByElsAccount(parentElsAccount);
                rows.addAll(parentElsSubAccountList);
            }
        } else if (type.equals("child")) {
            List<String> childElsAccountList = this.getAllChildElsAccount(elsAccount);
            for (String childElsAccount : childElsAccountList) {
                List<SubAccountVO> childElsSubAccountList = this.findSubAccountListByElsAccount(childElsAccount);
                rows.addAll(childElsSubAccountList);
            }
        } else if (type.equals("all")) {
            parentElsAccountList = new ArrayList();
            this.getAllParentElsAccount(elsAccount, parentElsAccountList, 1);
            for (String parentElsAccount : parentElsAccountList) {
                List<SubAccountVO> parentElsSubAccountList = this.findSubAccountListByElsAccount(parentElsAccount);
                rows.addAll(parentElsSubAccountList);
            }
            List<String> childElsAccountList = this.getAllChildElsAccount(elsAccount);
            for (String childElsAccount : childElsAccountList) {
                List<SubAccountVO> childElsSubAccountList = this.findSubAccountListByElsAccount(childElsAccount);
                rows.addAll(childElsSubAccountList);
            }
            List<SubAccountVO> elsSubAccountList = this.findSubAccountListByElsAccount(elsAccount);
            rows.addAll(elsSubAccountList);
        } else {
            rows = this.findSubAccountListByElsAccount(elsAccount);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(rows);
        pageListVO.setTotal(rows.size());
        return Response.ok((Object)pageListVO).build();
    }

    public Response ResetPassword(SubAccountVO subAccountVO, String valiteCode) {
        String md5Session;
        SubAccountVO subAccountInfo = new SubAccountVO();
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        Response req = this.checkPassword(subAccountVO);
        BaseVO result = (BaseVO)req.getEntity();
        if (ResponseCodeEnum.FAIL.getValue().equals(result.getStatusCode())) {
            return req;
        }
        String valiteElsAccount = "";
        String valiteElsSubAccount = "";
        if (request.getSession().getAttribute("valiteElsAccount") != null && request.getSession().getAttribute("valiteElsSubAccount") != null) {
            valiteElsAccount = request.getSession().getAttribute("valiteElsAccount").toString();
            valiteElsSubAccount = request.getSession().getAttribute("valiteElsSubAccount").toString();
        }
        String elsAccount = subAccountVO.getElsAccount();
        String elsSubAccount = subAccountVO.getElsSubAccount();
        if (!valiteElsAccount.equals(elsAccount) || !valiteElsSubAccount.equals(elsSubAccount)) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_accountIsNotConsistent", "\u8d26\u53f7\u4e0d\u4e00\u81f4", new Object[0]));
        }
        String valiteCodeSession = "";
        if (request.getSession().getAttribute("valiteCode") != null) {
            valiteCodeSession = request.getSession().getAttribute("valiteCode").toString();
        }
        if ((md5Session = EncryptUtil.md5((String)valiteCode)).equals(valiteCodeSession)) {
            request.getSession().removeAttribute("valiteCode");
            request.getSession().removeAttribute("valiteElsAccount");
            request.getSession().removeAttribute("valiteElsSubAccount");
            List list = this.accountMapper.findSubAccountByNumber(subAccountVO);
            if (list == null || list.size() == 0) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_newPasswordNotNull", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
            }
            subAccountInfo = (SubAccountVO)list.get(0);
            String newPassword = subAccountVO.getNewPassword();
            subAccountInfo.setElsSubAccountPassword(EncryptUtil.md5((String)newPassword));
            try {
                this.accountMapper.updateSubAccountPassword(subAccountInfo);
                this.addPasswordRecord(subAccountInfo, false);
                return Response.ok((Object)"1").build();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.error("\u4fee\u6539\u5bc6\u7801\u9519\u8bef " + e.getMessage());
            }
        }
        return Response.ok((Object)"0").build();
    }

    private int addPasswordRecord(SubAccountVO subAccountVO, boolean Sended) {
        PasswordPolicyVO passwordPolicyVO = new PasswordPolicyVO();
        Date date = new Date();
        if (subAccountVO == null || StringUtils.isBlank((String)subAccountVO.getElsAccount())) {
            return 0;
        }
        String subAccount = this.getCurrentSubAccount();
        String localuser = this.getCreateUser();
        String elsAccount = subAccountVO.getElsAccount();
        String elsSubAccount = subAccountVO.getElsSubAccount();
        String username = subAccountVO.getName();
        String phoneNum = subAccountVO.getTelphone1();
        PasswordRecordVO passwordRecord = new PasswordRecordVO();
        passwordRecord.setElsAccount(elsAccount);
        passwordRecord.setElsSubAccount(elsSubAccount);
        passwordRecord.setUserName(username);
        passwordRecord.setPassWordUpdateAccount(subAccount);
        passwordRecord.setPassWordUpdateDate(date);
        passwordRecord.setPassWordUpdateUser(localuser);
        passwordPolicyVO.setElsAccount(elsAccount);
        passwordPolicyVO.setElsSubAccount(elsSubAccount);
        try {
            passwordPolicyVO = this.passwordPolicyMapper.selectByPrimaryKey(passwordPolicyVO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (passwordPolicyVO == null) {
            passwordPolicyVO = this.createPasswordPolicy(subAccountVO);
            try {
                this.passwordPolicyMapper.insertSelective(passwordPolicyVO);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.error("\u63d2\u5165\u5bc6\u7801\u7b56\u7565\u8868\u5931\u8d25" + e.getMessage());
            }
        }
        if (passwordPolicyVO != null && passwordPolicyVO.getChangeTime() == null) {
            passwordPolicyVO.setChangeTime(Integer.valueOf(0));
        }
        if (passwordPolicyVO != null) {
            int changeTotal = passwordPolicyVO.getChangeTime();
            passwordPolicyVO.setChangeTime(Integer.valueOf(changeTotal + 1));
        }
        if (passwordPolicyVO != null) {
            if (Sended) {
                passwordPolicyVO.setNextTip(Integer.valueOf(1));
            } else {
                passwordPolicyVO.setNextTip(Integer.valueOf(0));
            }
            passwordPolicyVO.setPasswordLastUpdateDate(date);
            passwordPolicyVO.setPasswordLastUpdateUser(username);
            passwordPolicyVO.setPasswordStation(Integer.valueOf(PasswordStatusEnum.NORMAL.getValue()));
        }
        try {
            this.passwordPolicyMapper.updateByPrimaryKeySelective(passwordPolicyVO);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("\u66f4\u65b0\u5bc6\u7801\u7b56\u7565\u8868\u5931\u8d25" + e.getMessage());
        }
        int result = this.insertPasswordRecord(passwordRecord);
        if (phoneNum != null && phoneNum != "") {
            String dateString = DataFormatUtil.parseDateTimeString((Date)date);
            if (Sended) {
                HashMap<String, String> paramList = new HashMap<String, String>();
                paramList.put("date", dateString);
                this.sendAliyun(phoneNum, "SMS_106895045", paramList);
            }
        }
        return result;
    }

    public Response valiteAccountInfo(SubAccountVO subAccountVO, String valiteCode) {
        String md5Session;
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        String valiteElsAccount = "";
        String valiteElsSubAccount = "";
        if (request.getSession().getAttribute("valiteElsAccount") != null && request.getSession().getAttribute("valiteElsSubAccount") != null) {
            valiteElsAccount = request.getSession().getAttribute("valiteElsAccount").toString();
            valiteElsSubAccount = request.getSession().getAttribute("valiteElsSubAccount").toString();
        }
        String elsAccount = subAccountVO.getElsAccount();
        String elsSubAccount = subAccountVO.getElsSubAccount();
        if (!valiteElsAccount.equals(elsAccount) || !valiteElsSubAccount.equals(elsSubAccount)) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_accountIsNotConsistent", "\u8d26\u53f7\u4e0d\u4e00\u81f4", new Object[0]));
        }
        String valiteCodeSession = "";
        if (request.getSession().getAttribute("valiteCode") != null) {
            valiteCodeSession = request.getSession().getAttribute("valiteCode").toString();
        }
        if (valiteCodeSession.equals(md5Session = EncryptUtil.md5((String)valiteCode))) {
            return Response.ok((Object)"1").build();
        }
        String valiteCodeTime = "";
        Date datenow = new Date();
        Date sessionDate = new Date();
        if (request.getSession().getAttribute("phoneValitedate") != null) {
            valiteCodeTime = request.getSession().getAttribute("phoneValitedate").toString();
            long m = DataFormatUtil.compareDate((Date)datenow, (Date)sessionDate, (String)"m");
            if (m > 3L) {
                return Response.ok((Object)"0").build();
            }
        }
        return Response.ok((Object)"0").build();
    }

    public Response getAccountPassWordPolicy(SubAccountVO subAccountVO) {
        PasswordPolicyVO passwordPolicy = this.createPasswordPolicy(subAccountVO);
        PasswordPolicyVO passwordInfo = null;
        if (passwordPolicy != null) {
            passwordInfo = this.passwordPolicyMapper.selectByPrimaryKey(passwordPolicy);
        }
        if (passwordInfo != null) {
            passwordInfo.setElsAccount(passwordPolicy.getElsAccount());
            passwordInfo.setElsSubAccount(passwordPolicy.getElsSubAccount());
            passwordInfo.setCreateDate(passwordPolicy.getPasswordCreateDate());
            passwordInfo.setPasswordCreateDate(passwordPolicy.getPasswordCreateDate());
            passwordInfo.setPasswordStation(passwordPolicy.getPasswordStation());
            int status = passwordInfo.getPasswordStation();
            int nextTip = passwordInfo.getNextTip();
            if (status == 0) {
                return Response.ok((Object)PasswordStatusEnum.LOCKED).build();
            }
            if (nextTip == 1) {
                return Response.ok((Object)PasswordStatusEnum.WARN).build();
            }
        }
        return Response.ok((Object)PasswordStatusEnum.NORMAL).build();
    }

    private PasswordPolicyVO createPasswordPolicy(SubAccountVO subAccountVO) {
        Date date = new Date();
        String user = this.getCreateUser();
        PasswordPolicyVO passwordPolicyVO = new PasswordPolicyVO();
        String elsAccount = "";
        String elsSubAccount = "";
        SubAccountVO subAccountInfo = null;
        if (subAccountVO != null) {
            elsAccount = subAccountVO.getElsAccount();
            elsSubAccount = subAccountVO.getElsSubAccount();
            List list = this.accountMapper.findSubAccountByNumber(subAccountVO);
            if (list == null || list.size() == 0) {
                return null;
            }
            subAccountInfo = (SubAccountVO)list.get(0);
        }
        if (subAccountInfo != null) {
            passwordPolicyVO.setElsAccount(elsAccount);
            passwordPolicyVO.setElsSubAccount(elsSubAccount);
            passwordPolicyVO.setPasswordStation(Integer.valueOf(1));
            passwordPolicyVO.setChangeTime(Integer.valueOf(0));
            passwordPolicyVO.setUserName(subAccountInfo.getName());
            passwordPolicyVO.setPasswordCreateDate(date);
            passwordPolicyVO.setPasswordLastUpdateDate(date);
            passwordPolicyVO.setPasswordLastUpdateUser(user);
            passwordPolicyVO.setShowTip(Integer.valueOf(1));
            passwordPolicyVO.setNextTip(Integer.valueOf(1));
        }
        return passwordPolicyVO;
    }

    public Response frozenOrUnfreeze(SubAccountVO subAccountVO) {
        logger.info("Enter into method AccountServiceImpl.frozenOrUnfreeze. subAccountVO :" + subAccountVO.toString());
        try {
            subAccountVO.setLastUpdateDate(new Date());
            subAccountVO.setLastUpdateUser(this.getCreateUser());
            this.accountMapper.frozenOrUnfreeze(subAccountVO);
            logger.info("leave the method AccountServiceImpl.frozenOrUnfreeze. and successful \uff01");
            return Response.ok((Object)subAccountVO).build();
        }
        catch (Exception e) {
            logger.error("request failed!", (Throwable)e);
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), e.getMessage());
        }
    }

    public Response findSubAccountsByRole(SubAccountRoleVO subAccountRoleVO) {
        List rows = this.accountMapper.findSubAccountsByRole(subAccountRoleVO);
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(rows);
        return Response.ok((Object)pageListVO).build();
    }

    public Response agentSubaccount(AccountAgentVO agentVo) {
        logger.info("Enter into method AccountServiceImpl.agentSubaccount.AccountAgentVo:" + agentVo.toString());
        this.accountAgentMapper.insertAccountAgent(agentVo);
        logger.info("leave the method AccountServiceImpl.agentSubaccount. and successful:");
        return Response.ok((Object)agentVo).build();
    }

    public Response queryAgentSubAccount(AccountAgentVO agentVo) {
        List accountAgentVOs = null;
        if (agentVo != null) {
            PageListVO pageListVO = new PageListVO();
            try {
                int total = this.accountAgentMapper.queryAccountAgentCount(agentVo);
                accountAgentVOs = this.accountAgentMapper.queryAccountAgent(agentVo);
                pageListVO.setRows(accountAgentVOs);
                pageListVO.setTotal(total);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.error("\u67e5\u8be2\u4ee3\u7406\u6388\u6743\u5931\u8d25" + e.getMessage());
            }
            return Response.ok((Object)pageListVO).build();
        }
        return Response.ok().build();
    }

    public Response findEnterpriseInfoByElsAccount(String elsAccount) {
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        if (StringUtils.isNotBlank((String)elsAccount)) {
            enterpriseVO = (EnterpriseVO)this.redisDao.get(ENTERPRISE_KEY_PREFIX + elsAccount, EnterpriseVO.class);
            if (enterpriseVO != null) {
                return Response.ok((Object)enterpriseVO).build();
            }
            enterpriseVO = this.accountMapper.findEnterpriseByNumber(elsAccount);
            this.redisDao.set(ENTERPRISE_KEY_PREFIX + elsAccount, (Object)enterpriseVO);
        }
        return Response.ok((Object)enterpriseVO).build();
    }

    public Response goBackLogin(SubAccountVO subAccountVO) {
        try {
            SubAccountVO subAccount = new SubAccountVO();
            subAccount.setStatusCode("200");
            ResourceBundle bundle = ResourceBundle.getBundle("sso");
            if (bundle == null || StringUtils.isBlank((String)bundle.getString("sso.login.url"))) {
                subAccount.setMessage("\u65e0\u6cd5\u8fd4\u56de,\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u914d\u7f6e\u8fd4\u56de\u5730\u5740");
                return Response.ok((Object)subAccount).build();
            }
            String loginAddress = bundle.getString("sso.login.url");
            subAccount.setMessage("success");
            subAccount.setForwardUrl(loginAddress);
            return Response.ok((Object)subAccount).build();
        }
        catch (Exception e) {
            logger.error("\u6ce8\u518c\u9875\u9762\u8fd4\u56de\u767b\u9646\u51fa\u9519", (Object)e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_system_error_cannot_return", "\u7cfb\u7edf\u51fa\u9519\u65e0\u6cd5\u8fd4\u56de", new Object[0]));
        }
    }

    public Response getRegisterCode(String elsAccount) {
        ElsRegisterCodeVO queryVO = new ElsRegisterCodeVO();
        queryVO.setReceiveEls(elsAccount);
        queryVO.setCodeStatus(Integer.valueOf(1));
        List elsRegisterCodeVOs = this.elsRegisterCodeMapper.selectByPrimaryKey(queryVO);
        if (elsRegisterCodeVOs.size() > 0) {
            Random rand = new Random();
            int randNum = rand.nextInt(elsRegisterCodeVOs.size() - 1);
            return Response.ok(elsRegisterCodeVOs.get(randNum)).build();
        }
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_no_ver_code", "\u6ca1\u6709\u9a8c\u8bc1\u7801", new Object[0]));
    }

    public Response supplierSubAccountList(SubAccountVO subAccountVO) {
        if (subAccountVO.getElsSubAccount() != null && subAccountVO.getElsSubAccount().equals("")) {
            subAccountVO.setElsSubAccount(null);
        }
        List rows = this.accountMapper.findSupplierSubAccountByNumber(subAccountVO);
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(rows);
        pageListVO.setTotal(this.accountMapper.findSupplierSubAccountByNumberCount(subAccountVO));
        return Response.ok((Object)pageListVO).build();
    }

    public Response checkEnterpriseExistByName(EnterpriseVO enterpriseVO) {
        BaseVO baseVO = new BaseVO();
        try {
            String fullName = enterpriseVO.getFullName();
            String elsAccount = this.accountMapper.checkEnterpriseExistByName(fullName);
            if (!StringUtils.isEmpty((String)elsAccount)) {
                SubAccountVO subAccountVO = this.accountMapper.selectSubAccountPrimaryKey(elsAccount, "1001");
                baseVO.setElsAccount(subAccountVO.getElsAccount());
                baseVO.setCreateUser(subAccountVO.getName());
                baseVO.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return Response.ok((Object)baseVO).build();
    }

    public Response getVerificationByTelphone(String telphone) {
        try {
            HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
            String verificationCode = RandomUtil.generateNumber((int)5);
            String smsContext = "\u9a8c\u8bc1\u7801\u3010" + verificationCode + "\u3011\u53ea\u80fd\u7528\u4e8e\u9a8c\u8bc1\u6ce8\u518c,\u8bf7\u52ff\u8f6c\u53d1\u4ed6\u4eba";
            request.getSession().setAttribute(REG_PHONE_VERI_CODE + telphone, (Object)verificationCode);
            request.getSession().setAttribute(REG_PHONE_VERI_CODE_PERIOD + telphone, (Object)new Date().getTime());
            HashMap<String, String> codeList = new HashMap<String, String>();
            codeList.put("code", verificationCode);
            this.sendAliyun(telphone, "SMS_106015021", codeList);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.SUCCESS.getValue(), this.getI18n("i18n_get_ver_code_failure", "\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25", new Object[0]));
        }
        return this.getOkResponse(new BaseVO(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_get_ver_code_success", "\u83b7\u53d6\u9a8c\u8bc1\u7801\u6210\u529f", new Object[0])));
    }

    public Response checkVerificationByTelphone(String telphone, String verificationCode) {
        long period = 600L;
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_ver_code_failure_get_again", "\u9a8c\u8bc1\u7801\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01", new Object[0]));
    }

    @Transactional
    public Response updatePasswordSecurity(ElsPasswordSecurityVO elsPasswordSecurityVO) {
        this.elsPasswordSecurityMapper.replace(elsPasswordSecurityVO);
        return Response.ok().build();
    }

    public Response getPasswordSecurity(String elsAccount) {
        ElsPasswordSecurityVO elsPasswordSecurityVO = this.elsPasswordSecurityMapper.read(elsAccount);
        if (elsPasswordSecurityVO == null) {
            elsPasswordSecurityVO = this.elsPasswordSecurityMapper.read("540000");
        }
        return Response.ok((Object)elsPasswordSecurityVO).build();
    }

    public Response getValidateCode(SubAccountVO subAccountVO, String type) {
        return null;
    }

    public Response updatePhone(SubAccountVO subAccountVO) {
        return null;
    }

    public Response updateMail(SubAccountVO subAccountVO) {
        return null;
    }

    public Response checkValidateCode(String type, String target, String validateCode) {
        return null;
    }

    public Response querySubAccount(SubAccountVO subAccountVO) {
        PageListVO pageListVO = new PageListVO();
        List lstData = this.accountMapper.querySubAccount(subAccountVO);
        pageListVO.setRows(lstData);
        return Response.ok((Object)pageListVO).build();
    }

    public Response findSubAccountByKeyWord(SubAccountVO subAccountVO) {
        PageListVO pageListVO = new PageListVO();
        try {
            List rows = subAccountVO.getElsAccount().equals("267000") ? this.accountMapper.findSubAccountByKeyWord_tf(subAccountVO) : this.accountMapper.findSubAccountByKeyWord(subAccountVO);
            int total = this.accountMapper.findSubAccountByKeyWordCount(subAccountVO);
            pageListVO.setRows(rows);
            pageListVO.setTotal(total);
            pageListVO.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            pageListVO.setStatusCode(ResponseCodeEnum.FAIL.getValue());
            pageListVO.setMessage("\u67e5\u8be2\u5b50\u8d26\u53f7\u51fa\u9519!");
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_msg_queryException", "\u67e5\u8be2\u5b50\u8d26\u53f7\u51fa\u9519", new Object[0]));
        }
        return Response.ok((Object)pageListVO).build();
    }

    public Response findEnterpriseExtend(String elsAccount) {
        try {
            ElsEnterpriseExtendVO extendVO = ((ElsEnterpriseExtendMapper)this.DALClientService.getMapper(elsAccount, ElsEnterpriseExtendMapper.class)).findEnterpriseExtendByPrimaryKey(elsAccount);
            if (extendVO == null) {
                extendVO = new ElsEnterpriseExtendVO();
            }
            extendVO.setMessage(ResponseCodeEnum.SUCCESS.getValue());
            return Response.ok((Object)extendVO).build();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_error_find_info", "\u67e5\u627e\u4f01\u4e1a\u94f6\u884c\u3001\u5730\u5740\u3001\u8ba4\u8bc1\u3001\u8054\u7cfb\u4eba\u8d44\u6599\u51fa\u9519!", new Object[0]));
        }
    }

    public Response findEnterpriseAddress(List<String> elsAccounts) {
        try {
            List list = this.accountMapper.findEnterpriseAddress(elsAccounts);
            return Response.ok((Object)list).build();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_error_find_company_add", "\u516c\u53f8\u5730\u5740\u67e5\u627e\u51fa\u9519!", new Object[0]));
        }
    }

    public int checkTelphone(EnterpriseVO enterpriseVO) {
        int telphoneCount = this.accountMapper.checkSubAccountExistTelphone(enterpriseVO.getTelphone());
        return telphoneCount;
    }

    public Response copySubaccount(SubAccountVO subAccountVO) {
        return null;
    }

    public Response findSubAccountInfoList(SubAccountVO subAccountVO) {
        PageListVO pageListVO = new PageListVO();
        try {
            int total = this.accountMapper.findSubAccountInfoListCount(subAccountVO);
            if (total > 0) {
                List subAccountList = this.accountMapper.findSubAccountInfoList(subAccountVO);
                pageListVO.setRows(subAccountList);
                pageListVO.setTotal(total);
            }
            pageListVO.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            pageListVO.setStatusCode(ResponseCodeEnum.FAIL.getValue());
            pageListVO.setMessage("\u5b50\u8d26\u53f7\u67e5\u8be2\u51fa\u9519!");
        }
        return Response.ok((Object)pageListVO).build();
    }

    public Response getServiceTime() {
        return null;
    }

    public Response findEnterpriseByKeyword(EnterpriseVO enterpriseVO) {
        PageListVO pageListVO = new PageListVO();
        try {
            int total = this.accountMapper.findEnterpriseByKeywordCount(enterpriseVO);
            if (total > 0) {
                List lstEnterprise = this.accountMapper.findEnterpriseByKeyword(enterpriseVO);
                pageListVO.setRows(lstEnterprise);
            } else {
                pageListVO.setRows(new ArrayList());
            }
            pageListVO.setTotal(total);
            pageListVO.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
        }
        catch (Exception e) {
            pageListVO.setStatusCode(ResponseCodeEnum.FAIL.getValue());
            pageListVO.setMessage("\u67e5\u8be2\u4f01\u4e1a\u4fe1\u606f\u51fa\u9519:" + e.getMessage());
        }
        return Response.ok((Object)pageListVO).build();
    }

    public Response querySubAccountList(SubAccountVO subAccountVO) {
        PageListVO pageListVO = new PageListVO();
        try {
            int total = this.accountMapper.querySubAccountListCount(subAccountVO);
            if (total > 0) {
                List lstSubAccount = this.accountMapper.querySubAccountList(subAccountVO);
                pageListVO.setRows(lstSubAccount);
            } else {
                pageListVO.setRows(new ArrayList());
            }
            pageListVO.setTotal(total);
            pageListVO.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            pageListVO.setStatusCode(ResponseCodeEnum.FAIL.getValue());
            pageListVO.setMessage("\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f\u51fa\u9519\uff1a" + e.getMessage());
        }
        return Response.ok((Object)pageListVO).build();
    }

    public Response warningForPriceStatus(String elsAccount, String sku, String platformCode, String price, String pxPrice, String telphone) {
        try {
            HashMap<String, String> codeList = new HashMap<String, String>();
            codeList.put("elsAccount", elsAccount);
            codeList.put("sku", sku);
            codeList.put("platformCode", platformCode);
            codeList.put("price", price);
            codeList.put("xyPrice", pxPrice);
            SmsAsynTask task = new SmsAsynTask();
            task.sendAliyunSms(telphone, "SMS_129763399", codeList);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.SUCCESS.getValue(), this.getI18n("i18n_failure_send_SMS", "\u53d1\u9001\u901a\u77e5\u77ed\u4fe1\u5931\u8d25", new Object[0]));
        }
        return this.getOkResponse(new BaseVO(ResponseCodeEnum.FAIL.getValue(), "\u53d1\u9001\u901a\u77e5\u77ed\u4fe1\u6210\u529f"));
    }

    public Response paymentAdvice(String fullName, String requisitionNumber, String telphone) {
        try {
            HashMap<String, String> codeList = new HashMap<String, String>();
            codeList.put("fullName", fullName);
            codeList.put("requisitionNumber", requisitionNumber);
            SmsAsynTask task = new SmsAsynTask();
            task.sendAliyunSms(telphone, "SMS_132395150", codeList);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.SUCCESS.getValue(), this.getI18n("i18n_failure_send_SMS", "\u53d1\u9001\u901a\u77e5\u77ed\u4fe1\u5931\u8d25", new Object[0]));
        }
        return this.getOkResponse(new BaseVO(ResponseCodeEnum.FAIL.getValue(), "\u53d1\u9001\u901a\u77e5\u77ed\u4fe1\u6210\u529f"));
    }

    public Response getAdminloginStatus() {
        long interval;
        long period = 600L;
        HttpSession session = ((HttpServletRequest)ContextFilter.context.get()).getSession();
        Object sessionAdminPeriod = session.getAttribute(ELS_ADMIN_PERIOD);
        if (sessionAdminPeriod != null && sessionAdminPeriod != "" && (interval = new Date().getTime() - (Long)sessionAdminPeriod) / 1000L < period) {
            return Response.ok((Object)ResponseCodeEnum.SUCCESS.getValue()).build();
        }
        return Response.ok().build();
    }

    public Response sendVerificationCode() {
        try {
            HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
            String verificationCode = RandomUtil.generateNumber((int)6);
            request.getSession().setAttribute(ELS_ADMIN_VERIFICATION, (Object)verificationCode);
            request.getSession().setAttribute(ELS_ADMIN_VERIFICATION_PERIOD, (Object)new Date().getTime());
            HashMap<String, String> codeList = new HashMap<String, String>();
            codeList.put("code", verificationCode);
            String[] arr = adminPhone.split(",");
            List<String> adminPhoneList = Arrays.asList(arr);
            for (String adminPhone : adminPhoneList) {
                this.sendAliyun(adminPhone, "SMS_135792811", codeList);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return this.getErrorResponse(ResponseCodeEnum.SUCCESS.getValue(), this.getI18n("i18n_get_ver_code_failure", "\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25", new Object[0]));
        }
        return this.getOkResponse(new BaseVO(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_get_ver_code_success", "\u83b7\u53d6\u9a8c\u8bc1\u7801\u6210\u529f", new Object[0])));
    }

    public Response verification(String verification) {
        block4: {
            System.out.println(verification);
            long period = 300L;
            try {
                HttpSession session = ((HttpServletRequest)ContextFilter.context.get()).getSession();
                Object sessionVeriCode = session.getAttribute(ELS_ADMIN_VERIFICATION);
                if (sessionVeriCode != null && sessionVeriCode.toString().equalsIgnoreCase(verification)) {
                    long interval;
                    Object sessionMils = session.getAttribute(ELS_ADMIN_VERIFICATION_PERIOD);
                    if (sessionMils != null && period > (interval = new Date().getTime() - (Long)sessionMils) / 1000L) {
                        session.removeAttribute(ELS_ADMIN_VERIFICATION);
                        session.removeAttribute(ELS_ADMIN_VERIFICATION_PERIOD);
                        session.setAttribute(ELS_ADMIN_PERIOD, (Object)new Date().getTime());
                        return Response.ok((Object)ResponseCodeEnum.SUCCESS.getValue()).build();
                    }
                    break block4;
                }
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_account_error_VerificationCodeError", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01", new Object[0]));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_ver_code_failure_get_again", "\u9a8c\u8bc1\u7801\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01", new Object[0]));
    }

    @Transactional
    public Response resetPassworda(List<SubAccountVO> record) {
        try {
            if (CollectionUtils.isNotEmpty(record)) {
                for (SubAccountVO subAccountVO : record) {
                    SubAccountVO subAccountVO1 = new SubAccountVO();
                    subAccountVO1.setElsAccount(subAccountVO.getElsAccount());
                    subAccountVO1.setElsSubAccount(subAccountVO.getElsSubAccount());
                    subAccountVO1.setElsSubAccountPassword(EncryptUtil.md5((String)"123"));
                    subAccountVO1.setLastUpdateDate(new Date());
                    ((AccountMapper)this.DALClientService.getMapper(subAccountVO.getElsAccount(), AccountMapper.class)).updateSubAccountPassword(subAccountVO1);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(String.valueOf(record.get(0).getElsAccount()) + "\u91cd\u7f6e\u5bc6\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u91cd\u7f6e\u5bc6\u7801\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return Response.ok(record).build();
    }

    @Transactional
    public Response turntoFormalAccountList(List<SubAccountVO> subAccountVOList) {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        String elsAccount = request.getSession().getAttribute("elsAccount").toString();
        try {
            for (SubAccountVO subAccountVO : subAccountVOList) {
                String route = this.accountMapper.getRoute(subAccountVO.getElsAccount());
                if (StringUtils.isEmpty((String)route)) continue;
                throw new Exception(String.valueOf(subAccountVO.getElsAccount()) + "\u5e10\u53f7\u5df2\u7ecf\u662f\u6b63\u5f0f\u5e10\u53f7");
            }
            for (SubAccountVO subAccountVO : subAccountVOList) {
                if (subAccountVO == null) continue;
                String forwardUrl = this.accountMapper.getForwardUrl(elsAccount);
                List subAccountList = this.accountMapper.findSubAccountInfoByName(subAccountVO);
                AccountVO accountVO = this.accountMapper.findAccountByNumber(subAccountVO.getElsAccount());
                for (SubAccountVO subaccountVO : subAccountList) {
                    subaccountVO.setAccountValidityDate(new Date(4102329600000L));
                    this.accountMapper.updateSubAccount(subaccountVO);
                }
                accountVO.setAccountValidityDate(new Date(4102329600000L));
                this.accountMapper.updateAccount(accountVO);
                this.accountMapper.insertElsLoginRoute(accountVO.getElsAccount(), forwardUrl);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(String.valueOf(subAccountVOList.get(0).getElsAccount()) + "\u8f6c\u6362\u8d26\u53f7\u51fa\u9519\uff1a" + e.getMessage());
            throw new BusinessException("\u8f6c\u6362\u8d26\u53f7\u51fa\u9519\uff1a" + e.getMessage());
        }
        return Response.ok(subAccountVOList).build();
    }

    public Response newAccountByEmail(String elsAccount) {
        HashMap<String, String> data = new HashMap<String, String>();
        EnterpriseVO ep = this.accountMapper.findEmail(elsAccount);
        String email = ep.getEmail();
        String station = ep.getFbk1();
        data.put("statusCode", ResponseCodeEnum.SUCCESS.getValue());
        data.put("email", email);
        data.put("station", station);
        return Response.ok(data).build();
    }

    public Response isAdmin(String elsAccount, String elsSubAccount) {
        HashMap<String, String> data = new HashMap<String, String>();
        String isAdmin = this.accountMapper.isAdmin(elsAccount, elsSubAccount);
        data.put("statusCode", ResponseCodeEnum.SUCCESS.getValue());
        data.put("isAdmin", isAdmin);
        return Response.ok(data).build();
    }

    String createUserIDMRegister(String idcard, String supplierName, String userName, String email, String uaesName, String uaesEmail) {
        System.out.println("\u8fdb\u5165\u4f9b\u5e94\u5546\u5230IDM\u6ce8\u518c-\u65b9\u6cd5");
        JSONObject jsb = new JSONObject();
        jsb.put("idcard", (Object)idcard);
        jsb.put("supplierName", (Object)supplierName);
        jsb.put("userName", (Object)userName);
        jsb.put("email", (Object)email);
        jsb.put("uaesName", (Object)uaesName);
        jsb.put("uaesEmail", (Object)uaesEmail);
        jsb.put("system", (Object)"iPur");
        InterfaceParamVO interfaceParamVO = new InterfaceParamVO();
        interfaceParamVO.setElsAccount("540000");
        interfaceParamVO.setInterfaceCode("createUserIDMRegister");
        interfaceParamVO.setParamObj(jsb.toJSONString());
        if (this.interfaceConfigService.interfaceExists(interfaceParamVO)) {
            InterfaceResultVO result = this.interfaceConfigService.callInterface(interfaceParamVO);
            System.out.println("\u4f9b\u5e94\u5546\u5230IDM\u6ce8\u518c\u7ed3\u679c:" + result.getResult());
            System.out.println("\u8fd4\u56de\u7ed3\u679c:" + result.getMsg());
            return result.getMsg();
        }
        System.out.println("\u4f9b\u5e94\u5546\u5230IDM\u6ce8\u518c,\u8be5\u65b9\u6cd5\u6ca1\u6709\u5728\u8868\u91cc\u6ce8\u518c");
        return "{\"result\":\"error\",\"desc\":\"\u8be5\u65b9\u6cd5\u6ca1\u6709\u5728\u8868\u91cc\u6ce8\u518c\"}";
    }

    public Response selectSubAccountName() {
        List list = new ArrayList();
        ArrayList<String> lists = new ArrayList<String>();
        try {
            list = ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).selectSubAccountName();
            if (list.size() > 0) {
                for (SubAccountVO vo : list) {
                    lists.add(String.valueOf(vo.getElsSubAccount()) + "_" + vo.getName());
                }
                return Response.ok(lists).build();
            }
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "");
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2elSubAccount\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Response countrys() {
        List countrys = this.accountMapper.selectCountry();
        return Response.ok((Object)countrys).build();
    }

    public Response clearCache(String key) {
        this.redisDao.del(key);
        return Response.ok().build();
    }

    public Response init() {
        HashMap<String, List> map = new HashMap<String, List>();
        try {
            ArrayList<SubAccountVO> list1 = new ArrayList<SubAccountVO>();
            SubAccountVO s1 = new SubAccountVO();
            s1.setRoleCode("PCP-P-engineer");
            SubAccountVO s2 = new SubAccountVO();
            s2.setRoleCode("PCP-P-teamLeader");
            list1.add(s1);
            list1.add(s2);
            List project_procurement = ((AccountMapper)this.DALClientService.getMapper(this.getLoginElsAccount(), AccountMapper.class)).selectRoleName(list1);
            ArrayList<SubAccountVO> list2 = new ArrayList<SubAccountVO>();
            SubAccountVO s3 = new SubAccountVO();
            s3.setRoleCode("PCP-S-engineer");
            SubAccountVO s4 = new SubAccountVO();
            s4.setRoleCode("PCP-S-teamLeader");
            list2.add(s3);
            list2.add(s4);
            List business_procurement = ((AccountMapper)this.DALClientService.getMapper(this.getLoginElsAccount(), AccountMapper.class)).selectRoleName(list2);
            map.put("project_procurement", project_procurement);
            map.put("business_procurement", business_procurement);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u67e5\u8be2\u5546\u52a1\u91c7\u8d2d/\u9879\u76ee\u91c7\u8d2d\u51fa\u9519" + e.getMessage());
            throw new BusinessException("\u521d\u59cb\u5316\u67e5\u8be2\u5546\u52a1\u91c7\u8d2d/\u9879\u76ee\u91c7\u8d2d\u51fa\u9519");
        }
        return Response.ok(map).build();
    }

    public Response SupplierAccountManagement(SubAccountVO vo) {
        PageListVO pageListVO = new PageListVO();
        List listVo = null;
        Integer count = null;
        try {
            listVo = ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).getSupplierAccount(vo);
            count = ((AccountMapper)this.DALClientService.getMapper("540000", AccountMapper.class)).getSupplierAccountCount(vo);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u67e5\u8be2\u4f9b\u5e94\u5546\u8d26\u53f7\u7ba1\u7406\u5217\u8868" + e.getMessage());
            throw new BusinessException("\u521d\u59cb\u5316\u67e5\u8be2\u4f9b\u5e94\u5546\u8d26\u53f7\u7ba1\u7406\u5217\u8868\u51fa\u9519");
        }
        pageListVO.setTotal(count);
        pageListVO.setRows(listVo);
        return Response.ok((Object)pageListVO).build();
    }

    public Response AccountExport(SubAccountVO vo) {
        BaseVO baseVO = new BaseVO();
        ExportExcel ex = new ExportExcel();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList fieldNames = new ArrayList();
        try {
            boolean flag;
            List dataset = this.accountMapper.AccountExecl(vo);
            headers.add("iPUR\u516c\u53f8\u4ee3\u7801");
            headers.add("\u5b50\u8d26\u53f7\u4ee3\u7801");
            headers.add("\u662f\u5426\u7ba1\u7406\u5458");
            headers.add("\u7cfb\u7edf\u57fa\u672c\u89d2\u8272");
            headers.add("\u89d2\u8272");
            headers.add("\u59d3\u540d");
            headers.add("\u5e10\u53f7");
            headers.add("\u5de5\u53f7");
            headers.add("\u79d1\u5ba4");
            headers.add("\u7535\u5b50\u90ae\u7bb1");
            headers.add("\u624b\u673a\u53f7\u7801");
            headers.add("\u7535\u8bdd\u53f7\u7801");
            headers.add("\u4f20\u771f\u53f7\u7801");
            headers.add("\u6635\u79f0");
            headers.add("\u8d26\u6237\u72b6\u6001");
            headers.add("\u8d26\u6237\u6709\u6548\u671f\u81f3");
            headers.add("\u6700\u540e\u66f4\u65b0\u65f6\u95f4");
            Properties pro = SysProperties.INSTANCE.getSysProperties();
            String fileSystemPath = pro.getProperty("fileSystemPath");
            File tempDir = new File(String.valueOf(fileSystemPath) + "/temp");
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            String fileName = String.valueOf(String.valueOf(System.currentTimeMillis())) + ".xls";
            File temp = new File(String.valueOf(fileSystemPath) + "/temp/" + fileName);
            if (!temp.exists() && !(flag = temp.createNewFile())) {
                logger.error("create new file failed!");
            }
            Throwable throwable = null;
            Object var14_16 = null;
            try (FileOutputStream out = new FileOutputStream(temp);){
                ex.exportExcel("\u8d26\u53f7\u7ba1\u7406", headers.toArray(new String[0]), fieldNames.toArray(new String[0]), (Collection)dataset, (OutputStream)out);
                baseVO.setMessage("temp/" + fileName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("\u8d26\u53f7\u7ba1\u7406\u5931\u8d25\uff1a" + e.getMessage());
            throw new RuntimeException("\u8d26\u53f7\u7ba1\u7406\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        return Response.ok((Object)baseVO).build();
    }

    public Response getAccountInfo(String elsAccount, String toElsAccount, String subElsAccount) {
        AccountInfoVO accountInfoVO = null;
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        AccountVO accountVO = new AccountVO();
        SupplierMainDataVO supplierMainDataVO = new SupplierMainDataVO();
        List subAccountList = new ArrayList();
        try {
            if (toElsAccount != null) {
                enterpriseVO = ((AccountMapper)this.DALClientService.getMapper(toElsAccount, AccountMapper.class)).getElsEnterpriseInfoByelsAccount(toElsAccount);
                accountVO = ((AccountMapper)this.DALClientService.getMapper(toElsAccount, AccountMapper.class)).findAccountByNumber(toElsAccount);
                subAccountList = ((AccountMapper)this.DALClientService.getMapper(toElsAccount, AccountMapper.class)).getElsSubaccountInfo(toElsAccount);
                SubAccountVO subAccountVO = new SubAccountVO();
                subAccountVO.setElsAccount(elsAccount);
                subAccountVO.setElsSubAccount(subElsAccount);
                subAccountVO.setPageSize(99999);
                List subAccountRoleList = ((SubAccountRoleMapper)this.DALClientService.getMapper(toElsAccount, SubAccountRoleMapper.class)).findSubAccountRole(subAccountVO);
                List accountResourceList = ((AccountResourceMapper)this.DALClientService.getMapper(toElsAccount, AccountResourceMapper.class)).queryAccountResourceByEls(subAccountVO);
                List accountAppList = ((AccountAppMapper)this.DALClientService.getMapper(toElsAccount, AccountAppMapper.class)).queryAccountAppListByEls1(subAccountVO);
                SupplierMainDataVO tempSupplier = new SupplierMainDataVO();
                tempSupplier.setElsAccount(elsAccount);
                tempSupplier.setToElsAccount(toElsAccount);
                supplierMainDataVO = ((SupplierMainDataMapper)this.DALClientService.getMapper(elsAccount, SupplierMainDataMapper.class)).getSupplierByKey(tempSupplier);
                accountInfoVO = new AccountInfoVO();
                accountInfoVO.setEnterpriseVO(enterpriseVO);
                accountInfoVO.setAccountVO(accountVO);
                accountInfoVO.setSupplierMainDataVO(supplierMainDataVO);
                accountInfoVO.setSubAccountList(subAccountList);
                accountInfoVO.setSubAccountRoleList(subAccountRoleList);
                accountInfoVO.setAccountResourceList(accountResourceList);
                accountInfoVO.setAccountAppList(accountAppList);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
        }
        return Response.ok().entity(accountInfoVO).build();
    }
}

