/*
 * Decompiled with CFR 0.152.
 */
package com.els.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.async.SmsAsynTask;
import com.els.common.BaseVO;
import com.els.common.SysProperties;
import com.els.cxf.exception.BusinessException;
import com.els.dao.AccountMapper;
import com.els.dao.FacadeDataAccessMapper;
import com.els.enumerate.ResponseCodeEnum;
import com.els.remote.client.util.HttpInvokerClientServiceFactory;
import com.els.service.DALClientService;
import com.els.service.DataRuleService;
import com.els.service.ElsTransationService;
import com.els.service.impl.BaseServiceImpl;
import com.els.util.ExportExcel;
import com.els.util.SpringContextHelper;
import com.els.util.SqlHelper;
import com.els.util.SystemUtil;
import com.els.vo.DataRuleVO;
import com.els.vo.EnterpriseQueryVO;
import com.els.vo.SubAccountVO;
import com.els.web.filter.ContextFilter;
import java.beans.Introspector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

@Service
public class DALClientServiceImpl
extends BaseServiceImpl
implements DALClientService {
    private static final Logger logger = LoggerFactory.getLogger(DALClientServiceImpl.class);
    private static final String INIT_JSON = "initJson";
    private static final String ELSNOTNULL = "ELS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
    private static final String SQLVERIFY = "sqlVerify";
    private static final String FAILED = "\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a";
    public static final ThreadLocal<Map<String, String>> transactionMapping = new ThreadLocal();
    public static final ThreadLocal<Map<String, Integer>> startTime = new ThreadLocal();
    public static final ThreadLocal<Map<String, Integer>> commitTime = new ThreadLocal();
    @Autowired
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private AccountMapper accountMapper;

    public <T> T getMapper(String elsAccount, Class<T> mapperClass) throws Exception {
        String serviceUrl;
        if (elsAccount == null) {
            throw new RuntimeException(ELSNOTNULL);
        }
        if (this.isEnterpriseEdition() && SystemUtil.isNotEmpty((String)(serviceUrl = this.findServiceURL(this.getEnterpriseEls())))) {
            return this.getRemoteMapper(serviceUrl, mapperClass);
        }
        String mapperName = mapperClass.getSimpleName();
        mapperName = String.valueOf(mapperName.substring(0, 1).toLowerCase()) + mapperName.substring(1);
        return (T)SpringContextHelper.getBean((String)mapperName);
    }

    private boolean isEnterpriseEdition() {
        return SysProperties.INSTANCE.getSysProperties().get("enterpriseEls") != null;
    }

    private String getEnterpriseEls() {
        return SysProperties.INSTANCE.getSysProperties().get("enterpriseEls").toString();
    }

    public <T> T getMapper(String elsAccount, Class<T> mapperClass, BaseVO baseVO, String operateType) throws Exception {
        return this.getMapper(elsAccount, mapperClass);
    }

    public <T> T getMapper(String elsAccount, Class<T> mapperClass, BaseVO baseVO) throws Exception {
        return this.getMapper(elsAccount, mapperClass);
    }

    public static void main(String[] args) {
        String[] params = "result.age".split("\\.");
        System.out.println(params[0]);
        System.out.println(Introspector.decapitalize(ClassUtils.getShortName((String)DALClientServiceImpl.class.getName())));
    }

    public <T> T getRemoteMapper(String serviceUrl, Class<T> mapperClass) throws Exception {
        try {
            String serviceName = mapperClass.getSimpleName();
            if (transactionMapping.get() != null && serviceName.endsWith("Mapper")) {
                String threadId = String.valueOf(Thread.currentThread().getId());
                String transactionId = transactionMapping.get().get(String.valueOf(threadId) + "$" + serviceUrl);
                if (StringUtils.isNotBlank((String)transactionId)) {
                    serviceName = String.valueOf(serviceName) + "?transactionId=" + transactionId;
                }
            }
            if (!serviceUrl.startsWith("http")) {
                serviceUrl = "http://" + serviceUrl;
            }
            if (serviceUrl.indexOf("ELSDatalayer") > 0) {
                return (T)HttpInvokerClientServiceFactory.getService((String)(String.valueOf(serviceUrl) + "/remoteService/" + serviceName), mapperClass);
            }
            return (T)HttpInvokerClientServiceFactory.getService((String)(String.valueOf(serviceUrl) + "/ELSDatalayer/remoteService/" + serviceName), mapperClass);
        }
        catch (Exception e) {
            String msg = "\u8fdc\u7a0b\u8bbf\u95ee" + serviceUrl + "\u5f02\u5e38:" + e.getMessage();
            logger.info(msg);
            throw new RuntimeException(msg);
        }
    }

    public <T> T getMapper(Class<T> mapperClass) throws Exception {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        String elsAccount = (String)request.getSession().getAttribute("elsAccount");
        return this.getMapper(elsAccount, mapperClass);
    }

    public FacadeDataAccessMapper getFacadeDataAccessMapper(String elsAccount) throws Exception {
        if (elsAccount == null) {
            throw new RuntimeException(ELSNOTNULL);
        }
        String serviceUrl = this.findServiceURL(elsAccount);
        if (serviceUrl == null) {
            throw new Exception("\u8d26\u53f7\uff1a" + elsAccount + "\u6ca1\u6709\u914d\u7f6e\u8fdc\u7a0b\u8bbf\u95ee\u4f01\u4e1a\u670d\u52a1\u5668.");
        }
        return this.getRemoteMapper(serviceUrl, FacadeDataAccessMapper.class);
    }

    public void removeServiceUrl(String elsAccount) {
        this.removeServiceURL(elsAccount);
    }

    public Response queryBySql(EnterpriseQueryVO enterpriseQueryVO) {
        String sql;
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        if (request.getSession().getAttribute(SQLVERIFY) == null) {
            return this.getOkResponse(ResponseCodeEnum.SUCCESS.getValue(), "getVerify");
        }
        String sqlVerify = request.getSession().getAttribute(SQLVERIFY).toString();
        if (!"true".equals(sqlVerify)) {
            String verifyCode = enterpriseQueryVO.getVerifyCode();
            if (!sqlVerify.equals(verifyCode)) {
                return this.getOkResponse(ResponseCodeEnum.SUCCESS.getValue(), "verifyFail");
            }
            request.getSession().setAttribute(SQLVERIFY, (Object)"true");
        }
        if (!(sql = enterpriseQueryVO.getQuerySql().toLowerCase().trim()).startsWith("select")) {
            return this.getOkResponse(ResponseCodeEnum.SUCCESS.getValue(), "selectOnly");
        }
        try {
            String result = this.getFacadeDataAccessMapper(enterpriseQueryVO.getElsAccount()).bindDataToJson(enterpriseQueryVO.getQuerySql());
            return Response.ok((Object)result).build();
        }
        catch (Exception e) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), e.getMessage());
        }
    }

    public Response getVerifyCode() {
        String verifyCode = String.valueOf(new Random().nextInt(999999));
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        request.getSession().setAttribute(SQLVERIFY, (Object)verifyCode);
        SmsAsynTask smsAsyncTask = (SmsAsynTask)SpringContextHelper.getBean(SmsAsynTask.class);
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount("100000");
        subAccountVO.setElsSubAccount("1001");
        List lstData = this.accountMapper.findSubAccountByNumber(subAccountVO);
        HashMap<String, String> codeList = new HashMap<String, String>();
        codeList.put("code", verifyCode);
        for (SubAccountVO subAccount : lstData) {
            if (!StringUtils.isNotBlank((String)subAccount.getTelphone1())) continue;
            this.sendAliyun(subAccount.getTelphone1(), "SMS_106015021", codeList);
        }
        return Response.ok().build();
    }

    public Response exportExcel(EnterpriseQueryVO enterpriseQueryVO) {
        Response res = this.queryBySql(enterpriseQueryVO);
        if (res.getEntity() instanceof BaseVO) {
            return res;
        }
        String result = res.getEntity().toString();
        JSONArray jsonArray = JSONArray.parseArray((String)result);
        if (jsonArray.size() > 0) {
            ArrayList<String> headers = new ArrayList<String>();
            JSONObject json = jsonArray.getJSONObject(0);
            for (String key : json.keySet()) {
                headers.add(key);
            }
            String[] excelHead = headers.toArray(new String[headers.size()]);
            Properties pro = SysProperties.INSTANCE.getSysProperties();
            String fileSystemPath = pro.getProperty("fileSystemPath");
            File tempDir = new File(String.valueOf(fileSystemPath) + "/temp");
            if (!tempDir.exists()) {
                tempDir.mkdir();
            }
            String fileName = String.valueOf(String.valueOf(System.currentTimeMillis())) + ".xls";
            File temp = new File(String.valueOf(fileSystemPath) + "/temp/" + fileName);
            try {
                Throwable throwable = null;
                Object var14_16 = null;
                try (FileOutputStream out = new FileOutputStream(temp);){
                    boolean flag;
                    if (!temp.exists() && !(flag = temp.createNewFile())) {
                        logger.error("create new file failed");
                    }
                    ExportExcel ex = new ExportExcel();
                    ex.exportExcel("\u5bfc\u51fa\u6570\u636e", excelHead, excelHead, (List)jsonArray, (OutputStream)out);
                    BaseVO baseVO = new BaseVO();
                    baseVO.setUrlStr("temp/" + fileName);
                    ((OutputStream)out).close();
                    return this.getOkResponse(baseVO);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("\u5bfc\u51fa\u67e5\u8be2\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "\u5bfc\u51fa\u67e5\u8be2\u7ed3\u679c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_query_result_empty", "\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", new Object[0]));
    }

    public Object callMapperMethod(String elsAccount, Class<?> mapperClass, String methodName, Object ... args) throws Exception {
        Class<?> T;
        String sql;
        FacadeDataAccessMapper remoteMapper;
        String typeName;
        block20: {
            if (elsAccount == null) {
                throw new BusinessException(ELSNOTNULL);
            }
            String serviceUrl = this.findServiceURL(elsAccount);
            String mapperName = mapperClass.getSimpleName();
            mapperName = String.valueOf(mapperName.substring(0, 1).toLowerCase()) + mapperName.substring(1);
            Object t = SpringContextHelper.getBean((String)mapperName);
            if (serviceUrl == null) {
                try {
                    Method m = t.getClass().getMethod(methodName, DALClientServiceImpl.getMethodParamTypes(t, methodName));
                    return m.invoke(t, args);
                }
                catch (Exception e) {
                    logger.error(String.valueOf(elsAccount) + "\u8c03\u7528\u672c\u5730mapper[" + mapperClass.getSimpleName() + "]\u65b9\u6cd5" + methodName + FAILED + e.getCause().getMessage());
                    throw new Exception(String.valueOf(elsAccount) + "\u8c03\u7528\u672c\u5730mapper[" + mapperClass.getSimpleName() + "]\u65b9\u6cd5" + methodName + FAILED + e.getCause().getMessage());
                }
            }
            try {
                Method m = mapperClass.getMethod(methodName, DALClientServiceImpl.getMethodParamTypes(t, methodName));
                Type returnType = m.getGenericReturnType();
                typeName = returnType.toString();
                if (typeName.startsWith("class")) {
                    typeName = typeName.substring(6);
                }
                remoteMapper = this.getRemoteMapper(serviceUrl, FacadeDataAccessMapper.class);
                sql = SqlHelper.getMapperSql((SqlSessionFactory)this.sqlSessionFactory, (Object)t, (String)methodName, (Object[])args);
                if (args != null && args.length == 1) {
                    sql = this.addPermission(sql, args[0]);
                }
                logger.debug("\u8fdc\u7a0b\u6267\u884cSQL\uff1a" + sql);
                if (!"void".equals(typeName)) break block20;
                remoteMapper.executeSQL(sql);
                logger.debug("\u8fdc\u7a0b\u6267\u884cSQL\u66f4\u65b0\u6210\u529f");
                return null;
            }
            catch (Exception e) {
                logger.error(String.valueOf(elsAccount) + "\u8c03\u7528\u8fdc\u7a0bmapper[" + mapperClass.getSimpleName() + "]\u65b9\u6cd5" + methodName + FAILED + e.getMessage());
                throw new Exception(String.valueOf(elsAccount) + "\u8c03\u7528\u8fdc\u7a0bmapper[" + mapperClass.getSimpleName() + "]\u65b9\u6cd5" + methodName + FAILED + e.getMessage());
            }
        }
        boolean isList = false;
        if (typeName.indexOf("java.util.List") == 0) {
            typeName = typeName.substring(typeName.indexOf("<") + 1, typeName.lastIndexOf(">"));
            isList = true;
        }
        if ("int".equals(typeName)) {
            typeName = Integer.class.getName();
        } else if ("long".equals(typeName)) {
            typeName = Long.class.getName();
        } else if ("float".equals(typeName)) {
            typeName = Float.class.getName();
        }
        String resultJson = remoteMapper.bindDataToJson(sql);
        logger.debug("\u8fdc\u7a0b\u6267\u884cSQL\u67e5\u8be2\u6210\u529f\uff0c\u8fd4\u56de\uff1a" + resultJson);
        if (StringUtils.isBlank((String)resultJson)) {
            resultJson = "[]";
        }
        if (BaseVO.class.isAssignableFrom(T = Class.forName(typeName))) {
            List list = JSONArray.parseArray((String)resultJson, T);
            if (isList) {
                return list;
            }
            if (list.size() > 0) {
                return list.get(0);
            }
            return new ArrayList();
        }
        JSONArray list = JSONArray.parseArray((String)resultJson);
        if (list.size() > 0) {
            JSONObject obj = list.getJSONObject(0);
            Set keys = obj.keySet();
            return obj.get(keys.iterator().next());
        }
        return null;
    }

    private String addPermission(String sql, Object object) {
        Map parameterMap = SystemUtil.transBean2Map((Object)object);
        Iterator iter = parameterMap.entrySet().iterator();
        String elsAccount = "";
        String elsSubAccount = "";
        String permissionObject = "";
        String permissionObjectAlia = "";
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            if ("permissionObject".equals(key)) {
                permissionObject = (String)entry.getValue();
                continue;
            }
            if ("elsAccount".equals(entry.getKey())) {
                elsAccount = (String)entry.getValue();
                continue;
            }
            if ("elsSubAccount".equals(entry.getKey())) {
                elsSubAccount = (String)entry.getValue();
                continue;
            }
            if (!"permissionObjectAlia".equals(entry.getKey())) continue;
            permissionObjectAlia = (String)entry.getValue();
        }
        String appendSql = "";
        if (StringUtils.isNotBlank((String)permissionObject) && StringUtils.isNotBlank((String)elsAccount) && StringUtils.isNotBlank((String)elsSubAccount)) {
            DataRuleService dataRuleService = (DataRuleService)SpringContextHelper.getBean((String)"dataRuleServiceImpl");
            List lstRule = dataRuleService.getDataRule(elsAccount, elsSubAccount, permissionObject);
            StringBuffer sb = new StringBuffer();
            for (DataRuleVO dataRuleVO : lstRule) {
                sb.append(" ").append(dataRuleVO.getRuleSql());
            }
            appendSql = sb.toString().replaceAll("  ", " ");
            if (StringUtils.isNotBlank((String)appendSql) && StringUtils.isNotBlank((String)permissionObjectAlia)) {
                Pattern p = Pattern.compile("(AND|OR|\\()\\s([\\S]+)\\s(\\>=|=|\\<=|\\>|\\<|like)");
                Matcher m = p.matcher(appendSql);
                while (m.find()) {
                    appendSql = appendSql.replaceAll(" " + m.group(2) + " =", " " + permissionObjectAlia + "." + m.group(2) + " =").replaceAll(" " + m.group(2) + " >=", " " + permissionObjectAlia + "." + m.group(2) + " >=").replaceAll(" " + m.group(2) + " <=", " " + permissionObjectAlia + "." + m.group(2) + " <=").replaceAll(" " + m.group(2) + " >", " " + permissionObjectAlia + "." + m.group(2) + " >").replaceAll(" " + m.group(2) + " <", " " + permissionObjectAlia + "." + m.group(2) + " <").replaceAll(" " + m.group(2) + " like", " " + permissionObjectAlia + "." + m.group(2) + " like").replaceAll("\\{elsSubAccount\\}", elsSubAccount);
                }
            }
        }
        if (StringUtils.isNotBlank((String)appendSql)) {
            sql = this.packageSQL(sql, appendSql);
        }
        return sql;
    }

    private String packageSQL(String originalSql, String appendSQL) {
        int index1 = originalSql.lastIndexOf("where ");
        int index2 = originalSql.lastIndexOf("WHERE ");
        int index = -1;
        index = index1 >= index2 ? index1 : index2;
        if (index != -1) {
            originalSql = String.valueOf(originalSql.substring(0, index)) + "where 1=1 " + appendSQL + " and " + originalSql.substring(index + 5);
        }
        return originalSql;
    }

    private String removeSelectColumn(String sql, String column) {
        int secretIndex;
        int index;
        int whereIndex = sql.indexOf("where ");
        if (whereIndex <= (index = sql.indexOf("WHERE "))) {
            whereIndex = index;
        }
        if ((secretIndex = sql.indexOf(column)) > 0 && secretIndex < whereIndex) {
            String org1 = sql.substring(0, secretIndex).trim();
            String org2 = sql.substring(secretIndex + column.length()).trim();
            if (org1.lastIndexOf(",") != -1) {
                org1 = org1.substring(0, org1.lastIndexOf(","));
            } else if (org1.endsWith(".")) {
                org1 = org1.substring(0, org1.lastIndexOf(" "));
                if (org2.startsWith(",")) {
                    org2 = org2.substring(1);
                }
            }
            sql = String.valueOf(org1) + " " + org2;
        }
        return sql;
    }

    public static Class[] getMethodParamTypes(Object classInstance, String methodName) throws ClassNotFoundException {
        Class[] paramTypes = null;
        Method[] methods = classInstance.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                Class<?>[] params = methods[i].getParameterTypes();
                paramTypes = new Class[params.length];
                int j = 0;
                while (j < params.length) {
                    paramTypes[j] = Class.forName(params[j].getName());
                    ++j;
                }
                break;
            }
            ++i;
        }
        return paramTypes;
    }

    public <T> T getRemoteService(String serviceUrl, String serviceName, Class<T> serviceClass) throws Exception {
        try {
            String transactionId;
            if (transactionMapping.get() != null && serviceName.endsWith("Mapper") && StringUtils.isNotBlank((String)(transactionId = transactionMapping.get().get(serviceUrl)))) {
                serviceName = String.valueOf(serviceName) + "?transactionId=" + transactionId;
            }
            return (T)HttpInvokerClientServiceFactory.getService((String)("http://" + serviceUrl + "/ELSDatalayer/remoteService/" + serviceName), serviceClass);
        }
        catch (Exception e) {
            String msg = "\u8fdc\u7a0b\u8bbf\u95ee" + serviceUrl + "\u5f02\u5e38:" + e.getMessage();
            logger.info(msg);
            throw new RuntimeException(msg);
        }
    }

    public void startTransaction(String elsAccount) throws Exception {
        String serviceUrl = this.findServiceURL(elsAccount);
        if (StringUtils.isNotBlank((String)serviceUrl) && this.isEnterpriseEdition()) {
            String transactionId;
            String threadId = String.valueOf(Thread.currentThread().getId());
            if (transactionMapping.get() == null) {
                transactionMapping.set(new HashMap());
                startTime.set(new HashMap());
                commitTime.set(new HashMap());
                commitTime.get().put(String.valueOf(threadId) + "$" + serviceUrl, 0);
            }
            if (StringUtils.isBlank((String)(transactionId = transactionMapping.get().get(String.valueOf(threadId) + "$" + serviceUrl)))) {
                transactionId = this.getRemoteMapper(serviceUrl, ElsTransationService.class).startTransation();
                transactionMapping.get().put(String.valueOf(threadId) + "$" + serviceUrl, transactionId);
                startTime.get().put(String.valueOf(threadId) + "$" + serviceUrl, 1);
            } else {
                startTime.get().put(String.valueOf(threadId) + "$" + serviceUrl, startTime.get().get(String.valueOf(threadId) + "$" + serviceUrl) + 1);
            }
        }
    }

    public void commitTransaction(String elsAccount) throws Exception {
        String serviceUrl = this.findServiceURL(elsAccount);
        if (StringUtils.isNotBlank((String)serviceUrl) && this.isEnterpriseEdition()) {
            String threadId = String.valueOf(Thread.currentThread().getId());
            String transactionId = transactionMapping.get().get(String.valueOf(threadId) + "$" + serviceUrl);
            if (StringUtils.isNotBlank((String)transactionId)) {
                Integer start = startTime.get().get(String.valueOf(threadId) + "$" + serviceUrl);
                if (start == 1) {
                    this.getRemoteMapper(serviceUrl, ElsTransationService.class).commitTransation(transactionId);
                    transactionMapping.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                    startTime.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                    commitTime.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                } else {
                    Integer commit = commitTime.get().get(String.valueOf(threadId) + "$" + serviceUrl) + 1;
                    if (start.equals(commit)) {
                        this.getRemoteMapper(serviceUrl, ElsTransationService.class).commitTransation(transactionId);
                        transactionMapping.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                        startTime.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                        commitTime.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                    } else {
                        commitTime.get().put(String.valueOf(threadId) + "$" + serviceUrl, commit);
                    }
                }
            }
        }
    }

    public void rollbackTransaction(String elsAccount) {
        String serviceUrl = this.findServiceURL(elsAccount);
        if (StringUtils.isNotBlank((String)serviceUrl) && this.isEnterpriseEdition()) {
            if (transactionMapping.get() == null) {
                transactionMapping.set(new HashMap());
                startTime.set(new HashMap());
                commitTime.set(new HashMap());
            }
            String threadId = String.valueOf(Thread.currentThread().getId());
            String transactionId = transactionMapping.get().get(String.valueOf(threadId) + "$" + serviceUrl);
            if (StringUtils.isNotBlank((String)transactionId)) {
                try {
                    this.getRemoteMapper(serviceUrl, ElsTransationService.class).rollbackTransation(transactionId);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                transactionMapping.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                startTime.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
                commitTime.get().remove(String.valueOf(threadId) + "$" + serviceUrl);
            }
        }
    }

    public <T> T getLocalMapper(Class<T> mapperClass) {
        String mapperName = mapperClass.getSimpleName();
        mapperName = String.valueOf(mapperName.substring(0, 1).toLowerCase()) + mapperName.substring(1);
        return (T)SpringContextHelper.getBean((String)mapperName);
    }
}

