/*
 * Decompiled with CFR 0.152.
 */
package com.els.service.impl;

import com.els.common.BaseVO;
import com.els.cxf.exception.BusinessException;
import com.els.dao.AccountAgentMapper;
import com.els.dao.AccountMapper;
import com.els.dao.ElsAppGroupMapper;
import com.els.dao.ElsAppRelationMapper;
import com.els.dao.RoleAppMapper;
import com.els.enumerate.ResponseCodeEnum;
import com.els.service.AuditService;
import com.els.service.DALClientService;
import com.els.service.ElsAppGroupService;
import com.els.service.impl.BaseServiceImpl;
import com.els.vo.AccountAgentVO;
import com.els.vo.AuditResultVO;
import com.els.vo.ElsAppGroupVO;
import com.els.vo.ElsAppRelationVO;
import com.els.vo.PageListVO;
import com.els.vo.RoleAppVO;
import com.els.vo.SubAccountVO;
import com.els.web.filter.ContextFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsAppGroupServiceImpl
extends BaseServiceImpl
implements ElsAppGroupService {
    private static final Logger logger = LoggerFactory.getLogger(ElsAppGroupServiceImpl.class);
    @Autowired
    private DALClientService dalClientService;
    @Autowired
    private AuditService auditService;
    private final String AUDIT_KEY = "elsAppGroup";
    private final String PASSERROR = "\u5ba1\u6279\u901a\u8fc7\u5f02\u5e38\uff1a";
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    private AccountAgentMapper accountAgentMapper;
    @Autowired
    private ElsAppRelationMapper elsAppRelationMapper;
    @Autowired
    private ElsAppGroupMapper elsAppGroupMapper;
    @Autowired
    private RoleAppMapper roleAppMapper;

    @Transactional
    public Response saveElsAppGroup(ElsAppGroupVO record) {
        boolean isNew = true;
        if (StringUtils.isNotBlank((CharSequence)record.getGroupCode())) {
            isNew = false;
        }
        try {
            if (isNew) {
                ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).replace((Object)record);
            } else {
                ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).updateSelective((Object)record);
            }
            if (!isNew) {
                ElsAppRelationVO elsAppRelationVO = new ElsAppRelationVO();
                elsAppRelationVO.setGroupCode(record.getGroupCode());
                ((ElsAppRelationMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppRelationMapper.class)).deleteBatch((Object)elsAppRelationVO);
            }
            if (record.getLstElsAppRelation().size() > 0) {
                for (ElsAppRelationVO itemVO : record.getLstElsAppRelation()) {
                    itemVO.setGroupCode(record.getGroupCode());
                }
                ((ElsAppRelationMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppRelationMapper.class)).insertBatch(record.getLstElsAppRelation());
            }
        }
        catch (Exception e) {
            logger.error(String.valueOf(record.getElsAccount()) + "\u4fdd\u5b58ElsAppGroup\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u4fdd\u5b58\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return Response.ok((Object)record).build();
    }

    public Response queryElsAppGroup(ElsAppGroupVO record) {
        PageListVO pageListVO = new PageListVO();
        try {
            int total = ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).count((Object)record);
            List lstVO = total > 0 ? ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).list((Object)record) : new ArrayList();
            pageListVO.setRows(lstVO);
            pageListVO.setTotal(total);
        }
        catch (Exception e) {
            logger.error(String.valueOf(record.getElsAccount()) + "\u67e5\u8be2ElsAppGroup\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return Response.ok((Object)pageListVO).build();
    }

    public Response readElsAppGroup(ElsAppGroupVO record) {
        record = this.getElsAppGroup(record);
        return Response.ok((Object)record).build();
    }

    private ElsAppGroupVO getElsAppGroup(ElsAppGroupVO record) {
        try {
            record = (ElsAppGroupVO)((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).read((Object)record);
            ElsAppRelationVO elsAppRelationVO = new ElsAppRelationVO();
            elsAppRelationVO.setGroupCode(record.getGroupCode());
            elsAppRelationVO.setPageSize(Integer.MAX_VALUE);
            List lstElsAppRelation = ((ElsAppRelationMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppRelationMapper.class)).list((Object)elsAppRelationVO);
            record.setLstElsAppRelation(lstElsAppRelation);
            return record;
        }
        catch (Exception e) {
            logger.error(String.valueOf(record.getElsAccount()) + "\u8bfb\u53d6ElsAppGroup\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u8bfb\u53d6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Transactional
    public Response delElsAppGroup(ElsAppGroupVO record) {
        try {
            ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).delete((Object)record);
            ElsAppRelationVO elsAppRelationVO = new ElsAppRelationVO();
            elsAppRelationVO.setGroupCode(record.getGroupCode());
            ((ElsAppRelationMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppRelationMapper.class)).deleteBatch((Object)elsAppRelationVO);
        }
        catch (Exception e) {
            logger.error(String.valueOf(record.getElsAccount()) + "\u5220\u9664ElsAppGroup\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return Response.ok((Object)record).build();
    }

    @Transactional
    public Response entryElsAppGroup(ElsAppGroupVO record) {
        try {
            this.saveElsAppGroup(record);
            String desc = "";
            AuditResultVO auditResultVO = this.auditService.sendAuditPass(record.getElsAccount(), "elsAppGroup", record.getGroupCode(), record.getElsAccount(), record.getElsSubAccount(), (Object)record, desc);
            if (auditResultVO.getStatus() != 200) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), auditResultVO.getMessage());
            }
            ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).updateSelective((Object)record);
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u63d0\u4ea4\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u5ba1\u6279\u63d0\u4ea4\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return Response.ok((Object)record).build();
    }

    @Transactional
    public Response cancelAuditElsAppGroup(ElsAppGroupVO record) {
        AuditResultVO auditResultVO = this.auditService.cancelAuditIncludePass(record.getElsAccount(), "elsAppGroup", record.getGroupCode(), "Y", "0", record.getElsAccount(), record.getElsSubAccount());
        if (auditResultVO.getStatus() != 200) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), auditResultVO.getMessage());
        }
        try {
            ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).updateSelective((Object)record);
        }
        catch (Exception e) {
            logger.error("\u64a4\u9500\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("\u64a4\u9500\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
        }
        return this.getOkResponse((BaseVO)record);
    }

    @Transactional
    public Response sendElsAppGroupPass(ElsAppGroupVO record) {
        try {
            if (!this.auditService.checkAuditRight(record.getElsAccount(), record.getElsSubAccount(), record.getElsAccount(), "elsAppGroup", record.getGroupCode())) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_audit_noauthority", "\u60a8\u6ca1\u6709\u5ba1\u6279\u6743\u9650!", new Object[0]));
            }
            AuditResultVO auditResultVO = this.auditService.sendAuditPass(record.getElsAccount(), "elsAppGroup", record.getGroupCode(), record.getElsAccount(), record.getElsSubAccount(), (Object)record, "\u5ba1\u6279\u901a\u8fc7");
            if (auditResultVO.getStatus() != 200) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), auditResultVO.getMessage());
            }
            ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).updateSelective((Object)record);
            return Response.ok((Object)record).build();
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u901a\u8fc7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Transactional
    public Response sendElsAppGroupNoPass(ElsAppGroupVO record) {
        try {
            if (!this.auditService.checkAuditRight(record.getElsAccount(), record.getElsSubAccount(), record.getElsAccount(), "elsAppGroup", record.getGroupCode())) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_audit_noauthority", "\u60a8\u6ca1\u6709\u5ba1\u6279\u6743\u9650!", new Object[0]));
            }
            AuditResultVO auditResultVO = this.auditService.sendAuditNoPass(record.getElsAccount(), "elsAppGroup", record.getGroupCode(), "Y", "", record.getElsAccount(), record.getElsSubAccount(), (Object)record);
            if (auditResultVO.getStatus() != 200) {
                return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), auditResultVO.getMessage());
            }
            ((ElsAppGroupMapper)this.dalClientService.getMapper(record.getElsAccount(), ElsAppGroupMapper.class)).updateSelective((Object)record);
            return Response.ok((Object)record).build();
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u901a\u8fc7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Response findAuditStretegy(ElsAppGroupVO record) {
        PageListVO pageListVO = new PageListVO();
        List lstStretegy = this.auditService.getAuditStretegy(record.getElsAccount(), "elsAppGroup", (Object)record);
        if (lstStretegy == null || lstStretegy.size() <= 0) {
            return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), this.getI18n("i18n_alert_nosuitStretegy", "\u627e\u4e0d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5ba1\u6279\u7b56\u7565", new Object[0]));
        }
        pageListVO.setRows(lstStretegy);
        pageListVO.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
        return Response.ok((Object)pageListVO).build();
    }

    public Response findMenu(String elsAccount, String elsSubAccount) {
        List<ElsAppGroupVO> lstData = new ArrayList();
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount(elsAccount);
        subAccountVO.setElsSubAccount(elsSubAccount);
        RoleAppVO roleApp = new RoleAppVO();
        roleApp.setElsAccount(elsAccount);
        roleApp.setElsSubAccount(elsSubAccount);
        List list = this.accountMapper.findSubAccountByNumber(subAccountVO);
        if (list.size() <= 0) {
            throw new BusinessException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        subAccountVO = (SubAccountVO)list.get(0);
        String isAdmin = subAccountVO.getIsAdmin();
        List roleList = this.roleAppMapper.getAccountInfoByElsAccount(roleApp);
        if (roleList != null) {
            String roleCodes = "";
            int i = 0;
            while (i < roleList.size()) {
                roleCodes = String.valueOf(roleCodes) + ((RoleAppVO)roleList.get(i)).getRoleCode() + ",";
                ++i;
            }
            if (!"540000".equals(elsAccount) && !"Y".equals(isAdmin) && roleCodes.contains("saleContact")) {
                return Response.ok(this.getAppMenu(roleApp)).build();
            }
        }
        RoleAppVO roleAppVO = new RoleAppVO();
        roleAppVO.setElsAccount(elsAccount);
        roleAppVO.setElsSubAccount(elsSubAccount);
        roleAppVO.setRoleCode(subAccountVO.getStation());
        if (StringUtils.isBlank((CharSequence)roleAppVO.getFbk5())) {
            roleAppVO.setFbk5("NPS");
        }
        ElsAppRelationVO queryVO = new ElsAppRelationVO();
        queryVO.setElsAccount(elsAccount);
        int count = this.elsAppRelationMapper.count((Object)queryVO);
        roleAppVO.setQueryId(Integer.valueOf(count));
        String url = ((HttpServletRequest)ContextFilter.context.get()).getRequestURI();
        url = url.substring(0, url.indexOf("/", 1));
        roleAppVO.setUrlStr(url);
        lstData = "Y".equals(isAdmin) ? this.elsAppGroupMapper.getCompanyAllAppList(roleAppVO) : this.elsAppGroupMapper.getUserAllAppList(roleAppVO);
        AccountAgentVO agentVo = new AccountAgentVO();
        agentVo.setElsAccount(roleAppVO.getElsAccount());
        agentVo.setAgentSubAccount(roleAppVO.getElsSubAccount());
        List agentVos = this.accountAgentMapper.queryAccountAgent(agentVo);
        for (AccountAgentVO vo : agentVos) {
            RoleAppVO subAccountAgentVo = new RoleAppVO();
            subAccountAgentVo.setElsAccount(vo.getElsAccount());
            subAccountAgentVo.setElsSubAccount(vo.getElsSubAccount());
            if ("Y".equals(vo.getIsAdmin())) {
                lstData = this.elsAppGroupMapper.getCompanyAllAppList(subAccountAgentVo);
                break;
            }
            List temData = this.elsAppGroupMapper.getUserAllAppList(subAccountAgentVo);
            for (ElsAppGroupVO tmp : temData) {
                if (lstData.contains(tmp)) continue;
                lstData.add(tmp);
            }
        }
        HashMap<String, ElsAppGroupVO> groupMap = new HashMap<String, ElsAppGroupVO>();
        for (ElsAppGroupVO appGroup : lstData) {
            appGroup.setGroupName(this.getI18n(appGroup.getGroupKey(), appGroup.getGroupName(), new Object[0]));
            groupMap.put(appGroup.getGroupCode(), appGroup);
        }
        List<RoleAppVO> roleAppVoList = this.getAllAppListByGroupCode(roleAppVO);
        for (RoleAppVO app : roleAppVoList) {
            if (!groupMap.containsKey(app.getGroupCode())) continue;
            ((ElsAppGroupVO)groupMap.get(app.getGroupCode())).getLstApp().add(app);
        }
        return Response.ok(lstData).build();
    }

    public List<RoleAppVO> getAllAppListByGroupCode(RoleAppVO roleAppVO) {
        List<RoleAppVO> lstData = new ArrayList();
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount(roleAppVO.getElsAccount());
        subAccountVO.setElsSubAccount(roleAppVO.getElsSubAccount());
        List list = this.accountMapper.findSubAccountByNumber(subAccountVO);
        if (list.size() <= 0) {
            logger.error("\u8be5\u8d26\u53f7\u4e0d\u5b58\u5728\u5f02\u5e38(\u65b9\u6cd5\uff1agetAllAppList)");
            return null;
        }
        subAccountVO = (SubAccountVO)list.get(0);
        String isAdmin = subAccountVO.getIsAdmin();
        roleAppVO.setRoleCode(subAccountVO.getStation());
        String url = ((HttpServletRequest)ContextFilter.context.get()).getRequestURI();
        url = url.substring(0, url.indexOf("/", 1));
        roleAppVO.setUrlStr(url);
        if (StringUtils.isBlank((CharSequence)roleAppVO.getFbk5())) {
            roleAppVO.setFbk5("NPS");
        }
        lstData = "Y".equals(isAdmin) ? this.roleAppMapper.getCompanyAllAppListByGroupCode(roleAppVO) : ("540001".equals(roleAppVO.getFbk1()) ? this.roleAppMapper.getCopyAppList(roleAppVO) : this.roleAppMapper.getUserAllAppListByGroupCode(roleAppVO));
        AccountAgentVO agentVo = new AccountAgentVO();
        agentVo.setElsAccount(roleAppVO.getElsAccount());
        agentVo.setAgentSubAccount(roleAppVO.getElsSubAccount());
        List agentVos = this.accountAgentMapper.queryAccountAgent(agentVo);
        for (AccountAgentVO vo : agentVos) {
            RoleAppVO subAccountAgentVo = new RoleAppVO();
            subAccountAgentVo.setElsAccount(vo.getElsAccount());
            subAccountAgentVo.setElsSubAccount(vo.getElsSubAccount());
            if ("Y".equals(vo.getIsAdmin())) {
                lstData = this.roleAppMapper.getCompanyAllAppListByGroupCode(subAccountAgentVo);
                break;
            }
            List temData = this.roleAppMapper.getUserAllAppListByGroupCode(subAccountAgentVo);
            for (RoleAppVO appVo : temData) {
                if (appVo.getAppCode() == null || !this.isNotExisRole(lstData, appVo)) continue;
                lstData.add(appVo);
            }
        }
        for (RoleAppVO roleApp : lstData) {
            String name = roleApp.getAppName();
            String[] attr = name.split(":");
            name = attr.length == 2 ? this.getI18n(attr[0], attr[1], new Object[0]) : this.getI18n("", attr[0], new Object[0]);
            roleApp.setAppName(name);
        }
        return lstData;
    }

    private boolean isNotExisRole(List<RoleAppVO> lst, RoleAppVO vo) {
        for (RoleAppVO role : lst) {
            if (role.getAppCode() == null || !role.getAppCode().equals(vo.getAppCode())) continue;
            return false;
        }
        return true;
    }

    public Response findAllGroup(String elsAccount, String elsSubAccount) {
        List<ElsAppGroupVO> lstData = new ArrayList();
        SubAccountVO subAccountVO = new SubAccountVO();
        subAccountVO.setElsAccount(elsAccount);
        subAccountVO.setElsSubAccount(elsSubAccount);
        List list = this.accountMapper.findSubAccountByNumber(subAccountVO);
        if (list.size() <= 0) {
            throw new BusinessException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        subAccountVO = (SubAccountVO)list.get(0);
        String isAdmin = subAccountVO.getIsAdmin();
        RoleAppVO roleAppVO = new RoleAppVO();
        roleAppVO.setElsAccount(elsAccount);
        roleAppVO.setElsSubAccount(elsSubAccount);
        roleAppVO.setRoleCode(subAccountVO.getStation());
        if (StringUtils.isBlank((CharSequence)roleAppVO.getFbk5())) {
            roleAppVO.setFbk5("NPS");
        }
        ElsAppRelationVO queryVO = new ElsAppRelationVO();
        queryVO.setElsAccount(elsAccount);
        int count = this.elsAppRelationMapper.count((Object)queryVO);
        roleAppVO.setQueryId(Integer.valueOf(count));
        String url = ((HttpServletRequest)ContextFilter.context.get()).getRequestURI();
        url = url.substring(0, url.indexOf("/", 1));
        roleAppVO.setUrlStr(url);
        lstData = "Y".equals(isAdmin) ? this.elsAppGroupMapper.getCompanyAllAppList(roleAppVO) : this.elsAppGroupMapper.getUserAllAppList(roleAppVO);
        AccountAgentVO agentVo = new AccountAgentVO();
        agentVo.setElsAccount(roleAppVO.getElsAccount());
        agentVo.setAgentSubAccount(roleAppVO.getElsSubAccount());
        List agentVos = this.accountAgentMapper.queryAccountAgent(agentVo);
        for (AccountAgentVO vo : agentVos) {
            RoleAppVO subAccountAgentVo = new RoleAppVO();
            subAccountAgentVo.setElsAccount(vo.getElsAccount());
            subAccountAgentVo.setElsSubAccount(vo.getElsSubAccount());
            if ("Y".equals(vo.getIsAdmin())) {
                lstData = this.elsAppGroupMapper.getCompanyAllAppList(subAccountAgentVo);
                break;
            }
            List temData = this.elsAppGroupMapper.getUserAllAppList(subAccountAgentVo);
            for (ElsAppGroupVO tmp : temData) {
                if (lstData.contains(tmp)) continue;
                lstData.add(tmp);
            }
        }
        for (ElsAppGroupVO appGroup : lstData) {
            appGroup.setGroupName(this.getI18n(appGroup.getGroupKey(), appGroup.getGroupName(), new Object[0]));
        }
        return Response.ok(lstData).build();
    }

    public List<ElsAppGroupVO> getAppMenu(RoleAppVO roleAppVO) {
        roleAppVO.setFbk1("540001");
        List lstData = this.elsAppGroupMapper.selectSaleConcts(roleAppVO);
        HashMap<String, ElsAppGroupVO> groupMap = new HashMap<String, ElsAppGroupVO>();
        for (ElsAppGroupVO appGroup : lstData) {
            appGroup.setGroupName(this.getI18n(appGroup.getGroupKey(), appGroup.getGroupName(), new Object[0]));
            groupMap.put(appGroup.getGroupCode(), appGroup);
        }
        roleAppVO.setElsSubAccount("1002");
        List<RoleAppVO> roleAppVoList = this.getAllAppListByGroupCode(roleAppVO);
        for (RoleAppVO app : roleAppVoList) {
            if (!groupMap.containsKey(app.getGroupCode())) continue;
            ((ElsAppGroupVO)groupMap.get(app.getGroupCode())).getLstApp().add(app);
        }
        return lstData;
    }
}

