/*
 * Decompiled with CFR 0.152.
 */
package com.els.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.BaseVO;
import com.els.common.SysProperties;
import com.els.dao.AccountColumnMapper;
import com.els.dao.AppMapper;
import com.els.dao.I18nMapper;
import com.els.dao.RedisClusterDao;
import com.els.dao.TableColumnMapper;
import com.els.enumerate.LanguageEnum;
import com.els.enumerate.LanguageMapEnum;
import com.els.enumerate.ResponseCodeEnum;
import com.els.service.I18nService;
import com.els.util.ExportExcel;
import com.els.util.HanyuPinyinHelper;
import com.els.util.SystemUtil;
import com.els.util.TranslateUtilBD;
import com.els.vo.AppVO;
import com.els.vo.I18nTableColumnVO;
import com.els.vo.I18nVO;
import com.els.vo.PageListVO;
import com.els.vo.TableColumnVO;
import com.els.vo.TableVO;
import com.els.web.filter.ContextFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class I18nServiceImpl
implements I18nService {
    private static Properties I18NCONFIG;
    private static String enviroment;
    private static String i18nInit;
    private static String i18nIgnore;
    private static String clearI18nCache_elsAccounts;
    private static final String CREATEUSER = "WangBintao";
    private static final String CHINESSSIMPLEQQT = "zh_cn";
    private static final String CHINESSCOMPLEXQQT = "zh_tw";
    private static final String I18N = "i18n_";
    private static final String TRANS = "Trans";
    private static final Logger logger;
    private Map<String, Map<String, Response>> mutiLanguageCacheMap = new ConcurrentHashMap<String, Map<String, Response>>();
    private Map<String, Map<String, Response>> elsCacheMap = new ConcurrentHashMap<String, Map<String, Response>>();
    @Autowired
    private I18nMapper i18nMapper;
    @Autowired
    private TableColumnMapper tableColumnMapper;
    @Autowired
    private AccountColumnMapper accountColumnMapper;
    @Autowired
    private AppMapper appMapper;
    private static final String I18NRESOURCE_KEY = "i18n_resource_key#";
    private final RedisClusterDao redisDao = new RedisClusterDao();

    static {
        logger = LoggerFactory.getLogger(I18nServiceImpl.class);
        try {
            I18NCONFIG = SysProperties.INSTANCE.getProperties("i18nInit.properties");
            enviroment = I18NCONFIG.getProperty("run_environment");
            i18nInit = I18NCONFIG.getProperty("i18nInit");
            i18nIgnore = I18NCONFIG.getProperty("i18nIgnore");
            clearI18nCache_elsAccounts = I18NCONFIG.getProperty("clearI18nCache_elsAccounts");
        }
        catch (Exception e) {
            System.out.println("resource\u4e0b\u7f3a\u5c11i18nInit.properties\u914d\u7f6e\u6587\u4ef6\uff0c\u5982\u679c\u65e0\u9700\u7528\u5230\u56fd\u9645\u5316\u53ef\u5ffd\u7565");
        }
    }

    public static Properties getI18NCONFIG() {
        return I18NCONFIG;
    }

    public static void setI18NCONFIG(Properties i18n_CONFIG) {
        I18NCONFIG = i18n_CONFIG;
    }

    public static String getEnviroment() {
        return enviroment;
    }

    public static void setEnviroment(String enviroment) {
        I18nServiceImpl.enviroment = enviroment;
    }

    public static String getI18nInit() {
        return i18nInit;
    }

    public static void setI18nInit(String i18nInit) {
        I18nServiceImpl.i18nInit = i18nInit;
    }

    public static String getI18nIgnore() {
        return i18nIgnore;
    }

    public static void setI18nIgnore(String i18nIgnore) {
        I18nServiceImpl.i18nIgnore = i18nIgnore;
    }

    public void setLanguage(String language) {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        HttpSession session = request.getSession();
        Locale locale = (Locale)LanguageMapEnum.FRONTTOLOCALEMAP.getLanguage(language);
        LanguageEnum languageEnum = (LanguageEnum)LanguageMapEnum.FRONTTOSYSTEMMAP.getLanguage(language);
        session.setAttribute("language", (Object)languageEnum.getValue());
        session.setAttribute("languageName", (Object)languageEnum.getValue());
        session.setAttribute("Locale", (Object)locale);
        Locale.setDefault(locale);
        try {
            Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(language);
            if (cacheMap == null) {
                new Thread(new I18nCacheLoad(language)).start();
            } else {
                Response response = cacheMap.get(this.createMutiLanguageLoadTag(language));
                if (response == null) {
                    new Thread(new I18nCacheLoad(language)).start();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void putMutiLanguageCacheMap(List<I18nVO> i18nVOS, String language) {
        if (i18nVOS == null || i18nVOS.size() < 1) {
            return;
        }
        Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(language);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, Response>();
        } else {
            cacheMap.clear();
        }
        String cachekey = null;
        for (I18nVO i18nVO1 : i18nVOS) {
            cachekey = this.createCacheMapKey(i18nVO1.getKey(), language);
            cacheMap.put(cachekey, this.getOkResponse((BaseVO)i18nVO1));
        }
        cacheMap.put(this.createMutiLanguageLoadTag(language), this.getOkResponse(new BaseVO()));
        this.mutiLanguageCacheMap.put(language, cacheMap);
    }

    private String createMutiLanguageLoadTag(String language) {
        return String.valueOf(language) + "i18nMutilanguageLoad";
    }

    private String createCacheMapKey(String key, String language) {
        return "i18nkey_" + language + key;
    }

    public String getLanguage() {
        return (String)((HttpServletRequest)ContextFilter.context.get()).getSession().getAttribute("language");
    }

    public String getResource(String key, String language) {
        Response res = this.getResourceByKey(key, language);
        Object obj = res.getEntity();
        if (obj instanceof I18nVO) {
            return ((I18nVO)obj).getValue();
        }
        return "";
    }

    public Response getResourceByKey(String key, String language) {
        String cachekey = this.createCacheMapKey(key, language);
        Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(language);
        if (cacheMap != null && cacheMap.get(cachekey) != null) {
            return cacheMap.get(cachekey);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("language", language);
        List list = this.i18nMapper.getResourceByKey(map);
        if (list != null && list.size() > 0) {
            Response response = this.getOkResponse((BaseVO)list.get(0));
            if (cacheMap != null) {
                cacheMap.put(cachekey, response);
            }
            return response;
        }
        return this.getErrorResponse(ResponseCodeEnum.FAIL.getValue(), "No In18 Resource found");
    }

    public Response getResourceByKey(String key) {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        Object obj = request.getSession().getAttribute("language");
        String language = LanguageEnum.CN.getValue();
        if (obj != null) {
            language = (String)obj;
        }
        return this.getResourceByKey(key, language);
    }

    public DataHandler downloadTemplate(String elsAccount, String key, String language) {
        DataHandler fileDataHandler = null;
        ExportExcel ex = new ExportExcel();
        if ((key = key.trim()).equals("-")) {
            key = "";
        }
        if ((language = language.trim()).equals("-")) {
            language = "";
        }
        I18nVO i18vo = new I18nVO();
        i18vo.setElsAccount(elsAccount);
        i18vo.setKey(key);
        i18vo.setLanguage(language);
        List list = this.i18nMapper.findI18nKeyContent(i18vo);
        String[] headers = new String[]{"\u8bed\u8a00", "\u8d44\u6e90key", "\u8d44\u6e90key\u503c", "\u8d44\u6e90type"};
        String[] fieldNames = new String[]{"language", "key", "value", "resourceType"};
        try {
            String path = ((HttpServletRequest)ContextFilter.context.get()).getRealPath("/");
            String fileName = "multilingual.xls";
            File temp = new File(String.valueOf(path) + fileName);
            FileOutputStream out = new FileOutputStream(temp);
            ex.exportExcel("\u591a\u8bed\u8a00\u6a21\u677f", headers, fieldNames, (Collection)list, (OutputStream)out);
            ((OutputStream)out).close();
            FileDataSource dataSource = new FileDataSource(temp);
            fileDataHandler = new DataHandler((DataSource)dataSource);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException("\u591a\u8bed\u8a00\u6a21\u677f");
        }
        return fileDataHandler;
    }

    public Response saveResource(I18nVO i18nVO) {
        this.i18nMapper.insertResource(i18nVO);
        this.redisDao.del(I18NRESOURCE_KEY + i18nVO.getLanguage());
        return this.getOkResponse((BaseVO)i18nVO);
    }

    public Response updateResource(I18nVO i18nVO) {
        String cachekey = this.createCacheMapKey(i18nVO.getKey(), i18nVO.getLanguage());
        Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(i18nVO.getLanguage());
        if (cacheMap != null) {
            cacheMap.remove(cachekey);
        }
        this.i18nMapper.updateResource(i18nVO);
        this.redisDao.del(I18NRESOURCE_KEY + i18nVO.getLanguage());
        return this.getOkResponse((BaseVO)i18nVO);
    }

    public Response findI18nKeyContent(I18nVO i18nVO) {
        String cachekey = this.createCacheMapKey(i18nVO.getKey(), i18nVO.getLanguage());
        Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(i18nVO.getLanguage());
        if (cacheMap != null) {
            cacheMap.remove(cachekey);
        }
        List list = this.i18nMapper.findI18nKeyList(i18nVO);
        int count = this.i18nMapper.findI18nKeyListCount(i18nVO);
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(list);
        pageListVO.setTotal(count);
        return Response.ok((Object)pageListVO).build();
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public Response saveI18nList(List<I18nVO> list) {
        try {
            for (I18nVO i18n : list) {
                List findList = this.i18nMapper.findI18nKeyContent(i18n);
                if (findList != null && findList.size() > 0) continue;
                this.i18nMapper.insertResource(i18n);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getMessage());
            throw new RuntimeException("Save I18nList Exception.Details: " + e.getMessage());
        }
        return this.getOkResponse(new BaseVO());
    }

    public void deleteResourceByKey(String key, String language) {
        String cachekey = this.createCacheMapKey(key, language);
        Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(language);
        if (cacheMap != null) {
            cacheMap.remove(cachekey);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("language", language);
        this.i18nMapper.deleteResourceByKey(map);
        this.redisDao.del(I18NRESOURCE_KEY + language);
    }

    /*
     * Unable to fully structure code
     */
    public Response getAllResource(I18nVO i18nVO) {
        block5: {
            if (i18nVO.getLanguage() == null || i18nVO.getLanguage() == "") {
                request = (HttpServletRequest)ContextFilter.context.get();
                language = (String)request.getSession().getAttribute("language");
                i18nVO.setLanguage(language);
            }
            try {
                i18nMap = (HashMap<String, String>)this.redisDao.get("i18n_resource_key#" + i18nVO.getLanguage(), Map.class);
                if (i18nMap != null && !i18nMap.isEmpty()) break block5;
                i18nVOs = this.i18nMapper.getAllResourceByLanguage(i18nVO);
                i18nMap = new HashMap<K, V>();
                for (I18nVO vo : i18nVOs) {
                    if (vo.getKey() == null || vo.getKey() == "") continue;
                    i18nMap.put(vo.getKey(), vo.getValue());
                }
                this.redisDao.set("i18n_resource_key#" + i18nVO.getLanguage(), i18nMap);
                break block5;
            }
            catch (Exception e) {
                I18nServiceImpl.logger.error("read i18n info from redis exception:", (Throwable)e);
                i18nVOs = this.i18nMapper.getAllResourceByLanguage(i18nVO);
                i18nMap = new HashMap<String, String>();
                ** for (vo : i18nVOs)
            }
lbl-1000:
            // 1 sources

            {
                if (vo.getKey() == null || vo.getKey() == "") continue;
                i18nMap.put(vo.getKey(), vo.getValue());
                continue;
            }
        }
        return Response.ok(i18nMap).build();
    }

    private Response getOkResponse(BaseVO entity) {
        entity.setStatusCode(ResponseCodeEnum.SUCCESS.getValue());
        entity.setMessage(ResponseCodeEnum.SUCCESS.getDesc());
        return Response.ok((Object)entity).build();
    }

    private Response getErrorResponse(String errorCode, String errorMsg) {
        return Response.ok().entity((Object)new BaseVO(errorCode, errorMsg)).build();
    }

    /*
     * Exception decompiling
     */
    public Response i18nExcelImport(String elsAccount, String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCellFormatValue(Cell cell) {
        String cellvalue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: 
                case 2: {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellvalue = sdf.format(date);
                        break;
                    }
                    long changeValue = (long)cell.getNumericCellValue();
                    cellvalue = String.valueOf(changeValue);
                    break;
                }
                case 1: {
                    cellvalue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellvalue = " ";
                    break;
                }
            }
        } else {
            cellvalue = "";
        }
        return cellvalue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Response getI18nPage(I18nVO i18nVO) {
        lstVO /* !! */  = null;
        request = (HttpServletRequest)ContextFilter.context.get();
        filename = String.valueOf(request.getRealPath("/")) + i18nVO.getUrlStr();
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                fis = new FileInputStream(filename);
                try {
                    Inputreader = new InputStreamReader((InputStream)fis, "utf-8");
                    try {
                        br = new BufferedReader(Inputreader);
                        try {
                            temp = br.readLine();
                            data = new StringBuffer();
                            while (temp != null) {
                                data.append(temp);
                                temp = br.readLine();
                            }
                            content = data.toString();
                            keys = new ArrayList<String>();
                            pattern = "<i18n:I18n\\s*key=\\s*[\"'](.*?)[\"']\\s*defaultValue=\\s*[\"'](.*?)[\"']";
                            r = Pattern.compile(pattern);
                            m = r.matcher(content);
                            defaultMap = new HashMap<String, String>();
                            while (m.find()) {
                                key = m.group(1);
                                if (key.contains("arrayVal[0]")) {
                                    System.out.println(key);
                                }
                                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)key) || keys.contains(key)) continue;
                                keys.add(key);
                                defaultMap.put(key, m.group(2));
                            }
                            lstVO /* !! */  = keys.size() > 0 ? this.i18nMapper.getKeys(i18nVO.getLanguage(), keys) : new ArrayList<E>();
                            lstKeys = new ArrayList<String>();
                            for (I18nVO vo : lstVO /* !! */ ) {
                                lstKeys.add(vo.getKey());
                                vo.setFbk1((String)defaultMap.get(vo.getKey()));
                            }
                            if (keys.size() > lstVO /* !! */ .size()) {
                                for (String key : keys) {
                                    if (lstKeys.contains(key)) continue;
                                    vo = new I18nVO();
                                    vo.setLanguage(i18nVO.getLanguage());
                                    vo.setKey(key);
                                    vo.setValue("");
                                    vo.setFbk1((String)defaultMap.get(vo.getKey()));
                                    lstVO /* !! */ .add(vo);
                                }
                            }
                        }
                        finally {
                            if (br != null) {
                                br.close();
                            }
                        }
                        ** if (Inputreader == null) goto lbl-1000
                    }
                    catch (Throwable var6_9) {
                        if (var5_5 == null) {
                            var5_5 = var6_9;
                        } else if (var5_5 != var6_9) {
                            var5_5.addSuppressed(var6_9);
                        }
                        if (Inputreader != null) {
                            Inputreader.close();
                        }
                        throw var5_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        Inputreader.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var6_10) {
                    if (var5_5 == null) {
                        var5_5 = var6_10;
                    } else if (var5_5 != var6_10) {
                        var5_5.addSuppressed(var6_10);
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    throw var5_5;
                }
lbl-1000:
                // 1 sources

                {
                    fis.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var6_11) {
                if (var5_5 == null) {
                    var5_5 = var6_11;
                } else if (var5_5 != var6_11) {
                    var5_5.addSuppressed(var6_11);
                }
                throw var5_5;
            }
        }
        catch (Exception e) {
            I18nServiceImpl.logger.error(e.getMessage());
        }
        pageListVO = new PageListVO();
        pageListVO.setRows(lstVO /* !! */ );
        return Response.ok((Object)pageListVO).build();
    }

    public static void main(String[] args) {
        String str = "<i18n:I18n  key='hello' defaultValue=\"\u4f9b\u5e94\u5546ElS\u5e10\u53f7\"/><i18n:I18n key=\"i18n_button_create\" defaultValue=\"\u65b0\u5efa\" />";
        String pattern = "<i18n:I18n\\s*key=\\s*[\"'](.*?)[\"']\\s*defaultValue=\\s*[\"'](.*?)[\"']";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(str);
        while (m.find()) {
            System.out.println(m.group(1));
            System.out.println(m.group(2));
        }
    }

    @Transactional
    public Response saveI18n(List<I18nVO> list) {
        String language = list.get(0).getLanguage();
        ArrayList<String> keys = new ArrayList<String>();
        for (I18nVO i18nVO : list) {
            keys.add(i18nVO.getKey());
        }
        this.i18nMapper.deleteKeys(language, keys);
        this.i18nMapper.insertBatch(list);
        return Response.ok().build();
    }

    public String getValue(String elsAccount, String key, String language) {
        Object obj;
        String cachekey = this.createCacheMapKey(key, language);
        if (!this.elsCacheMap.containsKey(elsAccount)) {
            List lstData = this.i18nMapper.getAllElsResource(elsAccount);
            ConcurrentHashMap<String, Response> elsMap = new ConcurrentHashMap<String, Response>();
            for (I18nVO i18nVO : lstData) {
                elsMap.put(this.createCacheMapKey(i18nVO.getKey(), i18nVO.getLanguage()), this.getOkResponse((BaseVO)i18nVO));
            }
            this.elsCacheMap.put(elsAccount, elsMap);
        }
        Map<String, Response> elsMap = this.elsCacheMap.get(elsAccount);
        Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(language);
        if (elsMap.containsKey(cachekey)) {
            obj = elsMap.get(cachekey).getEntity();
            return ((I18nVO)obj).getValue();
        }
        if (cacheMap != null && cacheMap.get(cachekey) != null) {
            obj = cacheMap.get(cachekey).getEntity();
            return ((I18nVO)obj).getValue();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("language", language);
        List list = this.i18nMapper.getResourceByKey(map);
        if (list != null && list.size() > 0) {
            Response response = this.getOkResponse((BaseVO)list.get(0));
            if (cacheMap != null) {
                cacheMap.put(cachekey, response);
            }
            return ((I18nVO)list.get(0)).getValue();
        }
        return "";
    }

    public synchronized Response i18nTranslate() {
        if (this.i18nInitCheck()) {
            String elsAccount = this.getLoginElsAccount();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        I18nServiceImpl.this.elsAppNameInit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.tableColumnKeyInit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.i18nTranslateValueIsEmpty();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.translateMutiThread();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.i18nMapper.updateResourceTypeByKeyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    I18nServiceImpl.this.clearI18nRedis();
                }
            }).start();
        }
        return this.getOkResponse(new BaseVO());
    }

    private void elsAppNameInit() {
        try {
            List appVOS = this.appMapper.queryAppNoI18n();
            if (appVOS == null || appVOS.size() < 1) {
                return;
            }
            for (AppVO appVO : appVOS) {
                String i18nKey;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appVO.getAppName()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(i18nKey = this.createI18nKey(appVO.getAppName())))) continue;
                appVO.setAppName(String.valueOf(i18nKey) + ":" + appVO.getAppName());
                try {
                    this.appMapper.updateApp(appVO);
                }
                catch (Exception e) {
                    logger.error("els_app_list\u8868\u66f4\u65b0\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void tableColumnKeyInit() {
        try {
            List tableColumnVOS = this.tableColumnMapper.findTableColumns();
            if (tableColumnVOS == null || tableColumnVOS.size() < 1) {
                return;
            }
            for (TableColumnVO tableColumnVO : tableColumnVOS) {
                String i18nKey;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tableColumnVO.getColumnName()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(i18nKey = this.createI18nKey(tableColumnVO.getColumnName())))) continue;
                tableColumnVO.setColumnKey(i18nKey);
                try {
                    this.tableColumnMapper.updateColumnKey(tableColumnVO);
                }
                catch (Exception e) {
                    logger.error("els_table_column_sta\u8868\u66f4\u65b0\u5931\u8d25:" + e.getMessage());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLoginElsAccount() {
        HttpServletRequest request = (HttpServletRequest)ContextFilter.context.get();
        Object obj = request.getSession().getAttribute("elsAccount");
        if (obj == null) {
            return ResponseCodeEnum.NO_LOGIN.getValue();
        }
        return (String)obj;
    }

    public Response clearI18nRedis() {
        String language;
        String[] enableClearElsAccounts = clearI18nCache_elsAccounts.split(",");
        boolean enableTag = false;
        String elsaccount = this.getLoginElsAccount();
        String[] stringArray = enableClearElsAccounts;
        int n = enableClearElsAccounts.length;
        int n2 = 0;
        while (n2 < n) {
            String enableElsAccount = stringArray[n2];
            if (enableElsAccount.equals(elsaccount)) {
                enableTag = true;
                break;
            }
            ++n2;
        }
        if (enableTag) {
            language = ((HttpServletRequest)ContextFilter.context.get()).getSession().getAttribute("language").toString();
            this.elsCacheMap.clear();
            Map<String, Response> cacheMap = this.mutiLanguageCacheMap.get(language);
            if (cacheMap != null) {
                cacheMap.clear();
            }
        } else {
            return this.getErrorResponse("100", "\u60a8\u65e0\u6743\u6e05\u7406\u7f13\u5b58\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        new Thread(new I18nCacheLoad(language)).start();
        return this.getOkResponse(new BaseVO("200", "\u7f13\u5b58\u6e05\u7406\u6210\u529f"));
    }

    public I18nVO i18nChinessRecordInit(String key, String value) {
        return this.i18nChinessRecordInit(key, value, null);
    }

    public I18nVO i18nChinessRecordInit(String key, String value, String resourceType) {
        block11: {
            block10: {
                block9: {
                    if (this.i18nInitCheck()) break block9;
                    return null;
                }
                if (key != null && !"test".equals(key) && !" ".equals(key) && !key.contains("xxx")) break block10;
                return null;
            }
            if (value != null && !value.equals("") && !value.equals("test") && !value.contains(" ") && !value.contains("xxx")) break block11;
            return null;
        }
        try {
            if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
                ArrayList<I18nVO> chinessList = new ArrayList<I18nVO>();
                I18nVO i18nVO = new I18nVO();
                i18nVO.setKey(key);
                i18nVO.setValue(value);
                i18nVO.setLanguage(CHINESSSIMPLEQQT);
                i18nVO.setResourceType(resourceType);
                i18nVO.setCreateDate(new Date());
                i18nVO.setCreateUser(CREATEUSER);
                chinessList.add(i18nVO);
                List i18nVOList = this.i18nMapper.findI18nKeyContent(i18nVO);
                if (i18nVOList != null && i18nVOList.size() > 0) {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)resourceType)) {
                        if (resourceType.equals(((I18nVO)i18nVOList.get(0)).getResourceType())) {
                            return (I18nVO)i18nVOList.get(0);
                        }
                        this.i18nMapper.updateResourceTypeByKey(i18nVO);
                        return i18nVO;
                    }
                    return i18nVO;
                }
                this.i18nMapper.insertResource(i18nVO);
                return i18nVO;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean i18nInitCheck() {
        return "dev".equals(enviroment) && "true".equals(i18nInit) && !"true".equals(i18nIgnore);
    }

    private synchronized Response i18nTranslateValueIsEmpty() {
        List list = this.i18nMapper.getI18nByEmptyValue();
        if (list == null || list.size() < 1) {
            return this.getOkResponse(new BaseVO());
        }
        for (I18nVO i18nVO : list) {
            try {
                if (CHINESSSIMPLEQQT.equals(i18nVO.getLanguage())) {
                    HashMap<String, String> keyMap = new HashMap<String, String>();
                    keyMap.put("resourceKey", i18nVO.getKey());
                    this.i18nMapper.deleteResourceByKey(keyMap);
                    continue;
                }
                I18nVO findI18nVo = new I18nVO();
                findI18nVo.setLanguage(CHINESSSIMPLEQQT);
                findI18nVo.setKey(i18nVO.getKey());
                List chinessList = this.i18nMapper.findI18nKeyContent(findI18nVo);
                if (chinessList == null || chinessList.size() < 1 || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((I18nVO)chinessList.get(0)).getValue())) {
                    HashMap<String, String> keyMap = new HashMap<String, String>();
                    keyMap.put("resourceKey", i18nVO.getKey());
                    this.i18nMapper.deleteResourceByKey(keyMap);
                    continue;
                }
                I18nVO insertI18VO = this.i18nVOGet(findI18nVo.getKey(), ((I18nVO)chinessList.get(0)).getValue(), i18nVO.getLanguage(), CREATEUSER);
                this.i18nMapper.insertResource(insertI18VO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getOkResponse(new BaseVO());
    }

    private I18nVO findChinessVo(List<I18nVO> list) {
        if (list == null) {
            return null;
        }
        for (I18nVO i18nVO : list) {
            if (!CHINESSSIMPLEQQT.equals(i18nVO.getLanguage())) continue;
            return i18nVO;
        }
        return null;
    }

    private synchronized void translateMutiThread() {
        List list = this.i18nMapper.getI18nNumberByKey(TranslateUtilBD.Country.values().length + 2);
        ArrayList<String> list1 = new ArrayList<String>();
        int listCount = list.size();
        int qy = 3;
        if (listCount > 30) {
            qy = listCount / 30;
        }
        int i = 0;
        while (i < listCount) {
            list1.add((String)list.get(i));
            if (i != 0 && i % qy == 0) {
                new Thread(new I18nTranslateThread(list1)).start();
                list1 = new ArrayList();
            }
            if (i + qy > listCount && list1.size() == listCount % qy) {
                new Thread(new I18nTranslateThread(list1)).start();
            }
            ++i;
        }
    }

    private I18nVO i18nVOGet(String key, String value, String QQTlanguage, String toLanguage, String CREATEUSER) {
        I18nVO i18nVO = new I18nVO();
        i18nVO.setCreateUser(CREATEUSER);
        i18nVO.setCreateDate(new Date());
        i18nVO.setLanguage(QQTlanguage);
        i18nVO.setKey(key);
        String languageStr = TranslateUtilBD.baiduFY((String)value, (String)TranslateUtilBD.Country.CHINESS.getName(), (String)toLanguage);
        i18nVO.setValue(this.languageStrFilter(languageStr));
        return i18nVO;
    }

    private I18nVO i18nVOGet(String key, String value, String toLanguage, String CREATEUSER) {
        I18nVO i18nVO = new I18nVO();
        i18nVO.setCreateUser(CREATEUSER);
        i18nVO.setCreateDate(new Date());
        i18nVO.setLanguage(toLanguage);
        i18nVO.setKey(key);
        String languageStr = TranslateUtilBD.baiduFY((String)value, (String)TranslateUtilBD.Country.CHINESS.getName(), (String)toLanguage);
        i18nVO.setValue(this.languageStrFilter(languageStr));
        return i18nVO;
    }

    private String languageStrFilter(String languageStr) {
        char[] languageStrChars = languageStr.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = languageStrChars;
        int n = languageStrChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ('\"' == c) {
                stringBuffer.append("&quot;");
            } else if ('&' == c) {
                stringBuffer.append("&amp;");
            } else if ('<' == c) {
                stringBuffer.append("&lt;");
            } else if ('>' == c) {
                stringBuffer.append("&gt;");
            } else if ('\'' == c) {
                stringBuffer.append("&acute;");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String createI18nKey(String chinessStr) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)chinessStr)) {
            return "value \u4e0d\u80fd\u4e3a\u7a7a";
        }
        int keyHashCode = chinessStr.hashCode();
        String key_temp = I18N + HanyuPinyinHelper.getPinYinLowHasTone((String)chinessStr) + keyHashCode;
        if (key_temp.length() > 60) {
            key_temp = I18N + HanyuPinyinHelper.getFirstLettersLowHasTone((String)chinessStr) + keyHashCode;
        }
        if (key_temp.length() > 60) {
            key_temp = I18N + HanyuPinyinHelper.getFirstLettersLowHasTone((String)chinessStr).hashCode() + keyHashCode;
        }
        return key_temp;
    }

    public Response initI18nRecord(String requestParams) {
        if (!this.i18nInitCheck()) {
            return this.getErrorResponse("100", "\u60a8\u6ca1\u6709\u914d\u7f6e\u56fd\u9645\u5316\uff08\u914d\u7f6e\u6587\u4ef6:i18nInit.properties\uff09");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestParams)) {
            JSONObject requestPramJson = JSONObject.parseObject((String)requestParams);
            String key = requestPramJson.getString("key");
            String defaultValue = requestPramJson.getString("defaultValue");
            String resourceType = "frontJs";
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)defaultValue)) {
                return this.getErrorResponse("100", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            I18nVO i18nVO = new I18nVO();
            i18nVO.setKey(key);
            i18nVO.setLanguage(LanguageEnum.CN.getValue());
            i18nVO.setResourceType(resourceType);
            int i18nCount = this.i18nMapper.findI18nKeyListCount(i18nVO);
            if (i18nCount < 1) {
                return this.getOkResponse((BaseVO)this.i18nChinessRecordInit(key, defaultValue, resourceType));
            }
            return this.getOkResponse((BaseVO)i18nVO);
        }
        return this.getErrorResponse("100", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Response getI18nTableColumn(I18nTableColumnVO i18nTableColumnVO) {
        ArrayList list = this.i18nMapper.getI18nTableColumn(i18nTableColumnVO);
        if (list.size() < 1) {
            list = new ArrayList();
        }
        if (list.size() > 0 && !"2".equals(i18nTableColumnVO.getFbk1())) {
            ((I18nTableColumnVO)list.get(0)).setColumnName(this.getI18nName(((I18nTableColumnVO)list.get(0)).getColumnName()));
            ((I18nTableColumnVO)list.get(0)).setNeedKeyName(this.getI18nName(((I18nTableColumnVO)list.get(0)).getNeedKeyName()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setRows(list);
        return Response.ok((Object)pageListVO).build();
    }

    private String getI18nName(String s) {
        String[] names = s.split("--");
        String finalname = "";
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            finalname = String.valueOf(finalname) + this.getI18n(string, "", new Object[0]) + "--";
            ++n2;
        }
        return finalname.substring(0, finalname.length() - 2);
    }

    public String getI18n(String key, String defaultValue, Object ... args) {
        String value = defaultValue;
        Response response = this.getResourceByKey(key);
        if (response.getEntity() instanceof I18nVO) {
            I18nVO i18nVO = (I18nVO)response.getEntity();
            if (SystemUtil.isNotEmpty((String)i18nVO.getValue())) {
                value = i18nVO.getValue();
            } else {
                this.i18nChinessRecordInit(key, defaultValue);
                value = String.format(i18nVO.getValue(), args);
            }
        } else {
            this.i18nChinessRecordInit(key, defaultValue);
        }
        return value;
    }

    public Map<String, Map<String, String>> getDataTranslate(I18nTableColumnVO i18nTableColumnVO) {
        List list = this.i18nMapper.getDataTranslate(i18nTableColumnVO);
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (I18nTableColumnVO i18nTableColumnVO2 : list) {
            HashMap<String, String> tempList = (HashMap<String, String>)map.get(i18nTableColumnVO2.getDataKey());
            if (tempList == null) {
                tempList = new HashMap<String, String>();
                tempList.put(i18nTableColumnVO.getNeedKey(), i18nTableColumnVO2.getDataKey());
                tempList.put(String.valueOf(i18nTableColumnVO2.getColumnCode()) + TRANS, i18nTableColumnVO2.getTransValues());
                map.put(i18nTableColumnVO2.getDataKey(), tempList);
                continue;
            }
            tempList.put(String.valueOf(i18nTableColumnVO2.getColumnCode()) + TRANS, i18nTableColumnVO2.getTransValues());
        }
        return map;
    }

    public Response saveI18nTableColumnTransValue(I18nTableColumnVO i18nTableColumnVO) {
        I18nTableColumnVO itcVO = new I18nTableColumnVO();
        itcVO.setElsAccount(i18nTableColumnVO.getElsAccount());
        itcVO.setTableCode(i18nTableColumnVO.getTableCode());
        itcVO.setIsStarted(i18nTableColumnVO.getIsStarted());
        this.i18nMapper.updateI18nTableColumn(itcVO);
        itcVO.setSelectLanguage(i18nTableColumnVO.getSelectLanguage());
        Map transmap = i18nTableColumnVO.getTransMap();
        for (Map.Entry entry : transmap.entrySet()) {
            itcVO.setDataKey((String)entry.getKey());
            Map datamap = (Map)entry.getValue();
            String[] stringArray = i18nTableColumnVO.getColumnCode().split("--");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String columncode = stringArray[n2];
                itcVO.setColumnCode(columncode);
                itcVO.setTransValues((String)datamap.get(columncode));
                if (this.i18nMapper.updateTableColumnTransValue(itcVO) == 0) {
                    this.i18nMapper.insertTableColumnTransValue(itcVO);
                }
                ++n2;
            }
        }
        return Response.ok().build();
    }

    public Map<String, Map<String, String>> transI18nTableColumnTransValue(I18nTableColumnVO i18nTableColumnVO) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        I18nTableColumnVO itcVO = new I18nTableColumnVO();
        itcVO.setElsAccount(i18nTableColumnVO.getElsAccount());
        itcVO.setTableCode(i18nTableColumnVO.getTableCode());
        itcVO.setSelectLanguage(i18nTableColumnVO.getSelectLanguage());
        Map transmap = i18nTableColumnVO.getTransMap();
        for (Map.Entry entry : transmap.entrySet()) {
            itcVO.setDataKey((String)entry.getKey());
            Map datamap = (Map)entry.getValue();
            String[] stringArray = i18nTableColumnVO.getColumnCode().split("--");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    String columncode = stringArray[n2];
                    try {
                        try {
                            if (!"".equals(datamap.get(columncode)) && "".equals(datamap.get(String.valueOf(columncode) + TRANS)) && datamap.get(columncode) != null) {
                                datamap.put(String.valueOf(columncode) + TRANS, TranslateUtilBD.baiduFY((String)((String)datamap.get(columncode)), (String)"auto", (String)(CHINESSSIMPLEQQT.equals(i18nTableColumnVO.getSelectLanguage()) ? "zh" : (CHINESSCOMPLEXQQT.equals(i18nTableColumnVO.getSelectLanguage()) ? "cht" : i18nTableColumnVO.getSelectLanguage()))));
                            }
                        }
                        catch (Exception e) {
                            System.out.println(String.valueOf((String)entry.getKey()) + ":" + columncode + "Trans:" + (String)datamap.get(columncode));
                            itcVO.setColumnCode(columncode);
                            itcVO.setTransValues((String)datamap.get(String.valueOf(columncode) + TRANS));
                            if (this.i18nMapper.updateTableColumnTransValue(itcVO) == 0) {
                                this.i18nMapper.insertTableColumnTransValue(itcVO);
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        itcVO.setColumnCode(columncode);
                        itcVO.setTransValues((String)datamap.get(String.valueOf(columncode) + TRANS));
                        if (this.i18nMapper.updateTableColumnTransValue(itcVO) == 0) {
                            this.i18nMapper.insertTableColumnTransValue(itcVO);
                        }
                        throw throwable;
                    }
                    itcVO.setColumnCode(columncode);
                    itcVO.setTransValues((String)datamap.get(String.valueOf(columncode) + TRANS));
                    if (this.i18nMapper.updateTableColumnTransValue(itcVO) == 0) {
                        this.i18nMapper.insertTableColumnTransValue(itcVO);
                    }
                }
                ++n2;
            }
        }
        map.putAll(transmap);
        return map;
    }

    public Response updateI18nTableColumn(I18nTableColumnVO i18nTableColumnVO) {
        if (this.i18nMapper.updateI18nTableColumn(i18nTableColumnVO) == 0) {
            this.i18nMapper.insertI18nTableColumn(i18nTableColumnVO);
        }
        return Response.ok().build();
    }

    public String checkTableExsit(I18nTableColumnVO i18nTableColumnVO) {
        String text = "notexsit";
        TableVO tableVO = new TableVO();
        tableVO.setTableCode(i18nTableColumnVO.getTableCode());
        List list = this.accountColumnMapper.getTableList(tableVO);
        for (TableVO tableVO2 : list) {
            if (!tableVO2.getTableCode().equals(i18nTableColumnVO.getTableCode())) continue;
            text = "exsit";
            return text;
        }
        if (text.equals("notexsit") && this.i18nMapper.getI18nTableColumn(i18nTableColumnVO).size() > 0) {
            text = "exsit";
        }
        return text;
    }

    static /* synthetic */ I18nVO access$2(I18nServiceImpl i18nServiceImpl, List list) {
        return i18nServiceImpl.findChinessVo(list);
    }

    static /* synthetic */ I18nVO access$3(I18nServiceImpl i18nServiceImpl, String string, String string2, String string3, String string4) {
        return i18nServiceImpl.i18nVOGet(string, string2, string3, string4);
    }

    static /* synthetic */ I18nVO access$4(I18nServiceImpl i18nServiceImpl, String string, String string2, String string3, String string4, String string5) {
        return i18nServiceImpl.i18nVOGet(string, string2, string3, string4, string5);
    }

    static /* synthetic */ Response access$5(I18nServiceImpl i18nServiceImpl, BaseVO baseVO) {
        return i18nServiceImpl.getOkResponse(baseVO);
    }

    class I18nCacheLoad
    implements Runnable {
        private String language;

        public I18nCacheLoad(String language) {
            this.language = language;
        }

        @Override
        public void run() {
            I18nVO i18nVO = new I18nVO();
            i18nVO.setLanguage(this.language);
            List i18nVOS = I18nServiceImpl.this.i18nMapper.findI18nKeyContent(i18nVO);
            I18nServiceImpl.this.putMutiLanguageCacheMap(i18nVOS, this.language);
        }
    }

    class I18nTranslateThread
    implements Runnable {
        private List<String> list;

        @Override
        public void run() {
            this.translateMutile();
        }

        public I18nTranslateThread() {
        }

        public I18nTranslateThread(List<String> list) {
            this.list = list;
        }

        public List<String> getList() {
            return this.list;
        }

        public void setList(List<String> list) {
            this.list = list;
        }

        /*
         * Unable to fully structure code
         */
        public Response translateMutile() {
            block13: {
                list = this.list;
                countries = TranslateUtilBD.Country.values();
                selectI18nVO = new I18nVO();
                singleKeyAllList = null;
                insertList = new ArrayList<I18nVO>();
                for (String resourceKey : list) {
                    try {
                        selectI18nVO.setKey(resourceKey);
                        singleKeyAllList = I18nServiceImpl.access$0(I18nServiceImpl.this).findI18nKeyContent(selectI18nVO);
                        chinessI18nVO = I18nServiceImpl.access$2(I18nServiceImpl.this, singleKeyAllList);
                        if (chinessI18nVO == null) {
                            keyMap = new HashMap<String, String>();
                            keyMap.put("key", resourceKey);
                            I18nServiceImpl.access$0(I18nServiceImpl.this).deleteResourceByKey(keyMap);
                            continue;
                        }
                        languageEqualsTag = false;
                        var13_18 = countries;
                        var12_17 = countries.length;
                        var11_16 = 0;
                        while (var11_16 < var12_17) {
                            country = var13_18[var11_16];
                            countryName = country.getName();
                            languageEqualsTag = false;
                            for (I18nVO i18nVO : singleKeyAllList) {
                                if (!countryName.equals(i18nVO.getLanguage())) continue;
                                languageEqualsTag = true;
                                break;
                            }
                            if (!languageEqualsTag) {
                                insertList.add(I18nServiceImpl.access$3(I18nServiceImpl.this, resourceKey, chinessI18nVO.getValue(), countryName, "WangBintao"));
                            }
                            ++var11_16;
                        }
                        languageEqualsTag = false;
                        for (I18nVO i18nVO : singleKeyAllList) {
                            if (!"zh_tw".equals(i18nVO.getLanguage())) continue;
                            languageEqualsTag = true;
                            break;
                        }
                        if (languageEqualsTag) continue;
                        insertList.add(I18nServiceImpl.access$4(I18nServiceImpl.this, resourceKey, chinessI18nVO.getValue(), "zh_tw", TranslateUtilBD.Country.ZHHANT.getName(), "WangBintao"));
                    }
                    catch (Exception var8_10) {
                        // empty catch block
                    }
                }
                try {
                    if (insertList.size() <= 0) break block13;
                    I18nServiceImpl.access$0(I18nServiceImpl.this).insertBatch(insertList);
                    break block13;
                }
                catch (Exception e) {
                    ** for (i18nVO : insertList)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        I18nServiceImpl.access$0(I18nServiceImpl.this).insertResource(i18nVO);
                    }
                    catch (Exception var9_13) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return I18nServiceImpl.access$5(I18nServiceImpl.this, new BaseVO());
        }
    }
}

